/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.remote.CachedRemoteServicesImpl;
import com.iplanet.am.sdk.remote.RemoteServicesImpl;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;

class RemoteServicesFactory {
    private static final String GLOBAL_CACHE_ENABLED_DISABLED_KEY = "com.iplanet.am.sdk.caching.enabled";
    private static final String UM_CACHE_ENABLED_DISABLED_KEY = "com.sun.identity.amsdk.cache.enabled";
    private static Debug debug = RemoteServicesImpl.getDebug();
    private static boolean cachingEnabled;
    private static IDirectoryServices dsServicesImpl;

    RemoteServicesFactory() {
    }

    public static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public static IDirectoryServices getInstance() {
        return dsServicesImpl;
    }

    static {
        dsServicesImpl = null;
        String string = System.getProperty(GLOBAL_CACHE_ENABLED_DISABLED_KEY);
        if (string == null || string.length() == 0) {
            string = SystemProperties.get(GLOBAL_CACHE_ENABLED_DISABLED_KEY, "true");
        }
        if (cachingEnabled = string.equalsIgnoreCase("true") ? true : ((string = SystemProperties.get(UM_CACHE_ENABLED_DISABLED_KEY)) != null && string.length() > 0 ? string.equalsIgnoreCase("true") : false)) {
            dsServicesImpl = CachedRemoteServicesImpl.getInstance();
            if (debug.messageEnabled()) {
                debug.message("RemoteServicesFactory.static{} - Caching Mode: " + cachingEnabled + "Using implementation " + "Class CachedRemoteServicesImpl");
            }
        } else {
            dsServicesImpl = RemoteServicesImpl.getInstance();
            if (debug.messageEnabled()) {
                debug.message("RemoteServicesFactory.static{} - Caching Mode: " + cachingEnabled + "Using implementation " + "Class RemoteServicesImpl");
            }
        }
    }
}

