/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMObjectListenerImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.IComplianceServices;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServicesProvider;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.security.ProviderException;

public class AMDirectoryAccessFactory {
    private static IDirectoryServices dsServicesImpl;
    private static IDCTreeServices dcTreeServicesImpl;
    private static IComplianceServices complianceServicesImpl;
    private static Debug debug;
    private static boolean isInitialized;
    private static final String CONFIGURED_SDK_PACKAGE_PROPERTY = "com.iplanet.am.sdk.package";
    private static final String LDAP_SDK_PACKAGE = "com.iplanet.am.sdk.ldap";
    private static final String REMOTE_SDK_PACKAGE = "com.iplanet.am.sdk.remote";
    private static final String DS_SERVICES_PROVIDER_CLASS = "DirectoryServicesProviderImpl";
    private static final String REMOTE_SERVICES_PROVIDER_CLASS = "RemoteServicesProviderImpl";
    private static final String PACKAGE_SEPARATOR = ".";

    private static void initialize() {
        String string = SystemProperties.get(CONFIGURED_SDK_PACKAGE_PROPERTY);
        if (string == null || string.equals(LDAP_SDK_PACKAGE)) {
            try {
                AMDirectoryAccessFactory.instantiateImpls(LDAP_SDK_PACKAGE, DS_SERVICES_PROVIDER_CLASS);
            }
            catch (ProviderException providerException) {
                if (debug.messageEnabled()) {
                    debug.message("AMDirectoryAccessFactory.static{} - Initializing the server packages failed. Hence trying the remote client sdk pacakage");
                }
                AMDirectoryAccessFactory.instantiateImpls(REMOTE_SDK_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS);
            }
        } else if (string.equals(REMOTE_SDK_PACKAGE)) {
            AMDirectoryAccessFactory.instantiateImpls(REMOTE_SDK_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS);
        } else {
            AMDirectoryAccessFactory.instantiateImpls(LDAP_SDK_PACKAGE, DS_SERVICES_PROVIDER_CLASS);
        }
        isInitialized = true;
    }

    private static void instantiateImpls(String string, String string2) {
        String string3 = string + PACKAGE_SEPARATOR + string2;
        try {
            IDirectoryServicesProvider iDirectoryServicesProvider = (IDirectoryServicesProvider)Class.forName(string3).newInstance();
            dsServicesImpl = iDirectoryServicesProvider.getDirectoryServicesImpl();
            dcTreeServicesImpl = iDirectoryServicesProvider.getDCTreeServicesImpl();
            complianceServicesImpl = iDirectoryServicesProvider.getComplianceServicesImpl();
            AMDirectoryAccessFactory.initListener();
        }
        catch (InstantiationException instantiationException) {
            debug.error("AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + string + "FAILED!", instantiationException);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.error("AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + string + "FAILED!", illegalAccessException);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.error("AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + string + "FAILED!", classNotFoundException);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (AMEventManagerException aMEventManagerException) {
            debug.error("AMDirectoryAccessFactory.instantiateImpls()- Initializing Impls from package: " + string + "FAILED!", aMEventManagerException);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryAccessFactory.instantiateImpls() - Successfully initialized Impls Using Impl Package: " + string + " for accessing Directory Services");
        }
    }

    private static void initListener() throws AMEventManagerException {
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        AMObjectListenerImpl aMObjectListenerImpl = new AMObjectListenerImpl();
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryAccessFactory.initListener() - adding listener: " + aMObjectListenerImpl.getClass().getName());
        }
        dsServicesImpl.addListener(sSOToken, aMObjectListenerImpl, null);
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    public static IDirectoryServices getDirectoryServices() {
        if (!AMDirectoryAccessFactory.isInitialized()) {
            AMDirectoryAccessFactory.initialize();
        }
        return dsServicesImpl;
    }

    public static IDCTreeServices getDCTreeServices() {
        if (!AMDirectoryAccessFactory.isInitialized()) {
            AMDirectoryAccessFactory.initialize();
        }
        return dcTreeServicesImpl;
    }

    public static IComplianceServices getComplianceServices() {
        if (!AMDirectoryAccessFactory.isInitialized()) {
            AMDirectoryAccessFactory.initialize();
        }
        return complianceServicesImpl;
    }

    static {
        debug = AMCommonUtils.debug;
        isInitialized = false;
    }
}

