/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.IDCTreeServices;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AMDCTree
implements AMConstants {
    protected static ServiceSchema gsc = null;
    public static final String IPLANET_DOMAIN_NAME_ATTR = "sunPreferredDomain";
    public static final String INET_CANONICAL_DOMAIN = "inetcanonicaldomainname";
    public static final String DOMAIN_BASE_DN = "inetDomainBaseDN";
    private static Map domainMap;
    private static Map canonicalDomainMap;
    private static Debug debug;
    private static IDCTreeServices dcTreeServices;

    AMDCTree() {
    }

    protected static boolean isRequired() throws AMException {
        try {
            Object object;
            if (AMCompliance.gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                AMCompliance.gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            object = AMCompliance.gsc.getAttributeDefaults();
            Set set = (Set)object.get("iplanet-am-admin-console-dctree");
            boolean bl = false;
            if (set == null || set.isEmpty()) {
                bl = false;
            } else {
                String string = (String)set.iterator().next();
                bl = string.equalsIgnoreCase("true");
            }
            return bl;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("354"), sMSException);
            throw new AMException(AMSDKBundle.getString("354"), "354");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("345"), sSOException);
            throw new AMException(AMSDKBundle.getString("354"), "354");
        }
    }

    protected static String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        return dcTreeServices.getOrganizationDN(sSOToken, string);
    }

    protected static AttrSet[] splitAttrSet(String string, AttrSet attrSet) throws AMException {
        AttrSet[] attrSetArray = new AttrSet[]{new AttrSet(), new AttrSet()};
        if (attrSet == null) {
            return attrSetArray;
        }
        Set set = AMDCTree.dcNodeAttributes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Attr attr;
            String string2 = (String)iterator.next();
            int n = string2.indexOf("objectclass=");
            if (n > -1) {
                attr = attrSet.getAttribute("objectclass");
                String string3 = string2.substring("objectclass=".length());
                Attr attr2 = new Attr("objectclass");
                if (attr == null || !attr.contains(string3)) continue;
                attr.removeValue(string3);
                attr2.addValue(string3);
                attrSet.replace(attr);
                attrSetArray[1].add(attr2);
                continue;
            }
            attr = attrSet.getAttribute(string2);
            if (attr == null) continue;
            attrSetArray[1].add(attr);
            attrSet.remove(string2);
        }
        attrSetArray[0] = attrSet;
        if (debug.messageEnabled()) {
            debug.message("AMCompliance.splitAttrSet: domain attrset = " + attrSetArray[1].toString());
            debug.message("AMCompliance.splitAttrSet: non-domain attrset = " + attrSetArray[0].toString());
        }
        return attrSetArray;
    }

    protected static void cleanDomainMap(String string) {
        Map map = canonicalDomainMap;
        synchronized (map) {
            canonicalDomainMap.remove(string);
        }
        Map map2 = domainMap;
        synchronized (map2) {
            domainMap.remove(string);
        }
    }

    private static Set dcNodeAttributes() throws AMException {
        try {
            Set set;
            Object object;
            if (gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            if ((set = (Set)(object = gsc.getAttributeDefaults()).get("iplanet-am-admin-console-dctree-attr-list")) == null) {
                if (debug.messageEnabled()) {
                    debug.message("DCTree.dcNodeAttributes = null");
                }
                return Collections.EMPTY_SET;
            }
            if (debug.messageEnabled()) {
                debug.message("DCTree.dcNodeAttributes = " + set.toString());
            }
            return set;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("908"), sMSException);
            throw new AMException(AMSDKBundle.getString("908"), "908");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("902"), sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
    }

    static {
        debug = AMCommonUtils.debug;
        dcTreeServices = AMDirectoryAccessFactory.getDCTreeServices();
        domainMap = new HashMap();
        canonicalDomainMap = new HashMap();
    }
}

