/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMObjectClassManager;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class AMCommonUtils
implements AMConstants {
    private static final String LOCALE_PROPERTY = "Locale";
    private static final String AM_SDK_DEBUG_FILE = "amProfile";
    static Debug debug;
    protected static Map supportedTypes;
    protected static Map supportedEntitiesBasedOnType;
    protected static Map supportedEntitiesBasedOnName;
    protected static Map supportedNames;
    protected static Map creationtemplateMap;
    protected static Map statusAttributeMap;
    private static final String LOCALE_INTEGRATION_PROPERTY = "locale.integration";
    private static final String EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR = "iplanet-am-admin-console-external-attribute-fetch-enabled";
    protected static boolean integrateLocale;
    private static Set supportedEntities;

    protected static String getUserLocale(SSOToken sSOToken) {
        try {
            String string = sSOToken.getProperty(LOCALE_PROPERTY);
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.getUserLocale(): locale = " + string);
            }
            return string;
        }
        catch (SSOException sSOException) {
            debug.error("AMCommonUtils.getUserLocale(): missing locale, setting to null");
            return null;
        }
    }

    protected static AttrSet combineAttrSets(AttrSet attrSet, AttrSet attrSet2) {
        Attr attr;
        int n;
        int n2;
        AttrSet attrSet3 = new AttrSet();
        if (attrSet != null) {
            n2 = attrSet.size();
            n = 0;
            while (n < n2) {
                attr = attrSet.elementAt(n);
                attrSet3.add(attr);
                ++n;
            }
        }
        if (attrSet2 != null) {
            n2 = attrSet2.size();
            n = 0;
            while (n < n2) {
                attr = attrSet2.elementAt(n);
                attrSet3.add(attr);
                ++n;
            }
        }
        return attrSet3;
    }

    protected static Map mergeMaps(Map map, Map map2) {
        if (map == null && map2 == null) {
            return null;
        }
        if (map == null || map.isEmpty()) {
            return map2;
        }
        if (map2 == null || map2.isEmpty()) {
            return map;
        }
        Map map3 = map.size() > map2.size() ? map : map2;
        Map map4 = map.size() <= map2.size() ? map : map2;
        Iterator iterator = map4.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map3.get(string);
            if (set != null) {
                set.addAll((Set)map4.get(string));
                continue;
            }
            map3.put(string, (Set)map4.get(string));
        }
        return map3;
    }

    protected static String mapSetToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map.get(string);
                stringBuffer.append("\n\tName: ").append(string);
                stringBuffer.append(" Values: ").append(set.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        return stringBuffer.toString();
    }

    protected static String mapByteToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])map.get(string);
                stringBuffer.append("\n\tName: ").append(string);
                stringBuffer.append(" Values: ").append(byArray);
            }
        } else {
            stringBuffer.append("<empty>");
        }
        return stringBuffer.toString();
    }

    protected static Set getSetCopy(Set set) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        if (!set.isEmpty()) {
            hashSet = new HashSet<String>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    protected static Set stringArrayToSet(String[] stringArray) {
        int n = stringArray.length;
        HashSet<String> hashSet = n > 0 ? new HashSet<String>(n) : new HashSet();
        int n2 = 0;
        while (n2 < n) {
            hashSet.add(stringArray[n2]);
            ++n2;
        }
        return hashSet;
    }

    protected static Map attrSetToMap(AttrSet attrSet) {
        return AMCommonUtils.attrSetToMap(attrSet, false);
    }

    protected static Map attrSetToMap(AttrSet attrSet, boolean bl) {
        AMHashMap aMHashMap = new AMHashMap(bl);
        if (attrSet == null) {
            return aMHashMap;
        }
        int n = attrSet.size();
        if (!bl) {
            int n2 = 0;
            while (n2 < n) {
                Attr attr = attrSet.elementAt(n2);
                String[] stringArray = attr.getStringValues();
                aMHashMap.put(attr.getName(), AMCommonUtils.stringArrayToSet(stringArray));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                Attr attr = attrSet.elementAt(n3);
                aMHashMap.put(attr.getName(), attr.getByteValues());
                ++n3;
            }
        }
        return aMHashMap;
    }

    protected static AttrSet mapToAttrSet(Map map) {
        return AMCommonUtils.mapToAttrSet(map, false);
    }

    protected static AttrSet mapToAttrSet(Map map, boolean bl) {
        AttrSet attrSet = new AttrSet();
        if (map == null) {
            return attrSet;
        }
        if (!bl) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map.get(string);
                String[] stringArray = set == null ? null : set.toArray(new String[set.size()]);
                attrSet.replace(new Attr(string, stringArray));
            }
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[][] byArray = (byte[][])map.get(string);
                attrSet.replace(new Attr(string, byArray));
            }
        }
        return attrSet;
    }

    private static String[] stringToArray(String string) {
        if (string == null || string.trim().length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    protected static String formatToRFC(String string) {
        return new DN(string).toRFCString().toLowerCase();
    }

    protected static String getPrincipalDN(SSOToken sSOToken) throws SSOException {
        String string = sSOToken.getPrincipal().getName();
        return AMCommonUtils.formatToRFC(string);
    }

    public static Set combineOCs(Set set, Set set2) {
        Object object;
        if (set == null || set.isEmpty()) {
            return set2;
        }
        if (set2 == null || set2.isEmpty()) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            hashSet.add(((String)object).toLowerCase());
        }
        object = set2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashSet.add(string.toLowerCase());
        }
        return hashSet;
    }

    protected static boolean isObjectClassPresent(Set set, String string) {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set updateAndGetRemovableOCs(Set set, Set hashSet) {
        HashSet<String> hashSet2 = hashSet;
        if (hashSet != null && !hashSet.isEmpty()) {
            hashSet2 = new HashSet<String>();
            Iterator iterator = set.iterator();
            block0: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.equalsIgnoreCase(string2)) continue;
                    hashSet2.add(string);
                    continue block0;
                }
            }
            set.removeAll(hashSet2);
        }
        return hashSet2;
    }

    public static Map removeEmptyValues(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set.isEmpty()) continue;
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    protected static boolean populateManagedObjects() {
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager("DAI", sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            Set set = serviceConfig.getSubConfigNames("*", "ManagedObjects");
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.populateManagedObjects. managedObjects=" + set);
            }
            if (set == null || set.isEmpty()) {
                return false;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string = string.toLowerCase());
                if (serviceConfig2 == null) continue;
                Map map = serviceConfig2.getAttributes();
                String string2 = AMCommonUtils.getValue((Set)map.get("objectclass"), string);
                String string3 = AMCommonUtils.getValue((Set)map.get("creationtemplatename"), string);
                String string4 = AMCommonUtils.getValue((Set)map.get("searchtemplatename"), string);
                String string5 = AMCommonUtils.getValue((Set)map.get("statusattribute"), string);
                String string6 = AMCommonUtils.getValue((Set)map.get("servicename"), string);
                String string7 = AMCommonUtils.getValue((Set)map.get("parentcontainerdn"), string);
                String string8 = AMCommonUtils.getValue((Set)map.get("parentcontainertype"), string);
                int n = string8 != null && string8.length() > 0 ? Integer.parseInt(string8) : 2;
                String string9 = AMCommonUtils.getValue((Set)map.get("type"), string);
                int n2 = Integer.parseInt(string9);
                supportedTypes.put(string, string9);
                supportedNames.put(string9, string);
                if (string2 != null) {
                    AMObjectClassManager.objectClassMap.put(string9, string2);
                    AMObjectClassManager.objectTypeMap.put(string2, string9);
                }
                if (string4 != null) {
                    AMSearchFilterManager.searchtemplateMap.put(string9, string4);
                }
                if (string3 != null) {
                    creationtemplateMap.put(string9, string3);
                }
                if (string5 != null) {
                    statusAttributeMap.put(string9, string5);
                }
                AMEntityType aMEntityType = new AMEntityType(string, n2, string6, string4, string3, string7, n, null, string5, string2);
                supportedEntities.add(aMEntityType);
                supportedEntitiesBasedOnType.put(string9, aMEntityType);
                supportedEntitiesBasedOnName.put(string, aMEntityType);
            }
            if (debug.messageEnabled()) {
                debug.message("CreationTemplae MAP = " + creationtemplateMap.toString());
                debug.message("SearchTemplate Map = " + AMSearchFilterManager.searchtemplateMap.toString());
                debug.message("ObjectClass-Type Map = " + AMObjectClassManager.objectClassMap.toString());
                debug.message("Type-ObjectClass MAP = " + AMObjectClassManager.objectTypeMap.toString());
                debug.message("Supported names-type = " + supportedTypes.toString());
                debug.message("Status Attributes= " + statusAttributeMap.toString());
            }
        }
        catch (SMSException sMSException) {
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.populateManagedObjects:  Got SMSException :", sMSException);
            }
            return false;
        }
        catch (SSOException sSOException) {
            return false;
        }
        return true;
    }

    protected static Set getSupportedEntityTypes() {
        return supportedEntities;
    }

    protected static boolean isExternalGetAttributesEnabled(String string) {
        Set set;
        Object object;
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfig serviceConfig = AMServiceUtils.getOrgConfig(sSOToken, string, "iPlanetAMAdminConsoleService");
            if (serviceConfig != null) {
                object = serviceConfig.getAttributes();
                set = (Set)object.get(EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
            } else {
                set = AMCommonUtils.getDefaultGlobalConfig(sSOToken, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
            }
        }
        catch (Exception exception) {
            set = AMCommonUtils.getDefaultGlobalConfig(sSOToken, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
        }
        boolean bl = false;
        if (set != null && !set.isEmpty()) {
            object = (String)set.iterator().next();
            bl = ((String)object).equalsIgnoreCase("true");
        }
        if (debug.messageEnabled()) {
            debug.message("AMCommonUtils.isExternalGetAttributeEnabled() = " + bl);
        }
        return bl;
    }

    private static Set getDefaultGlobalConfig(SSOToken sSOToken, String string) {
        block4: {
            if (debug.messageEnabled()) {
                debug.message("AMCommonUtils.getDefaultGlobalConfig() Organization config for service (iPlanetAMAdminConsoleService," + string + ") not found. Obtaining default service " + "config values ..");
            }
            try {
                Map map = AMServiceUtils.getServiceConfig(sSOToken, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (map != null) {
                    return (Set)map.get(string);
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMCommonUtils.getDefaultGlobalConfig(): Unable to get default global config information", exception);
            }
        }
        return null;
    }

    protected static void populateManagedObjectsWithDefaults() {
    }

    private static String getValue(Set set, String string) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return (String)set.iterator().next();
    }

    static {
        block5: {
            supportedTypes = new HashMap();
            supportedEntitiesBasedOnType = new HashMap();
            supportedEntitiesBasedOnName = new HashMap();
            supportedNames = new HashMap();
            creationtemplateMap = new HashMap();
            statusAttributeMap = new HashMap();
            integrateLocale = true;
            supportedEntities = new HashSet();
            debug = Debug.getInstance(AM_SDK_DEBUG_FILE);
            String string = SystemProperties.get(LOCALE_INTEGRATION_PROPERTY);
            if (string == null || string.equalsIgnoreCase("true")) {
                integrateLocale = true;
                if (debug.messageEnabled()) {
                    debug.message("AM SDK: Locale integration enabled");
                }
            } else {
                integrateLocale = false;
            }
            try {
                AMCommonUtils.populateManagedObjects();
            }
            catch (Throwable throwable) {
                if (!debug.messageEnabled()) break block5;
                debug.message("AMCommonUtils:Initial:  Caught exception in static block", throwable);
            }
        }
    }
}

