/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import java.util.Set;

public class AMAttributeSchema {
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_LIST = 2;
    public static final int TYPE_SINGLE_CHOICE = 3;
    public static final int TYPE_MULTIPLE_CHOICE = 4;
    public static final int TYPE_SIGNATURE = 20;
    public static final int TYPE_VALIDATOR = 21;
    public static final int UITYPE_RADIO = 22;
    public static final int UITYPE_LINK = 23;
    public static final int UITYPE_BUTTON = 24;
    public static final int UITYPE_UNDEFINED = 25;
    public static final int SYNTAX_BOOLEAN = 5;
    public static final int SYNTAX_EMAIL = 6;
    public static final int SYNTAX_URL = 7;
    public static final int SYNTAX_STRING = 8;
    public static final int SYNTAX_PASSWORD = 9;
    public static final int SYNTAX_NUMERIC = 10;
    public static final int SYNTAX_NUMBER = 11;
    public static final int SYNTAX_PERCENT = 12;
    public static final int SYNTAX_NUMBER_RANGE = 13;
    public static final int SYNTAX_DECIMAL_RANGE = 14;
    public static final int SYNTAX_DECIMAL_NUMBER = 15;
    public static final int SYNTAX_DN = 16;
    public static final int SYNTAX_PARAGRAPH = 17;
    public static final int SYNTAX_DATE = 18;
    public static final int SYNTAX_XML = 19;
    public static final int SYNTAX_ENCRYPTED_PASSWORD = 20;
    private AttributeSchema attrSchema;

    protected AMAttributeSchema(AttributeSchema attributeSchema) {
        this.attrSchema = attributeSchema;
    }

    public String getName() {
        return this.attrSchema.getName();
    }

    public int getType() {
        String string = this.attrSchema.getType().toString();
        if (string.equals(AttributeSchema.Type.SINGLE.toString())) {
            return 1;
        }
        if (string.equals(AttributeSchema.Type.LIST.toString())) {
            return 2;
        }
        if (string.equals(AttributeSchema.Type.SINGLE_CHOICE.toString())) {
            return 3;
        }
        if (string.equals(AttributeSchema.Type.MULTIPLE_CHOICE.toString())) {
            return 4;
        }
        if (string.equals(AttributeSchema.Type.SIGNATURE.toString())) {
            return 20;
        }
        if (string.equals(AttributeSchema.Type.VALIDATOR.toString())) {
            return 21;
        }
        return -1;
    }

    public int getUIType() {
        AttributeSchema.UIType uIType = this.attrSchema.getUIType();
        if (uIType == null) {
            return 25;
        }
        if (uIType.equals(AttributeSchema.UIType.RADIO)) {
            return 22;
        }
        if (uIType.equals(AttributeSchema.UIType.LINK)) {
            return 23;
        }
        if (uIType.equals(AttributeSchema.UIType.BUTTON)) {
            return 24;
        }
        return 25;
    }

    public int getSyntax() {
        String string = this.attrSchema.getSyntax().toString();
        if (string.equals(AttributeSchema.Syntax.BOOLEAN.toString())) {
            return 5;
        }
        if (string.equals(AttributeSchema.Syntax.EMAIL.toString())) {
            return 6;
        }
        if (string.equals(AttributeSchema.Syntax.URL.toString())) {
            return 7;
        }
        if (string.equals(AttributeSchema.Syntax.STRING.toString())) {
            return 8;
        }
        if (string.equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD.toString())) {
            return 20;
        }
        if (string.equals(AttributeSchema.Syntax.PASSWORD.toString())) {
            return 9;
        }
        if (string.equals(AttributeSchema.Syntax.NUMERIC.toString())) {
            return 10;
        }
        if (string.equals(AttributeSchema.Syntax.NUMBER.toString())) {
            return 11;
        }
        if (string.equals(AttributeSchema.Syntax.PERCENT.toString())) {
            return 12;
        }
        if (string.equals(AttributeSchema.Syntax.NUMBER_RANGE.toString())) {
            return 13;
        }
        if (string.equals(AttributeSchema.Syntax.DECIMAL_RANGE.toString())) {
            return 14;
        }
        if (string.equals(AttributeSchema.Syntax.DECIMAL_NUMBER.toString())) {
            return 15;
        }
        if (string.equals(AttributeSchema.Syntax.DN.toString())) {
            return 16;
        }
        if (string.equals(AttributeSchema.Syntax.PARAGRAPH.toString())) {
            return 17;
        }
        if (string.equals(AttributeSchema.Syntax.XML.toString())) {
            return 19;
        }
        if (string.equals(AttributeSchema.Syntax.DATE.toString())) {
            return 18;
        }
        return -1;
    }

    public String getCosQualifier() {
        return this.attrSchema.getCosQualifier();
    }

    public Set getDefaultValues() {
        return this.attrSchema.getDefaultValues();
    }

    public String[] getChoiceValues() {
        return this.attrSchema.getChoiceValues();
    }

    public String getChoiceValueI18NKey(String string) {
        return this.attrSchema.getChoiceValueI18NKey(string);
    }

    public String getI18NKey() {
        return this.attrSchema.getI18NKey();
    }

    public void setI18NKey(String string) throws AMException {
        try {
            this.attrSchema.setI18NKey(string);
        }
        catch (SMSException sMSException) {
            AMCommonUtils.debug.message("AMAttributeSchema.setAttributeDefaults(Map): ", sMSException);
            throw new AMException(AMSDKBundle.getString("916"), "916");
        }
        catch (SSOException sSOException) {
            AMCommonUtils.debug.message("AMAttributeSchema.setAttributeDefaults(Map): ", sSOException);
            throw new AMException(AMSDKBundle.getString("916"), "916");
        }
    }

    public String getStartRange() {
        return this.attrSchema.getStartRange();
    }

    public String getEndRange() {
        return this.attrSchema.getEndRange();
    }

    public String getAny() {
        return this.attrSchema.getAny();
    }

    public String getPropertiesViewBeanURL() {
        return this.attrSchema.getPropertiesViewBeanURL();
    }

    public String getTrueValue() {
        return this.attrSchema.getTrueValue();
    }

    public String getTrueValueI18NKey() {
        return this.attrSchema.getTrueValueI18NKey();
    }

    public String getFalseValue() {
        return this.attrSchema.getFalseValue();
    }

    public String getFalseValueI18NKey() {
        return this.attrSchema.getFalseValueI18NKey();
    }

    public String toString() {
        return this.attrSchema.toString();
    }
}

