/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.spi;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.SecureFileHandler;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Archiver {
    private static SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmmss");
    private static final String PREFIX = "_secure.";
    private int filesPerKeystoreCounter = 0;
    private int filesPerKeyStore;
    private String path;
    private String name;
    private static LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();

    public Archiver() {
        String string = lmanager.getProperty("iplanet-am-logging-files-per-keystore");
        if (string == null || string.length() == 0) {
            Debug.error("Archiver: could not get the files per keystore str setting it to 1");
            string = "1";
        }
        this.filesPerKeyStore = Integer.parseInt(string);
    }

    public void archive(String string, String string2) {
        if (string == null || string.length() == 0) {
            Debug.error("Archiver: FileName is null");
            return;
        }
        if (string2 == null || string2.length() == 0) {
            Debug.error("Archiver: Location is null");
            return;
        }
        Logger logger = (Logger)Logger.getLogger(string);
        ++this.filesPerKeystoreCounter;
        Date date = new Date();
        String string3 = string2 + PREFIX + string + "." + sdf.format(date).toString();
        String string4 = string2 + PREFIX + string;
        File file = new File(string4);
        file.renameTo(new File(string3));
        SecureFileHandler.addToCurrentFileList(string, string + "." + sdf.format(date).toString(), string);
    }

    public int checkCount() {
        return this.filesPerKeystoreCounter;
    }

    public void incrementCount() {
        ++this.filesPerKeystoreCounter;
    }

    public void archiveKeyStore(String string, String string2) {
        Logger logger = (Logger)Logger.getLogger(string);
        ArrayList arrayList = SecureFileHandler.getCurrentFileList(string);
        String string3 = ((String)arrayList.get(arrayList.size() - 2)).substring(((String)arrayList.get(arrayList.size() - 2)).lastIndexOf("."));
        if (Debug.messageEnabled()) {
            Debug.message("Archive Keystore timestamp=" + string3);
        }
        String string4 = string2 + PREFIX + "log." + string + string3;
        String string5 = string2 + PREFIX + "ver." + string + string3;
        String string6 = string2 + PREFIX + "log." + string;
        String string7 = string2 + PREFIX + "ver." + string;
        File file = new File(string6);
        file.renameTo(new File(string4));
        File file2 = new File(string7);
        file2.renameTo(new File(string5));
        this.filesPerKeystoreCounter = 0;
    }
}

