/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.service;

import com.iplanet.dpro.parser.WebtopParser;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.service.LogOperation;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.session.util.RestrictedTokenHelper;
import com.sun.identity.session.util.SessionUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogService
implements RequestHandler {
    private static String loggedBySid;
    private static final String pkg = "com.sun.identity.log.service.";
    private static final String LOG_SERVICE = "iplanet.webtop.service.logging";
    WebtopParser parser = new WebtopParser();

    public LogService() throws Exception {
        this.parser.register("logRecWrite", "com.sun.identity.log.service.LogRecWrite");
        this.parser.register("log", "com.sun.identity.log.service.Log");
        this.parser.register("logRecord", "com.sun.identity.log.service.LogRecord");
        this.parser.register("level", "com.sun.identity.log.service.Level");
        this.parser.register("recMsg", "com.sun.identity.log.service.RecMsg");
        this.parser.register("recType", "com.sun.identity.log.service.RecType");
        this.parser.register("logType", "com.sun.identity.log.service.LogType");
        this.parser.register("logInfoMap", "com.sun.identity.log.service.LogInfoMap");
        this.parser.register("logInfo", "com.sun.identity.log.service.LogInfo");
        this.parser.register("infoKey", "com.sun.identity.log.service.InfoKey");
        this.parser.register("infoValue", "com.sun.identity.log.service.InfoValue");
        this.parser.register("parameters", "com.sun.identity.log.service.Parameters");
        this.parser.register("parameter", "com.sun.identity.log.service.Parameter");
        this.parser.register("paramIndex", "com.sun.identity.log.service.ParamIndex");
        this.parser.register("paramValue", "com.sun.identity.log.service.ParamValue");
    }

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        if (Debug.messageEnabled()) {
            Debug.message("LogService.process() called :requests are");
            int n = 0;
            while (n < vector.size()) {
                Debug.message("xml = " + ((Request)vector.elementAt(n)).getContent());
                ++n;
            }
        }
        ResponseSet responseSet = new ResponseSet(LOG_SERVICE);
        int n = 0;
        while (n < vector.size()) {
            Response response;
            Request request = (Request)vector.elementAt(n);
            String string = request.getContent();
            if (string == null || string.equals("null")) {
                Debug.error("Received a null log request");
                response = new Response("NULL_LOG_REQUEST");
                responseSet.addResponse(response);
            } else {
                Object object;
                Object object2;
                int n2 = string.length();
                int n3 = string.indexOf("sid=");
                int n4 = string.indexOf("</log");
                loggedBySid = string.substring(n3 + 5, n4 - 2);
                try {
                    object2 = SessionUtils.getClientAddress((HttpServletRequest)httpServletRequest);
                    object = RestrictedTokenHelper.resolveRestrictedToken((String)loggedBySid, (Object)object2);
                    SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                    if (!sSOTokenManager.isValidToken((SSOToken)object)) {
                        String string2 = object.getPrincipal().getName();
                        Debug.error("LogService::process(): access denied for user :" + string2);
                        response = new Response("UNAUTHORIZED");
                        responseSet.addResponse(response);
                        return responseSet;
                    }
                }
                catch (SSOException sSOException) {
                    Debug.error("LogService::process(): SSOException", sSOException);
                    response = new Response("UNAUTHORIZED");
                    responseSet.addResponse(response);
                    return responseSet;
                }
                catch (Exception exception) {
                    Debug.error("LogService::process(): ", exception);
                    response = new Response("ERROR");
                    responseSet.addResponse(response);
                }
                try {
                    object2 = new ByteArrayInputStream(string.getBytes("UTF-8"));
                    object = (LogOperation)this.parser.parse((InputStream)object2);
                    response = object.execute();
                }
                catch (Exception exception) {
                    Debug.error("LogService::process():", exception);
                    response = new Response("ERROR");
                }
                responseSet.addResponse(response);
            }
            ++n;
        }
        return responseSet;
    }
}

