/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.sun.identity.log.spi.Debug;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.StringTokenizer;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.PFX;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.util.Password;

public class SecureLogHelper {
    private static int keyLength = 168;
    private static String currentKeyName = null;
    private static String loggerKey = "Logger";
    private static String verifier = "Verifier";
    private static String initialKey = "InitialKey";
    private static String currentKey = "CurrentKey";
    private static String currentSignature = "CurrentSignature";
    private byte[] currentLoggerKey = null;
    private byte[] currentVerifierKey = null;
    private byte[] currentVerifierSignature = null;
    private byte[] lastMac = null;
    private byte[] currentMAC = null;
    private byte[] lastLoggerKey = null;
    private String logFileName = null;
    private String verifierFileName = null;
    private CryptoToken mToken = null;
    private boolean loggerInitialized = false;
    private boolean verifierInitialized = false;
    private Password loggerPass = null;
    private Password verifierPass = null;
    private boolean LoggerLastLine = false;
    private boolean VerifierLastLine = false;

    public SecureLogHelper(CryptoManager.InitializationValues initializationValues) throws Exception {
        try {
            CryptoManager cryptoManager = CryptoManager.getInstance();
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            if (Debug.warningEnabled()) {
                Debug.warning("SecureLogHelper :  CryptoManager.NotInitializedException : ", notInitializedException);
            }
            CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
        }
    }

    public synchronized void initializeSecureLogHelper(String string, String string2, Password password, String string3, Password password2) throws Exception {
        this.logFileName = string2;
        this.verifierFileName = string3;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        this.loggerPass = new Password(new String(messageDigest.digest(Password.charToByte((char[])password.getCharCopy())), "UTF-8").toCharArray());
        messageDigest.reset();
        Password password3 = new Password(new String(messageDigest.digest(Password.charToByte((char[])password2.getCharCopy())), "UTF-8").toCharArray());
        CryptoManager cryptoManager = CryptoManager.getInstance();
        this.mToken = string == null || string.equals("") ? cryptoManager.getInternalCryptoToken() : cryptoManager.getTokenByName(string);
        this.loggerInitialized = this.isInitialized(string2, this.loggerPass);
        if (!this.loggerInitialized) {
            KeyGenerator keyGenerator = this.mToken.getKeyGenerator(KeyGenAlgorithm.DES3);
            keyGenerator.initialize(keyLength);
            SymmetricKey symmetricKey = keyGenerator.generate();
            this.currentLoggerKey = symmetricKey.getKeyData();
            this.writeToSecretStore(symmetricKey.getKeyData(), string2, this.loggerPass, initialKey);
            this.loggerInitialized = true;
            this.writeToSecretStore(symmetricKey.getKeyData(), string2, this.loggerPass, currentKey);
            this.writeToSecretStore(symmetricKey.getKeyData(), this.verifierFileName, password3, initialKey);
        } else {
            if (Debug.messageEnabled()) {
                Debug.message(this.logFileName + " Logger Module is already " + " initialized");
            }
            this.currentLoggerKey = this.readFromSecretStore(string2, currentKey, this.loggerPass);
        }
    }

    public synchronized byte[] generateLogEntryMAC(String string) throws Exception {
        byte[] byArray = null;
        this.lastMac = this.currentMAC;
        byte[] byArray2 = this.readFromSecretStore(this.logFileName, initialKey, this.loggerPass);
        byArray = this.readFromSecretStore(this.logFileName, currentKey, this.loggerPass);
        if (this.currentLoggerKey != null && !new String(this.currentLoggerKey).equals(new String(byArray))) {
            throw new Exception("Possible Intrusion or  Misconfiguration");
        }
        this.currentLoggerKey = byArray;
        this.currentMAC = this.getDigest(string, this.currentLoggerKey);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        messageDigest.update(this.currentLoggerKey);
        this.currentLoggerKey = messageDigest.digest();
        this.writeToSecretStore(this.currentLoggerKey, this.logFileName, this.loggerPass, currentKey);
        return this.currentMAC;
    }

    public byte[] signMAC(byte[] byArray) throws Exception {
        try {
            CryptoManager cryptoManager = CryptoManager.getInstance();
            PrivateKey privateKey = null;
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = cryptoManager.findCertByNickname(loggerKey);
            }
            catch (Exception exception) {
                Debug.error("SecureLogHelper.signMAC() :  Exception : ", exception);
            }
            try {
                privateKey = cryptoManager.findPrivKeyByCert(x509Certificate);
            }
            catch (Exception exception) {
                Debug.error("SecureLogHelper.signMAC() :  Exception : ", exception);
            }
            Signature signature = this.mToken.getSignatureContext(SignatureAlgorithm.RSASignatureWithSHA1Digest);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            this.writeToSecretStore(byArray2, this.logFileName, this.loggerPass, currentSignature);
            return byArray2;
        }
        catch (Exception exception) {
            Debug.error("SecureLogHelper.signMAC() :  Exception : ", exception);
            throw new Exception(exception.getMessage());
        }
    }

    public byte[] getLastMAC() {
        return this.currentMAC;
    }

    public byte[] getLastSignatureBytes() throws Exception {
        return this.readFromSecretStore(this.logFileName, currentSignature, this.loggerPass);
    }

    public String getPKCS12LogFileName() {
        return this.logFileName;
    }

    public String getPKCS12VerifierFileName() {
        return this.verifierFileName;
    }

    public synchronized void initializeVerifier(String string, Password password, Password password2) throws Exception {
        Object object;
        this.verifierFileName = string;
        if (this.mToken == null || this.mToken.equals((Object)"")) {
            this.mToken = CryptoManager.getInstance().getInternalCryptoToken();
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        Password password3 = new Password(new String(messageDigest.digest(Password.charToByte((char[])password.getCharCopy())), "UTF-8").toCharArray());
        messageDigest.reset();
        this.verifierPass = new Password(new String(messageDigest.digest(Password.charToByte((char[])password2.getCharCopy())), "UTF-8").toCharArray());
        this.verifierInitialized = password != null ? this.isInitialized(string, this.verifierPass) : true;
        if (!this.verifierInitialized) {
            this.currentVerifierKey = this.readFromSecretStore(this.verifierFileName, initialKey, password3);
            object = (Password)this.verifierPass.clone();
            this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, this.verifierPass, initialKey);
            this.verifierInitialized = true;
            this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, (Password)object, currentKey);
        } else {
            this.currentVerifierKey = this.readFromSecretStore(this.verifierFileName, currentKey, this.verifierPass);
        }
        object = this.readFromSecretStore(string, initialKey, this.verifierPass);
    }

    public synchronized void reinitializeVerifier(String string, Password password) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        Password password2 = new Password(new String(messageDigest.digest(Password.charToByte((char[])password.getCharCopy())), "UTF-8").toCharArray());
        this.verifierInitialized = this.isInitialized(string, password2);
        if (!this.verifierInitialized) {
            throw new Exception(this.logFileName + " Verifier is not initialized");
        }
        this.currentVerifierKey = this.readFromSecretStore(this.verifierFileName, initialKey, password2);
        Password password3 = (Password)password2.clone();
        this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, password3, currentKey);
    }

    public void setLastLineforLogger(boolean bl) {
        this.LoggerLastLine = bl;
        if (this.lastLoggerKey == null) {
            this.lastLoggerKey = new byte[this.currentLoggerKey.length];
        }
        System.arraycopy(this.currentLoggerKey, 0, this.lastLoggerKey, 0, this.currentLoggerKey.length);
    }

    public void setLastLineforVerifier(boolean bl) {
        this.VerifierLastLine = bl;
    }

    public boolean isIntrusionTrue() {
        if (this.LoggerLastLine && this.VerifierLastLine) {
            return !new String(this.currentVerifierKey).equals(new String(this.lastLoggerKey));
        }
        return false;
    }

    public boolean verifyMAC(String string, byte[] byArray) throws Exception {
        try {
            byte[] byArray2 = this.readFromSecretStore(this.verifierFileName, currentKey, this.verifierPass);
            if (this.currentVerifierKey != null && !new String(this.currentVerifierKey).equals(new String(byArray2))) {
                throw new Exception(this.verifierFileName + " Possible Intrusion or " + " Misconfiguration");
            }
            this.currentVerifierKey = byArray2;
            byte[] byArray3 = this.getDigest(string, this.currentVerifierKey);
            if (this.equalByteArrays(byArray, byArray3)) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(this.currentVerifierKey);
                this.currentVerifierKey = messageDigest.digest();
                this.writeToSecretStore(this.currentVerifierKey, this.verifierFileName, this.verifierPass, currentKey);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Debug.error("SecureLogHelper.verifyMAC() :  Exception : ", exception);
            return false;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws Exception {
        try {
            CryptoManager cryptoManager = CryptoManager.getInstance();
            PublicKey publicKey = null;
            X509Certificate x509Certificate = cryptoManager.findCertByNickname(loggerKey);
            publicKey = x509Certificate.getPublicKey();
            Signature signature = this.mToken.getSignatureContext(SignatureAlgorithm.RSASignatureWithSHA1Digest);
            signature.initVerify(publicKey);
            signature.update(byArray2);
            return signature.verify(byArray);
        }
        catch (Exception exception) {
            Debug.error("SecureLogHelper.verifySignature() :  Exception : ", exception);
            throw new Exception(exception.getMessage());
        }
    }

    private byte[] createLocalKeyId(byte[] byArray) throws Exception {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            Debug.error("SecureLogHelper.createLocalKeyId() :  Exception : ", exception);
            throw new Exception("Failed to create Key ID - " + exception.toString());
        }
    }

    private SET createBagAttrs(String string, byte[] byArray) throws Exception {
        try {
            SET sET = new SET();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement((ASN1Value)SafeBag.FRIENDLY_NAME);
            SET sET2 = new SET();
            sET2.addElement((ASN1Value)new BMPString(string));
            sEQUENCE.addElement((ASN1Value)sET2);
            sET.addElement((ASN1Value)sEQUENCE);
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addElement((ASN1Value)SafeBag.LOCAL_KEY_ID);
            SET sET3 = new SET();
            sET3.addElement((ASN1Value)new OCTET_STRING(byArray));
            sEQUENCE2.addElement((ASN1Value)sET3);
            sET.addElement((ASN1Value)sEQUENCE2);
            return sET;
        }
        catch (Exception exception) {
            Debug.error("SecureLogHelper.createBagAttrs() :  Exception : ", exception);
            throw new Exception("Failed to create Key Bag - " + exception.toString());
        }
    }

    private byte[] readFromSecretStore(String string, String string2, Password password) throws Exception {
        StringBuffer stringBuffer;
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        boolean bl = false;
        PFX.Template template = new PFX.Template();
        PFX pFX = (PFX)template.decode((InputStream)new BufferedInputStream(fileInputStream, 2048));
        if (!pFX.verifyAuthSafes(password, stringBuffer = new StringBuffer())) {
            throw new Exception("AuthSafes failed to verify because: " + stringBuffer.toString());
        }
        AuthenticatedSafes authenticatedSafes = pFX.getAuthSafes();
        SEQUENCE sEQUENCE = authenticatedSafes.getSequence();
        byte[] byArray = null;
        int n = 0;
        while (n < sEQUENCE.size()) {
            SEQUENCE sEQUENCE2 = authenticatedSafes.getSafeContentsAt(password, n);
            SafeBag safeBag = null;
            ASN1Value aSN1Value = null;
            int n2 = 0;
            while (n2 < sEQUENCE2.size()) {
                safeBag = (SafeBag)sEQUENCE2.elementAt(n2);
                SET sET = safeBag.getBagAttributes();
                if (sET != null) {
                    int n3 = 0;
                    while (n3 < sET.size()) {
                        BMPString bMPString;
                        Attribute attribute = (Attribute)sET.elementAt(n3);
                        if (attribute.getType().equals((Object)SafeBag.FRIENDLY_NAME) && string2.equals((bMPString = (BMPString)((ANY)attribute.getValues().elementAt(0)).decodeWith((ASN1Template)BMPString.getTemplate())).toString())) {
                            aSN1Value = safeBag.getInterpretedBagContent();
                            break;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            if (aSN1Value instanceof ANY) {
                byArray = ((ANY)aSN1Value).getContents();
            }
            ++n;
        }
        fileInputStream.close();
        return byArray;
    }

    private void writeToSecretStore(byte[] byArray, String string, Password password, String string2) throws Exception {
        SEQUENCE sEQUENCE;
        Object object;
        byte[] byArray2 = null;
        String string3 = null;
        if (string.equals(this.logFileName) && this.loggerInitialized) {
            if (string2.equals(currentSignature)) {
                byArray2 = this.readFromSecretStore(this.logFileName, currentKey, password);
                string3 = currentKey;
            } else if (string2.equals(currentKey)) {
                byArray2 = this.readFromSecretStore(this.logFileName, currentSignature, password);
                string3 = currentSignature;
            }
        }
        AuthenticatedSafes authenticatedSafes = new AuthenticatedSafes();
        if (byArray2 != null) {
            object = this.AddToSecretStore(byArray2, string3);
            authenticatedSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, password, null, 1, object);
        }
        if (string.equals(this.logFileName) && !string2.equals(initialKey) && this.loggerInitialized && (object = (Object)this.readFromSecretStore(string, initialKey, password)) != null) {
            sEQUENCE = this.AddToSecretStore((byte[])object, initialKey);
            authenticatedSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, password, null, 1, sEQUENCE);
        }
        if (string.equals(this.verifierFileName) && !string2.equals(initialKey) && this.verifierInitialized && (object = (Object)this.readFromSecretStore(string, initialKey, password)) != null) {
            sEQUENCE = this.AddToSecretStore((byte[])object, initialKey);
            authenticatedSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, password, null, 1, sEQUENCE);
        }
        object = this.AddToSecretStore(byArray, string2);
        authenticatedSafes.addEncryptedSafeContents(PBEAlgorithm.PBE_SHA1_DES3_CBC, password, null, 1, object);
        sEQUENCE = new PFX(authenticatedSafes);
        sEQUENCE.computeMacData(password, null, 5);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        sEQUENCE.encode((OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    private byte[] getDigest(String string, byte[] byArray) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        MessageDigest messageDigest2 = MessageDigest.getInstance("SHA");
        messageDigest2.update(string.getBytes());
        messageDigest2.update(byArray);
        messageDigest.update(byArray);
        byArray = null;
        messageDigest.update(messageDigest2.digest());
        return messageDigest.digest();
    }

    private SEQUENCE AddToSecretStore(byte[] byArray, String string) throws Exception {
        SEQUENCE sEQUENCE = new SEQUENCE();
        OCTET_STRING oCTET_STRING = new OCTET_STRING(byArray);
        byte[] byArray2 = this.createLocalKeyId(byArray);
        SET sET = this.createBagAttrs(string, byArray2);
        SafeBag safeBag = new SafeBag(SafeBag.SECRET_BAG, (ASN1Value)oCTET_STRING, sET);
        sEQUENCE.addElement((ASN1Value)safeBag);
        return sEQUENCE;
    }

    public String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.bytetohex((byte)(byArray[n2] + 128), stringBuffer);
            if (n2 < n - 1) {
                stringBuffer.append(":");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void bytetohex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    public static byte[] toByteArray(String string) {
        int n = string.length();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        byte[] byArray = new byte[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = Integer.parseInt(stringArray[n3], 16);
            byArray[n3] = (byte)(n4 - 128);
            ++n3;
        }
        return byArray;
    }

    private boolean isInitialized(String string, Password password) {
        try {
            byte[] byArray = null;
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(string);
            byArray = this.readFromSecretStore(string, currentKey, password);
            return byArray != null;
        }
        catch (Exception exception) {
            if (Debug.messageEnabled()) {
                Debug.message("SecureLogHelper.isInitialized() : " + exception.getMessage() + " : returning false");
            }
            return false;
        }
    }

    private boolean equalByteArrays(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
        int n = 0;
        while (n < byteArrayInputStream.available()) {
            int n2;
            int n3 = byteArrayInputStream.read();
            if (n3 == (n2 = byteArrayInputStream2.read())) continue;
            byteArrayInputStream.close();
            byteArrayInputStream2.close();
            return false;
        }
        byteArrayInputStream.close();
        byteArrayInputStream2.close();
        return true;
    }

    public static void setLoggerKeyName(String string) {
        loggerKey = string;
    }

    public static String getLoggerKeyName() {
        return loggerKey;
    }
}

