/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.SecureFileHandler;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.IVerifierOutput;
import com.sun.identity.log.spi.Token;
import com.sun.identity.log.spi.VerifierAction;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.LogManager;
import org.mozilla.jss.util.Password;

public class LogVerifier {
    private static String PREFIX = "_secure.";
    private String curMAC = null;
    private Timer verifyTimer;
    private String prevSignature = null;
    private IVerifierOutput result;
    private boolean verified = true;
    private SecureLogHelper helper;
    private Password logPassword;
    private Password verPassword;
    private String name;
    private LogManager manager = LogManagerUtil.getLogManager();
    private Logger logger;
    private boolean verificationOn = false;

    public LogVerifier(String string, Password password, Password password2) {
        this.name = string;
        this.logPassword = password;
        this.verPassword = password2;
    }

    public boolean getVerificationFlag() {
        return this.verificationOn;
    }

    public void startLogVerifier() {
        String string = this.manager.getProperty("iplanet-am-logging-verify-period-in-seconds");
        long l = string != null || string.length() != 0 ? Long.parseLong(string) : 3600L;
        l *= 1000L;
        if (this.verifyTimer == null) {
            this.verifyTimer = new Timer();
            this.verifyTimer.scheduleAtFixedRate((TimerTask)new VerifyTask(), l, l);
            if (Debug.messageEnabled()) {
                Debug.message(this.name + ":Verifier Thread Started");
            }
        }
    }

    public void stopLogVerifier() {
        if (this.verifyTimer != null) {
            this.verifyTimer.cancel();
        }
    }

    private boolean verifyLogRecord(String[] stringArray, int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length - 2) {
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        this.curMAC = new String(stringArray[n]);
        this.verified = this.helper.verifyMAC(stringBuffer.toString(), SecureLogHelper.toByteArray(this.curMAC));
        return this.verified;
    }

    private boolean verifySignature(String[] stringArray, int n, int n2) throws Exception {
        byte[] byArray;
        String string = new String(stringArray[n]);
        byte[] byArray2 = SecureLogHelper.toByteArray(this.curMAC);
        if (this.prevSignature == null || this.prevSignature.equals("")) {
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        } else {
            byArray = new byte[byArray2.length + SecureLogHelper.toByteArray(this.prevSignature).length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(SecureLogHelper.toByteArray(this.prevSignature), 0, byArray, byArray2.length, SecureLogHelper.toByteArray(this.prevSignature).length);
        }
        if (n2 != 0) {
            this.prevSignature = string;
        }
        this.verified = this.helper.verifySignature(SecureLogHelper.toByteArray(string), byArray);
        return this.verified;
    }

    public boolean verify() throws Exception {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        Object object;
        Logger logger = (Logger)Logger.getLogger(this.name);
        ArrayList arrayList = new ArrayList();
        String[][] stringArray = new String[1][1];
        Object object2 = new Object();
        Logger logger2 = logger;
        synchronized (logger2) {
            this.verificationOn = true;
            long l = System.currentTimeMillis();
            this.helper = SecureFileHandler.getSecureLogHelper(this.name);
            arrayList = SecureFileHandler.getCurrentFileList(this.name);
            if (arrayList == null) {
                Debug.error("No fileList found in handler.");
                boolean bl = VerifierAction.doVerifierAction(this.name, this.verified);
                return bl;
            }
            object2 = Token.createToken("AUDITOR", new String(this.verPassword.getCharCopy()));
            stringArray = LogReader.read((String)arrayList.get(arrayList.size() - 1), object2);
        }
        int n6 = 0;
        while (n6 < arrayList.size() - 1) {
            object = new String[1][1];
            try {
                object = LogReader.read((String)arrayList.get(n6), object2);
            }
            catch (Exception exception) {
                Debug.error("Error in reading File : " + arrayList.get(n6));
            }
            if (object == null || ((String[][])object).length == 0) {
                if (Debug.messageEnabled()) {
                    Debug.message("LogVerifier::verify::Empty return from read of " + (String)arrayList.get(n6) + ":" + arrayList.get(n6));
                }
                this.verified = false;
                break;
            }
            Vector<Object> vector = new Vector<Object>(((Object)object[0]).length);
            n5 = 0;
            while (n5 < ((Object)object[0]).length) {
                vector.add(object[0][n5]);
                ++n5;
            }
            n4 = -1;
            int n7 = -1;
            string = "Signature";
            String string2 = "MAC";
            n3 = 0;
            while (n3 < vector.size()) {
                if (((String)vector.get(n3)).equalsIgnoreCase(string)) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
            n2 = 0;
            while (n2 < vector.size()) {
                if (((String)vector.get(n2)).equalsIgnoreCase(string2)) {
                    n7 = n2;
                    break;
                }
                ++n2;
            }
            if (n4 == -1 || n7 == -1) {
                Debug.error("Could not locate mac and sign header");
                return VerifierAction.doVerifierAction(this.name, this.verified);
            }
            n = 1;
            while (n < ((Object)object).length) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.name + ":Start checking records " + ((Object)object).length + ":" + arrayList.get(n6));
                }
                if (((String)object[n][n4]).equals("-")) {
                    this.verified = this.verifyLogRecord((String[])object[n], n7);
                    if (!this.verified) {
                        Debug.error("Log Record Verification Failed in file:" + (String)arrayList.get(n6) + " at record no. " + n);
                        break;
                    }
                    if (Debug.messageEnabled()) {
                        Debug.message(this.name + ":Log Record Verification Succeeded in file:" + (String)arrayList.get(n6) + "at record no." + n);
                    }
                } else {
                    int n8 = 0;
                    n8 = ((Object)object).length - 1 - n;
                    this.verified = this.verifySignature((String[])object[n], n4, n8);
                    if (!this.verified) {
                        Debug.error("Log Signature Verification Failed in file:" + (String)arrayList.get(n6) + " at record no. " + n);
                        break;
                    }
                    if (Debug.messageEnabled()) {
                        Debug.message("Log Signature Verification Succeeded in file:" + (String)arrayList.get(n6) + "at record no." + n);
                    }
                }
                ++n;
            }
            if (!this.verified) break;
            ++n6;
        }
        if (stringArray != null && stringArray.length != 0) {
            object = new Vector(stringArray[0].length);
            int n9 = 0;
            while (n9 < stringArray[0].length) {
                ((Vector)object).add(stringArray[0][n9]);
                ++n9;
            }
            n5 = -1;
            n4 = -1;
            String string3 = "Signature";
            string = "MAC";
            int n10 = 0;
            while (n10 < ((Vector)object).size()) {
                if (((String)((Vector)object).get(n10)).equalsIgnoreCase(string3)) {
                    n5 = n10;
                    break;
                }
                ++n10;
            }
            n3 = 0;
            while (n3 < ((Vector)object).size()) {
                if (((String)((Vector)object).get(n3)).equalsIgnoreCase(string)) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
            if (n5 == -1 || n4 == -1) {
                Debug.error("Could not locate mac and sign header");
                return VerifierAction.doVerifierAction(this.name, this.verified);
            }
            n2 = 1;
            while (n2 < stringArray.length) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.name + ":Start checking records " + stringArray.length + ":" + arrayList.get(arrayList.size() - 1));
                }
                if (stringArray[n2][n5].equals("-")) {
                    this.verified = this.verifyLogRecord(stringArray[n2], n4);
                    if (!this.verified) {
                        Debug.error("Log Record Verification Failed in file:" + (String)arrayList.get(arrayList.size() - 1) + " at record no. " + n2);
                        break;
                    }
                    if (Debug.messageEnabled()) {
                        Debug.message(this.name + ":Log Record Verification Succeeded in file:" + (String)arrayList.get(arrayList.size() - 1) + "at record no." + n2);
                    }
                } else {
                    n = 0;
                    n = stringArray.length - 1 - n2;
                    this.verified = this.verifySignature(stringArray[n2], n5, n);
                    if (!this.verified) {
                        Debug.error("Log Signature Verification Failed in file:" + (String)arrayList.get(arrayList.size() - 1) + " at record no. " + n2);
                        break;
                    }
                    if (Debug.messageEnabled()) {
                        Debug.message("Log Signature Verification Succeeded in file:" + (String)arrayList.get(arrayList.size() - 1) + "at record no." + n2);
                    }
                }
                ++n2;
            }
        } else {
            if (Debug.messageEnabled()) {
                Debug.message("LogVerifier::verify::Empty return from read of " + (String)arrayList.get(arrayList.size() - 1) + ":" + arrayList.get(arrayList.size() - 1));
            }
            this.verified = false;
        }
        this.prevSignature = null;
        this.curMAC = null;
        object = this.manager.getProperty("iplanet-am-logging-location");
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        String string4 = (String)object + PREFIX + "ver." + this.name;
        this.helper.setLastLineforVerifier(true);
        n5 = this.helper.isIntrusionTrue() ? 1 : 0;
        if (n5 != 0) {
            Debug.error(this.name + " Last Line check in Verifier failed." + " Possible intrusion detected");
            this.verified = false;
        }
        this.helper.setLastLineforVerifier(false);
        this.helper.reinitializeVerifier(string4, this.verPassword);
        if (Debug.messageEnabled()) {
            Debug.message(this.name + ":Done Verifying");
        }
        return VerifierAction.doVerifierAction(this.name, this.verified);
    }

    class VerifyTask
    extends TimerTask {
        VerifyTask() {
        }

        public void run() {
            try {
                LogVerifier.this.verify();
            }
            catch (Exception exception) {
                Debug.error(LogVerifier.this.name + ":Error running verifier thread", exception);
            }
            LogVerifier.this.verificationOn = false;
        }
    }
}

