/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.messageid;

import com.sun.identity.log.spi.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogMessageID {
    private Level logLevel;
    private String prefix;
    private int id;
    private String name;
    private String description;
    private int dataInfo;
    private static Map mapLogLevel = new HashMap();

    public LogMessageID(Level level, String string, int n, String string2, String string3, int n2) {
        this.logLevel = level;
        this.prefix = string;
        this.id = n;
        this.name = string2;
        this.description = string3;
        this.dataInfo = n2;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    static LogMessageID createInstance(String string, Node node) {
        String string2;
        LogMessageID logMessageID = null;
        if (node != null && node.getNodeType() == 1 && (string2 = node.getNodeName()).equals("logmessage")) {
            String string3 = ((Element)node).getAttribute("name");
            String string4 = ((Element)node).getAttribute("id");
            String string5 = ((Element)node).getAttribute("loglevel");
            String string6 = ((Element)node).getAttribute("description");
            if (string3.length() > 0 && string4.length() > 0) {
                try {
                    logMessageID = new LogMessageID((Level)mapLogLevel.get(string5), string, Integer.parseInt(string4), string3, string6, LogMessageID.getArrayCount(node, "datainfo"));
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.error("LogMessageID.createInstance", numberFormatException);
                }
            } else {
                Debug.error("LogMessageID.createInstance: unable to create log message ID because its name is missing");
            }
        }
        return logMessageID;
    }

    private static int getArrayCount(Node node, String string) {
        NodeList nodeList;
        int n = 0;
        Node node2 = LogMessageID.getNodeOfName(node, string);
        if (node2 != null && (nodeList = node2.getChildNodes()) != null) {
            n = nodeList.getLength();
        }
        return n;
    }

    private static Node getNodeOfName(Node node, String string) {
        Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n && node2 == null) {
                Node node3 = nodeList.item(n2);
                if (node3.getNodeName().equals(string)) {
                    node2 = node3;
                }
                ++n2;
            }
        }
        return node2;
    }

    static {
        mapLogLevel.put("LL_CONFIG", Level.CONFIG);
        mapLogLevel.put("LL_FINE", Level.FINE);
        mapLogLevel.put("LL_FINER", Level.FINER);
        mapLogLevel.put("LL_FINEST", Level.FINEST);
        mapLogLevel.put("LL_INFO", Level.INFO);
        mapLogLevel.put("LL_SEVERE", Level.SEVERE);
        mapLogLevel.put("LL_ALL", Level.ALL);
    }
}

