/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.secure.MACGenerator;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.IGenerator;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class SecureELFFormatter
extends Formatter {
    private LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String[] allFields;
    private IGenerator fieldGenerator = new MACGenerator();
    private ITimestampGenerator secureTimestampGenerator;

    public SecureELFFormatter() {
        String string = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clazz = Class.forName(string);
            this.secureTimestampGenerator = (ITimestampGenerator)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error("SecureELFFormatter: TimeStamp Generator Class not found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Debug.error("SecureELFFormatter: Timestamp Generator Couldnot be Instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Debug.error("SecureELFFormatter: Timestamp Generator Couldnot be Instantiated", illegalAccessException);
        }
    }

    private void getAllFields() {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        this.allFields = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.allFields[n++] = stringTokenizer.nextToken().trim();
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + this.allFields[n2] + "\t";
            ++n2;
        }
    }

    public String format(java.util.logging.LogRecord logRecord) {
        String string;
        Object[] objectArray;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Map map = ((LogRecord)logRecord).getLogInfoMap();
        try {
            this.getAllFields();
            object = this.getSelectedFieldSet();
            objectArray = this.secureTimestampGenerator.getTimestamp();
            stringBuffer.append("\"").append((String)objectArray).append("\"\t");
            stringBuffer2.append("\"").append((String)objectArray).append("\"");
            string = this.processString(this.formatMessage(logRecord));
            if (string.indexOf(32) != -1 || string.indexOf(9) != -1) {
                stringBuffer.append("\"").append(string).append("\"\t");
                stringBuffer2.append("\"").append(string).append("\"");
            } else {
                stringBuffer.append(string).append("\t");
                stringBuffer2.append(string);
            }
            String string2 = null;
            String string3 = null;
            int n = 2;
            while (n < this.allFields.length) {
                string2 = this.allFields[n];
                if (string2 != null && string2.length() != 0 && object != null && map != null && object.contains(string2)) {
                    string3 = (String)map.get(string2);
                    string3 = string3 != null && string3.length() != 0 ? this.processString(string3) : "Not Available";
                    if (string3.indexOf(32) != -1 || string3.indexOf(9) != -1) {
                        stringBuffer.append("\"").append(string3).append("\"\t");
                        stringBuffer2.append("\"").append(string3).append("\"");
                    } else {
                        stringBuffer.append(string3).append("\t");
                        stringBuffer2.append(string3);
                    }
                } else {
                    stringBuffer.append("-").append("\t");
                    stringBuffer2.append("-");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Debug.error("SecureELFFormatter: Exception in String Handling", exception);
        }
        object = "Signature";
        if (map.containsKey(object)) {
            stringBuffer.append("-\t").append(map.get(object));
        } else {
            try {
                objectArray = new Object[]{logRecord.getLoggerName()};
                string = this.fieldGenerator.generateLogField(stringBuffer2.toString(), objectArray);
                stringBuffer.append(string).append("\t").append("-");
            }
            catch (Exception exception) {
                Debug.error("SecureLFFormatter: couldnot generate mac", exception);
                stringBuffer.append("\"MAC NOT AVAILABLE\"").append("\t").append("-");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#Version: 1.0").append("\n");
        stringBuffer.append("#Fields: ").append(this.constructHeader()).append("\n");
        return stringBuffer.toString();
    }

    public String getTail(Handler handler) {
        return "";
    }

    private String constructHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.allFields.length) {
            stringBuffer.append(this.allFields[n]).append("\t");
            ++n;
        }
        stringBuffer.append("MAC").append("\t");
        stringBuffer.append("Signature");
        return stringBuffer.toString();
    }

    private Set getSelectedFieldSet() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.lmanager.getProperty("iplanet-am-logging-logfields");
        if (string != null && string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return hashSet;
    }

    private String processString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"') {
                stringBuffer.append("\"\"");
                bl = true;
            }
            if (c == '\r') {
                stringBuffer.append("\\\\r");
                bl = true;
            }
            if (c == '\n') {
                stringBuffer.append("\\\\n");
                bl = true;
            }
            if (!bl) {
                stringBuffer.append(c);
            }
            bl = false;
            ++n2;
        }
        return stringBuffer.toString();
    }
}

