/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.AMLogException;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.QueryElement;
import com.sun.identity.log.handlers.ReadDBHandler;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.util.LogRecordSorter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.LogManager;

public class LogReadDBHandler
implements ReadDBHandler {
    private String logTableName;
    private String databaseURL;
    private String dbDriver;
    private boolean isMySQL = false;
    private String dbUserName;
    private String dbPassWord;
    private LogQuery queryCriteria = null;
    private int maxNoOfRecs = -1;
    private String maxRecordsStr = null;
    private int maxRecords = 0;
    private String version = "#Version:";
    private String fieldName = "#Fields: ";
    private LogRecordSorter sorter = null;
    private String[][] queryResult;
    private ArrayList listOfValidRecords = new ArrayList();
    private Connection conn = null;

    public String[][] logRecRead(String string, LogQuery logQuery, LogManager logManager, boolean bl) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, SQLException, ClassNotFoundException, Exception {
        String string2;
        Object object;
        String string3;
        String[][] stringArray;
        String string4 = null;
        this.cleaner();
        this.logTableName = string = string.replace('.', '_');
        try {
            this.databaseURL = logManager.getProperty("iplanet-am-logging-location");
            this.dbDriver = logManager.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logManager.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logManager.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logManager.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception exception) {
            Debug.error("DBLogRecRead:config: ", exception);
            throw exception;
        }
        if (this.dbDriver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
        } else if (this.dbDriver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
        } else {
            this.isMySQL = false;
            Debug.warning("DBlogRecRead:assuming driver: '" + this.dbDriver + "' is Oracle-compatible.");
        }
        if (bl) {
            this.queryCriteria = logQuery;
            stringArray = logQuery.getSortingField();
            if (stringArray != null) {
                string4 = stringArray.trim();
            }
            string3 = "*";
            object = logQuery.getColumns();
            if (object != null) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = ((ArrayList)object).size();
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append((String)((ArrayList)object).get(n2));
                    if (n2 + 1 < n) {
                        stringBuffer.append(", ");
                    }
                    ++n2;
                }
                string3 = stringBuffer.toString();
            }
            string2 = this.lq2Select(string, string3, logQuery);
            if (Debug.messageEnabled()) {
                Debug.message("logRecRead/4:selectStr = " + string2);
            }
        } else {
            string2 = this.lq2Select(string, null, null);
            if (Debug.messageEnabled()) {
                Debug.message("logRecRead/4.2:selectStr = " + string2);
            }
        }
        try {
            this.maxRecords = Integer.parseInt(this.maxRecordsStr);
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.warningEnabled()) {
                Debug.warning("DBlogRecRead: maxRecords error (" + this.maxRecordsStr + "), set to MAX");
            }
            this.maxRecords = 500;
        }
        try {
            this.connectToDatabase(this.dbUserName, this.dbPassWord);
        }
        catch (SQLException sQLException) {
            Debug.error("DBlogRecRead:connect:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
            throw sQLException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        string3 = string2;
        object = null;
        int n = 0;
        try {
            object = this.conn.createStatement(1004, 1008);
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:about to execute: " + string3);
            }
            ResultSet resultSet = object.executeQuery(string3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:#columns = " + n3);
            }
            String[] stringArray2 = new String[n3];
            int n4 = 1;
            while (n4 <= n3) {
                String string5 = resultSetMetaData.getColumnName(n4);
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:col #" + n4 + " name = " + string5);
                }
                stringArray2[n4 - 1] = string5;
                ++n4;
            }
            this.listOfValidRecords.add(stringArray2);
            while (resultSet.next()) {
                ++n;
            }
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:#rows = " + n);
            }
            if (n == 0) {
                object.close();
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {
                    Debug.error("DBlogRecRead:rows=0:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                }
                int n5 = this.listOfValidRecords.size();
                if (n5 <= 0) {
                    return null;
                }
                this.queryResult = new String[n5][];
                int n6 = 0;
                while (n6 < n5) {
                    this.queryResult[n6] = (String[])this.listOfValidRecords.get(n6);
                    ++n6;
                }
                return this.queryResult;
            }
            if (n > this.maxRecords) {
                object.close();
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {
                    Debug.error("DBlogRecRead:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                }
                throw new AMLogException("More than max number of records returned; Increase Max Records in configuration");
            }
            boolean bl2 = resultSet.first();
            if (!bl2) {
                Debug.error("DBlogRecRead:first() is false!");
            }
            int n7 = n;
            if (logQuery.getNumRecordsWanted() == -1 && n > this.maxRecords) {
                n7 = this.maxRecords;
            }
            stringArray = new String[n7][n3];
            String string6 = null;
            int n8 = 0;
            int n9 = 0;
            if (logQuery.getNumRecordsWanted() == -1 && n > this.maxRecords) {
                n9 = n - this.maxRecords;
            }
            if (Debug.messageEnabled()) {
                Debug.message("DBlogRecRead:skipThisMany = " + n9);
            }
            int n10 = 0;
            while (n10 < n3) {
                stringArray[0][n10] = string6 = resultSet.getString(n10 + 1);
                ++n10;
            }
            n8 = 1;
            while (resultSet.next()) {
                if (n9-- > 0) continue;
                int n11 = 0;
                while (n11 < n3) {
                    stringArray[n8][n11] = string6 = resultSet.getString(n11 + 1);
                    ++n11;
                }
                ++n8;
            }
            object.close();
            if (logQuery == null) {
                this.maxNoOfRecs = 1;
            }
        }
        catch (SQLException sQLException) {
            Debug.error("DBlogRecRead:query:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
            throw sQLException;
        }
        try {
            this.getRecords(stringArray, bl);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw exception;
        }
        int n12 = this.listOfValidRecords.size();
        if (n12 <= 0) {
            return null;
        }
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Debug.error("DBlogRecRead:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
        }
        this.queryResult = new String[n12][];
        int n13 = 0;
        while (n13 < n12) {
            this.queryResult[n13] = (String[])this.listOfValidRecords.get(n13);
            ++n13;
        }
        return this.queryResult;
    }

    public String[][] logRecRead(Set set, LogQuery logQuery, LogManager logManager, boolean bl) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, SQLException, ClassNotFoundException, Exception {
        Object object;
        String string;
        String string2 = null;
        this.cleaner();
        HashSet<String[][]> hashSet = new HashSet<String[][]>();
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = string.replace('.', '_');
            hashSet.add((String[][])object);
            stringBuffer.append((String)object);
        }
        this.logTableName = stringBuffer.toString();
        try {
            this.databaseURL = logManager.getProperty("iplanet-am-logging-location");
            this.dbDriver = logManager.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logManager.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logManager.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logManager.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception exception) {
            Debug.error("DBLogRecReadSet:config: ", exception);
            throw exception;
        }
        if (this.dbDriver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
        } else if (this.dbDriver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
        } else {
            this.isMySQL = false;
            Debug.warning("DBlogRecRead:assuming driver: '" + this.dbDriver + "' is Oracle-compatible.");
        }
        try {
            this.maxRecords = Integer.parseInt(this.maxRecordsStr);
        }
        catch (NumberFormatException numberFormatException) {
            if (Debug.warningEnabled()) {
                Debug.warning("DBlogRecRead(s): maxRecords error (" + this.maxRecordsStr + "), set to MAX");
            }
            this.maxRecords = 500;
        }
        if (!this.isMySQL) {
            Object object2;
            String string3;
            if (bl) {
                this.queryCriteria = logQuery;
                object = logQuery.getSortingField();
                if (object != null) {
                    string2 = object.trim();
                }
                string3 = "*";
                object2 = logQuery.getColumns();
                if (object2 != null) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    int n = ((ArrayList)object2).size();
                    int n2 = 0;
                    while (n2 < n) {
                        stringBuffer2.append((String)((ArrayList)object2).get(n2));
                        if (n2 + 1 < n) {
                            stringBuffer2.append(", ");
                        }
                        ++n2;
                    }
                    string3 = stringBuffer2.toString();
                }
                string = this.lq2Select(hashSet, string3, logQuery);
                if (Debug.messageEnabled()) {
                    Debug.message("logRecRead/4:selectStr = " + string);
                }
            } else {
                object = "*";
                string = this.lq2Select(hashSet, (String)object, null);
                if (Debug.messageEnabled()) {
                    Debug.message("logRecRead/4.2:selectStr = " + string);
                }
            }
            try {
                this.connectToDatabase(this.dbUserName, this.dbPassWord);
            }
            catch (SQLException sQLException) {
                Debug.error("DBlogRecRead:connect:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
                throw sQLException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            string3 = string;
            object2 = null;
            int n = 0;
            try {
                object2 = this.conn.createStatement(1004, 1008);
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:about to execute: " + string3);
                }
                ResultSet resultSet = object2.executeQuery(string3);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:#columns = " + n3);
                }
                String[] stringArray = new String[n3];
                int n4 = 1;
                while (n4 <= n3) {
                    String string4 = resultSetMetaData.getColumnName(n4);
                    if (Debug.messageEnabled()) {
                        Debug.message("DBlogRecRead:col #" + n4 + " name = " + string4);
                    }
                    stringArray[n4 - 1] = string4;
                    ++n4;
                }
                this.listOfValidRecords.add(stringArray);
                while (resultSet.next()) {
                    ++n;
                }
                if (Debug.messageEnabled()) {
                    Debug.message("DBlogRecRead:#rows = " + n);
                }
                if (n == 0) {
                    object2.close();
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {
                        Debug.error("DBlogRecRead:rows=0:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                    }
                    int n5 = this.listOfValidRecords.size();
                    if (n5 <= 0) {
                        return null;
                    }
                    this.queryResult = new String[n5][];
                    int n6 = 0;
                    while (n6 < n5) {
                        this.queryResult[n6] = (String[])this.listOfValidRecords.get(n6);
                        ++n6;
                    }
                    return this.queryResult;
                }
                if (n > this.maxRecords) {
                    object2.close();
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {
                        Debug.error("DBlogRecRead:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                    }
                    throw new AMLogException("More than max number of records returned; Increase Max Records in configuration");
                }
                boolean bl2 = resultSet.first();
                if (!bl2) {
                    Debug.error("DBlogRecRead:first() is false!");
                }
                int n7 = n;
                object = new String[n7][n3];
                String string5 = null;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n3) {
                    object[0][n9] = string5 = resultSet.getString(n9 + 1);
                    ++n9;
                }
                n8 = 1;
                while (resultSet.next()) {
                    int n10 = 0;
                    while (n10 < n3) {
                        object[n8][n10] = string5 = resultSet.getString(n10 + 1);
                        ++n10;
                    }
                    ++n8;
                }
                object2.close();
                if (logQuery == null) {
                    this.maxNoOfRecs = 1;
                }
            }
            catch (SQLException sQLException) {
                Debug.error("DBlogRecRead:query:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
                throw sQLException;
            }
            try {
                this.getRecords((String[][])object, bl);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw exception;
            }
            int n11 = this.listOfValidRecords.size();
            if (n11 <= 0) {
                return null;
            }
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                Debug.error("DBlogRecRead:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
            }
            this.queryResult = new String[n11][];
            int n12 = 0;
            while (n12 < n11) {
                this.queryResult[n12] = (String[])this.listOfValidRecords.get(n12);
                ++n12;
            }
        } else {
            String string6;
            object = null;
            if (bl) {
                this.queryCriteria = logQuery;
                String string7 = logQuery.getSortingField();
                if (string7 != null) {
                    string2 = string7.trim();
                }
                object = "*";
                ArrayList arrayList = logQuery.getColumns();
                if (arrayList != null) {
                    StringBuffer stringBuffer3 = new StringBuffer();
                    int n = arrayList.size();
                    int n13 = 0;
                    while (n13 < n) {
                        stringBuffer3.append((String)arrayList.get(n13));
                        if (n13 + 1 < n) {
                            stringBuffer3.append(", ");
                        }
                        ++n13;
                    }
                    object = stringBuffer3.toString();
                }
            } else {
                object = "*";
            }
            boolean bl3 = true;
            int n = 0;
            int n14 = 0;
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string8 = (String)iterator2.next();
                if (bl) {
                    string = this.lq2Select(string8, (String)object, logQuery);
                    if (Debug.messageEnabled()) {
                        Debug.message("logRecRead/5:selectStr = " + string);
                    }
                } else {
                    string = this.lq2Select(string8, (String)object, null);
                    if (Debug.messageEnabled()) {
                        Debug.message("logRecRead/5.2:selectStr = " + string);
                    }
                }
                String[][] stringArray = null;
                try {
                    this.connectToDatabase(this.dbUserName, this.dbPassWord);
                }
                catch (SQLException sQLException) {
                    Debug.error("DBlogRecRead:connect:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
                    throw sQLException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw classNotFoundException;
                }
                String string9 = string;
                Statement statement = null;
                int n15 = 0;
                try {
                    statement = this.conn.createStatement(1004, 1008);
                    if (Debug.messageEnabled()) {
                        Debug.message("DBlogRecRead:about to execute: " + string9);
                    }
                    ResultSet resultSet = statement.executeQuery(string9);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n16 = resultSetMetaData.getColumnCount();
                    if (Debug.messageEnabled()) {
                        Debug.message("DBlogRecRead:#columns = " + n16);
                    }
                    if (bl3) {
                        String[] stringArray2 = new String[n16];
                        int n17 = 1;
                        while (n17 <= n16) {
                            String string10 = resultSetMetaData.getColumnName(n17);
                            if (Debug.messageEnabled()) {
                                Debug.message("DBlogRecRead:col #" + n17 + " name = " + string10);
                            }
                            stringArray2[n17 - 1] = string10;
                            ++n17;
                        }
                        this.listOfValidRecords.add(stringArray2);
                    }
                    n15 = 0;
                    while (resultSet.next()) {
                        ++n15;
                    }
                    if ((n += n15) > this.maxRecords) {
                        statement.close();
                        try {
                            this.conn.close();
                        }
                        catch (SQLException sQLException) {
                            Debug.error("DBlogRecRead:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                        }
                        throw new AMLogException("More than max number of records returned; Increase Max Records in configuration");
                    }
                    if (n15 > 0) {
                        boolean bl4 = resultSet.first();
                        if (!bl4) {
                            Debug.error("DBlogRecRead:first() is false!");
                        }
                        stringArray = new String[n15][n16];
                        String string11 = null;
                        int n18 = 0;
                        do {
                            int n19 = 0;
                            while (n19 < n16) {
                                stringArray[n18][n19] = string11 = resultSet.getString(n19 + 1);
                                ++n19;
                            }
                            ++n18;
                        } while (resultSet.next());
                    }
                    statement.close();
                    if (logQuery == null) {
                        this.maxNoOfRecs = 1;
                    }
                }
                catch (SQLException sQLException) {
                    Debug.error("DBlogRecRead:query:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
                    throw sQLException;
                }
                if (n15 > 0) {
                    try {
                        this.getRecords(stringArray, bl);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw illegalArgumentException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                }
                if (!bl3) continue;
                bl3 = false;
            }
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                Debug.error("DBlogRecRead:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
            }
            if (logQuery != null && (string6 = logQuery.getSortingField()) != null) {
                try {
                    this.sorter = new LogRecordSorter(string6, this.listOfValidRecords);
                    this.queryResult = this.sorter.getSortedRecords();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Debug.error("DBlogRecRead/5:sort:nsfe: " + noSuchFieldException.getMessage());
                    throw noSuchFieldException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Debug.error("DBlogRecRead/5:sort:iae: " + illegalArgumentException.getMessage());
                    throw illegalArgumentException;
                }
                catch (RuntimeException runtimeException) {
                    Debug.error("DBlogRecRead/5:sort:rte: " + runtimeException.getMessage());
                    throw runtimeException;
                }
                catch (Exception exception) {
                    Debug.error("DBlogRecRead/5:sort:ex: " + exception.getMessage());
                    throw exception;
                }
                return this.queryResult;
            }
            n14 = this.listOfValidRecords.size();
            if (n14 <= 0) {
                return null;
            }
            this.queryResult = new String[n14][];
            int n20 = 0;
            while (n20 < n14) {
                this.queryResult[n20] = (String[])this.listOfValidRecords.get(n20);
                ++n20;
            }
        }
        return this.queryResult;
    }

    public String[][] getTableNames(LogManager logManager) {
        try {
            this.databaseURL = logManager.getProperty("iplanet-am-logging-location");
            this.dbDriver = logManager.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logManager.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logManager.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logManager.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception exception) {
            return null;
        }
        try {
            this.connectToDatabase(this.dbUserName, this.dbPassWord);
        }
        catch (SQLException sQLException) {
            Debug.error("DBgetTableNames:connect:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error("DBgetTableNames:connect:CNFE: " + classNotFoundException.getMessage());
            return null;
        }
        this.isMySQL = false;
        String string = null;
        if (this.dbDriver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
            string = "select table_name from dba_all_tables where owner = '" + this.dbUserName.toUpperCase() + "'";
        } else if (this.dbDriver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
            string = "show tables";
        }
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        ResultSetMetaData resultSetMetaData = null;
        String[][] stringArray = null;
        try {
            boolean bl;
            statement = this.conn.createStatement(1004, 1008);
            if (Debug.messageEnabled()) {
                Debug.message("DBgetTableNames:about to execute: " + string);
            }
            resultSet = statement.executeQuery(string);
            resultSetMetaData = resultSet.getMetaData();
            n = resultSetMetaData.getColumnCount();
            if (Debug.messageEnabled()) {
                Debug.message("DBgetTableNames:#columns = " + n);
            }
            String[] stringArray2 = new String[n];
            int n2 = 1;
            while (n2 <= n) {
                String string2;
                stringArray2[n2 - 1] = string2 = resultSetMetaData.getColumnName(n2);
                ++n2;
            }
            int n3 = 0;
            while (resultSet.next()) {
                ++n3;
            }
            if (Debug.messageEnabled()) {
                Debug.message("DBgetTableNames:#rows = " + n3);
            }
            if (!(bl = resultSet.first())) {
                Debug.error("DBgetTableNames:first() is false!");
            }
            String string3 = null;
            stringArray = new String[n3][n];
            int n4 = 0;
            while (n4 < n) {
                stringArray[0][n4] = string3 = resultSet.getString(n4 + 1);
                ++n4;
            }
            int n5 = 1;
            while (resultSet.next()) {
                int n6 = 0;
                while (n6 < n) {
                    stringArray[n5][n6] = string3 = resultSet.getString(n6 + 1);
                    ++n5;
                    ++n6;
                }
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Debug.error("DBgetTableNames:query:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
            return null;
        }
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Debug.error("DBgetTableNames:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
        }
        return stringArray;
    }

    public long getNumberOfRows(LogManager logManager, String string) {
        long l = 0L;
        try {
            this.databaseURL = logManager.getProperty("iplanet-am-logging-location");
            this.dbDriver = logManager.getProperty("iplanet-am-logging-db-driver");
            this.dbUserName = logManager.getProperty("iplanet-am-logging-db-user");
            this.dbPassWord = logManager.getProperty("iplanet-am-logging-db-password");
            this.maxRecordsStr = logManager.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception exception) {
            return 0L;
        }
        try {
            this.connectToDatabase(this.dbUserName, this.dbPassWord);
        }
        catch (SQLException sQLException) {
            Debug.error("DBgetNumberOfRows:connect:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
            return 0L;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error("DBgetgetNumberOfRows:connect:CNFE: " + classNotFoundException.getMessage());
            return 0L;
        }
        String string2 = string.replace('.', '_');
        String string3 = "select count(*) from " + string2;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        String string4 = null;
        try {
            statement = this.conn.createStatement(1004, 1008);
            if (Debug.messageEnabled()) {
                Debug.message("DBgetgetNumberOfRows:about to execute: " + string3);
            }
            resultSet = statement.executeQuery(string3);
            resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (Debug.messageEnabled()) {
                Debug.message("DBgetNumberOfRows:#columns = " + n);
            }
            while (resultSet.next()) {
                int n2 = 0;
                while (n2 < n) {
                    string4 = resultSet.getString(n2 + 1);
                    ++n2;
                }
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            Debug.error("DBgetNumberOfRows:query:SQE:code=" + sQLException.getErrorCode() + ", msg=" + sQLException.getMessage());
            return 0L;
        }
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            Debug.error("DBgetNumberOfRows:conn.close (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
        }
        try {
            Long l2 = new Long(string4);
            l = l2;
        }
        catch (NumberFormatException numberFormatException) {
            Debug.error("DBgetNumberOfRows:got " + string4 + " as number of rows, returning 0.");
        }
        return l;
    }

    private void displayResultSet(ResultSet resultSet) {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            Debug.error("displayRS:#columns = " + n);
            StringBuffer stringBuffer = new StringBuffer(80);
            int n2 = 1;
            while (n2 <= n) {
                String string = resultSetMetaData.getColumnName(n2);
                stringBuffer.append(string).append("\t");
                ++n2;
            }
            Debug.error("displayRS:columns =\n" + stringBuffer.toString());
            boolean bl = resultSet.first();
            int n3 = 1;
            do {
                stringBuffer = new StringBuffer(80);
                int n4 = 1;
                while (n4 <= n) {
                    stringBuffer.append(resultSet.getString(n4)).append("\t");
                    ++n4;
                }
                Debug.error("displayRS:row #" + n3 + " = " + stringBuffer.toString());
                ++n3;
            } while (resultSet.next());
            bl = resultSet.first();
        }
        catch (SQLException sQLException) {
            Debug.error("displayRS:got SQLException: " + sQLException.getMessage());
        }
    }

    private boolean getRecords(String[][] stringArray, boolean bl) throws IOException, RuntimeException {
        int n = Array.getLength(stringArray);
        int n2 = 0;
        while (n2 < n) {
            this.listOfValidRecords.add(stringArray[n2]);
            ++n2;
        }
        return true;
    }

    private void cleaner() {
        this.logTableName = null;
        this.queryCriteria = null;
        this.listOfValidRecords.clear();
        this.queryResult = null;
    }

    private void connectToDatabase(String string, String string2) throws SQLException, ClassNotFoundException {
        try {
            Class.forName(this.dbDriver);
            this.conn = DriverManager.getConnection(this.databaseURL, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error("DBlogRecRead:connect:ClassNotFoundException: " + classNotFoundException.getMessage());
            throw classNotFoundException;
        }
        catch (SQLException sQLException) {
            Debug.error("DBlogRecRead:connect:SQLEx: " + sQLException.getErrorCode() + "): " + sQLException.getMessage());
            throw sQLException;
        }
    }

    private String lq2Select(String string, String string2, LogQuery logQuery) {
        StringBuffer stringBuffer = null;
        String string3 = "*";
        StringBuffer stringBuffer2 = null;
        String string4 = " and ";
        int n = 2;
        int n2 = 0;
        String string5 = null;
        boolean bl = false;
        stringBuffer = new StringBuffer("select ");
        if (string2 != null && string2.length() > 0) {
            string3 = string2;
        }
        int n3 = 0;
        bl = false;
        String string6 = null;
        String string7 = null;
        if (logQuery != null) {
            n3 = logQuery.getNumRecordsWanted();
            if (n3 == -1 || n3 == -2) {
                bl = true;
            } else {
                string6 = Integer.toString(n3);
            }
            string7 = logQuery.getSortingField();
        } else {
            bl = true;
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:getAllRecs = " + bl + ", numRecs = " + n3 + ", sortByField = " + string7 + ", numRecsStr = " + string6);
        }
        if (logQuery == null) {
            stringBuffer.append(string3).append(" from ").append(string);
            return stringBuffer.toString();
        }
        ArrayList arrayList = logQuery.getQueries();
        if (arrayList == null || (n2 = arrayList.size()) == 0) {
            stringBuffer.append(string3).append(" from ").append(string);
            if (!bl) {
                if (this.isMySQL) {
                    stringBuffer.append(" limit ").append(string6);
                } else {
                    stringBuffer.append(" where rownum < ").append(string6);
                }
            }
            return stringBuffer.toString();
        }
        if (logQuery.getGlobalOperand() == n) {
            string4 = " or ";
        }
        stringBuffer.append(string3).append(" from ").append(string).append(" where ");
        if (!bl && !this.isMySQL) {
            stringBuffer.append("rownum < ").append(string6).append(" and ");
        }
        stringBuffer2 = new StringBuffer();
        boolean bl2 = false;
        if (n2 > 1) {
            bl2 = true;
            stringBuffer2.append("(");
        }
        int n4 = 0;
        while (n4 < n2) {
            String string8;
            QueryElement queryElement = (QueryElement)arrayList.get(n4);
            String string9 = queryElement.getFieldName();
            String string10 = queryElement.getFieldValue();
            int n5 = queryElement.getRelation();
            switch (n5) {
                case 1: {
                    string8 = " > ";
                    break;
                }
                case 2: {
                    string8 = " < ";
                    break;
                }
                case 3: {
                    string8 = " = ";
                    break;
                }
                case 4: {
                    string8 = " != ";
                    break;
                }
                case 5: {
                    string8 = " >= ";
                    break;
                }
                case 6: {
                    string8 = " <= ";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    string8 = " like ";
                    break;
                }
                default: {
                    string8 = " = ";
                }
            }
            if (string9 != null && string9.length() > 0 && string10 != null && string10.length() > 0) {
                if (bl2) {
                    stringBuffer2.append(" (");
                }
                stringBuffer2.append(string9).append(string8);
                if (n5 == 7) {
                    stringBuffer2.append(" '%").append(string10).append("%'");
                } else if (n5 == 8) {
                    stringBuffer2.append(" '").append(string10).append("%'");
                } else if (n5 == 9) {
                    stringBuffer2.append(" '%").append(string10).append("'");
                } else {
                    stringBuffer2.append(" '").append(string10).append("'");
                }
                if (bl2) {
                    stringBuffer2.append(") ");
                }
            }
            if (n4 + 1 < n2) {
                stringBuffer2.append(string4);
            }
            ++n4;
        }
        if (bl2) {
            stringBuffer2.append(")");
        }
        stringBuffer.append(stringBuffer2.toString());
        string5 = logQuery.getSortingField();
        if (string5 != null && string5.length() > 0) {
            stringBuffer.append(" order by ").append(string5);
        }
        if (!bl && this.isMySQL) {
            stringBuffer.append(" limit ").append(string6);
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:select = " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String lq2Select(Set set, String string, LogQuery logQuery) {
        String string2;
        StringBuffer stringBuffer = null;
        String string3 = "*";
        Object var7_6 = null;
        StringBuffer stringBuffer2 = null;
        String string4 = " and ";
        int n = 2;
        int n2 = 0;
        Object var12_11 = null;
        boolean bl = false;
        stringBuffer = new StringBuffer("select ");
        stringBuffer2 = new StringBuffer("select ");
        string3 = string;
        int n3 = 0;
        bl = false;
        String string5 = null;
        String string6 = null;
        if (logQuery != null) {
            n3 = logQuery.getNumRecordsWanted();
            if (n3 == -1 || n3 == -2) {
                bl = true;
            } else {
                string5 = Integer.toString(n3);
            }
            if (!string.equals("*") && (string2 = logQuery.getSortingField()) != null && string2.length() > 0 && string.indexOf(string2) != -1) {
                string6 = string2;
            }
        } else {
            bl = true;
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:getAllRecs = " + bl + ", numRecs = " + n3 + ", sortByField = " + string6 + ", numRecsStr = " + string5);
        }
        if (logQuery == null) {
            string2 = new String("select " + string3 + " from ");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(string2).append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(" union ");
            }
            return stringBuffer.toString();
        }
        ArrayList arrayList = logQuery.getQueries();
        stringBuffer2.append(string3).append(" from ");
        stringBuffer = new StringBuffer();
        if (arrayList == null || (n2 = arrayList.size()) == 0) {
            string2 = stringBuffer2.toString();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(string2).append(iterator.next());
                if (this.isMySQL) continue;
                if (!bl) {
                    stringBuffer.append(" where rownum < ").append(string5);
                }
                if (iterator.hasNext()) {
                    stringBuffer.append(" ").append("union").append(" ");
                    continue;
                }
                if (string6 == null) continue;
                stringBuffer.append(" order by ").append(string6);
            }
            return stringBuffer.toString();
        }
        if (logQuery.getGlobalOperand() == n) {
            string4 = " or ";
        }
        if (this.isMySQL) {
            string2 = stringBuffer2.toString();
            stringBuffer.append(string2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" where ");
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string7 = (String)iterator2.next();
                String string8 = this.doMySQLQueryElement(string7, arrayList, string4);
                stringBuffer.append(string8);
                if (!iterator2.hasNext()) continue;
                stringBuffer.append(" or ");
            }
            if (!bl && this.isMySQL) {
                stringBuffer.append(" limit ").append(string5);
            }
        } else {
            string2 = this.doOracleQueryElements(arrayList, string5, string4, bl, string6);
            String string9 = stringBuffer2.toString();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(string9).append(iterator.next()).append(" where ").append(string2);
                if (iterator.hasNext()) {
                    stringBuffer.append(" ").append("union").append(" ");
                    continue;
                }
                if (string6 == null) continue;
                stringBuffer.append(" order by ").append(string6);
            }
        }
        if (Debug.messageEnabled()) {
            Debug.message("lq2Select:select = " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String doOracleQueryElements(ArrayList arrayList, String string, String string2, boolean bl, String string3) {
        int n = arrayList.size();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if (string != null && string.length() > 0) {
            stringBuffer.append("rownum < ").append(string).append(" and ");
        }
        if (n > 1) {
            bl2 = true;
            stringBuffer.append("(");
        }
        int n2 = 0;
        while (n2 < n) {
            String string4;
            QueryElement queryElement = (QueryElement)arrayList.get(n2);
            String string5 = queryElement.getFieldName();
            String string6 = queryElement.getFieldValue();
            int n3 = queryElement.getRelation();
            switch (n3) {
                case 1: {
                    string4 = " > ";
                    break;
                }
                case 2: {
                    string4 = " < ";
                    break;
                }
                case 3: {
                    string4 = " = ";
                    break;
                }
                case 4: {
                    string4 = " != ";
                    break;
                }
                case 5: {
                    string4 = " >= ";
                    break;
                }
                case 6: {
                    string4 = " <= ";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    string4 = " like ";
                    break;
                }
                default: {
                    string4 = " = ";
                }
            }
            if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
                if (bl2) {
                    stringBuffer.append(" (");
                }
                stringBuffer.append(string5).append(string4);
                if (n3 == 7) {
                    stringBuffer.append(" '%").append(string6).append("%'");
                } else if (n3 == 8) {
                    stringBuffer.append(" '").append(string6).append("%'");
                } else if (n3 == 9) {
                    stringBuffer.append(" '%").append(string6).append("'");
                } else {
                    stringBuffer.append(" '").append(string6).append("'");
                }
                if (bl2) {
                    stringBuffer.append(") ");
                }
            }
            if (n2 + 1 < n) {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        if (bl2) {
            stringBuffer.append(")");
        }
        if (Debug.messageEnabled()) {
            Debug.message("doQueryElements:returning " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String doMySQLQueryElement(String string, ArrayList arrayList, String string2) {
        int n = arrayList.size();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 1) {
            bl = true;
            stringBuffer.append("(");
        }
        int n2 = 0;
        while (n2 < n) {
            String string3;
            QueryElement queryElement = (QueryElement)arrayList.get(n2);
            String string4 = string + "." + queryElement.getFieldName();
            String string5 = queryElement.getFieldValue();
            int n3 = queryElement.getRelation();
            switch (n3) {
                case 1: {
                    string3 = " > ";
                    break;
                }
                case 2: {
                    string3 = " < ";
                    break;
                }
                case 3: {
                    string3 = " = ";
                    break;
                }
                case 4: {
                    string3 = " != ";
                    break;
                }
                case 5: {
                    string3 = " >= ";
                    break;
                }
                case 6: {
                    string3 = " <= ";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    string3 = " like ";
                    break;
                }
                default: {
                    string3 = " = ";
                }
            }
            if (string4 != null && string4.length() > 0 && string5 != null && string5.length() > 0) {
                if (bl) {
                    stringBuffer.append(" (");
                }
                stringBuffer.append(string4).append(string3);
                if (n3 == 7) {
                    stringBuffer.append(" '%").append(string5).append("%'");
                } else if (n3 == 8) {
                    stringBuffer.append(" '").append(string5).append("%'");
                } else if (n3 == 9) {
                    stringBuffer.append(" '%").append(string5).append("'");
                } else {
                    stringBuffer.append(" '").append(string5).append("'");
                }
                if (bl) {
                    stringBuffer.append(") ");
                }
            }
            if (n2 + 1 < n) {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        if (bl) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

