/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.log.NullLocationException;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.FormatterInitException;
import com.sun.identity.log.spi.Debug;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class FileHandler
extends Handler {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private OutputStream output;
    private Writer writer;
    private MeteredStream meteredStream;
    private File[] files;
    private boolean headerWritten;
    private int count;
    private int maxFileSize;
    private String location;
    private Formatter formatter;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss.ddMMyyyy");
    private Date date;
    private String currentFileName;
    private String fileName;
    private int recCount = 0;
    private int recCountLimit;
    private String[] recordBuffer;
    private Timer bufferTimer;
    private boolean timeBufferingEnabled = false;
    private static String headerString = null;

    private void setOutputStream(OutputStream outputStream) throws SecurityException, UnsupportedEncodingException {
        if (outputStream == null && Debug.warningEnabled()) {
            Debug.warning(this.fileName + ":FileHandler: OutputStream is null");
        }
        this.output = outputStream;
        this.headerWritten = false;
        String string = this.getEncoding();
        if (string == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.output, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.error(this.fileName + ":FileHandler: Unsupported Encoding", unsupportedEncodingException);
                throw new UnsupportedEncodingException(unsupportedEncodingException.getMessage());
            }
        }
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        if (this.output == null) {
            return;
        }
        this.cleanup();
        this.writer = string == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, string);
    }

    private void configure() throws NullLocationException, FormatterInitException {
        String string;
        String string2;
        String string3 = this.lmanager.getProperty("iplanet-am-logging-buffer-size");
        if (string3 != null && string3.length() > 0) {
            try {
                this.recCountLimit = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.warning(this.fileName + ":FileHandler: NumberFormatException ", numberFormatException);
                if (Debug.messageEnabled()) {
                    Debug.message(this.fileName + ":FileHandler: Setting buffer size to 1");
                }
                this.recCountLimit = 1;
            }
        } else {
            Debug.warning(this.fileName + ":FileHandler: Invalid buffer size: " + string3);
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler: Setting buffer size to 1");
            }
            this.recCountLimit = 1;
        }
        if ((string2 = this.lmanager.getProperty("iplanet-am-logging-time-buffering-status")) != null && string2.equalsIgnoreCase("ON")) {
            this.timeBufferingEnabled = true;
        }
        this.count = (string = this.lmanager.getProperty("iplanet-am-logging-num-hist-file")) == null || string.length() == 0 ? 0 : Integer.parseInt(string);
        String string4 = this.lmanager.getProperty("iplanet-am-logging-max-file-size");
        this.maxFileSize = string4 == null || string4.length() == 0 ? 0 : Integer.parseInt(string4);
        this.location = this.lmanager.getProperty("iplanet-am-logging-location");
        if (this.location == null || this.location.length() == 0) {
            throw new NullLocationException("Location Not Specified");
        }
        if (!this.location.endsWith(File.separator)) {
            this.location = this.location + File.separator;
        }
        String string5 = this.lmanager.getProperty("iplanet-am-logging-elf-formatter");
        try {
            Class<?> clazz = Class.forName(string5);
            this.formatter = (Formatter)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new FormatterInitException("Unable to initialize Formatter Class" + exception);
        }
    }

    private void openFiles(String string) throws IOException {
        if (this.count < 0) {
            Debug.error(string + ":FileHandler: no. of history files negative " + this.count);
            this.count = 0;
        }
        if (this.maxFileSize < 0) {
            Debug.error(string + ":FileHandler: maxFileSize cannot be negative");
            this.maxFileSize = 0;
        }
        this.files = new File[this.count + 1];
        int n = 0;
        while (n < this.count + 1) {
            if (n != 0) {
                this.files[n] = new File(string + "-" + n);
            } else {
                this.files[0] = new File(string);
            }
            ++n;
        }
        this.open(this.files[0], true);
    }

    private void open(File file, boolean bl) throws IOException {
        String string = file.toString();
        int n = 0;
        n = (int)file.length();
        FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.meteredStream = new MeteredStream(bufferedOutputStream, n);
        this.setOutputStream(this.meteredStream);
        this.checkForHeaderWritten(file.toString());
    }

    public FileHandler(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.fileName = string;
        try {
            this.configure();
        }
        catch (NullLocationException nullLocationException) {
            Debug.error(string + ":FileHandler: Location not specified", nullLocationException);
        }
        catch (FormatterInitException formatterInitException) {
            Debug.error(string + ":FileHandler: couldnot instantiate Formatter", formatterInitException);
        }
        string = this.location + string;
        Logger logger = (Logger)Logger.getLogger(this.fileName);
        if (logger.getLevel() != Level.OFF) {
            try {
                this.openFiles(string);
            }
            catch (IOException iOException) {
                Debug.error(string + ":FileHandler: Unable to open Files", iOException);
            }
        }
        logger.setCurrentFile(this.fileName);
        this.recordBuffer = new String[this.recCountLimit];
        if (this.timeBufferingEnabled) {
            this.startTimeBufferingThread();
        }
    }

    private void cleanup() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception exception) {
                Debug.error(this.fileName + ":FileHandler: Couldnot Flush Output", exception);
            }
        }
    }

    public void close() {
        this.flush();
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                Debug.error(this.fileName + ":FileHandler: Error closing writer", iOException);
            }
        }
        this.stopBufferTimer();
    }

    public synchronized void publish(LogRecord logRecord) {
        String string;
        if (this.maxFileSize <= 0) {
            return;
        }
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.recordBuffer[this.recCount] = string = this.getFormatter().format(logRecord);
        ++this.recCount;
        if (this.recCount == this.recCountLimit) {
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler.publish(): got " + this.recCount + " records, writing all");
            }
            this.flush();
        }
    }

    private String getHeaderString() {
        if (headerString == null) {
            headerString = this.getFormatter().getHead(this);
        }
        return headerString;
    }

    public synchronized void flush() {
        if (this.recCount <= 0) {
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler.flush: no records in buffer to write");
            }
            return;
        }
        if (this.writer == null) {
            Debug.error(this.fileName + ":FileHandler: Writer is null");
            this.recCount = 0;
            return;
        }
        if (Debug.messageEnabled()) {
            Debug.message(this.fileName + ":FileHandler.flush: writing buffered records");
        }
        int n = 0;
        while (n < this.recCount) {
            String string = this.recordBuffer[n];
            if (string.length() > 0 && this.meteredStream.written + string.length() >= this.maxFileSize) {
                if (Debug.messageEnabled()) {
                    Debug.message(this.fileName + ":FileHandler: Rotation condition reached");
                }
                this.rotate();
            }
            try {
                if (!this.headerWritten) {
                    this.writer.write(this.getHeaderString());
                    this.headerWritten = true;
                }
                this.writer.write(string);
            }
            catch (IOException iOException) {
                Debug.error(this.fileName + ":FileHandler: couldnot write to file", iOException);
            }
            this.cleanup();
            ++n;
        }
        this.recCount = 0;
    }

    private void rotate() {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception exception) {
                Debug.error(this.fileName + ":FileHandler: Error closing writer", exception);
            }
        }
        int n = this.count - 2;
        while (n >= 0) {
            File file = this.files[n];
            File file2 = this.files[n + 1];
            if (file.exists()) {
                boolean bl;
                if (file2.exists()) {
                    try {
                        file2.delete();
                    }
                    catch (SecurityException securityException) {
                        Debug.error(this.fileName + ":FileHandler: could not delete file. msg = " + securityException.getMessage());
                    }
                }
                if (!(bl = file.renameTo(file2))) {
                    this.copyFile(file.toString(), file2.toString());
                }
            }
            --n;
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException iOException) {
            Debug.error(this.fileName + ":FileHandler: error opening file" + iOException);
        }
    }

    private void copyFile(String string, String string2) {
        if (Debug.messageEnabled()) {
            Debug.message(this.fileName + ":FileHandler: CopyFile Method called");
        }
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n = fileInputStream.read()) > -1) {
                fileOutputStream.write(n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.error(this.fileName + ":FileHandler: copyFile: File not found: ", fileNotFoundException);
        }
        catch (IOException iOException) {
            Debug.error(this.fileName + ":FileHandler: copyFile: IOExcpetion", iOException);
        }
    }

    private void checkForHeaderWritten(String string) {
        Object object;
        byte[] byArray = new byte[1024];
        try {
            object = new FileInputStream(new File(string));
            ((FileInputStream)object).read(byArray);
        }
        catch (IOException iOException) {
            Debug.error(string + ":FileHandler: couldnot read file content", iOException);
        }
        object = new String(byArray);
        object = ((String)object).trim();
        this.headerWritten = ((String)object).startsWith("#Version");
    }

    private void startTimeBufferingThread() {
        String string = this.lmanager.getProperty("iplanet-am-logging-buffer-time-in-seconds");
        long l = string != null || string.length() != 0 ? Long.parseLong(string) : 3600L;
        l *= 1000L;
        if (this.bufferTimer == null) {
            this.bufferTimer = new Timer();
            this.bufferTimer.scheduleAtFixedRate((TimerTask)new TimeBufferingTask(), l, l);
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler: Time Buffering Thread Started");
            }
        }
    }

    private void stopBufferTimer() {
        if (this.bufferTimer != null) {
            this.bufferTimer.cancel();
            if (Debug.messageEnabled()) {
                Debug.message(this.fileName + ":FileHandler: Buffer Timer Stopped");
            }
        }
    }

    private class TimeBufferingTask
    extends TimerTask {
        private TimeBufferingTask() {
        }

        public void run() {
            if (Debug.messageEnabled()) {
                Debug.message(FileHandler.this.fileName + ":FileHandler:TimeBufferingTask.run() called");
            }
            FileHandler.this.flush();
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream outputStream, int n) {
            this.out = outputStream;
            this.written = n;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.written;
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
            this.written += byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.written += n2;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

