/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.sun.identity.log.LogConstants;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.LogReadDBHandler;
import com.sun.identity.log.handlers.LogReadHandler;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.LogManager;

public class LogReader {
    private static int maxReordToReturn = 1;
    private static final String FILE_SOURCE = "File";
    private static final String DB_SOURCE = "DB";
    private static LogManager manager;
    private static String[][] queryResult;
    private static String logFileName;
    private static String logPathName;
    private static String logFields;
    private static String[] archivedFiles;
    private static String fileHandlerClass;
    private static String maxRecStr;
    private static String dbHandlerClass;
    private static String dbDriver;
    private static String dbUserName;
    private static String dbPassWord;
    private static String logStorageType;
    private static String logSecurity;
    private static String securityPrefix;
    private static String loggerName;
    private static LogReadHandler currentHandler;
    private static LogReadDBHandler currentDBHandler;
    private static boolean logTypeIsFile;

    private LogReader() {
        manager = LogManagerUtil.getLogManager();
    }

    public static int getSizeUnits() throws Exception {
        LogReader logReader = new LogReader();
        try {
            logReader.readConfiguration();
        }
        catch (Exception exception) {
            Debug.error("LogReader.getSizeUnits: could not read configuration");
            throw exception;
        }
        int n = 0;
        if (logTypeIsFile) {
            return 1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getSize(String string) throws IOException, Exception {
        LogReader logReader = new LogReader();
        try {
            logReader.readConfiguration();
        }
        catch (Exception exception) {
            Debug.error("LogReader.getSize: could not read configuration");
            throw exception;
        }
        if (!logTypeIsFile) return currentDBHandler.getNumberOfRows(manager, string);
        String string2 = logPathName + string;
        File file = new File(string2);
        if (!file.exists()) throw new IOException(string + " does not exist.");
        return file.length();
    }

    public static Set getLogNames() {
        HashSet<String> hashSet;
        block10: {
            block9: {
                LogReader logReader = new LogReader();
                hashSet = new HashSet<String>();
                try {
                    logReader.readConfiguration();
                }
                catch (Exception exception) {
                    return hashSet;
                }
                if (!logTypeIsFile) break block9;
                File file = new File(logPathName);
                String[] stringArray = file.list();
                if (stringArray == null) break block10;
                int n = Array.getLength(stringArray);
                int n2 = Array.getLength(LogConstants.LOGFILENAMES);
                if (n <= 0) break block10;
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        String string = LogConstants.LOGFILENAMES[n4];
                        if (logSecurity.equalsIgnoreCase("ON")) {
                            string = securityPrefix + "." + string;
                        }
                        if (stringArray[n3].indexOf(string) > -1) {
                            hashSet.add(stringArray[n3]);
                            break;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                break block10;
            }
            queryResult = currentDBHandler.getTableNames(manager);
            int n = Array.getLength(queryResult);
            int n5 = Array.getLength(LogConstants.LOGFILENAMES);
            int n6 = 0;
            while (n6 < n) {
                String string = queryResult[n6][0].replace('_', '.');
                String string2 = string.toUpperCase();
                String string3 = null;
                int n7 = 0;
                while (n7 < n5) {
                    string3 = LogConstants.LOGFILENAMES[n7].toUpperCase();
                    if (string3.indexOf(string2) > -1) {
                        hashSet.add(queryResult[n6][0]);
                        break;
                    }
                    ++n7;
                }
                ++n6;
            }
        }
        return hashSet;
    }

    public static ArrayList getLogFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        LogReader logReader = new LogReader();
        try {
            logReader.readConfiguration();
        }
        catch (Exception exception) {
            return arrayList;
        }
        arrayList.add("time");
        arrayList.add("Data");
        if (logFields != null && logFields.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(logFields, ", ");
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public static synchronized String[][] read(String string, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader logReader = new LogReader();
        logReader.readConfiguration();
        if (string == null) {
            throw new IllegalArgumentException("filename can't be null");
        }
        LogReader.setLoggerName(string);
        if (!logReader.isAllowed(object)) {
            throw new RuntimeException("Authorization failed");
        }
        String string2 = logPathName + string;
        LogQuery logQuery = new LogQuery(-2);
        queryResult = logTypeIsFile ? currentHandler.logRecRead(string2, logQuery, false) : currentDBHandler.logRecRead(string, logQuery, manager, false);
        return queryResult;
    }

    public static synchronized String[][] read(String string, String string2, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(string, string2, null, null, object);
        return queryResult;
    }

    public static synchronized String[][] read(String string, String string2, String string3, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(string, string2, string3, null, object);
        return queryResult;
    }

    public static synchronized String[][] read(String string, String string2, LogQuery logQuery, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(string, string2, null, logQuery, object);
        return queryResult;
    }

    public static String[][] read(String string, String string2, String string3, LogQuery logQuery, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        String string4 = new String();
        LogReader.setLoggerName(string, string2);
        string4 = loggerName;
        if (string3 != null) {
            if (string4.length() == 0) {
                return null;
            }
            string4 = string4 + "." + string3;
        }
        queryResult = LogReader.read(string4, logQuery, object);
        return queryResult;
    }

    public static String[][] read(String string, LogQuery logQuery, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader logReader = new LogReader();
        logReader.readConfiguration();
        if (string == null) {
            throw new IllegalArgumentException("filename can't be null");
        }
        if (maxReordToReturn <= 0) {
            maxReordToReturn = 1;
        }
        if (logQuery != null) {
            if (logQuery.getNumRecordsWanted() < -2) {
                logQuery.setMaxRecord(maxReordToReturn);
            } else if (logQuery.getNumRecordsWanted() == -1 && logTypeIsFile) {
                logQuery.setMaxRecord(maxReordToReturn);
            }
        } else {
            logQuery = new LogQuery(maxReordToReturn);
        }
        LogReader.setLoggerName(string);
        if (!logReader.isAllowed(object)) {
            throw new RuntimeException("Authorization failed");
        }
        if (logTypeIsFile) {
            String string2 = logPathName + string;
            queryResult = currentHandler.logRecRead(string2, logQuery, true);
        } else {
            queryResult = currentDBHandler.logRecRead(string, logQuery, manager, true);
        }
        return queryResult;
    }

    public static String[][] read(Set set, LogQuery logQuery, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        Object object2;
        LogReader logReader = new LogReader();
        logReader.readConfiguration();
        if (set == null) {
            throw new IllegalArgumentException("filenames can't be null");
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("filenames can't be empty");
        }
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (object2 != null) {
                object2 = ((String)object2).trim();
            }
            if (object2 != null && ((String)object2).length() != 0) continue;
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (maxReordToReturn <= 0) {
            maxReordToReturn = 1;
        }
        if (logQuery != null) {
            if (logQuery.getNumRecordsWanted() < -2) {
                logQuery.setMaxRecord(maxReordToReturn);
            } else if (logQuery.getNumRecordsWanted() == -1 && logTypeIsFile) {
                logQuery.setMaxRecord(maxReordToReturn);
            }
        } else {
            logQuery = new LogQuery(maxReordToReturn);
        }
        object3 = LogReader.getAllFilenames(set);
        LogReader.setLoggerName((String)object3);
        if (!logReader.isAllowed(object)) {
            throw new RuntimeException("Authorization failed");
        }
        if (logTypeIsFile) {
            object2 = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                string = logPathName + string;
                object2.add(string);
            }
            queryResult = currentHandler.logRecRead((Set)object2, logQuery, true);
        } else {
            queryResult = currentDBHandler.logRecRead(set, logQuery, manager, true);
        }
        return queryResult;
    }

    private static String getAllFilenames(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        if (set == null) {
            return null;
        }
        if (set.isEmpty()) {
            return "";
        }
        String string = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            stringBuffer.append(string);
        }
        string = stringBuffer.toString();
        return string;
    }

    private static String getCurrentFile(String string, String string2, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader.setLoggerName(string, string2);
        Logger logger = (Logger)Logger.getLogger(loggerName);
        try {
            logFileName = logger.getCurrentFile();
        }
        catch (RuntimeException runtimeException) {
            Debug.error("LogReader.getCurrentFile(): RuntimeException: ", runtimeException);
            logFileName = null;
            throw runtimeException;
        }
        return logFileName;
    }

    private boolean isAllowed(Object object) throws Exception {
        boolean bl = false;
        try {
            bl = Authorizer.isAuthorized(loggerName, "READ", object);
        }
        catch (Exception exception) {
            Debug.error("LogReader.isAllowed(): Exception: ", exception);
            throw exception;
        }
        return bl;
    }

    private void readConfiguration() throws Exception {
        this.cleanup();
        try {
            logPathName = manager.getProperty("iplanet-am-logging-location");
            if (logPathName == null) {
                Debug.error("LogReader readConfiguration():unable to get log location");
                return;
            }
            logStorageType = manager.getProperty("iplanet-am-logging-type");
            maxRecStr = manager.getProperty("iplanet-am-logging-max-records");
            if (maxRecStr == null || maxRecStr.length() == 0) {
                maxRecStr = "500";
            }
            logFields = manager.getProperty("iplanet-am-logging-logfields");
            logTypeIsFile = true;
            if (logStorageType.equals(FILE_SOURCE)) {
                fileHandlerClass = manager.getProperty("iplanet-am-logging-file-read-handler");
                if (!logPathName.endsWith(File.separator)) {
                    logPathName = logPathName + File.separator;
                }
                logSecurity = manager.getProperty("iplanet-am-logging-security-status");
            } else {
                logTypeIsFile = false;
                dbHandlerClass = manager.getProperty("sun-am-logging-db-read-handler");
                dbDriver = manager.getProperty("iplanet-am-logging-db-driver");
                dbUserName = manager.getProperty("iplanet-am-logging-db-user");
                dbPassWord = manager.getProperty("iplanet-am-logging-db-password");
            }
        }
        catch (Exception exception) {
            Debug.error("LogReader.readConfiguration(): Exception: ", exception);
            throw exception;
        }
        try {
            Class<?> clazz;
            if (logStorageType.compareToIgnoreCase(FILE_SOURCE) == 0) {
                clazz = ClassLoader.getSystemClassLoader().loadClass(fileHandlerClass);
                currentHandler = (LogReadHandler)clazz.newInstance();
            } else if (logStorageType.compareToIgnoreCase(DB_SOURCE) == 0) {
                clazz = ClassLoader.getSystemClassLoader().loadClass(dbHandlerClass);
                currentDBHandler = (LogReadDBHandler)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            Debug.error("LogReader.readConfiguration(): Exception: ", exception);
            throw exception;
        }
        try {
            if (maxRecStr != null) {
                maxRecStr = maxRecStr.trim();
                maxReordToReturn = Integer.parseInt(maxRecStr);
            }
        }
        catch (Exception exception) {
            Debug.error("LogReader.readConfiguration(): Exception: ", exception);
            throw exception;
        }
    }

    private static void setLoggerName(String string) {
        if (string.startsWith(securityPrefix)) {
            string = string.substring(securityPrefix.length() + 1, string.length());
        }
        int n = string.lastIndexOf(".");
        int n2 = string.length();
        String string2 = string.substring(++n + 1, n2);
        try {
            Long l = new Long(string2);
            long l2 = l;
            if (l2 >= 1L) {
                string = string.substring(0, n - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        loggerName = string;
    }

    private static void setLoggerName(String string, String string2) {
        if (string != null) {
            loggerName = string;
        }
        if (string2 != null) {
            if (string != null) {
                loggerName = loggerName + ".";
            }
            loggerName = loggerName + string2;
        }
    }

    private void cleanup() {
        maxReordToReturn = -1;
        queryResult = null;
        currentHandler = null;
        dbUserName = null;
        dbPassWord = null;
    }

    static {
        queryResult = null;
        logFileName = null;
        logPathName = null;
        logFields = null;
        archivedFiles = null;
        fileHandlerClass = null;
        maxRecStr = null;
        dbHandlerClass = null;
        dbDriver = null;
        dbUserName = null;
        dbPassWord = null;
        logStorageType = null;
        logSecurity = null;
        securityPrefix = "_secure";
        currentHandler = null;
        currentDBHandler = null;
        logTypeIsFile = true;
    }
}

