/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPExtendedResponse;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPAddResponse;
import netscape.ldap.client.opers.JDAPBindResponse;
import netscape.ldap.client.opers.JDAPCompareResponse;
import netscape.ldap.client.opers.JDAPDeleteResponse;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNResponse;
import netscape.ldap.client.opers.JDAPModifyResponse;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResult;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class LDAPMessage
implements Serializable {
    static final long serialVersionUID = -1364094245850026720L;
    public static final int BIND_REQUEST = 0;
    public static final int BIND_RESPONSE = 1;
    public static final int UNBIND_REQUEST = 2;
    public static final int SEARCH_REQUEST = 3;
    public static final int SEARCH_RESPONSE = 4;
    public static final int SEARCH_RESULT = 5;
    public static final int MODIFY_REQUEST = 6;
    public static final int MODIFY_RESPONSE = 7;
    public static final int ADD_REQUEST = 8;
    public static final int ADD_RESPONSE = 9;
    public static final int DEL_REQUEST = 10;
    public static final int DEL_RESPONSE = 11;
    public static final int MODIFY_RDN_REQUEST = 12;
    public static final int MODIFY_RDN_RESPONSE = 13;
    public static final int COMPARE_REQUEST = 14;
    public static final int COMPARE_RESPONSE = 15;
    public static final int ABANDON_REQUEST = 16;
    public static final int SEARCH_RESULT_REFERENCE = 19;
    public static final int EXTENDED_REQUEST = 23;
    public static final int EXTENDED_RESPONSE = 24;
    private int m_msgid;
    private JDAPProtocolOp m_protocolOp = null;
    private LDAPControl[] m_controls = null;

    LDAPMessage(int n, JDAPProtocolOp jDAPProtocolOp) {
        this.m_msgid = n;
        this.m_protocolOp = jDAPProtocolOp;
    }

    LDAPMessage(int n, JDAPProtocolOp jDAPProtocolOp, LDAPControl[] lDAPControlArray) {
        this.m_msgid = n;
        this.m_protocolOp = jDAPProtocolOp;
        this.m_controls = lDAPControlArray;
    }

    static LDAPMessage parseMessage(BERElement bERElement) throws IOException {
        JDAPBindResponse jDAPBindResponse = null;
        LDAPControl[] lDAPControlArray = null;
        if (bERElement.getType() != 48) {
            throw new IOException("SEQUENCE in jdap message expected");
        }
        BERSequence bERSequence = (BERSequence)bERElement;
        BERInteger bERInteger = (BERInteger)bERSequence.elementAt(0);
        int n = bERInteger.getValue();
        BERElement bERElement2 = bERSequence.elementAt(1);
        if (bERElement2.getType() != -1) {
            throw new IOException("TAG in protocol operation is expected");
        }
        BERTag bERTag = (BERTag)bERElement2;
        switch (bERTag.getTag() & 0x1F) {
            case 1: {
                jDAPBindResponse = new JDAPBindResponse(bERElement2);
                break;
            }
            case 4: {
                jDAPBindResponse = new JDAPSearchResponse(bERElement2);
                break;
            }
            case 3: 
            case 5: {
                jDAPBindResponse = new JDAPSearchResult(bERElement2);
                break;
            }
            case 7: {
                jDAPBindResponse = new JDAPModifyResponse(bERElement2);
                break;
            }
            case 9: {
                jDAPBindResponse = new JDAPAddResponse(bERElement2);
                break;
            }
            case 11: {
                jDAPBindResponse = new JDAPDeleteResponse(bERElement2);
                break;
            }
            case 13: {
                jDAPBindResponse = new JDAPModifyRDNResponse(bERElement2);
                break;
            }
            case 15: {
                jDAPBindResponse = new JDAPCompareResponse(bERElement2);
                break;
            }
            case 19: {
                jDAPBindResponse = new JDAPSearchResultReference(bERElement2);
                break;
            }
            case 24: {
                jDAPBindResponse = new JDAPExtendedResponse(bERElement2);
                break;
            }
            default: {
                throw new IOException("Unknown protocol operation");
            }
        }
        if (bERSequence.size() >= 3 && (bERTag = (BERTag)bERSequence.elementAt(2)).getTag() == 160) {
            BERSequence bERSequence2 = (BERSequence)bERTag.getValue();
            lDAPControlArray = new LDAPControl[bERSequence2.size()];
            for (int i = 0; i < bERSequence2.size(); ++i) {
                lDAPControlArray[i] = LDAPControl.parseControl(bERSequence2.elementAt(i));
            }
        }
        if (jDAPBindResponse instanceof JDAPSearchResponse) {
            return new LDAPSearchResult(n, (JDAPSearchResponse)jDAPBindResponse, lDAPControlArray);
        }
        if (jDAPBindResponse instanceof JDAPSearchResultReference) {
            return new LDAPSearchResultReference(n, (JDAPSearchResultReference)jDAPBindResponse, lDAPControlArray);
        }
        if (jDAPBindResponse instanceof JDAPExtendedResponse) {
            return new LDAPExtendedResponse(n, (JDAPExtendedResponse)jDAPBindResponse, lDAPControlArray);
        }
        return new LDAPResponse(n, (JDAPProtocolOp)jDAPBindResponse, lDAPControlArray);
    }

    public int getMessageID() {
        return this.m_msgid;
    }

    public int getType() {
        return this.m_protocolOp.getType();
    }

    JDAPProtocolOp getProtocolOp() {
        return this.m_protocolOp;
    }

    public LDAPControl[] getControls() {
        return this.m_controls;
    }

    void write(OutputStream outputStream) throws IOException {
        BERSequence bERSequence = new BERSequence();
        BERInteger bERInteger = new BERInteger(this.m_msgid);
        bERSequence.addElement((BERElement)bERInteger);
        BERElement bERElement = this.m_protocolOp.getBERElement();
        if (bERElement == null) {
            throw new IOException("Bad BER element");
        }
        bERSequence.addElement(bERElement);
        if (this.m_controls != null) {
            BERSequence bERSequence2 = new BERSequence();
            for (int i = 0; i < this.m_controls.length; ++i) {
                bERSequence2.addElement(this.m_controls[i].getBERElement());
            }
            BERTag bERTag = new BERTag(160, (BERElement)bERSequence2, true);
            bERSequence.addElement((BERElement)bERTag);
        }
        bERSequence.write(outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[LDAPMessage] ");
        stringBuffer.append(this.m_msgid);
        stringBuffer.append(" ");
        stringBuffer.append(this.m_protocolOp.toString());
        for (int i = 0; this.m_controls != null && i < this.m_controls.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(this.m_controls[i].toString());
        }
        return stringBuffer.toString();
    }

    StringBuffer toTraceString() {
        StringBuffer stringBuffer = new StringBuffer(" op=");
        stringBuffer.append(this.m_msgid);
        stringBuffer.append(" ");
        stringBuffer.append(this.m_protocolOp.toString());
        for (int i = 0; this.m_controls != null && i < this.m_controls.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(this.m_controls[i].toString());
        }
        return stringBuffer;
    }
}

