/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.util.impl;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.util.IDebug;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;

public class DebugImpl
implements IDebug {
    private static final String CONFIG_DEBUG_DIRECTORY = "com.iplanet.services.debug.directory";
    private static final String CONFIG_DEBUG_LEVEL = "com.iplanet.services.debug.level";
    private String debugName;
    private int debugLevel = 4;
    private PrintWriter debugWriter;
    private PrintWriter stdoutWriter = new PrintWriter(System.out, true);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
    private String debugFilePath;

    public DebugImpl(String string) {
        Object object;
        this.setName(string);
        String string2 = SystemProperties.get(CONFIG_DEBUG_DIRECTORY);
        boolean bl = false;
        if (string2 != null && string2.trim().length() > 0) {
            object = new File(string2);
            if (!((File)object).exists()) {
                bl = ((File)object).mkdirs();
            } else if (((File)object).isDirectory() && ((File)object).canWrite()) {
                bl = true;
            }
        }
        if (bl) {
            this.initialize(string2);
        } else {
            object = Locale.getInstallResourceBundle("amUtilMsgs");
            System.err.println(((ResourceBundle)object).getString("com.iplanet.services.debug.nodir"));
        }
    }

    private void initialize(String string) {
        block4: {
            this.setDebug(SystemProperties.get(CONFIG_DEBUG_LEVEL));
            this.debugFilePath = string + File.separator + this.debugName;
            String string2 = this.dateFormat.format(new Date()) + ": " + Thread.currentThread().toString();
            try {
                this.debugWriter = new PrintWriter((Writer)new FileWriter(this.debugFilePath, true), true);
                this.writeIt(string2, "**********************************************", null);
            }
            catch (IOException iOException) {
                this.setDebug(4);
                ResourceBundle resourceBundle = Locale.getInstallResourceBundle("amUtilMsgs");
                System.err.println(resourceBundle.getString("com.iplanet.services.debug.nofile"));
                iOException.printStackTrace(System.err);
                if (this.debugWriter == null) break block4;
                try {
                    this.debugWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String getName() {
        return this.debugName;
    }

    public int getState() {
        return this.debugLevel;
    }

    public void setDebug(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.debugLevel = n;
                break;
            }
        }
    }

    public void setDebug(String string) {
        int n = 4;
        if (string != null && string.trim().length() > 0) {
            if (string.equals("off")) {
                n = 0;
            } else if (string.equals("error")) {
                n = 1;
            } else if (string.equals("warning")) {
                n = 2;
            } else if (string.equals("message")) {
                n = 3;
            }
        }
        this.setDebug(n);
    }

    public boolean messageEnabled() {
        return this.debugLevel > 2;
    }

    public boolean warningEnabled() {
        return this.debugLevel > 1;
    }

    public boolean errorEnabled() {
        return this.debugLevel > 0;
    }

    public void message(String string, Throwable throwable) {
        if (this.messageEnabled()) {
            this.record(string, throwable);
        }
    }

    public void warning(String string, Throwable throwable) {
        if (this.warningEnabled()) {
            this.record("WARNING: " + string, throwable);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.errorEnabled()) {
            this.record("ERROR: " + string, throwable);
        }
    }

    private void record(String string, Throwable throwable) {
        String string2 = this.dateFormat.format(new Date()) + ": " + Thread.currentThread().toString();
        this.writeIt(string2, string, throwable);
    }

    private void writeIt(String string, String string2, Throwable throwable) {
        if (this.debugLevel == 4) {
            this.writeIt(this.stdoutWriter, string, string2, throwable);
        } else {
            this.writeIt(this.debugWriter, string, string2, throwable);
        }
    }

    private void writeIt(PrintWriter printWriter, String string, String string2, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('\n');
        stringBuffer.append(string2);
        if (throwable != null) {
            stringBuffer.append('\n');
            StringWriter stringWriter = new StringWriter(300);
            PrintWriter printWriter2 = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter2);
            printWriter2.flush();
            stringBuffer.append(stringWriter.toString());
        }
        printWriter.println(stringBuffer.toString());
    }

    private void setName(String string) {
        this.debugName = string;
    }

    private PrintWriter getStdoutWriter() {
        return this.stdoutWriter;
    }

    protected void finalize() throws Throwable {
        if (this.debugWriter != null) {
            try {
                this.debugWriter.flush();
                this.debugWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

