/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class SMSMigration {
    public static void main(String[] stringArray) {
        try {
            SSOToken sSOToken = SMSMigration.getSSOToken(stringArray);
            Principal principal = sSOToken.getPrincipal();
            ServiceManager serviceManager = new ServiceManager(sSOToken);
            Iterator iterator = serviceManager.getServiceNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, "ou=" + string + "," + "ou=services" + "," + SMSEntry.baseDN, null);
                SMSEntry sMSEntry = cachedSMSEntry.getSMSEntry();
                System.out.println("\nMigrating Service Name: " + string);
                String[] stringArray2 = sMSEntry.getAttributeValues("sunServiceSchema");
                Iterator iterator2 = sMSEntry.subEntries("*", 0, false, false).iterator();
                while (iterator2.hasNext()) {
                    SMSEntry sMSEntry2 = (SMSEntry)iterator2.next();
                    try {
                        if (stringArray2 != null) {
                            sMSEntry2.setAttribute("sunServiceSchema", stringArray2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sMSEntry2.save();
                    CachedSMSEntry cachedSMSEntry2 = CachedSMSEntry.getInstance(sSOToken, sMSEntry2.getDN(), null);
                    cachedSMSEntry2.refresh(sMSEntry2);
                    String string2 = new DN(sMSEntry2.getDN()).explodeDN(true)[0];
                    System.out.println("\tVersion: " + string2);
                    SMSMigration.migrateConfigData(sSOToken, string, string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void migrateConfigData(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(sSOToken, string, string2);
        ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
        ServiceSchema serviceSchema2 = serviceSchemaManager.getOrganizationSchema();
        Object[] objectArray = new String[]{string, string2};
        Iterator iterator = SMSEntry.search(MessageFormat.format("(&(objectclass=sunService)(ou={0})(ou={1}))", objectArray)).iterator();
        while (iterator.hasNext()) {
            SMSEntry sMSEntry = (SMSEntry)iterator.next();
            String string3 = sMSEntry.getDN();
            boolean bl = false;
            DN dN = new DN(new DN(string3).getParent().toRFCString());
            String string4 = new DN(dN.getParent().toRFCString()).toRFCString();
            if (string4.equalsIgnoreCase("ou=services," + SMSEntry.baseDN)) {
                bl = true;
            }
            String string5 = new DN(string4).getParent().toRFCString();
            CreateServiceConfig.checkBaseNodesForOrg(sSOToken, string5, string, string2);
            if (sMSEntry.isNewEntry()) continue;
            if (bl && serviceSchema != null) {
                System.out.println("\tMigrating Global Config Data: " + string3);
                SMSMigration.migrateConfigData(sSOToken, serviceSchema, sMSEntry, "ou=GlobalConfig,");
            }
            if (serviceSchema2 == null) continue;
            System.out.println("\tMigrating Org Config Data: " + string3);
            SMSMigration.migrateConfigData(sSOToken, serviceSchema2, sMSEntry, "ou=OrganizationConfig,");
        }
    }

    private static void migrateConfigData(SSOToken sSOToken, ServiceSchema serviceSchema, SMSEntry sMSEntry, String string) throws SMSException, SSOException {
        String string2 = "ou=default," + string + sMSEntry.getDN();
        SMSEntry sMSEntry2 = new SMSEntry(sSOToken, string2);
        SMSMigration.copyAttributesAndCreate(serviceSchema, sMSEntry, sMSEntry2);
        SMSMigration.migrateSubConfigEntries(sSOToken, serviceSchema, sMSEntry, sMSEntry2);
    }

    private static void migrateSubConfigEntries(SSOToken sSOToken, ServiceSchema serviceSchema, SMSEntry sMSEntry, SMSEntry sMSEntry2) throws SMSException, SSOException {
        Iterator iterator = sMSEntry.subEntries("*", 0, false, false).iterator();
        while (iterator.hasNext()) {
            ServiceSchema serviceSchema2;
            SMSEntry sMSEntry3 = (SMSEntry)iterator.next();
            String string = new DN(sMSEntry3.getDN()).explodeDN(true)[0];
            if (string.equalsIgnoreCase("GlobalConfig") || string.equalsIgnoreCase("OrganizationConfig") || string.equalsIgnoreCase("Instances") || string.equalsIgnoreCase("PluginConfig")) continue;
            String string2 = string;
            String[] stringArray = sMSEntry3.getAttributeValues("sunserviceID");
            if (stringArray != null) {
                string2 = stringArray[0];
            }
            if ((serviceSchema2 = serviceSchema.getSubSchema(string2)) == null && (serviceSchema2 = serviceSchema.getSubSchema(string)) == null) continue;
            String string3 = "ou=" + string + "," + sMSEntry2.getDN();
            SMSEntry sMSEntry4 = new SMSEntry(sSOToken, string3);
            SMSMigration.copyAttributesAndCreate(serviceSchema2, sMSEntry3, sMSEntry4);
            SMSMigration.migrateSubConfigEntries(sSOToken, serviceSchema2, sMSEntry3, sMSEntry4);
        }
    }

    private static void copyAttributesAndCreate(ServiceSchema serviceSchema, SMSEntry sMSEntry, SMSEntry sMSEntry2) throws SMSException, SSOException {
        String[] stringArray;
        if (sMSEntry2.isNewEntry()) {
            sMSEntry2.addAttribute("objectclass", "top");
            sMSEntry2.addAttribute("objectclass", "sunServiceComponent");
        }
        Set set = serviceSchema.getAttributeSchemaNames();
        Map map = SMSUtils.getAttrsFromEntry(sMSEntry);
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (!set.contains(stringArray)) continue;
            hashMap.put(stringArray, map.get(stringArray));
        }
        if (!hashMap.isEmpty()) {
            SMSUtils.setAttributeValuePairs(sMSEntry2, hashMap, serviceSchema.getSearchableAttributeNames());
        }
        if ((stringArray = sMSEntry.getAttributeValues("sunserviceID")) != null) {
            if (!stringArray[0].equals(serviceSchema.getName())) {
                stringArray[0] = serviceSchema.getName();
            }
            sMSEntry2.setAttribute("sunserviceID", stringArray);
        }
        if ((stringArray = sMSEntry.getAttributeValues("sunsmspriority")) != null) {
            sMSEntry2.setAttribute("sunsmspriority", stringArray);
        }
        sMSEntry2.save();
    }

    private static SSOToken getSSOToken(String[] stringArray) throws SSOException {
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            ServerInstance serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            AuthPrincipal authPrincipal = new AuthPrincipal(serverInstance.getAuthID());
            AuthContext authContext = new AuthContext((Principal)authPrincipal, serverInstance.getPasswd().toCharArray());
            return authContext.getSSOToken();
        }
        catch (Exception exception) {
            throw new SSOException(SSOProviderBundle.rbName, "invalidadmin", null);
        }
    }
}

