/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceManager;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class SMSEntry
implements Cloneable {
    public static final String SERVICES_NODE = "services";
    public static final String PLACEHOLDER_RDN = "ou";
    public static final String SERVICES_RDN = "ou=services";
    public static final String COMMA = ",";
    public static Debug debug;
    public static Debug eventDebug;
    public static SSOTokenManager tm;
    private static Cache cache;
    static String CACHE_PROPERTY;
    static boolean cacheSMSEntries;
    public static ResourceBundle bundle;
    static String DEFAULT_ORG_PROPERTY;
    static String baseDN;
    static int baseDNCount;
    static SMSException initializationException;
    static final String SMS_OBJECT_PROPERTY = "com.sun.identity.sm.sms_object_class_name";
    static final String DEFAULT_SMS_CLASS_NAME = "com.sun.identity.sm.ldap.SMSLdapObject";
    static final String JAXRPC_SMS_CLASS_NAME = "com.sun.identity.sm.jaxrpc.SMSJAXRPCObject";
    static final String SMS_ENABLE_DB_NOTIFICATION = "com.sun.identity.sm.enableDataStoreNotification";
    public static final String DB_PROXY_ENABLE = "com.sun.identity.sm.ldap.enableProxy";
    static SMSObject smsObject;
    static final String SLASH_STR = "/";
    static final String DOT_STR = ".";
    public static final String EXPORTEDARGS = "exportedTo";
    public static final String IMPORTEDARGS = "importedFrom";
    static final String AUTH_SUPER_USER = "com.sun.identity.authentication.super.user";
    static final String READ = "READ";
    static final String MODIFY = "MODIFY";
    static Set specialUserSet;
    static Set readActionSet;
    static Set modifyActionSet;
    static DelegationEvaluator dlgEval;
    static boolean SMSJAXRPCObjectFlg;
    static boolean backendProxyEnabled;
    static SSOToken adminSSOToken;
    static CaseInsensitiveHashSet mCaseSensitiveAttributes;
    static Set changeListeners;
    static List localChanges;
    static int LOCAL_CHANGES_MAX_SIZE;
    static boolean enableDataStoreNotification;
    private SSOToken ssoToken;
    protected String dn;
    protected String normalizedDN;
    private boolean newEntry;
    private boolean readOnly;
    private Map attrSet;
    private Set modSet;
    public static final String ORGANIZATION_RDN = "o";
    public static final String DC_RDN = "dc";
    public static final String EQUALS = "=";
    public static final String DEFAULT_RDN = "ou=default";
    static final String ORG_PLACEHOLDER_RDN = "o=";
    static final String DELEGATION_SERVICES_RDN = "ou=services,";
    static final String DELEGATION_SERVICES_RDN_WITH_COMMA = ",ou=services,";
    static final int DELEGATION_SERVICES_RDN_WITH_COMMA_LEN;
    static final int ORG_UNIT_OBJECT = 1;
    static final int SERVICE_OBJECT = 2;
    static final int SERVICE_COMP_OBJECT = 3;
    public static final String ATTR_SCHEMA = "sunServiceSchema";
    public static final String ATTR_PLUGIN_SCHEMA = "sunPluginSchema";
    public static final String ATTR_KEYVAL = "sunKeyValue";
    public static final String ATTR_XML_KEYVAL = "sunxmlKeyValue";
    public static final String ATTR_OBJECTCLASS = "objectclass";
    public static final String ATTR_PRIORITY = "sunsmspriority";
    public static final String ATTR_SERVICE_ID = "sunserviceID";
    public static final String ATTR_LABELED_URI = "labeleduri";
    public static final String ATTR_MODIFY_TIMESTAMP = "modifytimestamp";
    public static final String[] SMS_ATTRIBUTES;
    public static final String OC_TOP = "top";
    public static final String OC_ORG_UNIT = "organizationalunit";
    public static final String OC_SERVICE = "sunService";
    public static final String OC_REALM_SERVICE = "sunRealmService";
    public static final String OC_SERVICE_COMP = "sunServiceComponent";
    public static final String SUN_INTERNAL_REALM_NAME = "sunamhiddenrealm";
    public static final String SUN_INTERNAL_REALM_PREFIX = "o=sunamhiddenrealm";
    public static final String REALM_SERVICE = "sunAMRealmService";
    protected static final String FILTER_PATTERN_ALL = "(&(&(objectclass=top)(ou={0}))(&(objectclass=top)(sunserviceID={1})))";
    protected static final String FILTER_PATTERN = "(&(objectclass=top)(ou={0}))";
    protected static final String FILTER_PATTERN_SERVICE = "(&(objectclass=sunService)(ou={0})(ou={1}))";
    public static final String FILTER_SERVICE_COMPONENTS = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";

    SMSEntry(SSOToken sSOToken, String string) throws SSOException, SMSException {
        if (initializationException != null) {
            throw initializationException;
        }
        this.ssoToken = sSOToken;
        this.dn = string;
        this.normalizedDN = new DN(string).toRFCString().toLowerCase();
        this.read();
    }

    public Map getAttributes() {
        return this.attrSet;
    }

    String[] getAttributeValues(String string) {
        return this.getAttributeValues(string, false);
    }

    String[] getAttributeValues(String string, boolean bl) {
        if (bl || !cacheSMSEntries) {
            try {
                this.read();
            }
            catch (SMSException sMSException) {
                debug.error("SMSLdapEntry: Error in reading attrs: " + sMSException);
            }
            catch (SSOException sSOException) {
                debug.error("SMSLdapEntry: SSOToken problem in reading attrs: " + sSOException);
            }
        }
        Set set = this.attrSet == null ? null : (Set)this.attrSet.get(string);
        return set == null ? null : set.toArray(new String[set.size()]);
    }

    void addAttribute(String string, String string2) throws SMSException {
        HashSet<String> hashSet = null;
        if (this.attrSet == null) {
            this.attrSet = new CaseInsensitiveHashMap();
        } else if (this.attrSet.containsKey(string) && (hashSet = (Set)this.attrSet.get(string)).contains(string2)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEntry: Duplicate value for addition");
            }
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20), "sms-ATTR_OR_VAL_EXISTS");
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        hashSet.add(string2);
        this.attrSet.put(string, hashSet);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        this.modSet.add(new ModificationItem(1, new BasicAttribute(string, string2)));
    }

    void setAttribute(String string, String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        BasicAttribute basicAttribute = new BasicAttribute(string);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            hashSet.add(stringArray[n]);
            basicAttribute.add(stringArray[n]);
            ++n;
        }
        this.attrSet = this.attrSet == null ? new CaseInsensitiveHashMap() : this.attrSet;
        Set set = this.modSet = this.modSet == null ? new HashSet() : this.modSet;
        if (!this.attrSet.containsKey(string)) {
            this.modSet.add(new ModificationItem(1, basicAttribute));
        } else {
            this.modSet.add(new ModificationItem(2, basicAttribute));
        }
        this.attrSet.put(string, hashSet);
    }

    void removeAttribute(String string, String string2) throws SMSException {
        Set set = null;
        if (this.attrSet == null || (set = (Set)this.attrSet.get(string)) == null || !set.contains(string2)) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20), "sms-ATTR_OR_VAL_EXISTS");
        }
        set.remove(string2);
        this.attrSet.put(string, set);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        this.modSet.add(new ModificationItem(3, new BasicAttribute(string, string2)));
    }

    void removeAttribute(String string) throws SMSException {
        Set set = (Set)this.attrSet.get(string);
        if (set == null) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20), "sms-ATTR_OR_VAL_EXISTS");
        }
        this.attrSet.remove(string);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        BasicAttribute basicAttribute = new BasicAttribute(string, set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            basicAttribute.add(iterator.next());
        }
        this.modSet.add(new ModificationItem(3, basicAttribute));
    }

    boolean containsAttrValue(String string, String string2) {
        Set set;
        if (this.attrSet != null && (set = (Set)this.attrSet.get(string)) != null) {
            return set.contains(string2);
        }
        return false;
    }

    void read() throws SSOException, SMSException {
        this.read(this.ssoToken);
    }

    void read(SSOToken sSOToken) throws SSOException, SMSException {
        if (backendProxyEnabled) {
            if (SMSEntry.isAllowed(sSOToken, this.normalizedDN, readActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                sSOToken = adminSSOToken;
            }
        } else {
            SMSEntry.getDelegationPermission(sSOToken, this.normalizedDN, readActionSet);
        }
        this.attrSet = smsObject.read(sSOToken, this.dn);
        this.newEntry = this.attrSet == null;
    }

    void save() throws SSOException, SMSException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Attempted to save an entry that is marked as read-only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
        }
        this.save(this.ssoToken);
    }

    void save(SSOToken sSOToken) throws SSOException, SMSException {
        if (backendProxyEnabled) {
            if (SMSEntry.isAllowed(sSOToken, this.normalizedDN, modifyActionSet)) {
                if (adminSSOToken == null) {
                    adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
                sSOToken = adminSSOToken;
            }
        } else {
            SMSEntry.getDelegationPermission(sSOToken, this.normalizedDN, modifyActionSet);
        }
        if (this.newEntry && this.attrSet != null) {
            smsObject.create(sSOToken, this.dn, this.attrSet);
            SMSEntry.notifyObjectChanged(this.dn, 0);
        } else if (this.modSet != null) {
            smsObject.modify(sSOToken, this.dn, this.modSet.toArray(new ModificationItem[this.modSet.size()]));
            SMSEntry.notifyObjectChanged(this.dn, 3);
        }
        this.newEntry = false;
    }

    void delete() throws SMSException, SSOException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Attempted to delete an entry that is marked as read-only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
        }
        this.delete(this.ssoToken);
    }

    void delete(SSOToken sSOToken) throws SMSException, SSOException {
        if (!this.newEntry) {
            if (backendProxyEnabled) {
                if (SMSEntry.isAllowed(sSOToken, this.normalizedDN, modifyActionSet)) {
                    if (adminSSOToken == null) {
                        adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    }
                    sSOToken = adminSSOToken;
                }
            } else {
                SMSEntry.getDelegationPermission(sSOToken, this.normalizedDN, modifyActionSet);
            }
            smsObject.delete(sSOToken, this.dn);
            this.newEntry = true;
            this.attrSet = null;
            this.modSet = null;
            SMSEntry.notifyObjectChanged(this.dn, 1);
        } else if (debug.warningEnabled()) {
            debug.warning("SMSEntry: Attempted to delete an entry that does not exist: " + this.dn);
        }
    }

    Set searchSubOrgNames(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2, boolean bl3) throws SMSException, SSOException {
        Object object;
        Set set = smsObject.searchSubOrgNames(sSOToken, this.dn, string, n, bl, bl2, bl3);
        OrderedSet orderedSet = new OrderedSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!SMSEntry.hasReadPermission(sSOToken, (String)object)) continue;
            orderedSet.add(object);
        }
        object = SMSEntry.parseResult(orderedSet, this.normalizedDN);
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Successfully obtained suborganization names for : " + this.dn);
        }
        return object;
    }

    Set subEntries(String string, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        return this.subEntries(this.ssoToken, string, n, bl, bl2);
    }

    Set subEntries(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        Set set = smsObject.subEntries(sSOToken, this.dn, string, n, bl, bl2);
        OrderedSet orderedSet = new OrderedSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!SMSEntry.hasReadPermission(sSOToken, "ou=" + string2 + COMMA + this.dn)) continue;
            orderedSet.add(string2);
        }
        return orderedSet;
    }

    Set schemaSubEntries(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        Set set = smsObject.schemaSubEntries(sSOToken, this.dn, string, string2, n, bl, bl2);
        OrderedSet orderedSet = new OrderedSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!SMSEntry.hasReadPermission(sSOToken, "ou=" + string3 + COMMA + this.dn)) continue;
            orderedSet.add(string3);
        }
        return orderedSet;
    }

    Set searchOrganizationNames(SSOToken sSOToken, int n, boolean bl, boolean bl2, String string, String string2, Set set) throws SMSException, SSOException {
        Object object;
        Set set2 = smsObject.searchOrganizationNames(sSOToken, this.dn, n, bl, bl2, string, string2, set);
        OrderedSet orderedSet = new OrderedSet();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!SMSEntry.hasReadPermission(sSOToken, (String)object)) continue;
            orderedSet.add(object);
        }
        if (string2.equalsIgnoreCase(EXPORTEDARGS)) {
            return orderedSet;
        }
        object = SMSEntry.parseResult(orderedSet, this.normalizedDN, true);
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Successfully obtained organization names for : " + this.dn);
        }
        return object;
    }

    static Set search(String string) throws SMSException {
        try {
            return smsObject.search(null, baseDN, string);
        }
        catch (SSOException sSOException) {
            debug.error("SMSEntry: Search ERROR: " + string, sSOException);
            throw new SMSException(bundle.getString("sms-error-in-searching"), sSOException, "sms-error-in-searching");
        }
    }

    void refresh(SMSEntry sMSEntry) {
        this.attrSet = sMSEntry.attrSet != null ? SMSUtils.copyAttributes(sMSEntry.attrSet) : null;
        this.newEntry = sMSEntry.newEntry;
        this.modSet = null;
    }

    public static boolean checkIfEntryExists(String string, SSOToken sSOToken) {
        try {
            return smsObject.entryExists(sSOToken, string);
        }
        catch (Exception exception) {
            debug.error("SMSEntry: Error in checking if entry exists: " + string, exception);
            return false;
        }
    }

    public static void registerCallbackHandler(SSOToken sSOToken, SMSObjectListener sMSObjectListener) throws SMSException, SSOException {
        changeListeners.add(sMSObjectListener);
        if (!ServiceManager.isRealmEnabled() || enableDataStoreNotification) {
            smsObject.registerCallbackHandler(sSOToken, sMSObjectListener);
            if (eventDebug.messageEnabled()) {
                eventDebug.message("SMSEntry:registerCallbackHander calling SMSObject for co-existence mode");
            }
        }
        eventDebug.message("SMSEntry:registerCallbackHander called");
    }

    public static void objectChanged(String string, int n) {
        SMSEntry.objectChanged(string, n, false);
    }

    public static void objectChanged(String string, int n, boolean bl) {
        if (eventDebug.messageEnabled()) {
            eventDebug.message("SMSEntry:objectChanged: " + string + " type: " + n + " IsLocal: " + bl + "\nNumber of callback objects: " + changeListeners.size());
        }
        if (!bl) {
            if (localChanges.contains(string + n)) {
                localChanges.remove(string + n);
                if (eventDebug.messageEnabled()) {
                    eventDebug.message("SMSEntry:objectChanged: " + string + " type: " + n + " IsLocal: " + bl + "\nHas been delivered locally");
                }
                return;
            }
            if (eventDebug.messageEnabled()) {
                eventDebug.message("SMSEntry:objectChanged: " + string + " type: " + n + " IsLocal: " + bl + "\nHas NOT been delivered locally, will be notified");
            }
        } else {
            if (localChanges.size() > LOCAL_CHANGES_MAX_SIZE) {
                localChanges.remove(0);
            }
            localChanges.add(string + n);
        }
        Iterator iterator = changeListeners.iterator();
        while (iterator.hasNext()) {
            SMSObjectListener sMSObjectListener = (SMSObjectListener)iterator.next();
            sMSObjectListener.objectChanged(string, n);
        }
    }

    public static void notifyObjectChanged(String string, int n) {
        if (eventDebug.messageEnabled()) {
            eventDebug.message("SMSEntry:notifyObjectChanged: " + string + " type: " + n + "\nCalling NotificationThread");
        }
        NotificationThread notificationThread = new NotificationThread(string, n);
        if (WebtopNaming.isServerMode()) {
            notificationThread.start();
        } else {
            notificationThread.run();
        }
    }

    String getDN() {
        return this.dn;
    }

    Principal getPrincipal() {
        try {
            return this.ssoToken.getPrincipal();
        }
        catch (SSOException sSOException) {
            return null;
        }
    }

    SSOToken getSSOToken() {
        return this.ssoToken;
    }

    void setReadOnly() {
        this.readOnly = true;
    }

    boolean isNewEntry() {
        return this.newEntry;
    }

    public static SMSObject getSMSObject() {
        return smsObject;
    }

    public static void validateToken(SSOToken sSOToken) throws SMSException {
        try {
            tm.validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new SMSException(sSOException, "sms-INVALID_SSO_TOKEN");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SMSEntry sMSEntry = (SMSEntry)super.clone();
        sMSEntry.ssoToken = this.ssoToken;
        sMSEntry.dn = this.dn;
        sMSEntry.newEntry = this.newEntry;
        sMSEntry.modSet = null;
        sMSEntry.attrSet = this.attrSet != null ? SMSUtils.copyAttributes(this.attrSet) : null;
        if (debug.messageEnabled()) {
            debug.message("SMSEntry being cloned: " + this.dn);
        }
        return sMSEntry;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DN\t\t: " + this.dn + "\n");
        if (this.newEntry) {
            stringBuffer.append("\t(NEW Entry)");
        }
        stringBuffer.append("Attribute Set\t: " + this.attrSet + "\n");
        stringBuffer.append("Modifcation Set\t: " + this.modSet + "\n");
        return stringBuffer.toString();
    }

    public static String getRootSuffix() {
        return baseDN;
    }

    public static boolean isAttributeCaseSensitive(String string) {
        return mCaseSensitiveAttributes.contains(string);
    }

    public static String getFilterPatternService() {
        return FILTER_PATTERN_SERVICE;
    }

    protected static Set parseResult(Set set, String string) {
        return SMSEntry.parseResult(set, string, false);
    }

    protected static Set parseResult(Set set, String string, boolean bl) {
        OrderedSet orderedSet = new OrderedSet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n;
                int n2;
                String string2;
                DN dN = new DN((String)iterator.next());
                String string3 = dN.toRFCString();
                String string4 = dN.toRFCString().toLowerCase();
                if (string4.equals(baseDN) || string4.startsWith(SUN_INTERNAL_REALM_PREFIX)) continue;
                if (string4.equals(string)) {
                    if (!bl) continue;
                    orderedSet.add(SLASH_STR);
                    continue;
                }
                String string5 = string2 = ServiceManager.isRealmEnabled() ? ORG_PLACEHOLDER_RDN : OrgConfigViaAMSDK.getNamingAttrForOrg() + EQUALS;
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:orgAttr " + string2);
                }
                if ((n2 = string4.indexOf(string2.toLowerCase())) > 0) {
                    string3 = string3.substring(n2);
                }
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:DNName " + string);
                    debug.message("SMSEntry:parseResult:RFCDN " + string3);
                }
                if ((n = string4.indexOf(string)) < 0) {
                    n = string4.indexOf(baseDN);
                }
                String string6 = string3.substring(0, n - 1);
                string6 = DNMapper.replaceString(string6, string2, SLASH_STR);
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:origStr1 " + string6);
                }
                string6 = DNMapper.replaceString(string6, COMMA, "");
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry:parseResult:origStr2 " + string6);
                }
                String string7 = "";
                StringBuffer stringBuffer = new StringBuffer();
                while (string6.length() != 0) {
                    int n3 = string6.lastIndexOf(SLASH_STR);
                    if (n3 < 0) continue;
                    stringBuffer.append(string6.substring(n3 + 1)).append(SLASH_STR);
                    string6 = string6.substring(0, n3);
                }
                string7 = stringBuffer.toString();
                if (string7 == null || string7.length() <= 0) continue;
                orderedSet.add(string7.substring(0, string7.length() - 1));
            }
        }
        return orderedSet;
    }

    static String[] parseOrgDN(String string) {
        String[] stringArray = (String[])cache.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry:parseOrgDN:DNName " + string);
        }
        stringArray = new String[5];
        if (string == null || string.length() == 0) {
            stringArray[0] = baseDN;
            stringArray[1] = "*";
            stringArray[2] = "*";
            stringArray[3] = "*";
            stringArray[4] = "*";
            return stringArray;
        }
        DN dN = new DN(string);
        String string2 = dN.toRFCString().toLowerCase();
        String string3 = null;
        int n = string2.indexOf(DELEGATION_SERVICES_RDN_WITH_COMMA);
        if (n == -1 || string2.equals(DNMapper.serviceDN)) {
            stringArray[0] = string2;
            string3 = "";
        } else if (ServiceManager.isRealmEnabled()) {
            int n2 = string2.indexOf(DNMapper.serviceDN);
            if (n2 == -1 || n2 == 0) {
                stringArray[0] = baseDN;
                string3 = "";
            } else {
                String string4 = string2.substring(0, n2 - 1);
                if (string4.indexOf(DELEGATION_SERVICES_RDN) == -1) {
                    stringArray[0] = baseDN;
                    string3 = string4;
                } else {
                    stringArray[0] = string2.substring(n + DELEGATION_SERVICES_RDN_WITH_COMMA_LEN);
                    string3 = string2.substring(0, n);
                }
            }
        } else {
            stringArray[0] = string2.substring(n + DELEGATION_SERVICES_RDN_WITH_COMMA_LEN);
            string3 = string2.substring(0, n);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry:parseOrgDN: orgDN: " + stringArray[0] + " restOfDN: " + string3);
        }
        String[] stringArray2 = null;
        if (string3.length() > 0) {
            stringArray2 = new DN(string3).explodeDN(true);
        }
        int n3 = stringArray2 == null ? 0 : stringArray2.length;
        stringArray[4] = n3 < 1 ? REALM_SERVICE : stringArray2[n3 - 1];
        stringArray[3] = n3 < 2 ? "*" : stringArray2[n3 - 2];
        String string5 = stringArray[2] = n3 < 3 ? "*" : stringArray2[n3 - 3];
        if (n3 >= 4) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = n3 - 4;
            while (n4 >= 0) {
                stringBuffer.append('/').append(stringArray2[n4]);
                --n4;
            }
            stringArray[1] = stringBuffer.toString();
        } else {
            stringArray[1] = "*";
        }
        cache.put(string, stringArray);
        return stringArray;
    }

    static boolean hasReadPermission(SSOToken sSOToken, String string) {
        try {
            SMSEntry.getDelegationPermission(sSOToken, string, readActionSet);
        }
        catch (SMSException sMSException) {
            if (debug.messageEnabled()) {
                try {
                    debug.message("SMSEntry::hasReadPermission Denied user: " + sSOToken.getPrincipal().getName() + " for dn: " + string);
                }
                catch (SSOException sSOException) {
                    debug.message("SMSEntry::hasReadPermission Denied access for dn: " + string + " Got SSOException", sSOException);
                }
            }
            return false;
        }
        if (debug.messageEnabled()) {
            try {
                debug.message("SMSEntry::hasReadPermission Allowed user: " + sSOToken.getPrincipal().getName() + " for dn: " + string);
            }
            catch (SSOException sSOException) {
                debug.message("SMSEntry::hasReadPermission Allowed access for dn: " + string + " Got SSOException", sSOException);
            }
        }
        return true;
    }

    static boolean getDelegationPermission(SSOToken sSOToken, String string, Set set) throws SMSException {
        boolean bl = true;
        if (SMSJAXRPCObjectFlg || backendProxyEnabled || string.equals(baseDN) || string.equals(DNMapper.serviceDN)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEntry:getDelegationPermission :No delegation check needed for client sdk, db proxy enabled and for baseDNs: " + baseDN);
            }
            return bl;
        }
        try {
            String string2;
            String string3 = sSOToken.getPrincipal().getName();
            if (DN.isDN(string3) && specialUserSet.contains(string2 = new DN(string3).toRFCString().toLowerCase())) {
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry.getDelegationPermission :No delegation check needed for special users." + string2);
                }
                return bl;
            }
        }
        catch (SSOException sSOException) {
            debug.error("SMSEntry.isAllowed : Invalid Token: ", sSOException);
            throw new SMSException(bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (!ServiceManager.isConfigMigratedTo70()) {
            if (!backendProxyEnabled) {
                debug.error("SMSEntry::getDelegationPermission Must enable LDAP proxy support if configuration (DIT) is not migrated to AM 7.0");
                throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
            }
            return bl;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry:getDelegationPermission :Calling delegation service for dnName: " + string + " for permissions: " + set);
        }
        if (!SMSEntry.isAllowedByDelegation(sSOToken, string, set)) {
            throw new SMSException(SMSException.STATUS_NO_PERMISSION, "sms-INSUFFICIENT_ACCESS_RIGHTS");
        }
        return bl;
    }

    private static boolean isAllowed(SSOToken sSOToken, String string, Set set) throws SMSException {
        if (SMSJAXRPCObjectFlg) {
            return false;
        }
        if (string.equals(baseDN) || string.equals(DNMapper.serviceDN)) {
            return true;
        }
        try {
            String string2;
            String string3 = sSOToken.getPrincipal().getName();
            if (DN.isDN(string3) && specialUserSet.contains(string2 = new DN(string3).toRFCString().toLowerCase())) {
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry.isAllowed :No delegation check needed for special users." + string2);
                }
                return true;
            }
        }
        catch (SSOException sSOException) {
            debug.error("SMSEntry.isAllowed : Invalid Token: ", sSOException);
            throw new SMSException(bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (!ServiceManager.isConfigMigratedTo70()) {
            return false;
        }
        return SMSEntry.isAllowedByDelegation(sSOToken, string, set);
    }

    private static boolean isAllowedByDelegation(SSOToken sSOToken, String string, Set set) throws SMSException {
        boolean bl = true;
        String[] stringArray = SMSEntry.parseOrgDN(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        String string6 = stringArray[4];
        if (!string6.equals(REALM_SERVICE) && (string4.equalsIgnoreCase("*") || string3.equalsIgnoreCase("*"))) {
            return bl;
        }
        try {
            DelegationPermission delegationPermission = new DelegationPermission(string2, string6, string5, string4, string3, set, Collections.EMPTY_MAP);
            if (dlgEval == null) {
                dlgEval = new DelegationEvaluator();
            }
            if (!(bl = dlgEval.isAllowed(sSOToken, delegationPermission, Collections.EMPTY_MAP)) && debug.warningEnabled()) {
                try {
                    debug.warning("SMSEntry: Attempt by:  " + sSOToken.getPrincipal().getName() + " to read/modify entry: " + string + " has no permissions");
                }
                catch (SSOException sSOException) {
                    debug.warning("SMSEntry: Attempted to:  read/modify an entry that has invalid delegation privilege: " + string, sSOException);
                }
            }
        }
        catch (SSOException sSOException) {
            debug.error("SMSEntry.isAllowed : Invalid Token: ", sSOException);
            throw new SMSException(bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        catch (DelegationException delegationException) {
            debug.error("SMSEntry.isAllowed : Invalid DelegationPermission: ", delegationException);
            throw new SMSException(bundle.getString("sms-invalid_delegation_privilege"), "sms-invalid_delegation_privilege");
        }
        return bl;
    }

    static {
        Object object;
        String string;
        String string2;
        debug = Debug.getInstance("amSMS");
        eventDebug = Debug.getInstance("amSMSEvent");
        cache = new Cache(500);
        CACHE_PROPERTY = "com.iplanet.am.sdk.caching.enabled";
        DEFAULT_ORG_PROPERTY = "com.iplanet.am.defaultOrg";
        specialUserSet = new HashSet(50);
        readActionSet = new HashSet(2);
        modifyActionSet = new HashSet(2);
        changeListeners = new HashSet();
        localChanges = Collections.synchronizedList(new LinkedList());
        LOCAL_CHANGES_MAX_SIZE = 25;
        readActionSet.add(READ);
        modifyActionSet.add(MODIFY);
        String string3 = SystemProperties.get(AUTH_SUPER_USER, "");
        if (string3 != null && string3.length() != 0) {
            specialUserSet.add(new DN(string3).toRFCString().toLowerCase());
        }
        if ((string3 = AdminUtils.getAdminDN()) != null && string3.length() != 0) {
            specialUserSet.add(new DN(string3).toRFCString().toLowerCase());
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Special User Set: " + specialUserSet);
        }
        if ((string2 = SystemProperties.get(DB_PROXY_ENABLE)) != null && string2.equalsIgnoreCase("true")) {
            backendProxyEnabled = true;
        }
        mCaseSensitiveAttributes = new CaseInsensitiveHashSet(3);
        mCaseSensitiveAttributes.add(ATTR_SCHEMA);
        mCaseSensitiveAttributes.add(ATTR_PLUGIN_SCHEMA);
        mCaseSensitiveAttributes.add(ATTR_KEYVAL);
        String string4 = System.getProperty(CACHE_PROPERTY, SystemProperties.get(CACHE_PROPERTY, "true"));
        if (string4.equalsIgnoreCase("true")) {
            cacheSMSEntries = true;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: cache enabled: " + cacheSMSEntries);
        }
        if ((string = SystemProperties.get(SMS_ENABLE_DB_NOTIFICATION)) != null && string.equalsIgnoreCase("true")) {
            enableDataStoreNotification = true;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: DN notification enabled: " + enableDataStoreNotification);
        }
        AMResourceBundleCache aMResourceBundleCache = AMResourceBundleCache.getInstance();
        bundle = aMResourceBundleCache.getResBundle("amSDK", Locale.ENGLISH);
        String string5 = SystemProperties.get(SMS_OBJECT_PROPERTY, DEFAULT_SMS_CLASS_NAME);
        Object[] objectArray = new Object[]{string5};
        try {
            tm = SSOTokenManager.getInstance();
            object = Class.forName(string5);
            smsObject = (SMSObject)((Class)object).newInstance();
            if (debug.messageEnabled()) {
                debug.message("Using SMS object class " + string5);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug.warningEnabled()) {
                debug.warning("SMSObject class not found: " + string5);
            }
            initializationException = new SMSException(classNotFoundException, "sms-init-no-class-found");
        }
        catch (Exception exception) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: error in instantiation of: " + string5 + " Message: " + exception.getMessage());
            }
            initializationException = new SMSException(exception, "sms-instantiation-failed");
        }
        if (smsObject == null) {
            try {
                if (string5.equals(DEFAULT_SMS_CLASS_NAME)) {
                    debug.message("SMSEntry: Using default JAXRPC implementation");
                    smsObject = (SMSObject)Class.forName(JAXRPC_SMS_CLASS_NAME).newInstance();
                    SMSJAXRPCObjectFlg = true;
                } else if (string5.equals(JAXRPC_SMS_CLASS_NAME)) {
                    debug.message("SMSEntry: Using default JAXRPC implementation");
                    smsObject = (SMSObject)Class.forName(JAXRPC_SMS_CLASS_NAME).newInstance();
                    SMSJAXRPCObjectFlg = true;
                } else {
                    debug.message("SMSEntry: Using default LDAP implementation");
                    smsObject = (SMSObject)Class.forName(DEFAULT_SMS_CLASS_NAME).newInstance();
                }
                initializationException = null;
            }
            catch (Exception exception) {
                debug.error("SMSEntry: Error in getting configured/default SMSObject", initializationException);
                debug.error("SMSEntry: Error in getting backupSMSObject", exception);
            }
        }
        if ((baseDN = (object = smsObject.getRootSuffix()) != null ? new DN((String)object).toRFCString().toLowerCase() : "o=unknown-suffix") == null) {
            initializationException = new SMSException(bundle.getString("sms-invalid-dn"), "sms-invalid-dn");
        } else {
            baseDNCount = new StringTokenizer(baseDN, COMMA).countTokens();
        }
        DELEGATION_SERVICES_RDN_WITH_COMMA_LEN = DELEGATION_SERVICES_RDN_WITH_COMMA.length();
        SMS_ATTRIBUTES = new String[]{PLACEHOLDER_RDN, ATTR_SCHEMA, ATTR_PLUGIN_SCHEMA, ATTR_KEYVAL, ATTR_XML_KEYVAL, ATTR_OBJECTCLASS, ATTR_PRIORITY, ATTR_SERVICE_ID, ATTR_LABELED_URI, ATTR_MODIFY_TIMESTAMP};
    }

    static class NotificationThread
    extends Thread {
        String name;
        int type;

        NotificationThread(String string, int n) {
            this.name = string;
            this.type = n;
        }

        public void run() {
            block10: {
                String string = this.name.toLowerCase();
                if (this.type == 0 && (new StringTokenizer(this.name, SMSEntry.COMMA).countTokens() <= baseDNCount + 1 || string.startsWith(SMSEntry.DELEGATION_SERVICES_RDN) || string.startsWith("ou=globalconfig,") || string.startsWith("ou=organizationconfig,") || string.startsWith("ou=instances,") || string.startsWith("ou=pluginconfig,"))) {
                    return;
                }
                if (ServiceManager.isRealmEnabled() && !enableDataStoreNotification) {
                    if (eventDebug.messageEnabled()) {
                        eventDebug.message("SMSEntry::NotificationThread:run sending local notifications");
                    }
                    SMSEntry.objectChanged(this.name, this.type, true);
                }
                if (!SMSJAXRPCObjectFlg && !enableDataStoreNotification && ServiceManager.isRealmEnabled()) {
                    try {
                        Iterator iterator = ServiceManager.getAMServerInstances().iterator();
                        while (iterator != null && iterator.hasNext()) {
                            URL uRL = new URL((String)iterator.next());
                            URL uRL2 = WebtopNaming.getServiceURL("jaxrpc", uRL.getProtocol(), uRL.getHost(), Integer.toString(uRL.getPort()), false);
                            String string2 = uRL2.toString();
                            string2 = !string2.endsWith(SMSEntry.SLASH_STR) ? string2 + "/SMSObjectIF" : string2 + "SMSObjectIF";
                            try {
                                SOAPClient sOAPClient = new SOAPClient();
                                sOAPClient.setURL(string2);
                                Object[] objectArray = new Object[]{this.name, new Integer(this.type)};
                                if (eventDebug.messageEnabled()) {
                                    eventDebug.message("SMSEntry:NotificationThread:run Sending to URL: " + string2);
                                }
                                sOAPClient.send("notifyObjectChanged", objectArray, (String)null);
                            }
                            catch (Throwable throwable) {
                                if (!eventDebug.warningEnabled()) continue;
                                eventDebug.warning("SMSEntry:NotificationThread:: Unable to send notification to: " + string2, throwable);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (!eventDebug.warningEnabled()) break block10;
                        eventDebug.warning("SMSEntry:NotificationThread:: Unable to send notifications", throwable);
                    }
                }
            }
        }
    }
}

