/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class OrgConfigViaAMSDK {
    private SSOToken token;
    private String parentOrgName;
    private String smsOrgName;
    private AMOrganization parentOrg;
    private ServiceConfig serviceConfig;
    static Map attributeMappings = new CaseInsensitiveHashMap();
    static Map reverseAttributeMappings = new CaseInsensitiveHashMap();
    static Map attributeMappingServiceConfigs = new HashMap();
    static final String IDREPO_SERVICE = "sunidentityrepositoryservice";
    static final String MAPPING_ATTR_NAME = "sunCoexistenceAttributeMapping";
    Debug debug = SMSEntry.debug;
    ResourceBundle bundle = SMSEntry.bundle;
    static Map notMigratedAttributeMappings;
    static Map notMigratedReverseAttributeMappings;

    OrgConfigViaAMSDK(SSOToken sSOToken, String string, String string2) throws SMSException {
        this.token = sSOToken;
        this.parentOrgName = string;
        this.smsOrgName = string2;
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            this.parentOrg = aMStoreConnection.getOrganization(string);
            if (ServiceManager.isConfigMigratedTo70() && (this.serviceConfig = (ServiceConfig)attributeMappingServiceConfigs.get(string)) == null) {
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager(IDREPO_SERVICE, sSOToken);
                this.serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
                if (this.debug.messageEnabled()) {
                    this.debug.message("OrgConfigViaAMSDK::constructor: serviceConfig" + this.serviceConfig);
                }
                attributeMappingServiceConfigs.put(string, this.serviceConfig);
            }
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
    }

    void createSubOrganization(String string) throws SMSException {
        if (!this.getSubOrganizationNames(string, false).isEmpty() || string.startsWith("sunamhiddenrealm")) {
            return;
        }
        try {
            if (ServiceManager.isConfigMigratedTo70()) {
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("sunRealmService");
                hashMap.put("objectclass", hashSet);
                HashMap hashMap2 = new HashMap();
                hashMap2.put(string, hashMap);
                Set set = this.parentOrg.createSubOrganizations(hashMap2);
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(string);
                this.parentOrg.createSubOrganizations(hashSet);
            }
        }
        catch (AMException aMException) {
            if (!aMException.getErrorCode().equals("474")) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("OrgConfigViaAMSDK::createSubOrganization: failed with AMException", aMException);
                }
                throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
            }
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
    }

    Set getAssignedServices() throws SMSException {
        try {
            return this.parentOrg.getRegisteredServiceNames();
        }
        catch (AMException aMException) {
            if (this.debug.messageEnabled()) {
                this.debug.message("OrgConfigViaAMSDK::getAssignedServices: failed with AMException", aMException);
            }
            throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
    }

    void assignService(String string) throws SMSException {
        try {
            if (!this.getAssignedServices().contains(string)) {
                this.parentOrg.registerService(string, false, false);
            }
        }
        catch (AMException aMException) {
            if (this.debug.messageEnabled()) {
                this.debug.message("OrgConfigViaAMSDK::assignService: failed with AMException", aMException);
            }
            throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
    }

    void unassignService(String string) throws SMSException {
        try {
            if (this.getAssignedServices().contains(string)) {
                this.parentOrg.unregisterService(string);
            }
        }
        catch (AMException aMException) {
            if (this.debug.messageEnabled()) {
                this.debug.message("OrgConfigViaAMSDK::unassignService: failed with AMException", aMException);
            }
            throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
    }

    Set getSubOrganizationNames(String string, boolean bl) throws SMSException {
        try {
            Set set = this.parentOrg.searchSubOrganizations(string, bl ? 2 : 1);
            if (set != null && !set.isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(DNMapper.orgNameToDN((String)iterator.next()));
                }
                return SMSEntry.parseResult(hashSet, this.smsOrgName);
            }
        }
        catch (AMException aMException) {
            if (this.debug.messageEnabled()) {
                this.debug.message("OrgConfigViaAMSDK::getSubOrganizationNames: failed with AMException", aMException);
            }
            throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
        return Collections.EMPTY_SET;
    }

    void deleteSubOrganization(String string) throws SMSException {
        try {
            if (string == null || string.trim().length() == 0) {
                if (this.parentOrg.isExists()) {
                    this.parentOrg.delete(true);
                }
                return;
            }
            if (string.startsWith("sunamhiddenrealm")) {
                return;
            }
            Set set = this.parentOrg.searchSubOrganizations(string, 1);
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AMOrganization aMOrganization = this.parentOrg.getSubOrganization(string2);
                    if (aMOrganization == null) continue;
                    aMOrganization.delete(true);
                }
            } else {
                AMOrganization aMOrganization = this.parentOrg.getSubOrganization(string);
                if (aMOrganization != null) {
                    aMOrganization.delete(true);
                }
            }
        }
        catch (AMException aMException) {
            if (this.debug.messageEnabled()) {
                this.debug.message("OrgConfigViaAMSDK::deleteSubOrganization: failed with AMException", aMException);
            }
            throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
    }

    Map getAttributes() throws SMSException {
        HashMap hashMap = null;
        try {
            Map map;
            Map map2 = this.getReverseAttributeMapping();
            Set set = map2.keySet();
            if (!set.isEmpty() && (map = this.parentOrg.getAttributes(set)) != null && !map.isEmpty()) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Set set2 = (Set)map.get(string);
                    if (set2 == null || set2.isEmpty()) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    hashMap.put(map2.get(string), set2);
                }
            }
        }
        catch (AMException aMException) {
            if (this.debug.messageEnabled()) {
                this.debug.message("OrgConfigViaAMSDK::getAttributes: failed with AMException", aMException);
            }
            throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
        }
        catch (SSOException sSOException) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
        }
        return hashMap == null ? Collections.EMPTY_MAP : hashMap;
    }

    void addAttributeValues(String string, Set set) throws SMSException {
        if (string != null && set != null && !set.isEmpty()) {
            Map map = this.getAttributes();
            Set set2 = (Set)map.get(string);
            HashSet hashSet = new HashSet(set);
            if (set2 != null && !set2.isEmpty()) {
                hashSet.addAll(set2);
            }
            HashMap hashMap = new HashMap();
            hashMap.put(string, hashSet);
            this.setAttributes(hashMap);
        }
    }

    void setAttributes(Map map) throws SMSException {
        HashMap hashMap = null;
        if (map != null && !map.isEmpty()) {
            CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap(map);
            Map map2 = this.getAttributeMapping();
            Map map3 = this.getAttributes();
            if (map2 != null && !map2.isEmpty()) {
                Iterator iterator = map2.keySet().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string = (String)iterator.next();
                    Set set = (Set)caseInsensitiveHashMap.get(string);
                    if (set == null) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    boolean bl = false;
                    if (!set.isEmpty()) {
                        object = set.iterator();
                        while (object.hasNext()) {
                            String string2 = (String)object.next();
                            if (string2.length() <= 0) continue;
                            bl = true;
                        }
                        if (!bl) continue;
                        hashMap.put(map2.get(string), set);
                        continue;
                    }
                    object = (Set)map3.get(string);
                    if (object == null || object.isEmpty()) continue;
                    hashMap.put(map2.get(string), set);
                }
            }
        }
        if (hashMap != null) {
            try {
                this.parentOrg.setAttributes(hashMap);
                this.parentOrg.store();
            }
            catch (AMException aMException) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("OrgConfigViaAMSDK::createSubOrganization: failed with AMException", aMException);
                }
                throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
            }
            catch (SSOException sSOException) {
                throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
            }
        }
    }

    void removeAttribute(String string) throws SMSException {
        if (string == null) {
            return;
        }
        Map map = this.getAttributeMapping();
        String string2 = (String)map.get(string);
        if (string2 != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string2);
            try {
                this.parentOrg.removeAttributes(hashSet);
                this.parentOrg.store();
            }
            catch (AMException aMException) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("OrgConfigViaAMSDK::removeAttribute: failed with AMException", aMException);
                }
                throw new SMSException("amProfile", aMException.getMessage(), aMException, aMException.getMessage());
            }
            catch (SSOException sSOException) {
                throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), sSOException, "sms-INVALID_SSO_TOKEN");
            }
        }
    }

    void removeAttributeValues(String string, Set set) throws SMSException {
        Map map;
        Set set2;
        if (string != null && (set2 = (Set)(map = this.getAttributes()).get(string)) != null && !set2.isEmpty()) {
            HashSet hashSet = new HashSet(set2);
            hashSet.removeAll(set);
            if (hashSet.isEmpty()) {
                this.removeAttribute(string);
            } else {
                HashMap hashMap = new HashMap();
                hashMap.put(string, hashSet);
                this.setAttributes(hashMap);
            }
        }
    }

    private Map getAttributeMapping() throws SMSException {
        Set set;
        if (!ServiceManager.isConfigMigratedTo70()) {
            return notMigratedAttributeMappings;
        }
        Map map = (Map)attributeMappings.get(this.parentOrgName);
        if (map != null) {
            return map;
        }
        Map map2 = this.serviceConfig.getAttributes();
        if (map2 != null && !map2.isEmpty() && (set = (Set)map2.get(MAPPING_ATTR_NAME)) != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String[] stringArray = DNMapper.splitString(string);
                if (map == null) {
                    map = new CaseInsensitiveHashMap();
                }
                map.put(stringArray[0], stringArray[1]);
            }
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        attributeMappings.put(this.parentOrgName, map);
        return map;
    }

    private Map getReverseAttributeMapping() throws SMSException {
        if (!ServiceManager.isConfigMigratedTo70()) {
            return notMigratedReverseAttributeMappings;
        }
        Map map = (Map)reverseAttributeMappings.get(this.parentOrgName);
        if (map != null) {
            return map;
        }
        Map map2 = this.getAttributeMapping();
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (map == null) {
                map = new CaseInsensitiveHashMap();
            }
            map.put(entry.getValue(), entry.getKey().toString());
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        reverseAttributeMappings.put(this.parentOrgName, map);
        return map;
    }

    static String getNamingAttrForOrg() {
        return AMNamingAttrManager.getNamingAttr(2);
    }

    public Set getSDKAttributeValue(String string) {
        Set set;
        block4: {
            set = new HashSet();
            try {
                set = this.parentOrg.getAttribute(string);
            }
            catch (AMException aMException) {
                if (this.debug.warningEnabled()) {
                    this.debug.warning("OrgConfigViaAMSDK::getSDKAttributeValue: failed with AMException", aMException);
                }
            }
            catch (SSOException sSOException) {
                if (!this.debug.warningEnabled()) break block4;
                this.debug.warning("OrgConfigViaAMSDK::getSDKAttributeValue: failed with SSOException", sSOException);
            }
        }
        return set;
    }

    static {
        if (!ServiceManager.isConfigMigratedTo70()) {
            notMigratedAttributeMappings = new CaseInsensitiveHashMap();
            notMigratedAttributeMappings.put("sunPreferredDomain", "sunPreferredDomain");
            notMigratedAttributeMappings.put("sunOrganizationStatus", "inetDomainStatus");
            notMigratedAttributeMappings.put("sunOrganizationAliases", "sunOrganizationAlias");
            notMigratedAttributeMappings.put("sunDNSAliases", "associatedDomain");
            notMigratedReverseAttributeMappings = new CaseInsensitiveHashMap();
            notMigratedReverseAttributeMappings.put("sunPreferredDomain", "sunPreferredDomain");
            notMigratedReverseAttributeMappings.put("inetDomainStatus", "sunOrganizationStatus");
            notMigratedReverseAttributeMappings.put("sunOrganizationAlias", "sunOrganizationAliases");
            notMigratedReverseAttributeMappings.put("associatedDomain", "sunDNSAliases");
        }
    }
}

