/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.ServiceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class DNMapper {
    private static Debug debug = SMSEntry.debug;
    private static HashMap cache = new HashMap(2);
    protected static boolean realmEnabled = ServiceManager.isRealmEnabled();
    protected static String serviceDN = new DN("ou=services," + SMSEntry.baseDN).toRFCString().toLowerCase();
    static boolean migration = false;

    public static String orgNameToDN(String string) {
        if (string == null || string.trim().length() == 0 || string.equals("/")) {
            return SMSEntry.baseDN;
        }
        String string2 = (String)cache.get(string);
        if (string2 != null) {
            return string2;
        }
        if (DN.isDN(string)) {
            string2 = new DN(string).toRFCString();
            String string3 = string2.toLowerCase();
            if (string3.startsWith("o=sunamhiddenrealm")) {
                string2 = new DN(string2).explodeDN(false)[0] + "," + serviceDN;
                DNMapper.updateCache(string, string2);
                return string2;
            }
            if (string3.equals(SMSEntry.baseDN) || string3.equals(serviceDN)) {
                DNMapper.updateCache(string, SMSEntry.baseDN);
                return SMSEntry.baseDN;
            }
            if (realmEnabled) {
                int n;
                int n2 = string2.indexOf(serviceDN);
                if (n2 == -1) {
                    n2 = string2.lastIndexOf(SMSEntry.baseDN);
                }
                if (n2 > 0) {
                    string2 = string2.substring(0, n2 - 1);
                }
                if ((n = string2.lastIndexOf(",")) >= 0 && string2.substring(n).equals(",")) {
                    string2 = string2.substring(0, n);
                }
                if (debug.messageEnabled()) {
                    debug.message("DNMapper.orgNameToDN():orgdn " + string2);
                }
                String string4 = DNMapper.normalizeDN(string2) + serviceDN;
                if (debug.messageEnabled()) {
                    debug.message("DNMapper.orgNameToDN(" + string + ")=" + string4);
                }
                DNMapper.updateCache(string, string4);
                return string4;
            }
            if (!migration) {
                string2 = DNMapper.replaceString(string2, ",ou=services,", ",");
                DNMapper.updateCache(string, string2);
                return string2;
            }
            return string2;
        }
        StringBuffer stringBuffer = DNMapper.convertToDN(string);
        if (realmEnabled || stringBuffer.toString().toLowerCase().indexOf("sunamhiddenrealm") != -1) {
            stringBuffer.append(",").append(serviceDN);
        } else if (SMSEntry.baseDN.length() > 0) {
            stringBuffer.append(",").append(SMSEntry.baseDN);
        }
        if (debug.messageEnabled()) {
            debug.message("DNMapper.orgNameToDN(" + string + ")=" + stringBuffer.toString());
        }
        String string5 = stringBuffer.toString();
        DNMapper.updateCache(string, string5);
        return string5;
    }

    private static void updateCache(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(cache);
        hashMap.put(string, string2);
        cache = hashMap;
    }

    public static String realmNameToAMSDKName(String string) {
        String string2 = DNMapper.orgNameToDN(string);
        String string3 = string2.toLowerCase();
        if (debug.messageEnabled()) {
            debug.message("DNMapper.realmNameToAMSDKName realmName =" + string);
            debug.message("DNMapper.realmNameToAMSDKName orgDN =" + string2);
        }
        if (string3.equals(SMSEntry.baseDN) || string3.startsWith("o=sunamhiddenrealm")) {
            return SMSEntry.baseDN;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        String string4 = OrgConfigViaAMSDK.getNamingAttrForOrg();
        if (string4 == null || string4.equalsIgnoreCase("o")) {
            String string5 = DNMapper.replaceString(string2, ",ou=services,", ",");
            if (debug.messageEnabled()) {
                debug.message("DNMapper.realmNameToAMSDKName sdkName =" + string5);
            }
            return string5;
        }
        int n = string3.indexOf(serviceDN);
        if (n == -1) {
            n = string3.indexOf(SMSEntry.baseDN);
        }
        String string6 = n == -1 ? string2 : string2.substring(0, n - 1);
        String[] stringArray = new DN(string6).explodeDN(true);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(string4).append("=").append(stringArray[n3]);
            stringBuffer.append(',');
            ++n3;
        }
        stringBuffer.append(SMSEntry.baseDN);
        if (debug.messageEnabled()) {
            debug.message("DNMapper.realmNameToAMSDKName sdkName =" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static String orgNameToRealmName(String string) {
        String string2 = "/";
        if (string != null && string.length() != 0 && !string.equalsIgnoreCase(SMSEntry.baseDN) && !string.equalsIgnoreCase(serviceDN) && DN.isDN(string)) {
            HashSet<String> hashSet = new HashSet<String>(2);
            hashSet.add(string);
            String string3 = new DN(string).toRFCString();
            String string4 = string3.toLowerCase();
            Set set = null;
            if (string4.endsWith(serviceDN)) {
                set = SMSEntry.parseResult(hashSet, serviceDN, true);
            } else if (string4.endsWith(SMSEntry.baseDN)) {
                set = SMSEntry.parseResult(hashSet, serviceDN, true);
            }
            if (set != null && !set.isEmpty()) {
                string2 = (String)set.iterator().next();
            }
        }
        return string2;
    }

    static String[] splitString(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(61);
        if (n != -1) {
            stringArray[0] = string.substring(0, n).trim();
            stringArray[1] = string.substring(n + 1).trim();
        }
        return stringArray;
    }

    static String replaceString(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            string = string.substring(0, n2) + string3 + string.substring(n2 + n);
            n2 = string.indexOf(string2, n2 + n);
        }
        if (debug.messageEnabled()) {
            debug.message("DNMapper.replaceString() " + string);
        }
        return string;
    }

    static String normalizeDN(String string) {
        String string2 = "";
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String[] stringArray = new DN(string).explodeDN(false);
        int n = stringArray.length;
        if (!realmEnabled) {
            string2 = OrgConfigViaAMSDK.getNamingAttrForOrg();
        }
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray2 = DNMapper.splitString(stringArray[n2]);
            string3 = realmEnabled ? "o" : string2;
            stringBuffer.append(string3).append("=").append(stringArray2[1]).append(",");
            ++n2;
        }
        return stringBuffer.toString();
    }

    static StringBuffer convertToDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = realmEnabled ? "o" : OrgConfigViaAMSDK.getNamingAttrForOrg();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3 == null || string3.length() == 0) continue;
            arrayList.add(string3);
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)arrayList.get(n - n2 - 1);
            if (string4.toLowerCase().startsWith("sunamhiddenrealm")) {
                string2 = "o";
            }
            stringBuffer.append(string2);
            stringBuffer.append('=').append(string4);
            if (n2 != n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        return stringBuffer;
    }
}

