/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import netscape.ldap.util.DN;

class CachedSubEntries {
    protected static HashMap smsEntries = new CaseInsensitiveHashMap(100);
    protected Map ssoTokenToSubEntries = new Cache(100);
    protected CachedSMSEntry cEntry;
    protected SMSEntry entry;
    protected String dnRFCStr;
    protected String notificationID;
    private static Debug debug = SMSEntry.debug;

    private CachedSubEntries(SSOToken sSOToken, String string) throws SMSException {
        try {
            this.cEntry = CachedSMSEntry.getInstance(sSOToken, string, null);
            this.entry = this.cEntry.smsEntry;
            this.dnRFCStr = this.cEntry.dnRFCStr;
            this.update();
            Class<?> clazz = this.getClass();
            this.notificationID = SMSEventListenerManager.notifyChangesToSubNodes(sSOToken, string, clazz.getDeclaredMethod("update", null), this, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            debug.error("CachedSubEntries: unable to register for notifications: ", noSuchMethodException);
        }
        catch (SSOException sSOException) {
            debug.warning("CachedSubEntries::init Invalid SSOToken", sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::init: " + string);
        }
    }

    protected Set getSubEntries(SSOToken sSOToken) throws SMSException, SSOException {
        String string = sSOToken.getTokenID().toString();
        TreeSet treeSet = (TreeSet)this.ssoTokenToSubEntries.get(string);
        if (!SMSEntry.cacheSMSEntries || treeSet == null) {
            treeSet = this.getSubEntries(sSOToken, "*");
        }
        if (SMSEntry.cacheSMSEntries) {
            this.ssoTokenToSubEntries.put(string, treeSet);
            TreeSet treeSet2 = new TreeSet();
            treeSet2.addAll(treeSet);
            treeSet = treeSet2;
        }
        return treeSet;
    }

    protected Set getSubEntries(SSOToken sSOToken, String string) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.dnRFCStr + " pattern: " + string);
        }
        return this.entry.subEntries(sSOToken, string, 0, true, true);
    }

    protected Set getSchemaSubEntries(String string, String string2) throws SMSException, SSOException {
        SSOToken sSOToken = this.cEntry.getValidSSOToken();
        if (sSOToken == null) {
            smsEntries.remove(this.dnRFCStr);
            SMSEventListenerManager.removeNotification(this.notificationID);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        return this.getSchemaSubEntries(sSOToken, string, string2);
    }

    protected Set getSchemaSubEntries(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.dnRFCStr + " pattern: " + string2);
        }
        return this.entry.schemaSubEntries(sSOToken, string, string2, 0, true, true);
    }

    protected void add(String string) {
        this.ssoTokenToSubEntries = new Cache(100);
    }

    protected void remove(String string) {
        this.ssoTokenToSubEntries = new Cache(100);
    }

    protected boolean isEmpty(SSOToken sSOToken) throws SMSException, SSOException {
        return this.getSubEntries(sSOToken).isEmpty();
    }

    protected boolean contains(SSOToken sSOToken, String string) throws SMSException, SSOException {
        return this.getSubEntries(sSOToken).contains(string);
    }

    protected SMSEntry getSMSEntry() {
        return this.entry;
    }

    protected void update() {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::update called for dn: " + this.dnRFCStr);
        }
        this.ssoTokenToSubEntries = new Cache(100);
    }

    protected void finalize() throws Throwable {
        SMSEventListenerManager.removeNotification(this.notificationID);
    }

    static CachedSubEntries getInstance(SSOToken sSOToken, String string) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::getInstance DN: " + string);
        }
        String string2 = new DN(string).toRFCString();
        CachedSubEntries cachedSubEntries = null;
        cachedSubEntries = (CachedSubEntries)smsEntries.get(string2);
        if (cachedSubEntries == null) {
            HashMap hashMap = smsEntries;
            synchronized (hashMap) {
                cachedSubEntries = (CachedSubEntries)smsEntries.get(string2);
                if (cachedSubEntries == null) {
                    cachedSubEntries = new CachedSubEntries(sSOToken, string);
                    smsEntries.put(string2, cachedSubEntries);
                }
            }
        } else {
            cachedSubEntries.cEntry.addPrincipal(sSOToken);
        }
        return cachedSubEntries;
    }

    protected Set searchSubOrgNames(SSOToken sSOToken, String string, boolean bl) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading subOrgNames DN: " + this.dnRFCStr + " pattern: " + string);
        }
        if (sSOToken == null) {
            smsEntries.remove(this.dnRFCStr);
            SMSEventListenerManager.removeNotification(this.notificationID);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            bl2 = false;
            bl3 = false;
        }
        return this.entry.searchSubOrgNames(sSOToken, string, 0, bl2, bl3, bl);
    }

    protected Set searchOrgNames(SSOToken sSOToken, String string, String string2, Set set) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading orgNames DN: " + this.dnRFCStr + " attrName: " + string2);
        }
        return this.entry.searchOrganizationNames(sSOToken, 0, true, true, string, string2, set);
    }
}

