/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.keystore;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.keystore.AMCallbackHandler;
import java.io.File;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.X509KeyManager;

public class AMX509KeyManager
implements X509KeyManager {
    static final String bundleName = "amSecurity";
    static ResourceBundle bundle = null;
    static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    public static Debug debug = SecurityDebug.debug;
    private static String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
    private static String keyStoreFile = System.getProperty("javax.net.ssl.keyStore", null);
    private static String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", null);
    private static String certAlias = null;
    private X509KeyManager sunX509KeyManager = null;
    private KeyStore keyStore = null;
    KeyStore.Builder builder = null;
    KeyStore.CallbackHandlerProtection callback = null;
    private KeyManagerFactory kmf = null;
    String passwdPrompt = null;

    public AMX509KeyManager() {
        try {
            bundle = amCache.getResBundle(bundleName, Locale.getDefault());
            this.passwdPrompt = bundle.getString("KeyStorePrompt");
            this.callback = new KeyStore.CallbackHandlerProtection(new AMCallbackHandler(this.passwdPrompt));
            if (keyStoreType.equalsIgnoreCase("JKS") || keyStoreType.equalsIgnoreCase("PKCS12")) {
                this.builder = KeyStore.Builder.newInstance(keyStoreType, Security.getProvider(keyStoreProvider), new File(keyStoreFile), this.callback);
            } else if (keyStoreType.equalsIgnoreCase("PKCS11")) {
                this.builder = KeyStore.Builder.newInstance(keyStoreType, Security.getProvider(keyStoreProvider), this.callback);
            }
            KeyStoreBuilderParameters keyStoreBuilderParameters = new KeyStoreBuilderParameters(this.builder);
            this.kmf = KeyManagerFactory.getInstance("NewSunX509", "SunJSSE");
            this.kmf.init(keyStoreBuilderParameters);
        }
        catch (Exception exception) {
            debug.error(exception.toString());
        }
        this.sunX509KeyManager = (X509KeyManager)this.kmf.getKeyManagers()[0];
    }

    public static void setAlias(String string) {
        certAlias = string;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (certAlias != null && certAlias.length() > 0) {
            return certAlias;
        }
        return this.sunX509KeyManager.chooseClientAlias(stringArray, principalArray, socket);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.sunX509KeyManager.chooseServerAlias(string, principalArray, socket);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.sunX509KeyManager.getClientAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.sunX509KeyManager.getServerAliases(string, principalArray);
    }

    public X509Certificate[] getCertificateChain(String string) {
        X509Certificate[] x509CertificateArray = null;
        try {
            KeyStore keyStore = this.builder.getKeyStore();
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, this.builder.getProtectionParameter(string));
            x509CertificateArray = privateKeyEntry != null ? (X509Certificate[])privateKeyEntry.getCertificateChain() : this.sunX509KeyManager.getCertificateChain(string);
        }
        catch (Exception exception) {
            debug.error("Error in getting certificate chain from keystore." + exception.toString());
        }
        return x509CertificateArray;
    }

    public PrivateKey getPrivateKey(String string) {
        PrivateKey privateKey = null;
        try {
            KeyStore keyStore = this.builder.getKeyStore();
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, this.builder.getProtectionParameter(string));
            privateKey = privateKeyEntry != null ? privateKeyEntry.getPrivateKey() : this.sunX509KeyManager.getPrivateKey(string);
        }
        catch (Exception exception) {
            debug.error("Error in getting private key from keystore." + exception.toString());
        }
        return privateKey;
    }
}

