/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.keystore;

import com.iplanet.am.util.AMResourceBundleCache;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.SecurityDebug;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class AMCallbackHandler
implements CallbackHandler {
    static final String bundleName = "amSecurity";
    static ResourceBundle bundle = null;
    static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    static String passwdPrompt = null;
    static String passWDFile = System.getProperty("com.sun.identity.security.keyStorePasswordFile", null);
    static transient String keystorePW = System.getProperty("javax.net.ssl.keyStorePassword", null);

    public AMCallbackHandler() {
        this(passwdPrompt);
    }

    public AMCallbackHandler(String string) {
        if (string != null) {
            passwdPrompt = string;
        }
    }

    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        int n = 0;
        try {
            for (n = 0; n < callbackArray.length; ++n) {
                if (callbackArray[n] instanceof PasswordCallback) {
                    if (SecurityDebug.debug.messageEnabled()) {
                        SecurityDebug.debug.message("AMCallbackHandler() :  PasswordCallback()");
                    }
                    PasswordCallback passwordCallback = (PasswordCallback)callbackArray[n];
                    if (keystorePW == null) {
                        if (SecurityDebug.debug.messageEnabled()) {
                            SecurityDebug.debug.message("AMCallbackHandler() :  Prompt Password ");
                        }
                        if (passwdPrompt != null) {
                            System.out.print(passwdPrompt);
                        } else {
                            System.out.print(passwordCallback.getPrompt());
                        }
                        System.out.flush();
                        passwordCallback.setPassword(AMCallbackHandler.readPassword(System.in));
                        continue;
                    }
                    passwordCallback.setPassword(keystorePW.toCharArray());
                    continue;
                }
                SecurityDebug.debug.error("Got UnknownCallback");
                break;
            }
        }
        catch (Exception exception) {
            SecurityDebug.debug.error("Exception in Callback : " + exception);
            exception.printStackTrace();
            throw new UnsupportedCallbackException(callbackArray[n], "Callback exception: " + exception);
        }
    }

    private static char[] readPassword(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = cArray = new char[128];
        int n = cArray2.length;
        int n2 = 0;
        block4: while (true) {
            int n3 = inputStream.read();
            switch (n3) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                }
                default: {
                    if (--n < 0) {
                        cArray2 = new char[n2 + 128];
                        n = cArray2.length - n2 - 1;
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        Arrays.fill(cArray, ' ');
                        cArray = cArray2;
                    }
                    cArray2[n2++] = (char)n3;
                    continue block4;
                }
            }
            break;
        }
        if (n2 == 0) {
            return null;
        }
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray2, 0, cArray3, 0, n2);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }

    public static void setPassword(String string) {
        keystorePW = string;
    }

    static {
        if (SecurityDebug.debug.messageEnabled()) {
            SecurityDebug.debug.message("AMCallbackHandler() : Keystore Password File ---> " + passWDFile);
        }
        bundle = amCache.getResBundle(bundleName, Locale.getDefault());
        passwdPrompt = bundle.getString("KeyStorePrompt");
        if (passWDFile != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(passWDFile);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                keystorePW = (String)AccessController.doPrivileged(new DecodeAction(bufferedReader.readLine()));
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SecurityDebug.debug.error("AMCallbackHandler: Unable to read keystore password file " + passWDFile);
            }
        }
    }
}

