/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.iplanet.am.util.Debug;
import com.iplanet.security.x509.X500Name;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class AMCertStore {
    protected AMLDAPCertStoreParameters storeParam = null;
    protected LDAPConnection ldapconn = null;
    protected X509Certificate certificate = null;
    protected static CertificateFactory cf = null;
    static final String amSecurity = "amSecurity";
    static Debug debug = SecurityDebug.debug;

    public AMCertStore(AMLDAPCertStoreParameters aMLDAPCertStoreParameters) {
        this.storeParam = aMLDAPCertStoreParameters;
    }

    LDAPConnection getConnection() {
        if (this.ldapconn != null) {
            return this.ldapconn;
        }
        if (this.storeParam.isSecure()) {
            debug.message("Cert:  initial ldc  using ssl.");
            try {
                this.ldapconn = new LDAPConnection(this.storeParam.getSecureSocketFactory());
                debug.message("validate(): SSLSocketFactory called");
            }
            catch (Exception exception) {
                debug.error("validate.JSSSocketFactory", exception);
            }
        } else {
            this.ldapconn = new LDAPConnection();
        }
        try {
            this.ldapconn.connect(this.storeParam.getServerName(), this.storeParam.getPort());
            this.ldapconn.authenticate(3, this.storeParam.getUser(), this.storeParam.getPassword());
        }
        catch (LDAPException lDAPException) {
            debug.message("Certificate: dircontext", lDAPException);
        }
        return this.ldapconn;
    }

    LDAPSearchResults getSearchResults(LDAPConnection lDAPConnection) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            lDAPSearchResults = lDAPConnection.search(this.storeParam.getStartLoc(), 2, this.storeParam.getSearchFilter(), null, false);
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                debug.error("No ldap Entry found !");
                return null;
            }
        }
        catch (Exception exception) {
            debug.error("Error in ldap search for " + this.storeParam.getSearchFilter());
            debug.error("" + exception.toString());
            return null;
        }
        return lDAPSearchResults;
    }

    LDAPEntry getLdapEntry(LDAPConnection lDAPConnection) {
        LDAPEntry lDAPEntry = null;
        try {
            LDAPSearchResults lDAPSearchResults = this.getSearchResults(lDAPConnection);
            lDAPEntry = lDAPSearchResults.next();
        }
        catch (Exception exception) {
            debug.error("Error in getting Cached CRL");
            return null;
        }
        return lDAPEntry;
    }

    public X509Certificate getCertificate(X509Certificate x509Certificate) {
        try {
            LDAPSearchResults lDAPSearchResults = this.getSearchResults(this.getConnection());
            while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute("usercertificate");
                if (lDAPAttribute == null && (lDAPAttribute = lDAPAttributeSet.getAttribute("usercertificate;binary")) == null) {
                    debug.message("Certificate - get usercertificate is null ");
                    continue;
                }
                Enumeration enumeration = lDAPAttribute.getByteValues();
                while (enumeration.hasMoreElements()) {
                    byte[] byArray = (byte[])enumeration.nextElement();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    X509Certificate x509Certificate2 = null;
                    try {
                        x509Certificate2 = (X509Certificate)cf.generateCertificate(byteArrayInputStream);
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        debug.error("Error in Certificate parsing : ", certificateParsingException);
                    }
                    if (x509Certificate2 == null || !x509Certificate.equals(x509Certificate2)) continue;
                    return x509Certificate2;
                }
            }
        }
        catch (Exception exception) {
            debug.error("Certificate - Error finding registered certificate = ", exception);
        }
        return null;
    }

    public static X500Name getIssuerDN(X509Certificate x509Certificate) throws IOException {
        X500Name x500Name = null;
        try {
            sun.security.x509.X500Name x500Name2 = (sun.security.x509.X500Name)x509Certificate.getIssuerDN();
            x500Name = new X500Name(x500Name2.getEncoded());
        }
        catch (IOException iOException) {
            debug.error("Error in getting issuer DN : " + iOException.toString());
        }
        return x500Name;
    }

    public static X500Name getSubjectDN(X509Certificate x509Certificate) throws IOException {
        X500Name x500Name = null;
        try {
            sun.security.x509.X500Name x500Name2 = (sun.security.x509.X500Name)x509Certificate.getSubjectDN();
            x500Name = new X500Name(x500Name2.getEncoded());
        }
        catch (Exception exception) {
            debug.error("Error in getting subject DN : " + exception.toString());
        }
        return x500Name;
    }

    static {
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            debug.error("" + certificateException.toString());
        }
    }
}

