/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.iplanet.am.util.Debug;
import com.sun.identity.security.SecurityDebug;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class AMCertPath {
    private static String OCSP_ENABLE = null;
    private static String OCSP_RESPONDER_URL = null;
    private static String OCSP_RESPONDER_CERT_SUBJECT_NAME = null;
    private static String OCSP_RESPONDER_CERT_ISSUER_NAME = null;
    private static String OCSP_RESPONDER_CERT_SERIAL_NUMBER = null;
    private static CertificateFactory cf = null;
    private static CertPathValidator cpv = null;
    private CertStore store = null;
    public static Debug debug = SecurityDebug.debug;

    public AMCertPath(Vector vector) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object object;
        if (debug.messageEnabled()) {
            object = (X509CRL)vector.elementAt(0);
            debug.message("" + ((CRL)object).toString());
        }
        if (vector != null && vector.size() > 0) {
            object = new CollectionCertStoreParameters(vector);
            this.store = CertStore.getInstance("Collection", (CertStoreParameters)object);
        }
    }

    private void printOCSPConfig() {
        if (debug.messageEnabled()) {
            debug.message("OCSP_ENABLE :" + OCSP_ENABLE);
            debug.message("OCSP_RESPONDER_URL:" + OCSP_RESPONDER_URL);
            debug.message("OCSP_RESPONDER_CERT_SUBJECT_NAME :" + OCSP_RESPONDER_CERT_SUBJECT_NAME);
            debug.message("OCSP_RESPONDER_CERT_ISSUER_NAME :" + OCSP_RESPONDER_CERT_ISSUER_NAME);
            debug.message("OCSP_RESPONDER_CERT_SERIAL_NUMBER :" + OCSP_RESPONDER_CERT_SERIAL_NUMBER);
        }
    }

    public boolean velify(X509Certificate[] x509CertificateArray) {
        try {
            this.printOCSPConfig();
            List<X509Certificate> list = Arrays.asList(x509CertificateArray);
            CertPath certPath = cf.generateCertPath(list);
            Class<?> clazz = Class.forName("com.sun.identity.security.keystore.AMX509TrustManager");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getKeyStore", null);
            KeyStore keyStore = (KeyStore)method.invoke(obj, null);
            PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
            if (this.store != null) {
                pKIXParameters.addCertStore(this.store);
            }
            CertPathValidatorResult certPathValidatorResult = cpv.validate(certPath, pKIXParameters);
            if (debug.messageEnabled()) {
                debug.message("VALIDATE_RESULT: PASS" + certPathValidatorResult.toString());
            }
        }
        catch (Exception exception) {
            debug.message("VALIDATE_RESULT: FAILED");
            debug.message("" + exception.toString());
            return false;
        }
        return true;
    }

    static {
        OCSP_ENABLE = Security.getProperty("ocsp.enable");
        OCSP_RESPONDER_URL = Security.getProperty("ocsp.responderURL");
        OCSP_RESPONDER_CERT_SUBJECT_NAME = Security.getProperty("ocsp.responderCertSubjectName");
        OCSP_RESPONDER_CERT_ISSUER_NAME = Security.getProperty("ocsp.responderCertIssuerName");
        OCSP_RESPONDER_CERT_SERIAL_NUMBER = Security.getProperty("ocsp.responderCertSerialNumber");
        try {
            cf = CertificateFactory.getInstance("X509");
            cpv = CertPathValidator.getInstance("PKIX");
        }
        catch (Exception exception) {
            debug.error("" + exception.toString());
        }
    }
}

