/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.StatusCode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Status {
    private StatusCode statusCode = null;
    private String statusMessage = null;
    private Element statusDetail = null;

    Status() {
    }

    public Status(Element element) throws SAMLException {
        String string = null;
        if (element == null) {
            SAMLUtilsCommon.debug.message("Status: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        string = element.getLocalName();
        if (string == null || !string.equals("Status")) {
            SAMLUtilsCommon.debug.message("Status: wrong input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("StatusCode")) {
                    if (this.statusCode != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Status: contained more than one <StatusCode>");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
                    }
                    this.statusCode = new StatusCode((Element)node);
                } else if (string2.equals("StatusMessage")) {
                    String string3 = XMLUtils.getElementValue((Element)node);
                    if (string3 == null || string3.equals("")) {
                        SAMLUtilsCommon.debug.message("Status: Empty StatusMessage.");
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("emptyElement"));
                    }
                    if (this.statusMessage != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Status: included more than one <StatusMessage>");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
                    }
                    this.statusMessage = string3;
                } else if (string2.equals("StatusDetail")) {
                    if (this.statusDetail != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Status: included more than one <StatusDetail>");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
                    }
                    this.statusDetail = (Element)node;
                } else {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Status: contained wrong element:" + string2);
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
            }
            ++n2;
        }
        if (this.statusCode == null) {
            SAMLUtilsCommon.debug.message("Status: missing <StatusCode>.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public Status(StatusCode statusCode, String string, Element element) throws SAMLException {
        if (statusCode == null) {
            SAMLUtilsCommon.debug.message("Status: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this.statusCode = statusCode;
        if (string != null && string.length() == 0) {
            SAMLUtilsCommon.debug.message("Status: Empty StatusMessage.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("emptyElement"));
        }
        this.statusMessage = string;
        this.statusDetail = element;
    }

    public Status(StatusCode statusCode) throws SAMLException {
        if (statusCode == null) {
            SAMLUtilsCommon.debug.message("Status: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this.statusCode = statusCode;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Element getStatusDetail() {
        return this.statusDetail;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "samlp:";
        }
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        stringBuffer.append("<").append(string).append("Status").append(string2).append(">\n").append(this.statusCode.toString(bl, false));
        if (this.statusMessage != null) {
            stringBuffer.append("<").append(string).append("StatusMessage>").append(this.statusMessage).append("</").append(string).append("StatusMessage>\n");
        }
        if (this.statusDetail != null) {
            stringBuffer.append("<").append(string).append("StatusDetail>\n");
            NodeList nodeList = this.statusDetail.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(XMLUtils.print(nodeList.item(n2)));
                ++n2;
            }
            stringBuffer.append("</").append(string).append("StatusDetail>\n");
        }
        stringBuffer.append("</").append(string).append("Status>\n");
        return stringBuffer.toString();
    }
}

