/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.saml.protocol.AuthenticationQuery;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Request
extends AbstractRequest {
    protected Query query = null;
    protected List assertionIDRefs = Collections.EMPTY_LIST;
    protected List artifacts = Collections.EMPTY_LIST;
    protected int contentType = -1;
    protected String xmlString = null;
    protected String signatureString = null;
    private static final String REQUEST_ID_ATTRIBUTE = "RequestID";
    public static final int NOT_SUPPORTED = -1;
    public static final int AUTHENTICATION_QUERY = 0;
    public static final int AUTHORIZATION_DECISION_QUERY = 1;
    public static final int ASSERTION_ID_REFERENCE = 2;
    public static final int ASSERTION_ARTIFACT = 3;
    public static final int ATTRIBUTE_QUERY = 4;

    protected Request() {
    }

    public void signXML() throws SAMLException {
        if (this.signed) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request.signXML: the request is already signed.");
            }
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("alreadySigned"));
        }
        String string = SystemProperties.get("com.sun.identity.saml.xmlsig.certalias");
        if (string == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request.signXML: couldn't obtain this site's cert Alias.");
            }
            throw new SAMLResponderException(SAMLUtilsCommon.bundle.getString("cannotFindCertAlias"));
        }
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        if (this.majorVersion == 1 && this.minorVersion == 0) {
            SAMLUtilsCommon.debug.message("Request.signXML: sign with version 1.0");
            this.signatureString = xMLSignatureManager.signXML(this.toString(true, true), string);
            this.signature = XMLUtils.toDOMDocument(this.signatureString, SAMLUtilsCommon.debug).getDocumentElement();
        } else {
            Document document = XMLUtils.toDOMDocument(this.toString(true, true), SAMLUtilsCommon.debug);
            this.signature = xMLSignatureManager.signXML(document, string, null, REQUEST_ID_ATTRIBUTE, this.getRequestID(), true, null);
            this.signatureString = XMLUtils.print(this.signature);
        }
        this.signed = true;
        this.xmlString = this.toString(true, true);
    }

    public Request(List list, String string, List list2) throws SAMLException {
        Object var4_4 = null;
        if (list != null && list != Collections.EMPTY_LIST) {
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                var4_4 = list.get(n);
                if (!(var4_4 instanceof String)) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request: wrong input for RespondWith");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                if (this.respondWiths == null || this.respondWiths.size() == 0) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(this.checkAndGetRespondWith(var4_4));
                ++n;
            }
        }
        if (string != null && !string.equals("")) {
            this.requestID = string;
        } else {
            this.requestID = SAMLUtilsCommon.generateID();
            if (this.requestID == null) {
                SAMLUtilsCommon.debug.error("Request: couldn't generate RequestID.");
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("errorGenerateID"));
            }
        }
        this.parseContents(list2);
        this.issueInstant = new Date();
    }

    private String checkAndGetRespondWith(String string) throws SAMLException {
        if (string == null || string.equals("")) {
            SAMLUtilsCommon.debug.message("Request: empty RespondWith Value.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        if (string.indexOf(":") == -1) {
            return "saml:" + string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            SAMLUtilsCommon.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().trim();
        if (string2.length() == 0) {
            SAMLUtilsCommon.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        return "saml:" + string2;
    }

    private void parseContents(List list) throws SAMLException {
        int n = 0;
        int n2 = 0;
        if (list == null || (n = list.size()) == 0) {
            SAMLUtilsCommon.debug.message("Request: empty content.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (e instanceof AuthenticationQuery) {
                if (this.contentType != -1 || n2 != n - 1) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request: should contain only one AuthenticationQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                this.contentType = 0;
                this.query = (AuthenticationQuery)e;
            } else if (e instanceof AuthorizationDecisionQuery) {
                if (this.contentType != -1 || n2 != n - 1) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request: should contain only one AuthorizationDecisionQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                this.contentType = 1;
                this.query = (AuthorizationDecisionQuery)e;
            } else if (e instanceof AttributeQuery) {
                if (this.contentType != -1 || n2 != n - 1) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request: should contain only one AttributeQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                this.contentType = 4;
                this.query = (AttributeQuery)e;
            } else if (e instanceof AssertionIDReference) {
                if (this.contentType != -1 && this.contentType != 2) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request: should contain one or more AssertionIDReference.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                this.contentType = 2;
                if (this.assertionIDRefs == Collections.EMPTY_LIST) {
                    this.assertionIDRefs = new ArrayList();
                }
                this.assertionIDRefs.add((AssertionIDReference)e);
            } else if (e instanceof AssertionArtifact) {
                if (this.contentType != -1 && this.contentType != 3) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request: should contain  one or more AssertionArtifact.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                this.contentType = 3;
                if (this.artifacts == Collections.EMPTY_LIST) {
                    this.artifacts = new ArrayList();
                }
                this.artifacts.add((AssertionArtifact)e);
            } else {
                SAMLUtilsCommon.debug.message("Request: wrong input.");
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
            ++n2;
        }
    }

    public Request(String string, Query query) throws SAMLException {
        if (string != null && !string.equals("")) {
            this.requestID = string;
        } else {
            this.requestID = SAMLUtilsCommon.generateID();
            if (this.requestID == null) {
                SAMLUtilsCommon.debug.error("Request: couldn't generate RequestID.");
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("errorGenerateID"));
            }
        }
        if (query == null) {
            SAMLUtilsCommon.debug.message("Request: empty content.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (query instanceof AuthenticationQuery) {
            this.contentType = 0;
        } else if (query instanceof AuthorizationDecisionQuery) {
            this.contentType = 1;
        } else if (query instanceof AttributeQuery) {
            this.contentType = 4;
        } else {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request: this type of query is not supported.");
            }
            throw new SAMLResponderException(SAMLUtilsCommon.bundle.getString("queryNotSupported"));
        }
        this.query = query;
        this.issueInstant = new Date();
    }

    public Request(String string, List list) throws SAMLException {
        if (string != null) {
            this.requestID = string;
        } else {
            this.requestID = SAMLUtilsCommon.generateID();
            if (this.requestID == null) {
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("errorGenerateID"));
            }
        }
        this.parseContents(list);
        this.issueInstant = new Date();
    }

    public static Request parseXML(String string) throws SAMLException {
        Document document = XMLUtils.toDOMDocument(string, SAMLUtilsCommon.debug);
        Element element = document.getDocumentElement();
        return new Request(element);
    }

    public Request(Element element) throws SAMLException {
        Object object;
        String string = null;
        if (element == null) {
            SAMLUtilsCommon.debug.message("Request(Element): null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        string = element.getLocalName();
        if (string == null || !string.equals("Request")) {
            SAMLUtilsCommon.debug.message("Request(Element): wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        List list = XMLUtils.getElementsByTagNameNS1(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = list.size();
        if (n == 1) {
            object = XMLSignatureManager.getInstance();
            this.valid = ((XMLSignatureManager)object).verifyXMLSignature(element, REQUEST_ID_ATTRIBUTE, null);
            if (!this.valid && SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): couldn't verify Request's signature.");
            }
            this.xmlString = XMLUtils.print(element);
            this.signed = true;
        } else if (n != 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
        }
        this.requestID = element.getAttribute(REQUEST_ID_ATTRIBUTE);
        if (this.requestID == null || this.requestID.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): Request doesn't have a RequestID.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        this.parseMajorVersion(this.requestID, element.getAttribute("MajorVersion"));
        this.parseMinorVersion(this.requestID, element.getAttribute("MinorVersion"));
        object = element.getAttribute("IssueInstant");
        if (object == null || ((String)object).equals("")) {
            SAMLUtilsCommon.debug.message("Request(Element): missing IssueInstant");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)object);
        }
        catch (ParseException parseException) {
            SAMLUtilsCommon.debug.message("Request(Element): could not parse IssueInstant", parseException);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        int n3 = nodeList.getLength();
        while (n2 < n3) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("RespondWith")) {
                    String string3 = XMLUtils.getElementValue((Element)node);
                    if (string3.length() == 0) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): wrong RespondWith value.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    if (this.respondWiths == Collections.EMPTY_LIST) {
                        this.respondWiths = new ArrayList();
                    }
                    this.respondWiths.add(string3);
                } else if (string2.equals("Signature")) {
                    this.signature = (Element)node;
                } else if (string2.equals("AuthenticationQuery")) {
                    if (this.contentType != -1) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): shouldcontain only one AuthenticationQuery.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 0;
                    this.query = new AuthenticationQuery((Element)node);
                } else if (string2.equals("AuthorizationDecisionQuery")) {
                    if (this.contentType != -1) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): shouldcontain only one AuthorizationDecisionQuery.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 1;
                    this.query = new AuthorizationDecisionQuery((Element)node);
                } else if (string2.equals("AttributeQuery")) {
                    if (this.contentType != -1) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): shouldcontain only one AttributeQuery.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 4;
                    this.query = new AttributeQuery((Element)node);
                } else if (string2.equals("AssertionIDReference")) {
                    if (this.contentType != -1 && this.contentType != 2) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): contained mixed contents.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 2;
                    if (this.assertionIDRefs == Collections.EMPTY_LIST) {
                        this.assertionIDRefs = new ArrayList();
                    }
                    this.assertionIDRefs.add(new AssertionIDReference(XMLUtils.getElementValue((Element)node)));
                } else if (string2.equals("AssertionArtifact")) {
                    if (this.contentType != -1 && this.contentType != 3) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): contained mixed contents.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 3;
                    if (this.artifacts == Collections.EMPTY_LIST) {
                        this.artifacts = new ArrayList();
                    }
                    this.artifacts.add(new AssertionArtifact(XMLUtils.getElementValue((Element)node)));
                } else if (string2.equals("Query") || string2.equals("SubjectQuery")) {
                    this.parseQuery(node);
                } else {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request(Element): invalid node" + string2);
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
            }
            ++n2;
        }
        if (this.contentType == -1) {
            SAMLUtilsCommon.debug.message("Request: empty content.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
    }

    private void parseMajorVersion(String string, String string2) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): invalid MajorVersion", numberFormatException);
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Request(Element):MajorVersion of the Request is too high.");
                }
                throw new SAMLRequestVersionTooHighException(string + "|" + SAMLUtilsCommon.bundle.getString("requestVersionTooHigh"));
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element):MajorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException(string + "|" + SAMLUtilsCommon.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string, String string2) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): invalid MinorVersion", numberFormatException);
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        if (this.minorVersion > 1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): MinorVersion of the Request is too high.");
            }
            throw new SAMLRequestVersionTooHighException(string + "|" + SAMLUtilsCommon.bundle.getString("requestVersionTooHigh"));
        }
        if (this.minorVersion < 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): MinorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException(string + "|" + SAMLUtilsCommon.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseQuery(Node node) throws SAMLException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = attr.getLocalName();
            if (string != null && string.equals("type")) {
                String string2 = attr.getNodeValue();
                if (string2.equals("AuthenticationQueryType")) {
                    if (this.contentType != -1) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): should contain only one AuthenticationQuery.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 0;
                    this.query = new AuthenticationQuery((Element)node);
                } else if (string2.equals("AuthorizationDecisionQueryType")) {
                    if (this.contentType != -1) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): should contain one AuthorizationDecisionQuery.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 1;
                    this.query = new AuthorizationDecisionQuery((Element)node);
                } else if (string2.equals("AttributeQueryType")) {
                    if (this.contentType != -1) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Request(Element): should contain one AttributeQuery.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                    this.contentType = 4;
                    this.query = new AttributeQuery((Element)node);
                } else {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Request(Element): This type of " + string + " is not supported.");
                    }
                    throw new SAMLResponderException(SAMLUtilsCommon.bundle.getString("queryNotSupported"));
                }
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Request(Element): missing xsi:type definition in " + node.getLocalName());
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
    }

    public Query getQuery() {
        return this.query;
    }

    public List getAssertionIDReference() {
        return this.assertionIDRefs;
    }

    public List getAssertionArtifact() {
        return this.artifacts;
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean setSignature(Element element) {
        this.signatureString = XMLUtils.print(element);
        return super.setSignature(element);
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean bl, boolean bl2) {
        return this.toString(bl, bl2, false);
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        Iterator iterator;
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        if (bl) {
            string = "samlp:";
        }
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String string3 = DateUtils.toUTCDateFormat(this.issueInstant);
        stringBuffer.append("<").append(string).append("Request").append(string2).append(" RequestID=\"").append(this.requestID).append("\"").append(" MajorVersion=\"").append(this.majorVersion).append("\"").append(" MinorVersion=\"").append(this.minorVersion).append("\"").append(" IssueInstant=\"").append(string3).append("\"").append(">\n");
        if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
            iterator = this.respondWiths.iterator();
            String string4 = null;
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                stringBuffer.append("<").append(string).append("RespondWith>");
                if (string4.startsWith("saml:")) {
                    stringBuffer.append(string4);
                } else {
                    try {
                        stringBuffer.append(this.checkAndGetRespondWith(string4));
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtilsCommon.debug.error("Request.toString: ", sAMLException);
                        stringBuffer.append(string4);
                    }
                }
                stringBuffer.append("</").append(string).append("RespondWith>\n");
            }
        }
        if (this.signed) {
            if (this.signatureString != null) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                stringBuffer.append(this.signatureString);
            }
        }
        switch (this.contentType) {
            case 0: {
                stringBuffer.append(((AuthenticationQuery)this.query).toString(bl, false));
                break;
            }
            case 1: {
                stringBuffer.append(((AuthorizationDecisionQuery)this.query).toString(bl, false));
                break;
            }
            case 4: {
                stringBuffer.append(((AttributeQuery)this.query).toString(bl, false));
                break;
            }
            case 2: {
                iterator = this.assertionIDRefs.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(((AssertionIDReference)iterator.next()).toString(true, true));
                }
                break;
            }
            case 3: {
                iterator = this.artifacts.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(((AssertionArtifact)iterator.next()).toString(bl, false));
                }
                break;
            }
        }
        stringBuffer.append("</").append(string).append("Request>\n");
        return stringBuffer.toString();
    }
}

