/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AuthorityBinding {
    private String _binding = null;
    private String _location = null;
    private int _authorityKind = -1;

    /*
     * Enabled aggressive block sorting
     */
    public AuthorityBinding(Element element) throws SAMLException {
        Object object;
        Object object2;
        if (element == null) {
            SAMLUtilsCommon.debug.message("AuthorityBinding: Input is null.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("AuthorityBinding")) {
            SAMLUtilsCommon.debug.message("AuthorityBinding: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        int n = 0;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        n = 0;
        while (n < n2) {
            block29: {
                String string2;
                block30: {
                    block31: {
                        object2 = namedNodeMap.item(n);
                        if (object2.getNodeType() != 2) break block29;
                        string2 = object2.getLocalName();
                        if (string2 == null || string2.equals("")) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("AuthorityBinding: Attribute Name is either null or empty.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                        }
                        if (!string2.equals("AuthorityKind")) break block30;
                        object = ((Attr)object2).getValue().trim();
                        if (object == null || ((String)object).equals("")) {
                            if (SAMLUtilsCommon.debug.messageEnabled()) {
                                SAMLUtilsCommon.debug.message("AuthorityBinding: AuthorityKind is null or empty.");
                            }
                            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
                        }
                        if (!((String)object).equals("samlp:AuthenticationQuery")) break block31;
                        this._authorityKind = 1;
                        break block29;
                    }
                    if (((String)object).equals("samlp:AttributeQuery")) {
                        this._authorityKind = 2;
                        break block29;
                    } else if (((String)object).equals("samlp:AuthorizationDecisionQuery")) {
                        this._authorityKind = 3;
                        break block29;
                    } else {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthorityBinding: The type of authority is illegal!");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                    }
                }
                if (string2.equals("Binding")) {
                    this._binding = ((Attr)object2).getValue().trim();
                    if (this._binding == null || this._binding.equals("")) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthorityBinding: BindingURI is null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
                    }
                } else if (string2.equals("Location")) {
                    this._location = ((Attr)object2).getValue().trim();
                    if (this._location == null || this._location.equals("")) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthorityBinding: Location URI is null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
                    }
                }
            }
            ++n;
        }
        if (this._authorityKind == -1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: AuthorityKind is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (this._location == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: Location is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (this._binding == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: Binding is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        object2 = element.getChildNodes();
        int n3 = object2.getLength();
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                object = object2.item(n);
                if (object.getNodeType() == 1) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AuthorityBinding: illegal input!");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
                }
                ++n;
            }
        }
    }

    public AuthorityBinding(int n, String string, String string2) throws SAMLException {
        if (string == null || string.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: The Location URI can not be null or empty!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._location = string;
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding: The binding URI can not be null or empty!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._binding = string2;
        if (n < 1 || n > 3) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorityBinding:The type of authority is illegal!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        this._authorityKind = n;
    }

    public String getLocation() {
        return this._location;
    }

    public String getBinding() {
        return this._binding;
    }

    public int getAuthorityKind() {
        return this._authorityKind;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(300);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("AuthorityBinding").append(string2).append(" AuthorityKind=\"");
        switch (this._authorityKind) {
            case 1: {
                stringBuffer.append("samlp:AuthenticationQuery");
                break;
            }
            case 2: {
                stringBuffer.append("samlp:AttributeQuery");
                break;
            }
            case 3: {
                stringBuffer.append("samlp:AuthorizationDecisionQuery");
            }
        }
        stringBuffer.append("\"").append(" Location=\"").append(this._location).append("\"").append(" Binding=\"").append(this._binding).append("\"").append(" />\n");
        return stringBuffer.toString();
    }

    public static class AuthorityKindType {
        public static final int AUTHENTICATION = 1;
        public static final int ATTRIBUTE = 2;
        public static final int AUTHORIZATION = 3;
        public static final int NOT_SUPPORTED = -1;
    }
}

