/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.saml.assertion.AdviceBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatementBase;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AssertionBase {
    protected static SAMLConstants sc;
    protected Set _statements = Collections.synchronizedSet(new HashSet());
    protected int _majorVersion = 1;
    protected int _minorVersion = SAMLConstants.ASSERTION_MINOR_VERSION;
    protected AssertionIDReference _assertionID = null;
    protected String _issuer = null;
    protected Date _issueInstant;
    protected Conditions _conditions;
    protected AdviceBase _advice;
    protected String xmlString = null;
    protected String signatureString = null;
    protected Element signature = null;
    protected boolean signed = false;
    protected boolean valid = true;
    protected boolean validationDone = true;
    protected static final String ASSERTION_ID_ATTRIBUTE = "AssertionID";

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSignatureValid() {
        return false;
    }

    public void signXML() throws SAMLException {
        throw new UnsupportedOperationException();
    }

    public void signXML(String string) throws SAMLException {
        throw new UnsupportedOperationException();
    }

    public Element getSignature() {
        return this.signature;
    }

    public boolean setSignature(Element element) {
        if (this.signed) {
            return false;
        }
        if (element == null) {
            return false;
        }
        this.signature = element;
        this.signed = true;
        this.signatureString = XMLUtils.print(element);
        return true;
    }

    protected abstract AdviceBase createAdvice(Element var1) throws SAMLException;

    protected abstract AuthorizationDecisionStatementBase createAuthorizationDecisionStatement(Element var1) throws SAMLException;

    protected abstract AuthenticationStatement createAuthenticationStatement(Element var1) throws SAMLException;

    protected abstract AttributeStatement createAttributeStatement(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(String var1) throws SAMLException;

    protected abstract Conditions createConditions(Element var1) throws SAMLException;

    protected AssertionBase() {
    }

    public AssertionBase(Element element) throws SAMLException {
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!string.equals("Assertion")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidElement") + ":" + string);
        }
        String string2 = element2.getAttribute("Issuer");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: Issuer missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "Issuer");
        }
        this._issuer = string2;
        List list = XMLUtils.getElementsByTagNameNS1(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = list.size();
        if (n == 1) {
            this.xmlString = XMLUtils.print(element);
            this.signed = true;
            this.validationDone = false;
        } else if (n != 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
        }
        string2 = element2.getAttribute("MajorVersion");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MajorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "MajorVersion");
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtilsCommon.debug.error("Assertion: invalid integer in MajorVersion", numberFormatException);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidNumber") + ":" + "MajorVersion");
        }
        if (n2 != 1) {
            if (n2 < 1) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Assertion: MajorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooLow") + ":" + "MajorVersion");
            }
            if (n2 > 1) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Assertion: MajorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooHigh") + ":" + "MajorVersion");
            }
            this._minorVersion = Integer.parseInt(string2);
        }
        if ((string2 = element2.getAttribute("MinorVersion")) == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "MinorVersion");
        }
        n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtilsCommon.debug.error("Assertion: invalid integer in MinorVersion", numberFormatException);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidNumber") + ":" + "MinorVersion");
        }
        if (n2 < 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion too low");
            }
            throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooLow"));
        }
        if (n2 > 1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: MinorVersion too high");
            }
            throw new SAMLVersionMismatchException(SAMLUtilsCommon.bundle.getString("assertionVersionTooHigh") + ":" + "MinorVersion");
        }
        this._minorVersion = n2;
        string2 = element2.getAttribute(ASSERTION_ID_ATTRIBUTE);
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: AssertionID missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + ASSERTION_ID_ATTRIBUTE);
        }
        this._assertionID = this.createAssertionIDReference(string2);
        string2 = element2.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: IssueInstant missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute") + ":" + "IssueInstant");
        }
        try {
            this._issueInstant = DateUtils.stringToDate(string2);
        }
        catch (ParseException parseException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: could not parse IssueInstant", parseException);
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput") + " " + parseException.getMessage());
        }
        n2 = 0;
        NodeList nodeList = element.getChildNodes();
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string3 = node.getLocalName();
            if (string3.equals("Conditions")) {
                this._conditions = this.createConditions((Element)node);
                continue;
            }
            if (string3.equals("Advice")) {
                this._advice = this.createAdvice((Element)node);
                continue;
            }
            if (string3.equals("AuthenticationStatement")) {
                this._statements.add(this.createAuthenticationStatement((Element)node));
                n2 = 1;
                continue;
            }
            if (string3.equals("AuthorizationDecisionStatement")) {
                this._statements.add(this.createAuthorizationDecisionStatement((Element)node));
                n2 = 1;
                continue;
            }
            if (string3.equals("AttributeStatement")) {
                this._statements.add(this.createAttributeStatement((Element)node));
                n2 = 1;
                continue;
            }
            if (string3.equals("Signature")) {
                this.signature = (Element)node;
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: invalid element in Assertion");
            }
            throw new SAMLRequesterException("invalidElement");
        }
        if (n2 == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: mandatory statement missing");
            }
            throw new SAMLRequesterException("missingStatement");
        }
    }

    public boolean isTimeValid() {
        if (this._conditions == null) {
            return true;
        }
        return this._conditions.checkDateValidity(System.currentTimeMillis());
    }

    public AssertionBase(String string, String string2, Date date, Set set) throws SAMLException {
        if (string2 == null || string2.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (set.size() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingStatement"));
        }
        this._statements.addAll(set);
        this._assertionID = this.createAssertionIDReference(string);
        if (string2 != null) {
            this._issuer = string2;
        }
        this._issueInstant = date != null ? date : new Date();
    }

    public AssertionBase(String string, String string2, Date date, Conditions conditions, Set set) throws SAMLException {
        if (string2 == null || string2.equals("") || conditions == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (set.size() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingStatement"));
        }
        this._statements.addAll(set);
        this._assertionID = this.createAssertionIDReference(string);
        if (string2 != null) {
            this._issuer = string2;
        }
        this._issueInstant = date != null ? date : new Date();
        if (conditions != null) {
            this._conditions = conditions;
        }
    }

    public AssertionBase(String string, String string2, Date date, Conditions conditions, AdviceBase adviceBase, Set set) throws SAMLException {
        if (string2 == null || string2.equals("") || conditions == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (set.size() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingStatement"));
        }
        this._statements.addAll(set);
        this._assertionID = this.createAssertionIDReference(string);
        if (string2 != null) {
            this._issuer = string2;
        }
        this._issueInstant = date != null ? date : new Date();
        if (conditions != null) {
            this._conditions = conditions;
        }
        if (adviceBase != null) {
            this._advice = adviceBase;
        }
    }

    public boolean addStatement(Statement statement) {
        if (this.signed) {
            return false;
        }
        if (statement == null) {
            return false;
        }
        this._statements.add(statement);
        return true;
    }

    protected boolean setIssueInstant(Date date) {
        if (this.signed) {
            return false;
        }
        if (date == null) {
            return false;
        }
        this._issueInstant = date;
        return true;
    }

    protected boolean setAssertionID(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null) {
            return false;
        }
        try {
            this._assertionID = this.createAssertionIDReference(string);
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Assertion: Exception in setting assertion id: " + exception.getMessage());
            }
            return false;
        }
        return true;
    }

    protected boolean setIssuer(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null || string.equals("")) {
            return false;
        }
        this._issuer = string;
        return true;
    }

    public boolean setAdvice(AdviceBase adviceBase) {
        if (this.signed) {
            return false;
        }
        if (adviceBase == null) {
            return false;
        }
        this._advice = adviceBase;
        return true;
    }

    public boolean setConditions(Conditions conditions) {
        if (this.signed) {
            return false;
        }
        if (conditions == null) {
            return false;
        }
        this._conditions = conditions;
        return true;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public void setMinorVersion(int n) {
        this._minorVersion = n;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public void setMajorVersion(int n) {
        this._majorVersion = n;
    }

    public Date getIssueInstant() {
        return this._issueInstant;
    }

    public String getIssuer() {
        return this._issuer;
    }

    public String getAssertionID() {
        return this._assertionID.getAssertionIDReference();
    }

    public Conditions getConditions() {
        return this._conditions;
    }

    public Set getStatement() {
        return this._statements;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        Object object;
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl2) {
            string = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (bl) {
            string2 = "saml:";
        }
        String string3 = null;
        if (this._issueInstant != null) {
            string3 = DateUtils.toUTCDateFormat(this._issueInstant);
        }
        stringBuffer.append("<").append(string2).append("Assertion").append(" ").append(string).append(" ").append("MajorVersion").append("=\"").append(this._majorVersion).append("\"").append(" ").append("MinorVersion").append("=\"").append(this._minorVersion).append("\"").append(" ").append("AssertionID=\"").append(this._assertionID.getAssertionIDReference()).append("\"").append(" ").append("Issuer").append("=\"").append(this._issuer).append("\"").append(" ").append("IssueInstant").append("=\"").append(string3).append("\"").append(" ").append(">").append("\n");
        if (this._conditions != null) {
            stringBuffer.append(this._conditions.toString(bl, false));
        }
        if (this._advice != null) {
            stringBuffer.append(this._advice.toString(bl, false));
        }
        Iterator iterator = this.getStatement().iterator();
        while (iterator.hasNext()) {
            object = (Statement)iterator.next();
            stringBuffer.append(((Statement)object).toString(bl, false));
        }
        if (this.signed && this.signatureString != null) {
            stringBuffer.append(this.signatureString);
        }
        object = SAMLUtilsCommon.makeEndElementTagXML("Assertion", bl);
        stringBuffer.append((String)object);
        return stringBuffer.toString();
    }
}

