/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.saml.assertion.AssertionBase;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AdviceBase {
    protected List _assertionIDRef = null;
    protected List _assertion = null;
    protected List _otherElements = null;

    public AdviceBase(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("Advice: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("Advice")) {
            SAMLUtilsCommon.debug.message("Advice: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Object object;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String string2 = node.getLocalName();
                String string3 = node.getNamespaceURI();
                if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Advice: The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                }
                if (string2.equals("AssertionIDReference") && string3.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    object = this.createAssertionIDReference((Element)node);
                    if (this._assertionIDRef == null) {
                        this._assertionIDRef = new ArrayList();
                    }
                    if (this._assertionIDRef.add(object)) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Advice:failed to add to AssertionIDReference List.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (string2.equals("Assertion") && string3.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    object = this.createAssertion((Element)node);
                    if (this._assertion == null) {
                        this._assertion = new ArrayList();
                    }
                    if (this._assertion.add(object)) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Advice:failed to add to Assertion List.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (this._otherElements == null) {
                    this._otherElements = new ArrayList();
                }
                if (this._otherElements.add((Element)node)) continue;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Advice: failed to add to other elements list.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
            }
        }
    }

    public AdviceBase(List list, List list2, List list3) {
        if (list != null && !list.isEmpty()) {
            if (this._assertionIDRef == null) {
                this._assertionIDRef = new ArrayList();
            }
            this._assertionIDRef = list;
        }
        if (list2 != null && !list2.isEmpty()) {
            if (this._assertion == null) {
                this._assertion = new ArrayList();
            }
            this._assertion = list2;
        }
        if (list3 != null) {
            if (this._otherElements == null) {
                this._otherElements = new ArrayList();
            }
            this._otherElements = list3;
        }
    }

    protected abstract AssertionBase createAssertion(Element var1) throws SAMLException;

    protected abstract AssertionIDReference createAssertionIDReference(Element var1) throws SAMLException;

    public List getAssertionIDReference() {
        return this._assertionIDRef;
    }

    public List getAssertion() {
        return this._assertion;
    }

    public List getOtherElement() {
        return this._otherElements;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        Iterator iterator = null;
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("Advice").append(string2).append(">\n");
        if (this._assertionIDRef != null && !this._assertionIDRef.isEmpty()) {
            iterator = this._assertionIDRef.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((AssertionIDReference)iterator.next()).toString(bl, false));
            }
        }
        if (this._assertion != null && !this._assertion.isEmpty()) {
            iterator = this._assertion.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((AssertionBase)iterator.next()).toString(bl, false));
            }
        }
        if (this._otherElements != null && !this._otherElements.isEmpty()) {
            iterator = this._otherElements.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(XMLUtils.print((Element)iterator.next()));
            }
        }
        stringBuffer.append("</").append(string).append("Advice>\n");
        return stringBuffer.toString();
    }
}

