/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.SAMLSOAPReceiver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLClient {
    private static void doSSO(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException, SAMLException {
        Serializable serializable;
        Object object;
        if (httpServletRequest == null || httpServletResponse == null || string == null) {
            SAMLUtilsCommon.debug.error("SAMLClient:Input parameter is null.");
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (!(string2.equals("samlawareservlet") || string2.equals("samlpostservlet") || string2.equals("samlsoapreceiver"))) {
            SAMLUtilsCommon.debug.error("SAMLClient:illegal naming service name.");
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("illegalNamingService"));
        }
        SSOToken sSOToken = null;
        try {
            object = SSOTokenManager.getInstance();
            sSOToken = ((SSOTokenManager)object).createSSOToken(httpServletRequest);
            if (sSOToken == null) {
                SAMLUtilsCommon.debug.error("SAMLClient:SSOToken is null.");
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullSSOToken"));
            }
            if (!((SSOTokenManager)object).isValidToken(sSOToken)) {
                SAMLUtilsCommon.debug.error("SAMLClient:SSOToken is invalid.");
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("invalidSSOToken"));
            }
        }
        catch (SSOException sSOException) {
            SAMLUtilsCommon.debug.error("SAMLClient", sSOException);
            throw new SAMLException("SAMLClient:doSSO:" + sSOException.getMessage());
        }
        object = null;
        try {
            serializable = new SessionID(sSOToken.getTokenID().toString());
            object = WebtopNaming.getServiceURL(string2, ((SessionID)serializable).getSessionServerProtocol(), ((SessionID)serializable).getSessionServer(), ((SessionID)serializable).getSessionServerPort());
        }
        catch (URLNotFoundException uRLNotFoundException) {
            SAMLUtilsCommon.debug.error("SAMLClient", uRLNotFoundException);
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("URLNotFoundException"));
        }
        serializable = new StringBuffer(200);
        String string3 = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier");
        ((StringBuffer)serializable).append(object).append("?").append(string3).append("=").append(string);
        httpServletResponse.sendRedirect(((StringBuffer)serializable).toString());
    }

    public static void doWebArtifact(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, SAMLException {
        SAMLClient.doSSO(httpServletRequest, httpServletResponse, string, "samlawareservlet");
    }

    public static void doWebPOST(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, SAMLException {
        SAMLClient.doSSO(httpServletRequest, httpServletResponse, string, "samlpostservlet");
    }

    public static Assertion getAssertionByArtifact(AssertionArtifact assertionArtifact) throws IOException, SAMLException {
        return SAMLClient.getAssertionByArtifact(assertionArtifact.getAssertionArtifact());
    }

    public static Assertion getAssertionByArtifact(String string) throws IOException, SAMLException {
        AssertionManager assertionManager;
        Object object;
        if (string == null || string.equals("")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLClient: input is null.");
            }
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        AssertionArtifact assertionArtifact = new AssertionArtifact(string);
        String string2 = assertionArtifact.getSourceID();
        String string3 = SAMLClient.getSamlSoapUrl(string2);
        URL uRL = null;
        try {
            if (string3 == null) {
                object = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-instance-list");
                if (object == null || object.size() == 0) {
                    throw new SAMLException(SAMLUtilsCommon.bundle.getString("instancemapNull"));
                }
                String string4 = (String)object.get(string2);
                if (string4 == null || string4.equals("")) {
                    throw new SAMLException(SAMLUtilsCommon.bundle.getString("instanceNotFound"));
                }
                assertionManager = new URL(string4);
                uRL = WebtopNaming.getServiceURL("samlsoapreceiver", assertionManager.getProtocol(), assertionManager.getHost(), Integer.toString(assertionManager.getPort()));
            } else {
                uRL = new URL(string3);
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLClient:SOAPUrl=" + uRL.toString());
            }
        }
        catch (URLNotFoundException uRLNotFoundException) {
            SAMLUtilsCommon.debug.error("SAMLClient", uRLNotFoundException);
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("URLNotFoundException"));
        }
        if (!SAMLClient.setLocalFlag(uRL)) {
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("failSetLocalFlag"));
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("SAMLClient:getAssertionByArtifact: check localFlag : " + SAMLServiceManager.localFlag);
        }
        object = (String)SAMLServiceManager.getAttribute("mysiteid");
        boolean bl = string2.equals(((String)object).trim());
        if (SAMLServiceManager.localFlag && bl) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLClient:getAssertionByArtifact:call AssertionManager.getAssertion(AssertionArtifact)");
            }
            assertionManager = AssertionManager.getInstance();
            Assertion assertion = assertionManager.getAssertion(assertionArtifact);
            return assertion;
        }
        assertionManager = new AssertionManager[]{string};
        List list = null;
        list = bl && string3 == null ? SAMLClient.artifactQueryHandler((String[])assertionManager, uRL.toString()) : SAMLClient.artifactQueryHandler((String[])assertionManager, null);
        if (list == null || list.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLClient:getAssertionByArtifact:returned assertion list is null.");
            }
            return null;
        }
        return (Assertion)list.get(0);
    }

    private static String getSamlSoapUrl(String string) {
        String string2 = null;
        try {
            Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (map == null) {
                SAMLUtilsCommon.debug.error("SAMLClient:Partner URL is null.");
                return null;
            }
            SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(string);
            if (sOAPEntry != null) {
                string2 = sOAPEntry.getSOAPUrl();
            } else if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLClient: " + string + " is not on trusted site list.");
            }
            return string2;
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLClient: ", exception);
            return null;
        }
    }

    public static boolean setLocalFlag(URL uRL) {
        if (uRL == null) {
            SAMLUtilsCommon.debug.error("SAMLClient:setLocalFlag has null input.");
            return false;
        }
        try {
            Class.forName("com.sun.identity.saml.servlet.SAMLSOAPReceiver");
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("in setLocalFlag(), url : " + uRL.toString());
                SAMLUtilsCommon.debug.message("SAMLSOAPReceiver.localSAMLServiceID : " + SAMLSOAPReceiver.localSAMLServiceID);
            }
            if (SAMLSOAPReceiver.localSAMLServiceID != null) {
                URL uRL2 = new URL(SAMLSOAPReceiver.localSAMLServiceID);
                if (uRL.getHost().equalsIgnoreCase(uRL2.getHost()) && uRL.getPort() == uRL2.getPort()) {
                    SAMLServiceManager.localFlag = true;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLClient::setLocalFlag: ", classNotFoundException);
            }
            SAMLServiceManager.localFlag = false;
            return true;
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLClient::setLocalFlag:: ", exception);
            return false;
        }
        SAMLServiceManager.localFlag = false;
        return true;
    }

    private static String createSOAPMessage(Request request) throws SAMLException {
        if (request == null) {
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("\n").append("<").append("soap-env").append(":Body>").append("\n");
            StringBuffer stringBuffer2 = new StringBuffer(100);
            stringBuffer2.append("</").append("soap-env").append(":Body>").append("\n").append("</").append("soap-env").append(":Envelope>").append("\n");
            StringBuffer stringBuffer3 = new StringBuffer(300);
            stringBuffer3.append((Object)stringBuffer).append(request.toString(true, true)).append((Object)stringBuffer2);
            return stringBuffer3.toString();
        }
        catch (Exception exception) {
            throw new SAMLException(exception.getMessage());
        }
    }

    private static String createSOAPReceiverUrl(SAMLServiceManager.SOAPEntry sOAPEntry, String string) throws IOException, SAMLException {
        String[] stringArray;
        if (sOAPEntry == null || string == null || string.equals("")) {
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String string2 = sOAPEntry.getAuthType();
        Object object = null;
        int n = -1;
        n = string.indexOf("//");
        if (n == -1) {
            SAMLUtilsCommon.debug.error("SAMLClient:createSOAPReceiverUrl:Illegal format of input parameter.");
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("illegalFormatSOAPUrl"));
        }
        String string3 = string.substring(0, n - 1);
        if (string2.equalsIgnoreCase("BASICAUTH") || string2.equalsIgnoreCase("NOAUTH")) {
            if (!string3.equals("http")) {
                if (SAMLServiceManager.localFlag) {
                    String[] stringArray2 = new String[]{SAMLUtilsCommon.bundle.getString("mismatchAuthTypeandProtocol")};
                    LogUtils.error(Level.INFO, "AUTH_PROTOCOL_MISMATCH", stringArray2);
                }
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("mismatchAuthTypeandProtocol"));
            }
        } else if (string2.equalsIgnoreCase("SSLWITHBASICAUTH") || string2.equalsIgnoreCase("SSL")) {
            if (!string3.equals("https")) {
                if (SAMLServiceManager.localFlag) {
                    String[] stringArray3 = new String[]{SAMLUtilsCommon.bundle.getString("mismatchAuthTypeandProtocol")};
                    LogUtils.error(Level.INFO, "AUTH_PROTOCOL_MISMATCH", stringArray3);
                }
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("mismatchAuthTypeandProtocol"));
            }
        } else {
            if (SAMLServiceManager.localFlag) {
                String[] stringArray4 = new String[]{SAMLUtilsCommon.bundle.getString("wrongAuthType")};
                LogUtils.error(Level.INFO, "INVALID_AUTH_TYPE", stringArray4);
            }
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongAuthType"));
        }
        if (string2.equalsIgnoreCase("BASICAUTH") || string2.equalsIgnoreCase("SSLWITHBASICAUTH")) {
            Object object2;
            stringArray = sOAPEntry.getBasicAuthUserID();
            String string4 = sOAPEntry.getBasicAuthPassword();
            if (stringArray == null || string4 == null) {
                object2 = SAMLServiceManager.getSAMLUser(sOAPEntry.getUser());
                stringArray = (String)object2.get("iplanet-am-saml-user");
                string4 = (String)object2.get("iplanet-am-saml-password");
                if (stringArray == null || string4 == null) {
                    SAMLUtilsCommon.debug.error("SAMLClient:createSOAPReceiverUrl:PartnerSite required basic authentication. But the user name or password used for authentication is null.");
                    throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongConfigBasicAuth"));
                }
            }
            object = object2 = string.substring(0, n + 2) + (String)stringArray + ":" + string4 + "@" + string.substring(n + 2);
        } else {
            object = string;
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Sending message to URL: " + (String)object);
        }
        if (SAMLServiceManager.localFlag) {
            stringArray = new String[]{SAMLUtilsCommon.bundle.getString("SOAPReceiverURL"), object};
            LogUtils.access(Level.FINE, "SOAP_RECEIVER_URL", stringArray);
        }
        return object;
    }

    private static Response getSAMLResponse(String string) throws IOException, SAMLException {
        if (string == null || string.equals("")) {
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Response response = null;
        Document document = XMLUtils.toDOMDocument(string, SAMLUtilsCommon.debug);
        Element element = document.getDocumentElement();
        String string2 = element.getLocalName();
        if (string2 == null || string2.equals("")) {
            SAMLUtilsCommon.debug.error("Missing Envelope tag.");
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("missingSOAPEnvTag"));
        }
        if (!string2.equals("Envelope") || !element.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            SAMLUtilsCommon.debug.error("Wrong Envelope tag or namespace.");
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongSOAPEnvtag"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n <= 0) {
            SAMLUtilsCommon.debug.error("Envelope does not contain a SOAP body.");
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("missingSOAPBody"));
        }
        String string3 = null;
        String string4 = null;
        Node node = null;
        Node node2 = null;
        int n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                string3 = node.getLocalName();
                if (string3 == null || string3.equals("")) {
                    SAMLUtilsCommon.debug.error("Missing tag name of child element");
                    throw new SAMLException(SAMLUtilsCommon.bundle.getString("missingChildTagName"));
                }
                if (string3.equals("Body")) {
                    NodeList nodeList2 = node.getChildNodes();
                    int n3 = nodeList2.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        node2 = nodeList2.item(n4);
                        if (node2.getNodeType() == 1) {
                            string4 = node2.getLocalName();
                            if (string4 == null || string4.equals("")) {
                                SAMLUtilsCommon.debug.error("Missing tag name of child element of <SOAP-ENV:Body>");
                                throw new SAMLException(SAMLUtilsCommon.bundle.getString("missingChildTagName"));
                            }
                            if (string4.equals("Fault")) {
                                SAMLUtilsCommon.debug.error("SOAPFault error.");
                                throw new SAMLException(XMLUtils.print(node2));
                            }
                            if (string4.equals("Response")) {
                                response = new Response((Element)node2);
                                if (SAMLUtilsCommon.debug.messageEnabled()) {
                                    SAMLUtilsCommon.debug.message("SAML Response:" + response.toString());
                                }
                                break;
                            }
                            SAMLUtilsCommon.debug.error("Wrong child element in SOAPBody");
                            throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongSOAPBody"));
                        }
                        ++n4;
                    }
                } else if (string3.equals("Header")) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Inside SOAP Response: SOAP Header");
                    }
                } else {
                    SAMLUtilsCommon.debug.error("Wrong child element in Envelope");
                    throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongSOAPElement"));
                }
            }
            ++n2;
        }
        return response;
    }

    private static List getAssertionList(Response response, List list) throws SAMLException {
        if (response == null || list == null) {
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        List list2 = new ArrayList();
        list2 = response.getAssertion();
        if (list2 == null || list2.isEmpty()) {
            if (SAMLServiceManager.localFlag) {
                String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("noAssertioninResponse"), response.toString(true, true)};
                LogUtils.error(Level.INFO, "NO_ASSERTION_IN_RESPONSE", stringArray);
            }
            throw new SAMLException(SAMLUtils.displayXML(response.getStatus().toString()));
        }
        if (list2.size() != list.size()) {
            SAMLUtilsCommon.debug.error("The SAML response containing assertions !=the number of artifacts in SAML request");
            if (SAMLServiceManager.localFlag) {
                String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("wrongNumberAssertions"), response.toString(true, true)};
                LogUtils.error(Level.INFO, "MISMATCHED_ASSERTION_AND_ARTIFACT", stringArray);
            }
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongNumberAssertions"));
        }
        return list2;
    }

    public static List artifactQueryHandler(String[] stringArray, String string) throws IOException, SAMLException {
        String[] stringArray2;
        Object object;
        String[] stringArray3;
        Object object2;
        if (stringArray == null || stringArray.length == 0) {
            SAMLUtilsCommon.debug.message("artifactQueryHandler: null input.");
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String string2 = null;
        SAMLServiceManager.SOAPEntry sOAPEntry = null;
        Response response = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        AssertionArtifact assertionArtifact = new AssertionArtifact(stringArray[0]);
        string2 = assertionArtifact.getSourceID();
        if (SAMLServiceManager.localFlag) {
            object2 = new String[]{SAMLUtilsCommon.bundle.getString("Artifact") + " " + 0, stringArray[0]};
            LogUtils.access(Level.INFO, "ARTIFACT_TO_SEND", (String[])object2);
        }
        arrayList2.add(assertionArtifact);
        arrayList.add(stringArray[0]);
        object2 = null;
        String string3 = null;
        int n = 1;
        while (n < stringArray.length) {
            object2 = new AssertionArtifact(stringArray[n]);
            string3 = ((AssertionArtifact)object2).getSourceID();
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SourceID within the Artifact is " + string3);
            }
            if (!string3.equals(string2)) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Received multiple Artifacts have different source id.");
                }
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("sourceidDifferent"));
            }
            if (SAMLServiceManager.localFlag) {
                stringArray3 = new String[]{SAMLUtilsCommon.bundle.getString("Artifact") + " " + n, stringArray[n]};
                LogUtils.access(Level.FINE, "ARTIFACT_TO_SEND", stringArray3);
            }
            arrayList2.add(object2);
            arrayList.add(stringArray[n]);
            ++n;
        }
        stringArray3 = "<html> <H4>";
        try {
            String[] stringArray4;
            String string4;
            String[] stringArray5;
            Object object3;
            object = null;
            stringArray2 = (String[])SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (stringArray2 == null) {
                SAMLUtilsCommon.debug.error(SAMLUtilsCommon.bundle.getString("nullPartnerUrl"));
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("nullPartnerUrl"));
            }
            String string5 = null;
            if (stringArray2.containsKey(string2)) {
                sOAPEntry = (SAMLServiceManager.SOAPEntry)stringArray2.get(string2);
                object = sOAPEntry.getSOAPUrl();
                if (object == null) {
                    if (string == null || string.equals("")) {
                        if (SAMLServiceManager.localFlag) {
                            String[] stringArray6 = new String[]{SAMLUtilsCommon.bundle.getString("wrongPartnerSOAPUrl")};
                            LogUtils.error(Level.INFO, "WRONG_SOAP_URL", stringArray6);
                        }
                        throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongPartnerSOAPUrl"));
                    }
                    string5 = string;
                } else {
                    string5 = SAMLClient.createSOAPReceiverUrl(sOAPEntry, (String)object);
                }
            } else {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("SAMLClient:artifactQueryHandler: Failed to locate SOAP-Receiver-URL using the source id from AssertionArtifact.");
                }
                if (string == null || string.equals("")) {
                    throw new SAMLException(SAMLUtilsCommon.bundle.getString("failedLocateSOAPUrl"));
                }
                string5 = string;
            }
            if (string5 == null) {
                SAMLUtilsCommon.debug.error("SAMLClient:artifactQueryHandler:createSOAPReceiverURL Error!");
                if (SAMLServiceManager.localFlag) {
                    String[] stringArray7 = new String[]{SAMLUtilsCommon.bundle.getString("wrongPartnerSOAPUrl")};
                    LogUtils.error(Level.INFO, "WRONG_SOAP_URL", stringArray7);
                }
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongPartnerSOAPUrl"));
            }
            Request request = new Request(null, arrayList2);
            String string6 = sOAPEntry.getVersion();
            if (string6 != null && ((StringTokenizer)(object3 = new StringTokenizer(string6, "."))).countTokens() == 2) {
                request.setMajorVersion(Integer.parseInt(((StringTokenizer)object3).nextToken().trim()));
                request.setMinorVersion(Integer.parseInt(((StringTokenizer)object3).nextToken().trim()));
            }
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signrequest")).booleanValue()) {
                request.signXML();
            }
            object3 = SAMLClient.createSOAPMessage(request);
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SENDING message: \n " + (String)object3);
            }
            if (SAMLServiceManager.localFlag) {
                stringArray5 = new String[]{SAMLUtilsCommon.bundle.getString("sendingSAMLRequest"), object3};
                LogUtils.access(Level.FINE, "SAML_ARTIFACT_QUERY", stringArray5);
            }
            stringArray5 = new String[]{string5};
            SOAPClient sOAPClient = new SOAPClient(stringArray5);
            InputStream inputStream = sOAPClient.call((String)object3, null);
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string4).append("\n");
            }
            if (stringBuffer == null) {
                if (SAMLServiceManager.localFlag) {
                    String[] stringArray8 = new String[]{SAMLUtilsCommon.bundle.getString("noReplyfromSOAPReceiver")};
                    LogUtils.error(Level.INFO, "NO_REPLY_FROM_SOAP_RECEIVER", stringArray8);
                }
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("noReplyfromSOAPReceiver"));
            }
            object3 = stringBuffer.toString();
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("REPLIED message: \n " + (String)object3);
            }
            if (SAMLServiceManager.localFlag) {
                stringArray4 = new String[]{SAMLUtilsCommon.bundle.getString("repliedSOAPMessage"), object3};
                LogUtils.access(Level.FINE, "REPLIED_SOAP_MESSAGE", stringArray4);
            }
            if ((response = SAMLClient.getSAMLResponse((String)object3)) == null) {
                SAMLUtilsCommon.debug.error("SAMLClient:artifactQueryHandler:No SAML Response contained in SOAPMessage.");
                if (SAMLServiceManager.localFlag) {
                    stringArray4 = new String[]{SAMLUtilsCommon.bundle.getString("noSAMLResponse")};
                    LogUtils.error(Level.INFO, "NULL_SAML_RESPONSE", stringArray4);
                }
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("noSAMLResponse"));
            }
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("SAMLClient:artifactQueryHandler", exception);
            throw new SAMLException(exception.getMessage());
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Start to process SAML Response...");
        }
        if (!response.isSignatureValid()) {
            if (SAMLServiceManager.localFlag) {
                object = new String[]{SAMLUtilsCommon.bundle.getString("cannotVerifyResponse")};
                LogUtils.error(Level.INFO, "INVALID_RESPONSE_SIGNATURE", object);
            }
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("cannotVerifyResponse"));
        }
        try {
            object = response.getStatus().getStatusCode().getValue();
            int n2 = 0;
            n2 = object.indexOf(":");
            if (n2 == -1) {
                throw new SAMLException(SAMLUtilsCommon.bundle.getString("wrongformatStatusCode"));
            }
            if (!object.substring(n2).equals(":Success")) {
                SAMLUtilsCommon.debug.error("Error:SAML StatusCode is not Success");
                throw new SAMLException(SAMLUtils.displayXML(response.getStatus().toString()));
            }
        }
        catch (Exception exception) {
            if (SAMLServiceManager.localFlag) {
                stringArray2 = new String[]{SAMLUtilsCommon.bundle.getString("errorSAMLStatusCode")};
                LogUtils.error(Level.INFO, "ERROR_RESPONSE_STATUS", stringArray2);
            }
            throw new SAMLException(exception.getMessage());
        }
        object = new ArrayList();
        object = SAMLClient.getAssertionList(response, arrayList);
        return object;
    }
}

