/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyService;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class ResourceResultRequest {
    static final String GET_RESOURCE_RESULTS = "GetResourceResults";
    static final String USER_SSOTOKEN = "userSSOToken";
    static final String SERVICE_NAME = "serviceName";
    static final String RESOURCE_NAME = "resourceName";
    static final String RESOURCE_SCOPE = "resourceScope";
    static final String ENV_PARAMETERS = "EnvParameters";
    static final String GET_RESPONSE_DECISIONS = "GetResponseDecisions";
    static final String RESOURCE_SCOPE_SELF = "self";
    static final String RESOURCE_SCOPE_STRICT_SUBTREE = "strict-subtree";
    static final String RESOURCE_SCOPE_SUBTREE = "subtree";
    static final String RESPONSE_ATTRIBUTES_ONLY = "response-attributes-only";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private String userSSOToken = null;
    private String serviceName = null;
    private String resourceName = null;
    private String resourceScope = null;
    private Map envParms = null;
    private Set respAttributes = null;

    public String getUserSSOToken() {
        return this.userSSOToken;
    }

    public void setUserSSOToken(String string) {
        this.userSSOToken = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public String getResourceScope() {
        return this.resourceScope;
    }

    public void setResourceScope(String string) {
        this.resourceScope = string;
    }

    public Map getEnvParms() {
        return this.envParms;
    }

    public void setEnvParms(Map map) {
        this.envParms = map;
    }

    public Set getResponseAttributes() {
        return this.respAttributes;
    }

    public void setResponseAttributes(Set set) {
        this.respAttributes = set;
    }

    public static ResourceResultRequest parseXML(Node node) throws PolicyEvaluationException {
        ResourceResultRequest resourceResultRequest = new ResourceResultRequest();
        String string = null;
        string = XMLUtils.getNodeAttributeValue(node, USER_SSOTOKEN);
        if (string == null || string.trim().equals("")) {
            if (debug.messageEnabled()) {
                debug.error("ResourceResultRequest: user sso toekn is null");
            }
            string = "";
        }
        resourceResultRequest.setUserSSOToken(string);
        string = XMLUtils.getNodeAttributeValue(node, SERVICE_NAME);
        if (string == null) {
            debug.error("ResourceResultRequest: missing attribute serviceName");
            Object[] objectArray = new String[]{SERVICE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        resourceResultRequest.setServiceName(string);
        string = XMLUtils.getNodeAttributeValue(node, RESOURCE_NAME);
        if (string == null) {
            debug.error("ResourceResultRequest: missing attribute resourceName");
            Object[] objectArray = new String[]{RESOURCE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        resourceResultRequest.setResourceName(string);
        string = XMLUtils.getNodeAttributeValue(node, RESOURCE_SCOPE);
        if (string == null) {
            resourceResultRequest.setResourceScope(RESOURCE_SCOPE_STRICT_SUBTREE);
        } else if (string.equals(RESOURCE_SCOPE_SUBTREE) || string.equals(RESOURCE_SCOPE_STRICT_SUBTREE) || string.equals(RESOURCE_SCOPE_SELF) || string.equals(RESPONSE_ATTRIBUTES_ONLY)) {
            resourceResultRequest.setResourceScope(string);
        } else {
            debug.error("ResourceResultRequest: invalid value " + string + " set for attribute " + RESOURCE_SCOPE);
            Object[] objectArray = new String[]{string, RESOURCE_SCOPE};
            throw new PolicyEvaluationException("amPolicy", "invalid_value_for_attribute", objectArray, null);
        }
        Node node2 = XMLUtils.getChildNode(node, ENV_PARAMETERS);
        if (node2 != null) {
            try {
                resourceResultRequest.setEnvParms(PolicyUtils.parseEnvParameters(node2));
            }
            catch (PolicyException policyException) {
                throw new PolicyEvaluationException(policyException);
            }
        }
        if ((node2 = XMLUtils.getChildNode(node, GET_RESPONSE_DECISIONS)) != null) {
            try {
                resourceResultRequest.setResponseAttributes(PolicyUtils.parseResponseAttributes(node2));
            }
            catch (PolicyException policyException) {
                throw new PolicyEvaluationException(policyException);
            }
        }
        return resourceResultRequest;
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<GetResourceResults");
        stringBuffer.append(" userSSOToken=\"" + (this.userSSOToken != null ? this.userSSOToken : "") + "\"");
        stringBuffer.append(" serviceName=\"" + this.serviceName + "\"");
        stringBuffer.append(" resourceName=\"" + XMLUtils.escapeSpecialCharacters(this.resourceName) + "\"");
        stringBuffer.append(" resourceScope=\"" + this.resourceScope + "\">" + CRLF);
        if (this.envParms != null) {
            stringBuffer.append(PolicyUtils.envParametersToXMLString(this.envParms));
        }
        if (this.respAttributes != null) {
            stringBuffer.append(PolicyUtils.responseAttributesToXMLString(this.respAttributes));
        }
        stringBuffer.append("</GetResourceResults>\r\n");
        return stringBuffer.toString();
    }
}

