/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.remote.PolicyChangeNotification;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyService;
import java.net.URL;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyListenerRequest
implements PolicyListener {
    static final String POLICY_LISTENER = "AddPolicyListener";
    static final String SERVICE_NAME = "serviceName";
    static final String NOTIFICATION_URL = "notificationURL";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private String notificationURL = null;
    private String serviceName = null;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getNotificationURL() {
        return this.notificationURL;
    }

    public void setNotificationURL(String string) {
        this.notificationURL = string;
    }

    public static PolicyListenerRequest parseXML(Node node) throws PolicyEvaluationException {
        PolicyListenerRequest policyListenerRequest = new PolicyListenerRequest();
        String string = XMLUtils.getNodeAttributeValue(node, SERVICE_NAME);
        if (string == null) {
            debug.error("PolicyListenerRequest: missing attribute serviceName");
            Object[] objectArray = new String[]{SERVICE_NAME};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        policyListenerRequest.setServiceName(string);
        string = XMLUtils.getNodeAttributeValue(node, NOTIFICATION_URL);
        if (string == null) {
            debug.error("PolicyListenerRequest: missing attribute notificationURL");
            Object[] objectArray = new String[]{NOTIFICATION_URL};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        policyListenerRequest.setNotificationURL(string);
        return policyListenerRequest;
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<AddPolicyListener serviceName=\"" + this.serviceName + "\" " + NOTIFICATION_URL + "=" + "\"" + this.notificationURL + "\"/>" + CRLF);
        return stringBuffer.toString();
    }

    public String getServiceTypeName() {
        return this.serviceName;
    }

    public void policyChanged(PolicyEvent policyEvent) {
        if (debug.messageEnabled()) {
            debug.message("PolicyListenerRequest.policyChanged()");
        }
        if (policyEvent == null) {
            debug.error("PolicyListenerRequest.policyChanged(): invalid policy event");
            return;
        }
        String string = null;
        int n = policyEvent.getChangeType();
        string = n == 1 ? "added" : (n == 2 ? "deleted" : "modified");
        Set set = policyEvent.getResourceNames();
        if (debug.messageEnabled()) {
            debug.message("PolicyListenerRequest.policyChanged(): resource names from the policy event :" + set.toString());
        }
        PolicyService policyService = new PolicyService();
        PolicyNotification policyNotification = new PolicyNotification();
        PolicyChangeNotification policyChangeNotification = new PolicyChangeNotification();
        policyChangeNotification.setResourceNames(set);
        policyChangeNotification.setPolicyChangeType(string);
        policyChangeNotification.setServiceName(this.serviceName);
        policyNotification.setNotificationType(1);
        policyNotification.setPolicyChangeNotification(policyChangeNotification);
        policyService.setMethodID(3);
        policyService.setPolicyNotification(policyNotification);
        Notification notification = new Notification(policyService.toXMLString());
        NotificationSet notificationSet = new NotificationSet("policy");
        notificationSet.addNotification(notification);
        if (debug.messageEnabled()) {
            debug.message("PolicyListenerRequest.policyChanged(): the notification set sent is : " + notificationSet.toXMLString());
        }
        try {
            PLLServer.send((URL)new URL(this.notificationURL), (NotificationSet)notificationSet);
            if (debug.messageEnabled()) {
                debug.message("PolicyListenerRequest.policyChanged(): the policy change notification has been sent to " + this.notificationURL);
            }
        }
        catch (Exception exception) {
            debug.error("PolicyListenerRequest.policyChanged(): PLLServer.send() failed", exception);
        }
    }
}

