/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SubOrgReferral
extends OrgReferral {
    private static Debug debug = Debug.getInstance("amPolicy");
    private static final String SUB_ORG_REFERRAL = "SubOrgReferral";

    public String getReferralTypeName() {
        return SUB_ORG_REFERRAL;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        try {
            Set set = (Set)this._configurationMap.get("OrganizationName");
            if (set == null || set.isEmpty()) {
                OrgReferral.DEBUG.error("SubOrgReferral.getValidValues():  Organization name not set");
                throw new PolicyException("amPolicy", "org_name_not_set", null, null);
            }
            Iterator iterator = set.iterator();
            String string2 = (String)iterator.next();
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string2);
            Set set2 = organizationConfigManager.getSubOrganizationNames(string, false);
            if (set2 != null && !set2.isEmpty()) {
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    OrganizationConfigManager organizationConfigManager2 = organizationConfigManager.getSubOrgConfigManager(string3);
                    if (organizationConfigManager2 == null) continue;
                    hashSet.add(organizationConfigManager2.getOrganizationName());
                }
            }
            if (debug.messageEnabled()) {
                debug.message("SubOrgReferral.getValidValues():subOrgNames=" + set2);
            }
        }
        catch (SMSException sMSException) {
            OrgReferral.DEBUG.error("Can not get valid values for referral " + this.getReferralTypeName() + sMSException);
            Object[] objectArray = new String[]{this.getReferralTypeName()};
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objectArray, sMSException);
        }
        return new ValidValues(n, hashSet);
    }
}

