/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IPCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance("amPolicy");
    public static final String START_IP = "StartIp";
    public static final String END_IP = "EndIp";
    public static final String IP_RANGE = "IpRange";
    public static final String DNS_NAME = "DnsName";
    public static final String REQUEST_IP = "requestIp";
    public static final String REQUEST_DNS_NAME = "requestDnsName";
    private Map properties;
    private ArrayList ipList = new ArrayList();
    private ArrayList dnsList = new ArrayList();
    private long startIp = Long.MAX_VALUE;
    private long endIp = Long.MIN_VALUE;
    private static List propertyNames = new ArrayList(3);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String string) {
        return Syntax.NONE;
    }

    public String getDisplayName(String string, Locale locale) throws PolicyException {
        return "";
    }

    public Set getValidValues(String string) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map map) throws PolicyException {
        this.properties = map;
        this.ipList.clear();
        this.dnsList.clear();
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        boolean bl = false;
        String string = (String)map.get(REQUEST_IP);
        if (string == null && sSOToken != null) {
            string = sSOToken.getIPAddress().getHostAddress();
        }
        Set set = (Set)map.get(REQUEST_DNS_NAME);
        if (string != null && this.isAllowedByIp(string)) {
            bl = true;
        } else if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!this.isAllowedByDns(string2)) continue;
                bl = true;
                break;
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At IPCondition.getConditionDecision():requestIp,  requestDnsName, allowed = " + string + ", " + set + "," + bl);
        }
        return new ConditionDecision(bl);
    }

    public Object clone() {
        IPCondition iPCondition = null;
        try {
            iPCondition = (IPCondition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        iPCondition.dnsList = (ArrayList)this.dnsList.clone();
        iPCondition.ipList = (ArrayList)this.ipList.clone();
        if (this.properties != null) {
            iPCondition.properties = new HashMap();
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                HashSet hashSet = new HashSet();
                hashSet.addAll((Set)this.properties.get(k));
                iPCondition.properties.put(k, hashSet);
            }
        }
        return iPCondition;
    }

    private boolean validateProperties() throws PolicyException {
        Set set;
        Object object;
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set set2 = this.properties.keySet();
        if (!(set2.contains(IP_RANGE) || set2.contains(DNS_NAME) || set2.contains(START_IP))) {
            Object[] objectArray = new String[]{"DnsName,StartIp"};
            throw new PolicyException("amPolicy", "at_least_one_of_the_properties_should_be_defined", objectArray, null);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (IP_RANGE.equals(object) || DNS_NAME.equals(object) || START_IP.equals(object) || END_IP.equals(object)) continue;
            Object[] objectArray = new String[]{object};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property ", objectArray, null);
        }
        object = (Set)this.properties.get(IP_RANGE);
        if (object != null) {
            this.validateIpRangeSet((Set)object);
        }
        if ((set = (Set)this.properties.get(DNS_NAME)) != null) {
            this.validateDnsNames(set);
        }
        Set set3 = (Set)this.properties.get(START_IP);
        Set set4 = (Set)this.properties.get(END_IP);
        if (set3 != null) {
            if (set4 == null) {
                Object[] objectArray = new String[]{START_IP, END_IP};
                throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
            }
            this.validateStartIp(set3);
        }
        if (set4 != null) {
            this.validateEndIp(set4);
        }
        return true;
    }

    private boolean validateIpRangeSet(Set set) throws PolicyException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            int n = stringTokenizer.countTokens();
            if (n > 2) {
                objectArray = new String[]{IP_RANGE, string};
                throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
            }
            Object object = objectArray = stringTokenizer.nextToken();
            if (n == 2) {
                object = stringTokenizer.nextToken();
            }
            this.ipList.add(new Long(this.stringToIp((String)objectArray)));
            this.ipList.add(new Long(this.stringToIp((String)object)));
        }
        return true;
    }

    private boolean validateEndIp(Set set) throws PolicyException {
        if (this.startIp == Long.MAX_VALUE) {
            Object[] objectArray = new String[]{END_IP, START_IP};
            throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
        }
        if (set.size() != 1) {
            Object[] objectArray = new String[]{END_IP};
            throw new PolicyException("amPolicy", "multiple_values_not_allowed_for", objectArray, null);
        }
        Iterator iterator = set.iterator();
        try {
            String string = (String)iterator.next();
            this.endIp = this.stringToIp(string);
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new String[]{END_IP};
            throw new PolicyException("amPolicy", "property_is_not_a_String", objectArray, classCastException);
        }
        if (this.endIp < this.startIp) {
            throw new PolicyException("amPolicy", "start_ip_can_not_be_greater_than_end_ip", null, null);
        }
        return true;
    }

    private boolean validateStartIp(Set set) throws PolicyException {
        if (set.size() != 1) {
            Object[] objectArray = new String[]{START_IP};
            throw new PolicyException("amPolicy", "multiple_values_not_allowed_for_property", objectArray, null);
        }
        Iterator iterator = set.iterator();
        try {
            String string = (String)iterator.next();
            this.startIp = this.stringToIp(string);
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new String[]{START_IP};
            throw new PolicyException("amPolicy", "property_is_not_a_String", objectArray, classCastException);
        }
        return true;
    }

    private void validateDnsNames(Set set) throws PolicyException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.validateDnsName(string);
            this.dnsList.add(string.toLowerCase());
        }
    }

    private long stringToIp(String string) throws PolicyException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n != 4) {
            Object[] objectArray = new String[]{"ip", string};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
        }
        long l = 0L;
        int n2 = -1;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            short s = 0;
            try {
                s = Short.parseShort(string2);
            }
            catch (Exception exception) {
                Object[] objectArray = new String[]{"ip", string};
                throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
            }
            if (s < 0 || s > 255) {
                Object[] objectArray = new String[]{"ipElement", string2};
                throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
            }
            l = l * 256L + (long)s;
        }
        return l;
    }

    private void validateDnsName(String string) throws PolicyException {
        int n = string.indexOf("*");
        if (!(n < 0 || string.equals("*") || n <= 0 && (n != 0 || string.indexOf("*", 1) == -1 && string.charAt(1) == '.'))) {
            Object[] objectArray = new String[]{DNS_NAME, string};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
        }
    }

    private boolean isAllowedByIp(String string) throws PolicyException {
        boolean bl = false;
        long l = this.stringToIp(string);
        Iterator iterator = ((AbstractList)this.ipList).iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            if (!iterator.hasNext()) continue;
            long l3 = (Long)iterator.next();
            if (l < l2 || l > l3) continue;
            bl = true;
            break;
        }
        if (l >= this.startIp && l <= this.endIp) {
            bl = true;
        }
        return bl;
    }

    private boolean isAllowedByDns(String string) throws PolicyException {
        boolean bl = false;
        string = string.toLowerCase();
        Iterator iterator = ((AbstractList)this.dnsList).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equals("*")) {
                bl = true;
                break;
            }
            int n = string2.indexOf("*");
            if (n != -1) {
                String string3 = string2.substring(1);
                if (!string.endsWith(string3)) continue;
                bl = true;
                break;
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isAllowed(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        return this.getConditionDecision(sSOToken, map).isAllowed();
    }

    static {
        propertyNames.add(START_IP);
        propertyNames.add(END_IP);
        propertyNames.add(DNS_NAME);
    }
}

