/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.ResponseProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class IDRepoResponseProvider
implements ResponseProvider {
    private static final Debug DEBUG = Debug.getInstance("amPolicy");
    public static final String STATIC_ATTRIBUTE = "StaticAttribute";
    public static final String DYNAMIC_ATTRIBUTE = "DynamicAttribute";
    public static final String ATTR_DELIMITER = "=";
    public static final String VAL_DELIMITER = "|";
    private Map properties;
    private static List propertyNames = new ArrayList(2);
    private boolean initialized = false;
    private String orgName = null;
    private Set validDynamicAttrNames = null;
    private Map staticResponse = null;
    private Set responseAttrNames = null;
    private Set repoAttrNames = null;
    private Map responseAttrToRepoAttr = null;

    public void initialize(Map map) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.initialize():entering");
        }
        if (map == null) {
            throw new PolicyException("amPolicy", "idrepo_initialization_failed", null, null);
        }
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        this.validDynamicAttrNames = (Set)map.get("sun-am-policy-dynamic-response-attributes");
        if (this.validDynamicAttrNames == null) {
            this.validDynamicAttrNames = Collections.EMPTY_SET;
        }
        this.initialized = true;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.initialize():initialized with:orgName=" + this.orgName + ",validDynamicAttrNames=" + this.validDynamicAttrNames);
        }
    }

    public List getPropertyNames() {
        return propertyNames;
    }

    public Syntax getPropertySyntax(String string) {
        if (string.equals(STATIC_ATTRIBUTE)) {
            return Syntax.ANY;
        }
        if (string.equals(DYNAMIC_ATTRIBUTE)) {
            return Syntax.MULTIPLE_CHOICE;
        }
        return Syntax.ANY;
    }

    public String getDisplayName(String string, Locale locale) throws PolicyException {
        return string;
    }

    public Set getValidValues(String string) throws PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "idrepo_response_provider_not_yet_initialized", null, null);
        }
        if (string.equals(DYNAMIC_ATTRIBUTE)) {
            return this.validDynamicAttrNames;
        }
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map map) throws PolicyException {
        Set set;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.setProperties():entering with properties=" + map);
        }
        if (map == null || map.isEmpty()) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        this.properties = map;
        if (!map.containsKey(STATIC_ATTRIBUTE) && !map.containsKey(DYNAMIC_ATTRIBUTE)) {
            Object[] objectArray = new String[]{STATIC_ATTRIBUTE, DYNAMIC_ATTRIBUTE};
            throw new PolicyException("amPolicy", "missing_required_property", objectArray, null);
        }
        Set set2 = (Set)map.get(STATIC_ATTRIBUTE);
        if (set2 != null) {
            this.validateStaticAttribute(set2);
        }
        if ((set = (Set)map.get(DYNAMIC_ATTRIBUTE)) != null) {
            this.validateDynamicAttribute(set);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.setProperties():returning");
        }
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public Map getResponseDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        HashMap hashMap;
        block12: {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("IDRepoResponseProvider.getResponseDecision():entering");
            }
            hashMap = new HashMap();
            if (this.staticResponse != null) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("IDRepoResponseProvider.getResponseDecision():adding staticResponse=" + this.staticResponse);
                }
                PolicyUtils.appendMapToMap(this.staticResponse, hashMap);
            }
            if (this.repoAttrNames != null && !this.repoAttrNames.isEmpty()) {
                HashMap hashMap2 = new HashMap();
                Map map2 = new HashMap();
                try {
                    if (sSOToken.getPrincipal() != null) {
                        AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken);
                        map2 = aMIdentity.getAttributes(this.repoAttrNames);
                        if (map2 != null) {
                            Iterator iterator = this.responseAttrNames.iterator();
                            while (iterator.hasNext()) {
                                String string = (String)iterator.next();
                                Set set = (Set)this.responseAttrToRepoAttr.get(string);
                                HashSet hashSet = new HashSet();
                                Iterator iterator2 = set.iterator();
                                while (iterator2.hasNext()) {
                                    String string2 = (String)iterator2.next();
                                    Set set2 = (Set)map2.get(string2);
                                    if (set2 == null) continue;
                                    hashSet.addAll(set2);
                                }
                                hashMap2.put(string, hashSet);
                            }
                        }
                        if (DEBUG.messageEnabled()) {
                            DEBUG.message("IDRepoResponseProvider.getResponseDecision():adding dynamicResponse=" + hashMap2);
                        }
                        PolicyUtils.appendMapToMap(hashMap2, hashMap);
                        break block12;
                    }
                    DEBUG.error("IDRepoResponseProvider:getResponseDecision(): Principal is null");
                    throw new PolicyException("amPolicy", "token_principal_null", null, null);
                }
                catch (IdRepoException idRepoException) {
                    DEBUG.error("IDRepoResponseProvider:getResponseDecision():IdRepoException", idRepoException);
                    throw new PolicyException(idRepoException);
                }
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.getResponseDecision():returning response=" + hashMap);
        }
        return hashMap;
    }

    private void validateStaticAttribute(Set set) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():entering with staticSet=" + set);
        }
        if (!set.isEmpty()) {
            this.staticResponse = new HashMap();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.indexOf(ATTR_DELIMITER) == -1) {
                    this.clearProperties();
                    DEBUG.error("IDRepoResponseProvider.validateStaticAttribute(): Invalid format in defining StaticAttribute, needs to be attr=value format");
                    Object[] objectArray = new String[]{string};
                    throw new PolicyException("amPolicy", "invalid_format_static_property", objectArray, null);
                }
                int n = string.indexOf(ATTR_DELIMITER);
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1);
                Set set2 = PolicyUtils.delimStringToSet(string3, VAL_DELIMITER);
                PolicyUtils.appendElementToMap(string2, set2, this.staticResponse);
                if (!DEBUG.messageEnabled()) continue;
                DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():attrName=" + string2 + ",values=" + set2);
                DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():caching staticResponse:" + this.staticResponse);
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateStaticAttribute():returning");
        }
    }

    private void validateDynamicAttribute(Set set) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():entering with dynamicSet=" + set);
        }
        this.responseAttrNames = new HashSet();
        this.repoAttrNames = new HashSet();
        this.responseAttrToRepoAttr = new HashMap();
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():valid dynamic attributes:" + this.validDynamicAttrNames);
        }
        Set set2 = (Set)this.properties.get(DYNAMIC_ATTRIBUTE);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():selected dynamic attributes:" + set2);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            String string = (String)iterator.next();
            if (!this.validDynamicAttrNames.contains(string)) {
                this.clearProperties();
                objectArray = new String[]{string};
                throw new PolicyException("amPolicy", "invalid_dynamic_property_being_set", objectArray, null);
            }
            objectArray = this.parseDynamicAttrName(string);
            String string2 = objectArray[0];
            String string3 = objectArray[1];
            this.responseAttrNames.add(string2);
            this.repoAttrNames.add(string3);
            this.addToResponseAttrToRepoAttrMap(string2, string3);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():responseAttrName=" + string2 + ", repoAttrName=" + string3);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():responseAttrToRepoAttr=" + this.responseAttrToRepoAttr);
            DEBUG.message("IDRepoResponseProvider.validateDynamicAttribute():returning");
        }
    }

    private String[] parseDynamicAttrName(String string) throws PolicyException {
        String[] stringArray = new String[2];
        if (string != null) {
            int n = string.indexOf(ATTR_DELIMITER);
            if (n == 0) {
                this.clearProperties();
                Object[] objectArray = new String[]{string};
                throw new PolicyException("amPolicy", "invalid_dynamic_property_being_set", objectArray, null);
            }
            if (n < 0) {
                String string2 = string.trim();
                if (string2.length() == 0) {
                    this.clearProperties();
                    Object[] objectArray = new String[]{string};
                    throw new PolicyException("amPolicy", "invalid_dynamic_property_being_set", objectArray, null);
                }
                stringArray[0] = string2;
                stringArray[1] = string2;
            } else {
                String string3 = string.substring(0, n).trim();
                String string4 = string.substring(n + 1).trim();
                if (string3.length() == 0 || string4.length() == 0) {
                    this.clearProperties();
                    Object[] objectArray = new String[]{string};
                    throw new PolicyException("amPolicy", "invalid_dynamic_property_being_set", objectArray, null);
                }
                stringArray[0] = string3;
                stringArray[1] = string4;
            }
        }
        return stringArray;
    }

    private void addToResponseAttrToRepoAttrMap(String string, String string2) throws PolicyException {
        HashSet<String> hashSet = (HashSet<String>)this.responseAttrToRepoAttr.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.responseAttrToRepoAttr.put(string, hashSet);
        }
        hashSet.add(string2);
    }

    private void clearProperties() {
        this.properties = null;
        this.staticResponse = null;
        this.responseAttrNames = null;
        this.repoAttrNames = null;
        this.responseAttrToRepoAttr = null;
    }

    public Object clone() {
        HashSet hashSet;
        Object k;
        Iterator iterator;
        IDRepoResponseProvider iDRepoResponseProvider = null;
        try {
            iDRepoResponseProvider = (IDRepoResponseProvider)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.validDynamicAttrNames != null) {
            iDRepoResponseProvider.validDynamicAttrNames = new HashSet();
            iDRepoResponseProvider.validDynamicAttrNames.addAll(this.validDynamicAttrNames);
        }
        if (this.properties != null) {
            iDRepoResponseProvider.properties = new HashMap();
            iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                hashSet = new HashSet();
                hashSet.addAll((Set)this.properties.get(k));
                iDRepoResponseProvider.properties.put(k, hashSet);
            }
        }
        if (this.staticResponse != null) {
            iDRepoResponseProvider.staticResponse = new HashMap();
            iterator = this.staticResponse.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                hashSet = new HashSet();
                hashSet.addAll((Set)this.staticResponse.get(k));
                iDRepoResponseProvider.staticResponse.put(k, hashSet);
            }
        }
        if (this.responseAttrNames != null) {
            iDRepoResponseProvider.responseAttrNames = new HashSet();
            iDRepoResponseProvider.responseAttrNames.addAll(this.responseAttrNames);
        }
        if (this.repoAttrNames != null) {
            iDRepoResponseProvider.repoAttrNames = new HashSet();
            iDRepoResponseProvider.repoAttrNames.addAll(this.repoAttrNames);
        }
        if (this.responseAttrToRepoAttr != null) {
            iDRepoResponseProvider.responseAttrToRepoAttr = new HashMap();
            iterator = this.responseAttrToRepoAttr.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                hashSet = new HashSet();
                hashSet.addAll((Set)this.responseAttrToRepoAttr.get(k));
                iDRepoResponseProvider.responseAttrToRepoAttr.put(k, hashSet);
            }
        }
        return iDRepoResponseProvider;
    }

    static {
        propertyNames.add(STATIC_ATTRIBUTE);
        propertyNames.add(DYNAMIC_ATTRIBUTE);
    }
}

