/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.policy.plugins.PrefixResourceName;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class PolicyProperties {
    private static final String SERVER_LOG = "com.sun.identity.agents.server.log.file.name";
    private static final String LOGGING_LEVEL = "com.sun.identity.agents.logging.level";
    private static final String CACHE_TTL = "com.sun.identity.agents.polling.interval";
    private static final int CACHE_TTL_DEFAULT = 3;
    private static final String NOTIFICATION_ENABLED = "com.sun.identity.agents.notification.enabled";
    private static final String NOTIFICATION_URL = "com.sun.identity.agents.notification.url";
    private static final String BOOLEAN_ACTION_VALUES = "com.sun.identity.policy.client.booleanActionValues";
    private static final String RESOURCE_COMPARATORS = "com.sun.identity.policy.client.resourceComparators";
    private static final String HEADER_ATTRIBUTES = "com.sun.identity.agents.header.attributes";
    private static final String CACHE_MODE = "com.sun.identity.policy.client.cacheMode";
    private static final String USE_PRE22_BOOLEAN_VALUES = "com.sun.identity.policy.client.usePre22BooleanValues";
    private static final String USE_PRE22_BOOLEAN_VALUES_DEFAULT = "true";
    private static final String PRE22_TRUE_VALUE_PROPERTY = "com.sun.identity.agents.true.value";
    private static final String PRE22_TRUE_VALUE_DEFAULT = "allow";
    private static final String PRE22_FALSE_VALUE = "deny";
    private static final String NOTIFICATION_ENABLED_DEFAULT = "false";
    private static final String COLON = ":";
    private static final String PIPE = "|";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    static final String ALLOW = "ALLOW";
    static final String DENY = "DENY";
    static final String BOTH = "BOTH";
    static final String DECISION = "DECISION";
    static final String NONE = "NONE";
    static final String SUBTREE = "subtree";
    static final String SELF = "self";
    private static final String STRICT_SUBTREE = "strict-subtree";
    private static final String CACHE_MODE_DEFAULT = "subtree";
    private Set responseAttributeNames = Collections.EMPTY_SET;
    private String appUserName;
    private String appPassword;
    private String logName;
    private String notificationURL;
    private int cacheTtl;
    private String cacheMode;
    private int cleanupInterval;
    private boolean notificationEnabledFlag = false;
    private Map resourceComparators = new HashMap(10);
    private Map booleanActionValues = new HashMap(10);
    private boolean usePre22BooleanValues = true;
    private String pre22TrueValue = "allow";
    private String pre22FalseValue = "deny";
    private ResourceName prefixResourceName = new PrefixResourceName();
    private static String logActions = "NONE";
    private static Debug debug = PolicyEvaluator.debug;
    private static String SECRET_MASK = "*********";

    PolicyProperties() throws PolicyException {
        Object object;
        String string;
        Object object2;
        String string2;
        String string3;
        this.logName = SystemProperties.get(SERVER_LOG);
        if (this.logName == null || this.logName.length() == 0) {
            throw new PolicyException("amPolicy", "no.log.filename", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties:logName=" + this.logName);
        }
        if ((string3 = SystemProperties.get(CACHE_TTL)) == null || string3.length() == 0) {
            throw new PolicyException("amPolicy", "invalid_cache_ttl", null, null);
        }
        try {
            this.cacheTtl = Integer.parseInt(string3);
            this.cleanupInterval = this.cacheTtl = this.cacheTtl * 60 * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException("amPolicy", "invalid_cache_ttl", null, numberFormatException);
        }
        if (this.cacheTtl <= 0) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyProperties():configured cacheTtl" + this.cacheTtl + " seconds too small");
                debug.warning("PolicyProperties():setting cacheTtl as3 minutes");
            }
            this.cleanupInterval = this.cacheTtl = 180000;
        } else if (debug.messageEnabled()) {
            debug.message("PolicyProperties:cacheTtl=" + this.cacheTtl / 60 / 1000 + "minutes");
        }
        String string4 = SystemProperties.get(NOTIFICATION_ENABLED);
        if ((string4 == null || string4.length() == 0) && debug.warningEnabled() && debug.warningEnabled()) {
            debug.warning("PolicyProperties:invalid value for poperty:com.sun.identity.agents.notification.enabled:defaulting to:false");
        }
        this.notificationEnabledFlag = Boolean.valueOf(string4);
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties:notificationEnabledFlag=" + this.notificationEnabledFlag);
        }
        if (this.notificationEnabledFlag) {
            this.notificationURL = SystemProperties.get(NOTIFICATION_URL);
            if (this.notificationURL == null || this.notificationURL.length() == 0) {
                throw new PolicyException("amPolicy", "invalid.notificationurl", null, null);
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyProperties:notificationURL=" + this.notificationURL);
            }
        }
        this.cacheMode = SystemProperties.get(CACHE_MODE);
        if (this.cacheMode == null || !this.cacheMode.equals("subtree") && !this.cacheMode.equals(SELF)) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyProperties.init():com.sun.identity.policy.client.cacheMode:not defined, or invalid, defaulting to:subtree");
            }
            this.cacheMode = "subtree";
        } else if (debug.messageEnabled()) {
            debug.message("PolicyProperties.init():cacheMode=" + this.cacheMode);
        }
        String string5 = SystemProperties.get(LOGGING_LEVEL);
        if (string5 == null || string5.length() == 0) {
            throw new PolicyException("amPolicy", "no.policy.logging.level", null, null);
        }
        if (string5 != null) {
            logActions = string5.equalsIgnoreCase(ALLOW) ? ALLOW : (string5.equalsIgnoreCase(DENY) ? DENY : (string5.equalsIgnoreCase(BOTH) ? BOTH : (string5.equalsIgnoreCase(DECISION) ? DECISION : NONE)));
            if (debug.messageEnabled()) {
                debug.message("PolicyProperties():property:" + logActions + "=logActions");
            }
        }
        if ((string2 = SystemProperties.get(BOOLEAN_ACTION_VALUES)) != null) {
            object2 = new StringTokenizer(string2, COLON);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                Object[] objectArray;
                string = ((StringTokenizer)object2).nextToken();
                object = new StringTokenizer(string, PIPE);
                int n = ((StringTokenizer)object).countTokens();
                if (n != 4) {
                    debug.error("PolicyProperties():booleanActionValues not well formed:" + string2);
                    objectArray = new Object[]{string};
                    throw new PolicyException("amPolicy", "invalid_boolean_action_values", objectArray, null);
                }
                objectArray = ((StringTokenizer)object).nextToken();
                String string6 = ((StringTokenizer)object).nextToken();
                String string7 = ((StringTokenizer)object).nextToken();
                String string8 = ((StringTokenizer)object).nextToken();
                this.setBooleanActionValues((String)objectArray, string6, string7, string8);
            }
        } else if (debug.warningEnabled()) {
            debug.warning("PolicyProperties():property:com.sun.identity.policy.client.booleanActionValues:not defined");
        }
        object2 = SystemProperties.get(USE_PRE22_BOOLEAN_VALUES, "true");
        this.usePre22BooleanValues = Boolean.valueOf((String)object2);
        if (debug.messageEnabled()) {
            debug.message("PolicyProperries:usePre22BooleanValues=" + this.usePre22BooleanValues);
        }
        if (this.usePre22BooleanValues) {
            this.pre22TrueValue = SystemProperties.get(PRE22_TRUE_VALUE_PROPERTY, PRE22_TRUE_VALUE_DEFAULT);
            if (debug.messageEnabled()) {
                debug.message("PolicyProperries:pre22TrueValue=" + this.pre22TrueValue);
                debug.message("PolicyProperries:pre22FalseValue=" + this.pre22FalseValue);
            }
        }
        if ((string = SystemProperties.get(RESOURCE_COMPARATORS)) != null) {
            object = new StringTokenizer(string, COLON);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string9 = ((StringTokenizer)object).nextToken();
                this.setResourceComparator(string9);
            }
        } else if (debug.warningEnabled()) {
            debug.warning("PolicyProperties():property:com.sun.identity.policy.client.resourceComparators:not defined");
        }
        object = SystemProperties.get(HEADER_ATTRIBUTES);
        if (object != null && ((String)object).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, PIPE);
            this.responseAttributeNames = new HashSet(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                this.responseAttributeNames.add(stringTokenizer.nextToken());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties():constructed");
        }
    }

    String getLogName() throws PolicyException {
        return this.logName;
    }

    String getLogActions() throws PolicyException {
        return logActions;
    }

    int getCacheTtl() throws PolicyException {
        return this.cacheTtl;
    }

    String getCacheMode() throws PolicyException {
        return this.cacheMode;
    }

    int getCleanupInterval() throws PolicyException {
        return this.cleanupInterval;
    }

    boolean notificationEnabled() {
        return this.notificationEnabledFlag;
    }

    String getNotificationURL() {
        return this.notificationURL;
    }

    String getTrueValue(String string, String string2) {
        String string3 = null;
        Map map = (Map)this.booleanActionValues.get(string);
        if (map != null) {
            String[] stringArray = (String[])map.get(string2);
            if (stringArray != null) {
                string3 = stringArray[0];
            }
        } else if (this.usePre22BooleanValues) {
            string3 = this.pre22TrueValue;
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties.getTrueValue():servcieName=" + string + ",actionName=" + string2 + " " + ":returning:" + string3);
        }
        return string3;
    }

    String getFalseValue(String string, String string2) {
        String string3 = null;
        Map map = (Map)this.booleanActionValues.get(string);
        if (map != null) {
            String[] stringArray = (String[])map.get(string2);
            if (stringArray != null) {
                string3 = stringArray[1];
            }
        } else if (this.usePre22BooleanValues) {
            string3 = this.pre22FalseValue;
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties.getFalseValue():servcieName=" + string + ",actionName=" + string2 + ":returning:" + string3);
        }
        return string3;
    }

    private Map getResourceComparators() {
        return this.resourceComparators;
    }

    ResourceName getResourceComparator(String string) {
        ResourceName resourceName = (ResourceName)this.resourceComparators.get(string);
        if (resourceName == null) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyProperties.getResourceComparator():ResourceName not configured for service:" + string + ":defaulting to PrefixResourceName");
            }
            resourceName = this.prefixResourceName;
        }
        return resourceName;
    }

    Set getResponseAttributeNames() {
        return this.responseAttributeNames;
    }

    private void setBooleanActionValues(String string, String string2, String string3, String string4) {
        String[] stringArray;
        HashMap<String, String[]> hashMap;
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties.setBooleanActionValues():servcieName=" + string + ",actionName=" + string2 + ",trueValue=" + string3 + ",falseValue=" + string4);
        }
        if ((hashMap = (HashMap<String, String[]>)this.booleanActionValues.get(string)) == null) {
            hashMap = new HashMap<String, String[]>(4);
            this.booleanActionValues.put(string, hashMap);
        }
        if ((stringArray = (String[])hashMap.get(string2)) == null) {
            stringArray = new String[2];
            hashMap.put(string2, stringArray);
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
    }

    void setResourceComparator(String string) throws PolicyException {
        String string2;
        ResourceName resourceName;
        block30: {
            if (debug.messageEnabled()) {
                debug.message("PolicyProperties.setResourceComparator():entering with str value=" + string);
            }
            resourceName = null;
            String[] stringArray = new String[5];
            string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n = 0;
            HashMap<String, String> hashMap = new HashMap<String, String>(4);
            StringTokenizer stringTokenizer = new StringTokenizer(string, PIPE);
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
                if (n > 4) break;
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = stringArray[n2].indexOf("=");
                String string7 = stringArray[n2].substring(0, n3);
                String string8 = stringArray[n2].substring(n3 + 1);
                if (string7 == null) {
                    debug.error("PolicyProperties.setResourceComparator():Resource comapartaor: name is null");
                } else if (string8 == null) {
                    debug.error("PolicyProperties.setResourceComparator():Resource comapartaor: value is null");
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("PolicyProperties.setResourceComparator():Attr Name= " + string7 + ":Attr Value=" + string8);
                    }
                    if (string7.equalsIgnoreCase("serviceType")) {
                        string2 = string8;
                    } else if (string7.equalsIgnoreCase("class")) {
                        hashMap.put("class", string3);
                        string3 = string8;
                    } else if (string7.equalsIgnoreCase("delimiter")) {
                        string4 = string8;
                        hashMap.put("delimiter", string4);
                    } else if (string7.equalsIgnoreCase("wildcard")) {
                        string5 = string8;
                        hashMap.put("wildcard", string5);
                    } else if (string7.equalsIgnoreCase("caseSensitive")) {
                        string6 = string8;
                        hashMap.put("caseSensitive", string6);
                    }
                }
                ++n2;
            }
            if (string2 == null) {
                debug.error("PolicyProperties().setResourceComparator():ResourceComparator definition not well formed" + string);
                Object[] objectArray = new Object[]{string};
                throw new PolicyException("amPolicy", "invalid_resource_comparator", objectArray, null);
            }
            try {
                block29: {
                    try {
                        if (string3 == null) break block29;
                        Class<?> clazz = Class.forName(string3);
                        resourceName = (ResourceName)clazz.newInstance();
                        resourceName.initialize(hashMap);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        debug.error("PolicyProperties.setResourceComparator():Illegal exception ", classNotFoundException);
                        Object var17_22 = null;
                        if (resourceName == null) {
                            debug.error("PolicyProperties.setResourceCompartor():invalid configuration:" + string + ":defaulting to PrefixResourceName");
                            resourceName = new PrefixResourceName();
                        }
                        break block30;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        debug.error("PolicyProperties.setResourceComparator():Illegal exception ", illegalAccessException);
                        Object var17_23 = null;
                        if (resourceName == null) {
                            debug.error("PolicyProperties.setResourceCompartor():invalid configuration:" + string + ":defaulting to PrefixResourceName");
                            resourceName = new PrefixResourceName();
                        }
                        break block30;
                    }
                    catch (InstantiationException instantiationException) {
                        debug.error("PolicyProperties.setResourceComparator():InstantiationException  exception ", instantiationException);
                        Object var17_24 = null;
                        if (resourceName == null) {
                            debug.error("PolicyProperties.setResourceCompartor():invalid configuration:" + string + ":defaulting to PrefixResourceName");
                            resourceName = new PrefixResourceName();
                        }
                    }
                }
                Object var17_21 = null;
                if (resourceName == null) {
                    debug.error("PolicyProperties.setResourceCompartor():invalid configuration:" + string + ":defaulting to PrefixResourceName");
                    resourceName = new PrefixResourceName();
                }
            }
            catch (Throwable throwable) {
                Object var17_25 = null;
                if (resourceName == null) {
                    debug.error("PolicyProperties.setResourceCompartor():invalid configuration:" + string + ":defaulting to PrefixResourceName");
                    resourceName = new PrefixResourceName();
                }
                throw throwable;
            }
        }
        this.resourceComparators.put(string2, resourceName);
    }
}

