/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.security.AppSSOTokenProvider;
import java.util.HashMap;
import java.util.Map;

public class PolicyEvaluatorFactory {
    static Debug debug = Debug.getInstance("amRemotePolicy");
    private static PolicyEvaluatorFactory factory;
    private Map evaluatorsCache = new HashMap(10);

    private PolicyEvaluatorFactory() {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluatorFactory():created singleton instance");
        }
    }

    public static synchronized PolicyEvaluatorFactory getInstance() {
        if (factory == null) {
            factory = new PolicyEvaluatorFactory();
        }
        return factory;
    }

    public PolicyEvaluator getPolicyEvaluator(String string) throws PolicyException, SSOException {
        return this.getPolicyEvaluator(string, null);
    }

    public synchronized PolicyEvaluator getPolicyEvaluator(String string, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        PolicyEvaluator policyEvaluator = null;
        if (string == null) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluatorFactory.getPolicyEvaluator():serviceName is null");
            }
            return null;
        }
        HashMap<AppSSOTokenProvider, PolicyEvaluator> hashMap = (HashMap<AppSSOTokenProvider, PolicyEvaluator>)this.evaluatorsCache.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<AppSSOTokenProvider, PolicyEvaluator>(5);
            this.evaluatorsCache.put(string, hashMap);
        }
        if ((policyEvaluator = (PolicyEvaluator)hashMap.get(appSSOTokenProvider)) == null) {
            if (debug.messageEnabled()) {
                debug.message("PolicyEvaluatorFactory.getPolicyEvaluator():serviceName=" + string + ":appSSOTokenProvider=" + appSSOTokenProvider + ":creating new PolicyEvaluator");
            }
            policyEvaluator = new PolicyEvaluator(string, appSSOTokenProvider);
            hashMap.put(appSSOTokenProvider, policyEvaluator);
        } else if (debug.messageEnabled()) {
            debug.message("PolicyEvaluatorFactory.getPolicyEvaluator():serviceName=" + string + ":appSSOTokenProvider=" + appSSOTokenProvider + ":returning PolicyEvaluator from cache");
        }
        return policyEvaluator;
    }
}

