/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Stats;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyDecisionCacheListener;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicySSOTokenListener;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ProtectedResource;
import com.sun.identity.policy.ResourceIndexManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.ServiceManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class PolicyEvaluator {
    public static final String ALL_RESOURCES = "---ALL_RESOURCES---";
    public static final String ADVICING_ORGANIZATION = "AdvicingOrganization";
    public static final String EMPTY_RESOURCE_NAME = "";
    public static final String SUN_AM_REQUESTED_RESOURCE = "sun.am.requestedResource";
    public static final String SUN_AM_REQUESTED_ACTIONS = "sun.am.requestedActions";
    private static final Debug DEBUG = PolicyManager.debug;
    private static final boolean USE_POLICY_CACHE = true;
    private static final boolean INCLUDE_SUPER_RESOURCE_POLCIES = true;
    private static final long DEFAULT_USER_NSROLE_CACHE_TTL = 600000L;
    private String orgName;
    private String serviceTypeName;
    private ServiceType serviceType;
    private PolicyCache policyCache;
    private PolicyManager policyManager;
    private ResourceManager resourceManager;
    private ResourceIndexManager resourceIndexManager;
    private HashMap booleanActionNameTrueValues;
    private HashMap booleanActionNameFalseValues;
    private Set actionNames;
    private Set orgNames = new HashSet();
    private Set serviceTypeNames = new HashSet();
    private PolicyDecisionCacheListener listener = null;
    private boolean continueEvaluationOnDenyDecision = false;
    static Map policyResultsCache = new HashMap();
    public static Map ssoListenerRegistry = Collections.synchronizedMap(new HashMap());
    private static Map policyListenerRegistry = Collections.synchronizedMap(new HashMap());
    static Map userNSRoleCache = Collections.synchronizedMap(new HashMap());
    private static long userNSRoleCacheTTL = 0L;
    public static SSOTokenListener ssoListener = new PolicySSOTokenListener();
    private static Map resourceNamesMap = new HashMap();
    private static final int RESOURCE_NAMES_CACHE_SIZE = 1000;
    static final String ORGANIZATION_NAME = "organizationName";
    static final String SERVICE_TYPE_NAME = "serviceTypeName";
    static Object lock = new Object();

    public PolicyEvaluator(String string) throws SSOException, NameNotFoundException, PolicyException {
        this(EMPTY_RESOURCE_NAME, string);
        Object object = lock;
        synchronized (object) {
            if (!policyListenerRegistry.containsKey(string)) {
                this.listener = new PolicyDecisionCacheListener(string);
                try {
                    PolicyCache.getInstance().addPolicyListener(this.listener);
                }
                catch (PolicyException policyException) {
                    DEBUG.error("PolicyEvaluator: registering policy decision cache listener failed");
                }
                policyListenerRegistry.put(string, this.listener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator: policy listener for service " + string + " added");
                }
            } else {
                this.listener = (PolicyDecisionCacheListener)policyListenerRegistry.get(string);
            }
        }
    }

    public PolicyEvaluator(String string, String string2) throws SSOException, PolicyException, NameNotFoundException {
        string = string == null || string.equals("/") || string.equals(EMPTY_RESOURCE_NAME) ? ServiceManager.getBaseDN() : DNMapper.orgNameToDN(string);
        this.orgName = string;
        this.serviceTypeName = string2;
        this.policyCache = PolicyCache.getInstance();
        ServiceTypeManager serviceTypeManager = ServiceTypeManager.getServiceTypeManager();
        this.serviceType = serviceTypeManager.getServiceType(string2);
        this.policyManager = this.policyCache.getPolicyManager(string);
        this.orgNames.add(this.policyManager.getOrganizationDN());
        this.serviceTypeNames.add(string2);
        this.resourceManager = this.policyManager.getResourceManager();
        this.resourceIndexManager = this.policyManager.getResourceIndexManager();
    }

    public boolean isAllowed(SSOToken sSOToken, String string, String string2) throws PolicyException, SSOException {
        return this.isAllowed(sSOToken, string, string2, new HashMap());
    }

    public boolean isAllowed(SSOToken sSOToken, String string, String string2, Map map) throws SSOException, PolicyException {
        Set set;
        ActionSchema actionSchema = this.serviceType.getActionSchema(string2);
        if (this.booleanActionNameFalseValues == null) {
            this.booleanActionNameFalseValues = new HashMap(10);
        }
        String string3 = null;
        string3 = (String)this.booleanActionNameFalseValues.get(string2);
        if (string3 == null) {
            string3 = actionSchema.getFalseValue();
            this.booleanActionNameFalseValues.put(string2, string3);
        }
        if (this.booleanActionNameTrueValues == null) {
            this.booleanActionNameTrueValues = new HashMap(10);
        }
        String string4 = null;
        string4 = (String)this.booleanActionNameTrueValues.get(string2);
        if (string4 == null) {
            string4 = actionSchema.getTrueValue();
            this.booleanActionNameTrueValues.put(string2, string4);
        }
        if (!AttributeSchema.Syntax.BOOLEAN.equals(actionSchema.getSyntax())) {
            Object[] objectArray = new String[]{string2};
            throw new PolicyException("amPolicy", "action_does_not_have_boolean_syntax", objectArray, null);
        }
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string2);
        PolicyDecision policyDecision = this.getPolicyDecision(sSOToken, string, hashSet, map);
        ActionDecision actionDecision = (ActionDecision)policyDecision.getActionDecisions().get(string2);
        if (actionDecision != null && (set = actionDecision.getValues()) != null) {
            if (set.contains(string3)) {
                bl = false;
            } else if (set.contains(string4)) {
                bl = true;
            }
        }
        return bl;
    }

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, Set set) throws PolicyException, SSOException {
        return this.getPolicyDecision(sSOToken, string, set, null);
    }

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, Set set, Map hashMap) throws SSOException, PolicyException {
        if (string == null || string == EMPTY_RESOURCE_NAME) {
            string = EMPTY_RESOURCE_NAME;
        }
        string = this.serviceType.canonicalize(string);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        if (set == null || set.isEmpty()) {
            set = this.serviceType.getActionNames();
        }
        HashSet hashSet2 = new HashSet();
        if (set != null) {
            hashSet2.addAll(set);
        }
        if (hashMap == null || hashMap.isEmpty()) {
            hashMap = new HashMap();
        }
        hashMap.put(SUN_AM_REQUESTED_RESOURCE, hashSet);
        hashMap.put(SUN_AM_REQUESTED_ACTIONS, hashSet2);
        return this.getPolicyDecision(sSOToken, string, set, hashMap, new HashSet());
    }

    private PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, Set set, Map map, Set set2) throws PolicyException, SSOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("Evaluating policies at org " + this.orgName);
        }
        if (set == null || set.isEmpty()) {
            set = this.serviceType.getActionNames();
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        Object object6 = null;
        Set set3 = null;
        HashSet<Object> hashSet2 = null;
        set3 = this.resourceIndexManager.getPolicyNames(this.serviceType, string, true);
        if (DEBUG.messageEnabled()) {
            object5 = sSOToken != null ? sSOToken.getPrincipal().getName() : EMPTY_RESOURCE_NAME;
            DEBUG.message("at PolicyEvaluator.getPolicyDecision()" + " principal, resource name, action names, policy names," + " orgName =" + (String)object5 + ",  " + string + ",  " + set + ",  " + set3 + ",  " + this.orgName);
        }
        object5 = set3.iterator();
        while (object5.hasNext()) {
            object4 = (String)object5.next();
            object3 = this.policyManager.getPolicy((String)object4, true);
            if (object3 != null && ((Policy)object3).isActive()) {
                object2 = ((Policy)object3).getPolicyDecision(sSOToken, this.serviceTypeName, string, hashSet, map);
                if (!((Policy)object3).isReferralPolicy() && ((PolicyDecision)object2).hasAdvices()) {
                    PolicyEvaluator.addAdvice((PolicyDecision)object2, ADVICING_ORGANIZATION, this.orgName);
                }
                if (PolicyUtils.logStatus && sSOToken != null && (object = ((PolicyDecision)object2).toString()) != null && !((String)object).equals(EMPTY_RESOURCE_NAME)) {
                    String[] stringArray = new String[]{object4, this.orgName, this.serviceTypeName, string, set.toString(), object};
                    PolicyUtils.logAccessMessage("POLICY_EVALUATION", stringArray, sSOToken);
                }
                if (object6 == null) {
                    object6 = object2;
                } else {
                    PolicyEvaluator.mergePolicyDecisions(this.serviceType, (PolicyDecision)object2, (PolicyDecision)object6);
                }
                if (!PolicyConfig.continueEvaluationOnDenyDecision()) {
                    hashSet.removeAll(PolicyEvaluator.getFinalizedActions(this.serviceType, (PolicyDecision)object6));
                }
                if (!hashSet.isEmpty()) continue;
                break;
            }
            if (hashSet2 == null) {
                hashSet2 = new HashSet<Object>();
            }
            hashSet2.add(object4);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("PolicyEvaluator.getProtectingPolicies():" + (String)object4 + " is inactive or non-existent");
        }
        if (hashSet2 != null) {
            set3.removeAll(hashSet2);
        }
        object4 = this.getOrgsToVisit(set3);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator.getPolicyDecision()" + " orgsToVist=" + object4.toString());
        }
        object4.removeAll(set2);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator.getPolicyDecision()" + " orgsToVist(after removing already visited orgs=" + object4.toString());
        }
        while (!object4.isEmpty() && !hashSet.isEmpty()) {
            object3 = (String)object4.iterator().next();
            object4.remove(object3);
            set2.add(object3);
            try {
                this.policyManager.verifyOrgName((String)object3);
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (!DEBUG.warningEnabled()) continue;
                DEBUG.warning("Organization does not exist - skipping referral to " + (String)object3);
                continue;
            }
            object2 = new PolicyEvaluator((String)object3, this.serviceTypeName);
            object = super.getPolicyDecision(sSOToken, string, set, map, set2);
            if (object6 == null) {
                object6 = object;
            } else {
                PolicyEvaluator.mergePolicyDecisions(this.serviceType, (PolicyDecision)object, (PolicyDecision)object6);
            }
            if (PolicyConfig.continueEvaluationOnDenyDecision()) continue;
            hashSet.removeAll(PolicyEvaluator.getFinalizedActions(this.serviceType, (PolicyDecision)object6));
        }
        if (object6 == null) {
            object6 = new PolicyDecision();
        }
        return object6;
    }

    public Set getProtectedResourcesIgnoreConditions(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (string == null || string == EMPTY_RESOURCE_NAME) {
            string = EMPTY_RESOURCE_NAME;
        }
        HashSet<ProtectedResource> hashSet = new HashSet<ProtectedResource>();
        Set set = null;
        if (string.equals(ALL_RESOURCES)) {
            set = this.resourceIndexManager.getTopLevelResourceNames(this.serviceType);
        } else {
            set = new HashSet<String>();
            set.add(string);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Set set2 = this.getResourceNames(sSOToken, string2, true);
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                Set set3 = this.getProtectingPolicies(sSOToken, string3);
                if (set3 == null || set3.isEmpty()) continue;
                boolean bl = true;
                Iterator iterator3 = set3.iterator();
                while (iterator3.hasNext()) {
                    Policy policy = (Policy)iterator3.next();
                    if (policy.isReferralPolicy()) continue;
                    bl = false;
                    break;
                }
                if (bl) continue;
                hashSet.add(new ProtectedResource(string3, set3));
            }
        }
        return hashSet;
    }

    Set getProtectingPolicies(SSOToken sSOToken, String string) throws PolicyException, SSOException {
        return this.getProtectingPolicies(sSOToken, string, new HashSet());
    }

    private Set getProtectingPolicies(SSOToken sSOToken, String string, Set set) throws PolicyException, SSOException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        HashSet<Object> hashSet = new HashSet<Object>();
        Set set2 = this.resourceIndexManager.getPolicyNames(this.serviceType, string, false);
        HashSet<String> hashSet2 = null;
        if (DEBUG.messageEnabled()) {
            iterator = sSOToken != null ? sSOToken.getPrincipal().getName() : EMPTY_RESOURCE_NAME;
            DEBUG.message("at PolicyEvaluator.getProtectingPolicies()" + " principal, resource name, policy names," + " orgName =" + (String)((Object)iterator) + ",  " + string + ",  " + set2 + ",  " + this.orgName);
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = this.policyManager.getPolicy((String)object4);
            if (object3 != null && ((Policy)object3).isActive()) {
                if (!((Policy)object3).isReferralPolicy()) {
                    if (!((Policy)object3).isApplicableToUser(sSOToken)) continue;
                    ((Policy)object3).setOrganizationName(this.orgName);
                    hashSet.add(object3);
                    continue;
                }
                ((Policy)object3).setOrganizationName(this.orgName);
                hashSet.add(object3);
                continue;
            }
            if (hashSet2 == null) {
                hashSet2 = new HashSet<String>();
            }
            hashSet2.add((String)object4);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("PolicyEvaluator.getProtectingPolicies():" + (String)object4 + " is inactive or non-existent");
        }
        if (hashSet2 != null) {
            set2.removeAll(hashSet2);
        }
        set2 = this.resourceIndexManager.getSuperResourcePolicyNames(this.serviceType, string);
        if (hashSet2 != null) {
            hashSet2.clear();
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = this.policyManager.getPolicy((String)object4);
            if (object3 != null && ((Policy)object3).isActive()) {
                if (!((Policy)object3).isReferralPolicy()) continue;
                ((Policy)object3).setOrganizationName(this.orgName);
                hashSet.add(object3);
                continue;
            }
            if (hashSet2 == null) {
                hashSet2 = new HashSet();
            }
            hashSet2.add((String)object4);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("PolicyEvaluator.getProtectingPolicies():" + (String)object4 + " is inactive or non-existent");
        }
        if (hashSet2 != null) {
            set2.removeAll(hashSet2);
        }
        object4 = this.getOrgsToVisit(set2);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator.getProtectingPolicies()" + " orgsToVist=" + object4.toString());
        }
        object4.removeAll(set);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator.getProtectingPolicies()" + " orgsToVist(after removing already visited orgs=" + object4.toString());
        }
        while (object4.size() != 0) {
            object3 = (String)object4.iterator().next();
            object4.remove(object3);
            set.add(object3);
            try {
                this.policyManager.verifyOrgName((String)object3);
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (!DEBUG.warningEnabled()) continue;
                DEBUG.warning("Organization does not exist - skipping referral to " + (String)object3);
                continue;
            }
            object2 = new PolicyEvaluator((String)object3, this.serviceTypeName);
            object = super.getProtectingPolicies(sSOToken, string, set);
            hashSet.addAll((Collection<Object>)object);
        }
        object3 = sSOToken != null ? sSOToken.getPrincipal().getName() : EMPTY_RESOURCE_NAME;
        object2 = null;
        object = null;
        if (PolicyManager.debug.messageEnabled() || PolicyUtils.logStatus) {
            object2 = new StringBuffer();
            stringArray = hashSet.iterator();
            while (stringArray.hasNext()) {
                Policy policy = (Policy)stringArray.next();
                ((StringBuffer)object2).append(policy.getOrganizationName()).append(":").append(policy.getName()).append(",");
            }
            object = ((StringBuffer)object2).toString();
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("Computed policies  protecting resource " + string + "for principal:" + (String)object3 + " " + (String)object);
        }
        if (PolicyUtils.logStatus && sSOToken != null) {
            stringArray = new String[]{object3, string, object};
            PolicyUtils.logAccessMessage("PROTECTED_RESOURCES", stringArray, sSOToken);
        }
        return hashSet;
    }

    public Set getResourceResults(SSOToken sSOToken, String string, String string2, Map map) throws SSOException, PolicyException {
        HashSet<ResourceResult> hashSet;
        if ("subtree".equals(string2)) {
            hashSet = this.getResourceResultTree(sSOToken, string, string2, map).getResourceResults();
        } else if ("strict-subtree".equals(string2) || "self".equals(string2)) {
            ResourceResult resourceResult = this.getResourceResultTree(sSOToken, string, string2, map);
            hashSet = new HashSet<ResourceResult>();
            hashSet.add(resourceResult);
        } else {
            DEBUG.error("PolicyEvaluator: invalid request scope: " + string2);
            Object[] objectArray = new String[]{string2};
            throw new PolicyException("amPolicy", "invalid_request_scope", objectArray, null);
        }
        return hashSet;
    }

    public ResourceResult getResourceResult(SSOToken sSOToken, String string, String string2, Map map) throws SSOException, PolicyException {
        if ("subtree".equals(string2) || "strict-subtree".equals(string2) || "self".equals(string2)) {
            if ("subtree".equals(string2)) {
                string2 = "strict-subtree";
            }
            return this.getResourceResultTree(sSOToken, string, string2, map);
        }
        DEBUG.error("PolicyEvaluator: invalid request scope: " + string2);
        Object[] objectArray = new String[]{string2};
        throw new PolicyException("amPolicy", "invalid_request_scope", objectArray, null);
    }

    private ResourceResult getResourceResultTree(SSOToken sSOToken, String string, String string2, Map map) throws PolicyException, SSOException {
        Object object;
        HashMap hashMap;
        Map<String, Object> map2;
        Object object2;
        String string3;
        String string4 = string3 = sSOToken != null ? sSOToken.getTokenID().toString() : EMPTY_RESOURCE_NAME;
        if (sSOToken == null) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("user sso token is null, forcing ResourceResult evaluation to self_scope");
            }
            string2 = "self";
        }
        Object object3 = null;
        if (string == null || string == EMPTY_RESOURCE_NAME) {
            string = EMPTY_RESOURCE_NAME;
        }
        string = this.serviceType.canonicalize(string);
        Map map3 = policyResultsCache;
        synchronized (map3) {
            object2 = (HashMap)policyResultsCache.get(this.serviceTypeName);
            if (object2 != null && (map2 = (HashMap)object2.get(string)) != null && (hashMap = (HashMap)map2.get(string3)) != null && (object3 = (ResourceResult)hashMap.get(string2)) != null) {
                long l = System.currentTimeMillis();
                long l2 = ((ResourceResult)object3).getTimeToLive();
                if (l2 > l) {
                    if (DEBUG.messageEnabled()) {
                        DEBUG.message("PolicyEvaluator.getResourceResult(): we get the result from the cache.\n" + ((ResourceResult)object3).toXML());
                    }
                    ResourceResult resourceResult = object3;
                    return resourceResult;
                }
            }
        }
        if (this.actionNames == null || this.actionNames.isEmpty()) {
            this.actionNames = this.serviceType.getActionNames();
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("PolicyEvaluator:computing policy decisions  for resource : " + string);
        }
        object2 = this.getPolicyDecision(sSOToken, string, this.actionNames, map);
        object3 = new ResourceResult(string, (PolicyDecision)object2);
        if ("subtree".equals(string2)) {
            map2 = new ResourceResult("-__viRTuAl-rOot--_", new PolicyDecision());
            ((ResourceResult)((Object)map2)).addResourceResult((ResourceResult)object3, this.serviceType);
            object3 = map2;
        }
        if ("subtree".equals(string2) || "strict-subtree".equals(string2)) {
            map2 = (Cache)resourceNamesMap.get(this.serviceTypeName);
            if (map2 == null) {
                map2 = new Cache(1000);
                resourceNamesMap.put(this.serviceTypeName, map2);
            }
            if ((hashMap = (Set)((Cache)map2).get(string)) == null) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("Computing subresources for:  " + string);
                }
                hashMap = this.getResourceNames(sSOToken, string, true);
                hashMap = PolicyEvaluator.removeDuplicateResourceNames((Set)((Object)hashMap), this.serviceType);
                hashMap = PolicyEvaluator.removeResourceName((Set)((Object)hashMap), this.serviceType, string);
                ((Cache)map2).put(string, hashMap);
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator:computing policy decisions  for subresources : " + hashMap);
            }
            Iterator iterator = hashMap.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!"subtree".equals(string2) && !this.serviceType.compare(string, (String)object, false).equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                PolicyDecision policyDecision = this.getPolicyDecision(sSOToken, (String)object, this.actionNames, map);
                ((ResourceResult)object3).addResourceResult(new ResourceResult((String)object, policyDecision), this.serviceType);
            }
        }
        if (object3 != null && !((ResourceResult)object3).hasAdvices()) {
            map2 = null;
            hashMap = null;
            HashMap hashMap2 = null;
            object = policyResultsCache;
            synchronized (object) {
                hashMap2 = (HashMap)policyResultsCache.get(this.serviceTypeName);
                if (hashMap2 != null) {
                    hashMap = (HashMap)hashMap2.get(string);
                    if (hashMap != null) {
                        map2 = (HashMap)hashMap.get(string3);
                        if (map2 == null) {
                            map2 = new HashMap();
                        }
                    } else {
                        hashMap = new HashMap();
                        map2 = new HashMap();
                    }
                } else {
                    hashMap2 = new HashMap();
                    hashMap = new HashMap();
                    map2 = new HashMap<String, Object>();
                }
                map2.put(string2, object3);
                hashMap.put(string3, map2);
                hashMap2.put(string, hashMap);
                policyResultsCache.put(this.serviceTypeName, hashMap2);
            }
            if (sSOToken != null && !ssoListenerRegistry.containsKey(string3)) {
                try {
                    sSOToken.addSSOTokenListener(ssoListener);
                }
                catch (SSOException sSOException) {
                    DEBUG.error("PolicyEvaluator:failed to add sso token listener");
                }
                ssoListenerRegistry.put(string3, ssoListener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator.getResourceResultTree(): sso listener added .\n");
                }
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator: we added the evaluation result to the cache");
            }
        }
        return object3;
    }

    public Set getResourceNames(SSOToken sSOToken, String string, boolean bl) throws PolicyException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.policyManager.getOrganizationDN());
        return this.getResourceNames(sSOToken, string, bl, hashSet);
    }

    public Set getResourceNames(SSOToken sSOToken, String string, boolean bl, Set set) throws PolicyException, SSOException {
        HashSet hashSet = new HashSet();
        Set set2 = null;
        HashSet<Object> hashSet2 = null;
        set2 = this.resourceIndexManager.getSubResourcePolicyNames(this.serviceType, string);
        set2.addAll(this.resourceIndexManager.getPolicyNames(this.serviceType, string, true));
        set2.addAll(this.resourceIndexManager.getWildSubResourcePolicyNames(this.serviceType, string));
        if (set2 != null && !set2.isEmpty()) {
            Object object;
            Object object2;
            Object object3;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = this.policyManager.getPolicy((String)object3, true);
                if (object2 != null && ((Policy)object2).isActive()) {
                    object = ((Policy)object2).getResourceNames(sSOToken, this.serviceTypeName, string, true);
                    if (object == null) continue;
                    hashSet.addAll(object);
                    continue;
                }
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<Object>();
                }
                hashSet2.add(object3);
                if (!DEBUG.messageEnabled()) continue;
                DEBUG.message("PolicyEvaluator.getProtectingPolicies():" + (String)object3 + " is inactive or non-existent");
            }
            if (hashSet2 != null) {
                set2.removeAll(hashSet2);
            }
            object3 = this.getOrgsToVisit(set2);
            object3.removeAll(set);
            while (object3.size() != 0) {
                object2 = (String)object3.iterator().next();
                object3.remove(object2);
                set.add(object2);
                try {
                    this.policyManager.verifyOrgName((String)object2);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    if (!DEBUG.warningEnabled()) continue;
                    DEBUG.warning("Organization does not exist - skipping referral to " + (String)object2);
                    continue;
                }
                object = new PolicyEvaluator((String)object2, this.serviceTypeName);
                hashSet.addAll(((PolicyEvaluator)object).getResourceNames(sSOToken, string, true, set));
            }
        }
        return hashSet;
    }

    public void addPolicyListener(PolicyListener policyListener) {
        this.policyCache.addPolicyListener(policyListener);
    }

    public void removePolicyListener(PolicyListener policyListener) {
        this.policyCache.removePolicyListener(policyListener);
    }

    static PolicyDecision mergePolicyDecisions(ServiceType serviceType, PolicyDecision policyDecision, PolicyDecision policyDecision2) {
        Object object;
        Map map = policyDecision.getActionDecisions();
        Map map2 = policyDecision2.getActionDecisions();
        HashSet hashSet = new HashSet();
        hashSet.addAll(map.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)map.get(object);
            policyDecision2.addActionDecision(actionDecision, serviceType);
        }
        object = new HashMap();
        PolicyUtils.appendMapToMap(policyDecision.getResponseAttributes(), (Map)object);
        PolicyUtils.appendMapToMap(policyDecision2.getResponseAttributes(), (Map)object);
        policyDecision2.setResponseAttributes((Map)object);
        return policyDecision2;
    }

    static Set getFinalizedActions(ServiceType serviceType, PolicyDecision policyDecision) {
        HashSet<String> hashSet = new HashSet<String>();
        Map map = policyDecision.getActionDecisions();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)map.get(string);
            Set set = actionDecision.getValues();
            if (set == null || set.isEmpty()) continue;
            try {
                ActionSchema actionSchema = serviceType.getActionSchema(string);
                if (!AttributeSchema.Syntax.BOOLEAN.equals(actionSchema.getSyntax()) || !set.contains(actionSchema.getFalseValue())) continue;
                hashSet.add(string);
            }
            catch (InvalidNameException invalidNameException) {
                DEBUG.error("can not find action schmea for action = " + string, invalidNameException);
            }
        }
        return hashSet;
    }

    private Set getOrgsToVisit(Set set) throws PolicyException, SSOException {
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Policy policy = this.policyManager.getPolicy(string, true);
            if (policy == null) continue;
            hashSet.addAll(policy.getReferredToOrganizations());
        }
        return hashSet;
    }

    private static Set removeDuplicateResourceNames(Set hashSet, ServiceType serviceType) {
        HashSet<String> hashSet2 = hashSet;
        if (hashSet != null && serviceType != null) {
            hashSet2 = new HashSet<String>(hashSet.size());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Iterator iterator2 = hashSet2.iterator();
                boolean bl = false;
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!serviceType.compare(string, string2, false).equals(ResourceMatch.EXACT_MATCH)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                hashSet2.add(string);
            }
        }
        return hashSet2;
    }

    private static Set removeResourceName(Set hashSet, ServiceType serviceType, String string) {
        HashSet hashSet2 = hashSet;
        if (hashSet != null && serviceType != null && string != null) {
            hashSet2 = new HashSet(hashSet.size());
            hashSet2.addAll(hashSet);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!serviceType.compare(string, string2, false).equals(ResourceMatch.EXACT_MATCH)) continue;
                hashSet2.remove(string2);
            }
        }
        return hashSet2;
    }

    static void policyChanged(String string, PolicyEvent policyEvent) {
        resourceNamesMap.remove(string);
        Cache cache = (Cache)resourceNamesMap.get(string);
        if (cache == null || cache.size() == 0) {
            return;
        }
        try {
            ServiceTypeManager serviceTypeManager = ServiceTypeManager.getServiceTypeManager();
            ServiceType serviceType = serviceTypeManager.getServiceType(string);
            HashSet<Object> hashSet = new HashSet<Object>();
            Cache cache2 = cache;
            synchronized (cache2) {
                Object object;
                Object object2;
                Enumeration enumeration = cache.keys();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    if (hashSet.contains(object2)) continue;
                    object = policyEvent.getResourceNames();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (serviceType.compare((String)object2, string2) == ResourceMatch.NO_MATCH) continue;
                        hashSet.add(object2);
                    }
                }
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    cache.remove(object);
                }
            }
        }
        catch (SSOException sSOException) {
            DEBUG.error("PolicyEvaluator.policyChanged:", sSOException);
        }
        catch (PolicyException policyException) {
            DEBUG.error("PolicyEvaluator.policyChanged:", policyException);
        }
    }

    private static void addAdvice(PolicyDecision policyDecision, String string, String string2) {
        if (policyDecision != null && policyDecision.hasAdvices()) {
            Map map = policyDecision.getActionDecisions();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ActionDecision actionDecision = (ActionDecision)map.get(string3);
                Map map2 = actionDecision.getAdvices();
                if (map2 == null || map2.isEmpty()) continue;
                HashSet<String> hashSet = (HashSet<String>)map2.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(string2);
                map2.put(string, hashSet);
            }
        }
    }

    PolicyDecision getPolicyDecisionIgnoreSubjects(String string, Set set, Map hashMap) throws PolicyException, SSOException {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        if (set == null || set.isEmpty()) {
            set = this.serviceType.getActionNames();
        }
        HashSet hashSet2 = new HashSet();
        if (set != null) {
            hashSet2.addAll(set);
        }
        if (hashMap == null || hashMap.isEmpty()) {
            hashMap = new HashMap();
        }
        hashMap.put(SUN_AM_REQUESTED_RESOURCE, hashSet);
        hashMap.put(SUN_AM_REQUESTED_ACTIONS, hashSet2);
        return this.getPolicyDecision(null, string, set, hashMap, new HashSet());
    }

    public static Set getUserNSRoleValues(SSOToken sSOToken) throws SSOException, PolicyException {
        Object object;
        Object[] objectArray;
        Object object2;
        if (userNSRoleCacheTTL == 0L) {
            object2 = userNSRoleCache;
            synchronized (object2) {
                objectArray = ServiceManager.getBaseDN();
                object = PolicyConfig.getPolicyConfig((String)objectArray);
                userNSRoleCacheTTL = PolicyConfig.getSubjectsResultTtl((Map)object);
                if (userNSRoleCacheTTL <= 0L) {
                    userNSRoleCacheTTL = 600000L;
                    if (DEBUG.warningEnabled()) {
                        DEBUG.warning("Invalid TTL got from configuration. Set TTL to default:" + userNSRoleCacheTTL);
                    }
                }
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("userNSRoleCacheTTL=" + userNSRoleCacheTTL);
                }
            }
        }
        if (sSOToken == null) {
            return null;
        }
        object2 = sSOToken.getTokenID().toString();
        objectArray = (Object[])userNSRoleCache.get(object2);
        if (objectArray != null) {
            long l;
            object = (Long)objectArray[0];
            long l2 = 0L;
            if (object != null) {
                l2 = (Long)object;
            }
            if (l2 > (l = System.currentTimeMillis())) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator.getUserNSRoleValues(): get the nsRole values from cache.\n");
                }
                return (HashSet)objectArray[1];
            }
        }
        try {
            Object[] objectArray2;
            object = new AMStoreConnection(sSOToken);
            AMUser aMUser = ((AMStoreConnection)object).getUser(sSOToken.getPrincipal().getName());
            if (aMUser == null || !aMUser.isActivated()) {
                return null;
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet hashSet2 = new HashSet();
            Set set = aMUser.getRoleDNs();
            Set set2 = aMUser.getFilteredRoleDNs();
            if (set != null) {
                hashSet2.addAll(set);
            }
            if (set2 != null) {
                hashSet2.addAll(set2);
            }
            if (!hashSet2.isEmpty()) {
                objectArray2 = hashSet2.iterator();
                while (objectArray2.hasNext()) {
                    String string = (String)objectArray2.next();
                    if (string == null) continue;
                    hashSet.add(new DN(string).toRFCString().toLowerCase());
                }
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator.getUserNSRoleValues(): added user nsRoles: " + hashSet);
            }
            objectArray2 = new Object[]{new Long(System.currentTimeMillis() + userNSRoleCacheTTL), hashSet};
            userNSRoleCache.put(object2, objectArray2);
            if (!ssoListenerRegistry.containsKey(object2)) {
                sSOToken.addSSOTokenListener(ssoListener);
                ssoListenerRegistry.put(object2, ssoListener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator.getUserNSRoleValues(): sso listener added .\n");
                }
            }
            return hashSet;
        }
        catch (AMException aMException) {
            throw new PolicyException(aMException);
        }
    }

    static void printStats(Stats stats) {
        int n = 0;
        Map map = policyResultsCache;
        synchronized (map) {
            n = policyResultsCache.size();
        }
        stats.record("PolicyEvaluator: Number of services in  resultsCache: " + n);
        stats.record("PolicyEvaluator: Number of token IDs in  sessionListernerRgistry:" + ssoListenerRegistry.size());
        stats.record("PolicyEvaluator: Number of serviceNames  in policyListenerRegistry: " + policyListenerRegistry.size());
        stats.record("PolicyEvaluator: Number of token IDs  in role cahce: " + userNSRoleCache.size());
        int n2 = 0;
        Map map2 = resourceNamesMap;
        synchronized (map2) {
            n2 = resourceNamesMap.size();
        }
        stats.record("PolicyEvaluator:Number of serviceNames in  resourceNames cache: " + resourceNamesMap.size());
    }
}

