/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.interfaces.ResourceName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PolicyDecisionCacheListener
implements PolicyListener {
    private static Map resultsCache = PolicyEvaluator.policyResultsCache;
    private static Debug debug = PolicyManager.debug;
    private static final String resourceWildcard = "*";
    private static final String resourceDelimiter = "/";
    private static final String resourceCase = "false";
    private ResourceName resourceNameUtil = null;
    private String serviceName = null;

    public PolicyDecisionCacheListener(String string) {
        this.serviceName = string;
        HashMap<String, String> hashMap = null;
        String string2 = null;
        try {
            hashMap = PolicyConfig.getResourceCompareConfig(string);
            if (hashMap != null) {
                string2 = (String)hashMap.get("class");
            } else {
                hashMap = new HashMap<String, String>();
                hashMap.put("delimiter", resourceDelimiter);
                hashMap.put("wildcard", resourceWildcard);
                hashMap.put("caseSensitive", resourceCase);
            }
            if (string2 != null) {
                Class<?> clazz = Class.forName(string2);
                this.resourceNameUtil = (ResourceName)clazz.newInstance();
                this.resourceNameUtil.initialize(hashMap);
            }
        }
        catch (Exception exception) {
            debug.error("PolicyDecisionCacheListener: failed to get a resource comparator", exception);
        }
    }

    public void setServiceTypeName(String string) {
        this.serviceName = string;
    }

    public String getServiceTypeName() {
        return this.serviceName;
    }

    public synchronized void policyChanged(PolicyEvent policyEvent) {
        HashMap hashMap;
        if (debug.messageEnabled()) {
            debug.message("PolicyDecisionCacheListener.policyChanged()");
        }
        if (policyEvent == null) {
            debug.error("PolicyDecisionCacheListener.policyChanged(): invalid policy event");
            return;
        }
        Set set = policyEvent.getResourceNames();
        if (debug.messageEnabled()) {
            debug.message("PolicyDecisionCacheListener.policyChanged(): resource names from the policy event :" + set.toString());
        }
        if (!resultsCache.isEmpty() && !set.isEmpty() && (hashMap = (HashMap)resultsCache.get(this.serviceName)) != null) {
            Set set2 = hashMap.keySet();
            Iterator iterator = set2.iterator();
            block0: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    ResourceMatch resourceMatch = this.resourceNameUtil.compare(string, string2, true);
                    if (resourceMatch.equals(ResourceMatch.NO_MATCH)) continue;
                    iterator.remove();
                    if (!debug.messageEnabled()) continue block0;
                    debug.message("PolicyDecisionCacheListener.policyChanged(): cache wiped out for " + string);
                    continue block0;
                }
            }
        }
    }
}

