/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.sm.AttributeSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyDecision {
    static final String POLICY_DECISION = "PolicyDecision";
    static final String RESPONSE_DECISIONS = "ResponseDecisions";
    static final String RESPONSE_ATTRIBUTES = "ResponseAttributes";
    Map actionDecisions = new HashMap();
    private Map responseDecisions;
    private Map responseAttributes;
    private long timeToLive = Long.MAX_VALUE;
    private boolean advicesAreSet = false;

    public Map getActionDecisions() {
        return this.actionDecisions;
    }

    void addActionDecision(ActionDecision actionDecision, ServiceType serviceType) {
        String string = actionDecision.getActionName();
        ActionDecision actionDecision2 = (ActionDecision)this.actionDecisions.get(string);
        if (actionDecision2 == null) {
            this.addActionDecision(actionDecision);
        } else {
            ActionSchema actionSchema = null;
            AttributeSchema.Syntax syntax = null;
            try {
                actionSchema = serviceType.getActionSchema(string);
                syntax = actionSchema.getSyntax();
            }
            catch (InvalidNameException invalidNameException) {
                PolicyManager.debug.error("can not find action schmea for action = " + string, invalidNameException);
            }
            if (!AttributeSchema.Syntax.BOOLEAN.equals(syntax)) {
                this.addActionDecision(actionDecision);
            } else {
                String string2 = actionSchema.getFalseValue();
                String string3 = actionSchema.getTrueValue();
                this.addActionDecision(actionDecision, string3, string2);
            }
        }
    }

    public void addActionDecision(ActionDecision actionDecision, String string, String string2) {
        String string3 = actionDecision.getActionName();
        ActionDecision actionDecision2 = (ActionDecision)this.actionDecisions.get(string3);
        if (actionDecision2 == null || string == null || string2 == null) {
            this.addActionDecision(actionDecision);
        } else {
            long l = actionDecision.getTimeToLive();
            long l2 = actionDecision2.getTimeToLive();
            Set set = actionDecision2.getValues();
            Set set2 = actionDecision.getValues();
            Map map = null;
            Map map2 = actionDecision2.getAdvices();
            Map map3 = actionDecision.getAdvices();
            map = PolicyUtils.addMapToMap(map2, map3);
            if (set != null && set.contains(string2)) {
                if (set2 != null && set2.contains(string2)) {
                    actionDecision2.setTimeToLive(Math.max(l, l2));
                }
            } else if (set != null && set.contains(string)) {
                if (set2 != null && set2.contains(string2)) {
                    this.actionDecisions.put(string3, actionDecision);
                } else if (actionDecision.getValues().contains(string)) {
                    actionDecision2.setTimeToLive(Math.max(l, l2));
                }
            } else {
                this.actionDecisions.put(string3, actionDecision);
            }
            ActionDecision actionDecision3 = (ActionDecision)this.actionDecisions.get(string3);
            actionDecision3.setAdvices(map);
            this.setTimeToLive();
        }
    }

    public void addActionDecision(ActionDecision actionDecision) {
        ActionDecision actionDecision2 = (ActionDecision)this.actionDecisions.get(actionDecision.getActionName());
        if (actionDecision2 == null) {
            this.actionDecisions.put(actionDecision.getActionName(), actionDecision);
        } else {
            Set set = actionDecision2.getValues();
            if (set == Collections.EMPTY_SET || set == null) {
                actionDecision2.setValues(actionDecision.getValues());
            } else {
                set.addAll(actionDecision.getValues());
            }
            if (actionDecision.getTimeToLive() < actionDecision2.getTimeToLive()) {
                actionDecision2.setTimeToLive(actionDecision.getTimeToLive());
            }
            PolicyUtils.appendMapToMap(actionDecision.getAdvices(), actionDecision2.getAdvices());
        }
        this.setTimeToLive();
    }

    public String toString() {
        Object object;
        String string;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.responseAttributes != null && this.responseAttributes != Collections.EMPTY_MAP) {
            iterator = this.responseAttributes.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                object = (Set)this.responseAttributes.get(string);
                stringBuffer.append(string + "=" + object + "\n");
            }
        }
        iterator = this.actionDecisions.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (ActionDecision)this.actionDecisions.get(string);
            Set set = ((ActionDecision)object).getValues();
            stringBuffer.append(string + "=" + set + "\n");
        }
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(POLICY_DECISION).append(">").append("\r\n");
        if (this.responseAttributes != null && this.responseAttributes != Collections.EMPTY_MAP) {
            stringBuffer.append("<").append(RESPONSE_ATTRIBUTES);
            stringBuffer.append(">").append("\r\n");
            stringBuffer.append(PolicyUtils.mapToXMLString(this.responseAttributes));
            stringBuffer.append("<").append("/").append(RESPONSE_ATTRIBUTES);
            stringBuffer.append(">").append("\r\n");
        }
        Iterator iterator = this.actionDecisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)this.actionDecisions.get(string);
            stringBuffer.append(actionDecision.toXML());
        }
        if (this.responseDecisions != null) {
            stringBuffer.append("<").append(RESPONSE_DECISIONS).append(">").append("\r\n");
            stringBuffer.append(PolicyUtils.mapToXMLString(this.responseDecisions));
            stringBuffer.append("</").append(RESPONSE_DECISIONS).append(">").append("\r\n");
        }
        stringBuffer.append("</").append(POLICY_DECISION).append(">");
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public static PolicyDecision parsePolicyDecision(Node node) throws PolicyException {
        Object object;
        Object object2;
        PolicyDecision policyDecision = new PolicyDecision();
        Set set = XMLUtils.getChildNodes(node, "ActionDecision");
        if (set == null) {
            PolicyManager.debug.error("parsePolicyDecision: Required element not found in policy decision node:ActionDecision");
            Object[] objectArray = new Object[]{"ActionDecision"};
            throw new PolicyException("amPolicy", "missing_element", objectArray, null);
        }
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            object2 = (Node)object3.next();
            object = ActionDecision.parseActionDecision((Node)object2);
            policyDecision.addActionDecision((ActionDecision)object);
        }
        object3 = XMLUtils.getChildNodes(node, RESPONSE_ATTRIBUTES);
        if (object3 != null && !object3.isEmpty()) {
            object2 = (Node)object3.iterator().next();
            object = PolicyUtils.parseAttributeValuePairs((Node)object2);
            policyDecision.setResponseAttributes((Map)object);
        }
        if ((object2 = XMLUtils.getChildNodes(node, RESPONSE_DECISIONS)) != null && !object2.isEmpty()) {
            object = (Node)object2.iterator().next();
            Map map = PolicyUtils.parseAttributeValuePairs((Node)object);
            policyDecision.setResponseDecisions(map);
        }
        return policyDecision;
    }

    public Map getResponseDecisions() {
        return this.responseDecisions;
    }

    public void setResponseDecisions(Map map) {
        this.responseDecisions = map;
    }

    public Map getResponseAttributes() {
        return this.responseAttributes;
    }

    public void setResponseAttributes(Map map) {
        this.responseAttributes = map;
    }

    public Object clone() {
        Object object;
        Iterator iterator;
        PolicyDecision policyDecision = new PolicyDecision();
        policyDecision.actionDecisions = new HashMap(this.actionDecisions.size());
        Iterator iterator2 = this.actionDecisions.keySet().iterator();
        while (iterator2.hasNext()) {
            iterator = (String)iterator2.next();
            object = (ActionDecision)this.actionDecisions.get(iterator);
            policyDecision.addActionDecision((ActionDecision)((ActionDecision)object).clone());
        }
        if (this.responseDecisions != null) {
            policyDecision.responseDecisions = new HashMap(this.responseDecisions.size());
            iterator = this.responseDecisions.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                policyDecision.responseDecisions.put(object, this.responseDecisions.get(object));
            }
        }
        if (this.responseAttributes != null) {
            policyDecision.responseAttributes = new HashMap(this.responseAttributes.size());
            iterator = this.responseAttributes.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                policyDecision.responseAttributes.put(object, this.responseAttributes.get(object));
            }
        }
        return policyDecision;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    private void setTimeToLive() {
        this.timeToLive = Long.MAX_VALUE;
        this.advicesAreSet = false;
        Iterator iterator = this.actionDecisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)this.actionDecisions.get(string);
            long l = actionDecision.getTimeToLive();
            if (l < this.timeToLive) {
                this.timeToLive = l;
            }
            boolean bl = this.advicesAreSet = this.advicesAreSet || actionDecision.getAdvices() != null && !actionDecision.getAdvices().isEmpty();
        }
    }

    void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    public boolean hasAdvices() {
        return this.advicesAreSet;
    }
}

