/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Stats;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyStatsListener;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

class PolicyCache
implements ServiceListener {
    public static final String POLICY_STATS = "amPolicyStats";
    static final Debug DEBUG = PolicyManager.debug;
    private static final String CACHE_KEY_DELIMITER = "/";
    private static final String POLICIES_COMPONENT = "/policies/";
    private static final String RESOURCES_COMPONENT = "/resources/";
    private static final String REALM_SUBJECTS_COMPONENT = "/realmsubjects";
    private static PolicyCache policyCache;
    private Map policies = Collections.synchronizedMap(new HashMap());
    private Map policyManagers = Collections.synchronizedMap(new HashMap());
    private Map policyListenersMap = Collections.synchronizedMap(new HashMap());
    private ServiceConfigManager scm;
    private SSOToken token;

    static synchronized PolicyCache getInstance() throws PolicyException {
        if (policyCache == null) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Creating singleton policy cache");
            }
            policyCache = new PolicyCache();
            try {
                PolicyCache.policyCache.token = ServiceTypeManager.getSSOToken();
                PolicyCache.policyCache.scm = new ServiceConfigManager("iPlanetAMPolicyService", PolicyCache.policyCache.token);
                PolicyCache.policyCache.scm.addListener(policyCache);
            }
            catch (SMSException sMSException) {
                DEBUG.error(ResBundleUtils.getString("can_not_create_policy_cache"), sMSException);
                throw new PolicyException("amPolicy", "can_not_create_policy_cache", null, sMSException);
            }
            catch (SSOException sSOException) {
                DEBUG.error(ResBundleUtils.getString("can_not_create_policy_cache"), sSOException);
                throw new PolicyException("amPolicy", "can_not_create_policy_cache", null, sSOException);
            }
            Stats stats = Stats.getInstance(POLICY_STATS);
            if (stats.isEnabled()) {
                PolicyStatsListener policyStatsListener = new PolicyStatsListener(stats);
                stats.addStatsListener(policyStatsListener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyCache.getInstance(): Registered PolicyStatsListener with  Stats service");
                }
            }
        }
        return policyCache;
    }

    private PolicyCache() {
    }

    Policy getPolicy(String string, String string2) {
        String string3 = this.buildCacheKey(string, string2);
        if (DEBUG.messageEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("at PolicyCache.getPolicy(orgName,policyName):");
            stringBuffer.append("orgName=").append(string).append(":").append("policyName=").append(string2).append("cacheKey=").append(string3);
            DEBUG.message(stringBuffer.toString());
        }
        return this.getPolicy(string3);
    }

    Policy getPolicy(String string) {
        Policy policy = null;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("PolicyCache:cacheKeys in cache:" + this.policies.keySet());
        }
        if (this.policies.containsKey(string)) {
            policy = (Policy)this.policies.get(string);
            if (DEBUG.messageEnabled() && policy == null) {
                DEBUG.message("PolicyCache:returning null policy from cache for key:" + string);
            }
        } else {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyCache:refreshing policy for cache key:" + string);
            }
            policy = this.refreshPolicy(string);
        }
        return policy;
    }

    Policy refreshPolicy(String string) {
        Object object;
        String[] stringArray = this.tokenizeCacheKey(string);
        Policy policy = null;
        String string2 = stringArray[5];
        String string3 = stringArray[1];
        if (DEBUG.messageEnabled()) {
            object = new StringBuffer(500);
            ((StringBuffer)object).append("at PolicyCache.refreshPolicy refreshing policy for - ").append("cacheKey=").append(string).append(":").append("policyName=").append(string3).append(":").append("orgName=").append(string2);
            DEBUG.message(((StringBuffer)object).toString());
        }
        try {
            object = this.getPolicyManager(string2);
            policy = ((PolicyManager)object).getPolicy(string3);
        }
        catch (PolicyException policyException) {
            Object[] objectArray = new String[]{string};
            DEBUG.error(ResBundleUtils.getString("can_not_refresh_policy_for_cachekey", objectArray), policyException);
        }
        catch (SSOException sSOException) {
            Object[] objectArray = new String[]{string};
            DEBUG.error(ResBundleUtils.getString("can_not_refresh_policy_for_cachekey", objectArray), sSOException);
        }
        if (policy == null) {
            DEBUG.error("refreshed policy is null for cache key : " + string);
        } else {
            this.policies.put(string, policy);
            policy.initializeEvaluationWeights();
        }
        return policy;
    }

    void addPolicyListener(PolicyListener policyListener) {
        String string = policyListener.getServiceTypeName();
        HashSet<PolicyListener> hashSet = new HashSet<PolicyListener>();
        hashSet.add(policyListener);
        Set set = (Set)this.policyListenersMap.get(string);
        if (set != null) {
            hashSet.addAll(set);
        }
        this.policyListenersMap.put(string, hashSet);
    }

    void removePolicyListener(PolicyListener policyListener) {
        String string = policyListener.getServiceTypeName();
        Set set = (Set)this.policyListenersMap.get(string);
        if (set != null) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(set);
            hashSet.remove(policyListener);
            this.policyListenersMap.put(string, hashSet);
        }
    }

    public void schemaChanged(String string, String string2) {
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        Object object;
        Object object2;
        Object object3;
        if (DEBUG.messageEnabled()) {
            object3 = new StringBuffer(255);
            ((StringBuffer)object3).append("Received SMS notification, orgConfigChanged");
            ((StringBuffer)object3).append("serviceName, version, orgName, groupName, ");
            ((StringBuffer)object3).append(" serviceComponent, changeType:");
            ((StringBuffer)object3).append(string).append(":").append(string2).append(":");
            ((StringBuffer)object3).append(string3).append(":").append(string4).append(":");
            ((StringBuffer)object3).append(string5).append(":").append(n);
            DEBUG.message(((StringBuffer)object3).toString());
        }
        object3 = null;
        Policy policy = null;
        if (string5.startsWith(POLICIES_COMPONENT)) {
            object2 = this.buildCacheKey(string, string2, string3, string4, string5);
            if (n == 1) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- policy added -Refreshing policy for cacheKey=" + (String)object2);
                }
                policy = this.refreshPolicy((String)object2);
            } else if (n == 2) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- policy removed - cacheKey=" + (String)object2);
                }
                object3 = (Policy)this.policies.get(object2);
                this.policies.put(object2, null);
            } else if (n == 4) {
                object3 = (Policy)this.policies.get(object2);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- policy modified -Refreshing policy for cacheKey=" + (String)object2);
                }
                policy = this.refreshPolicy((String)object2);
            } else {
                DEBUG.error("SMS Notification- unsupported change type : " + n);
            }
            object = this.policyListenersMap.keySet().iterator();
            while (object.hasNext()) {
                String string6 = (String)object.next();
                HashSet hashSet = new HashSet();
                try {
                    if (object3 != null) {
                        hashSet.addAll(((Policy)object3).getResourceNames(string6));
                    }
                    if (policy != null) {
                        hashSet.addAll(policy.getResourceNames(string6));
                    }
                }
                catch (SSOException sSOException) {
                    DEBUG.error(ResBundleUtils.getString("invalid_sso_token"), sSOException);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    Object[] objectArray = new String[]{string6};
                    DEBUG.error(ResBundleUtils.getString("service_name_not_found", objectArray), nameNotFoundException);
                }
                if (hashSet.isEmpty()) continue;
                this.firePolicyChanged(string6, hashSet, n);
            }
        }
        if (string5.startsWith(RESOURCES_COMPONENT)) {
            try {
                object2 = this.getPolicyManager(string3);
                object = string5.substring("/resources".length() + 1);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- resource index modified-clearing index for resource type " + (String)object);
                }
                ((PolicyManager)object2).getResourceIndexManager().clearResourceIndex((String)object);
            }
            catch (PolicyException policyException) {
                DEBUG.error("error while clearing resource index ", policyException);
            }
            catch (SSOException sSOException) {
                DEBUG.error(ResBundleUtils.getString("invalid_sso_token"), sSOException);
            }
        }
        if (string5.startsWith(REALM_SUBJECTS_COMPONENT)) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("SMS Notification- realm subjects modified - resetting realm subjects for orgName:" + string3);
            }
            this.realmSubjectsChanged(string3);
        }
    }

    private String buildCacheKey(String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string5).append(CACHE_KEY_DELIMITER);
        stringBuffer.append(string4).append(CACHE_KEY_DELIMITER);
        stringBuffer.append(string2).append(CACHE_KEY_DELIMITER);
        stringBuffer.append(string).append(CACHE_KEY_DELIMITER);
        stringBuffer.append(string3);
        return stringBuffer.toString().toLowerCase();
    }

    private String buildCacheKey(String string, String string2) {
        String string3 = "/Policies/" + string2;
        return this.buildCacheKey("iPlanetAMPolicyService", "1.0", string, "default", string3);
    }

    private String[] tokenizeCacheKey(String string) {
        String[] stringArray = new String[6];
        StringTokenizer stringTokenizer = new StringTokenizer(string, CACHE_KEY_DELIMITER);
        stringArray[0] = stringTokenizer.nextToken();
        stringArray[1] = stringTokenizer.nextToken();
        stringArray[2] = stringTokenizer.nextToken();
        stringArray[3] = stringTokenizer.nextToken();
        stringArray[4] = stringTokenizer.nextToken();
        stringArray[5] = stringTokenizer.nextToken();
        return stringArray;
    }

    private void firePolicyChanged(String string, Set set, int n) {
        Object object;
        if (DEBUG.messageEnabled()) {
            object = new StringBuffer(255);
            ((StringBuffer)object).append("at firePolicyChanged(serrviceName,affectedResourceNames):");
            ((StringBuffer)object).append(string).append(":");
            ((StringBuffer)object).append(set.toString());
            DEBUG.message(((StringBuffer)object).toString());
        }
        object = new PolicyEvent();
        ((PolicyEvent)object).setResourceNames(set);
        ((PolicyEvent)object).setChangeType(n);
        Set set2 = (Set)this.policyListenersMap.get(string);
        if (set2 != null) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                PolicyListener policyListener = (PolicyListener)iterator.next();
                try {
                    policyListener.policyChanged((PolicyEvent)object);
                }
                catch (Exception exception) {
                    DEBUG.error("policy change not handled properly", exception);
                }
            }
        }
        PolicyEvaluator.policyChanged(string, (PolicyEvent)object);
    }

    PolicyManager getPolicyManager(String string) throws PolicyException, SSOException {
        PolicyManager policyManager = (PolicyManager)this.policyManagers.get(string = new DN(string).toRFCString().toLowerCase());
        if (policyManager == null) {
            policyManager = new PolicyManager(this.token, string);
            this.policyManagers.put(string, policyManager);
            if (DEBUG.messageEnabled()) {
                StringBuffer stringBuffer = new StringBuffer(255);
                stringBuffer.append("at PolicyCache.getPolicyManager():");
                stringBuffer.append("creating and caching pm for orgname ");
                stringBuffer.append(string);
                DEBUG.message(stringBuffer.toString());
            }
        }
        return policyManager;
    }

    void policyConfigChanged(String string) {
        block12: {
            Object object;
            String string2 = CACHE_KEY_DELIMITER + string;
            if (DEBUG.messageEnabled()) {
                object = new StringBuffer(255);
                ((StringBuffer)object).append("at PolicyCache.policyConfigChanged():");
                ((StringBuffer)object).append("updating policy config for orgname ");
                ((StringBuffer)object).append(string);
                DEBUG.message(((StringBuffer)object).toString());
            }
            try {
                int n;
                object = this.getPolicyManager(string);
                Map map = ((PolicyManager)object).getPolicyConfig();
                if (map == null || map.isEmpty()) break block12;
                Set set = this.policies.keySet();
                String[] stringArray = new String[]{};
                Map map2 = this.policies;
                synchronized (map2) {
                    stringArray = new String[set.size()];
                    n = 0;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        stringArray[n] = (String)iterator.next();
                        ++n;
                    }
                }
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Policy policy;
                    String string3 = stringArray[n2];
                    if (string3.endsWith(string2) && (policy = policyCache.getPolicy(string3)) != null) {
                        policy.getSubjects().setPolicyConfig(map);
                    }
                    ++n2;
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (DEBUG.warningEnabled()) {
                    DEBUG.warning("Can not set policy config for orgname:" + string + ":" + nameNotFoundException.getMessage());
                }
            }
            catch (PolicyException policyException) {
                DEBUG.error("Can not set policy config for orgname:" + string, policyException);
            }
            catch (SSOException sSOException) {
                DEBUG.error("Can not set policy config for orgname:" + string, sSOException);
            }
        }
    }

    void realmSubjectsChanged(String string) {
        DEBUG.message("resetting realm subjects");
        try {
            SubjectTypeManager subjectTypeManager;
            PolicyManager policyManager = this.getPolicyManager(string);
            SubjectTypeManager subjectTypeManager2 = subjectTypeManager = policyManager.getSubjectTypeManager();
            synchronized (subjectTypeManager2) {
                subjectTypeManager.resetRealmSubjects();
            }
        }
        catch (PolicyException policyException) {
            DEBUG.error("Can not reset realmSubjects for orgname:" + string, policyException);
        }
        catch (SSOException sSOException) {
            DEBUG.error("Can not reset realmSubjects for orgname:" + string, sSOException);
        }
    }

    static void printStats(Stats stats) {
        stats.record("PolicyCache: Number of policies in cache: " + PolicyCache.policyCache.policies.size());
        stats.record("PolicyCache: Number of policyManagers in cache:" + PolicyCache.policyCache.policyManagers.size());
        stats.record("PolicyCache: Number of service names in  policyListeners cache: " + PolicyCache.policyCache.policyListenersMap.size());
    }
}

