/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.Conditions;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Referrals;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResponseProviders;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Subjects;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.sm.AttributeSchema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;
import org.w3c.dom.Node;

public class Policy
implements Cloneable {
    static final String REFERRAL_POLICY = "referralPolicy";
    static final String ACTIVE_FLAG = "active";
    private static final int SUBJECTS_CONDITIONS_RULES = 1;
    private static final int CONDITIONS_SUBJECTS_RULES = 2;
    private static final int RULES_SUBJECTS_CONDITIONS = 3;
    private static final int RULES_CONDITIONS_SUBJECTS = 4;
    private static final int SUBJECTS_RULES_CONDITIONS = 5;
    private static final int CONDITIONS_RULES_SUBJECTS = 6;
    private static String EVALUATION_WEIGHTS = null;
    private static String DEFAULT_EVALUATION_WEIGHTS = "10:10:10";
    private static final String EVALUATION_WEIGHTS_KEY = "com.sun.identity.policy.Policy.policy_evaluation_weights";
    private static final Debug DEBUG = PolicyManager.debug;
    private int evaluationOrder = 3;
    private static int ruleWeight;
    private static int conditionWeight;
    private static int subjectWeight;
    private int prWeight;
    private int pcWeight;
    private int psWeight;
    private String origPolicyName;
    private String policyName;
    private String description = "";
    private boolean referralPolicy = false;
    private boolean active = true;
    private int priority;
    private Map rules = new HashMap();
    private Subjects users = new Subjects();
    private Conditions conditions = new Conditions();
    private ResponseProviders respProviders = new ResponseProviders();
    private Referrals referrals = new Referrals();
    private String organizationName;
    private static final int MATCHED_RULE_RESULTS_CACHE_SIZE = 1000;
    private static final int MATCHED_REFERRAL_RULES_CACHE_SIZE = 100;
    private Cache matchRulesResultsCache = new Cache(1000);
    private Cache matchReferralRulesCache = new Cache(100);
    private String subjectRealm;

    private Policy() {
    }

    public Policy(String string) throws InvalidNameException {
        this(string, null);
    }

    private Policy(String string, int n) throws InvalidNameException {
        this.validateName(string);
        this.policyName = string;
        this.priority = n;
    }

    public Policy(String string, String string2) throws InvalidNameException {
        this(string, string2, false, true);
    }

    public Policy(String string, String string2, boolean bl) throws InvalidNameException {
        this(string, string2, bl, true);
    }

    public Policy(String string, String string2, boolean bl, boolean bl2) throws InvalidNameException {
        this.validateName(string);
        this.policyName = string;
        if (string2 != null) {
            this.description = string2;
        }
        this.referralPolicy = bl;
        this.active = bl2;
    }

    public Policy(PolicyManager policyManager, Node node) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        Object object;
        Node node2;
        Object object2;
        Set set;
        String string;
        String string2;
        if (!node.getNodeName().equalsIgnoreCase("Policy")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid policy xml blob given to construct policy");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_policy_root_node", null, "", 1);
        }
        this.policyName = XMLUtils.getNodeAttributeValue(node, "name");
        this.validateName(this.policyName);
        this.description = XMLUtils.getNodeAttributeValue(node, "description");
        String string3 = XMLUtils.getNodeAttributeValue(node, REFERRAL_POLICY);
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            this.referralPolicy = true;
        }
        if ((string2 = XMLUtils.getNodeAttributeValue(node, ACTIVE_FLAG)) != null && string2.equalsIgnoreCase("false")) {
            this.active = false;
        }
        if ((string = XMLUtils.getNodeAttributeValue(node, "priority")) != null) {
            try {
                this.priority = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                PolicyManager.debug.error("Number format exception in determining policy's priority: " + string, numberFormatException);
            }
        }
        if ((set = XMLUtils.getChildNodes(node, "Rule")) != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                node2 = (Node)object2.next();
                object = new Rule(node2);
                this.rules.put(((Rule)object).getName(), object);
            }
        }
        if (!this.referralPolicy) {
            object2 = XMLUtils.getChildNode(node, "Subjects");
            if (object2 != null) {
                this.users = new Subjects(policyManager, (Node)object2);
            }
            if ((node2 = XMLUtils.getChildNode(node, "Conditions")) != null) {
                this.conditions = new Conditions(policyManager.getConditionTypeManager(), node2);
            }
            if ((object = XMLUtils.getChildNode(node, "ResponseProviders")) != null) {
                this.respProviders = new ResponseProviders(policyManager.getResponseProviderTypeManager(), (Node)object);
            }
        } else {
            object2 = XMLUtils.getChildNode(node, "Referrals");
            if (object2 != null) {
                this.referrals = new Referrals(policyManager, (Node)object2);
            }
        }
    }

    public String getName() {
        return this.policyName;
    }

    public void setName(String string) throws InvalidNameException {
        this.validateName(string);
        if (this.policyName.equals(string)) {
            return;
        }
        if (this.origPolicyName == null) {
            this.origPolicyName = this.policyName;
        }
        this.policyName = string;
    }

    protected String getOriginalName() {
        return this.origPolicyName;
    }

    void setOrganizationName(String string) {
        this.organizationName = string;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    protected void resetOriginalName() {
        this.origPolicyName = null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws InvalidNameException {
        if (string != null) {
            this.description = string;
        }
    }

    public boolean isReferralPolicy() {
        return this.referralPolicy;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public Set getRuleNames() {
        return new HashSet(this.rules.keySet());
    }

    public Rule getRule(String string) throws NameNotFoundException {
        Rule rule = (Rule)this.rules.get(string);
        if (rule == null) {
            throw new NameNotFoundException("amPolicy", "rule_not_found", null, string, 2);
        }
        return rule;
    }

    public void addRule(Rule rule) throws NameAlreadyExistsException, InvalidNameException {
        if (rule.getName() == null) {
            rule.setName("rule" + ServiceTypeManager.generateRandomName());
        }
        if (this.rules.containsKey(rule.getName())) {
            throw new NameAlreadyExistsException("amPolicy", "rule_name_already_present", null, rule.getName(), 2);
        }
        if (this.rules.containsValue(rule)) {
            throw new NameAlreadyExistsException("amPolicy", "rule_already_present", null, rule.getName(), 2);
        }
        this.rules.put(rule.getName(), rule);
    }

    public void replaceRule(Rule rule) throws InvalidNameException {
        if (rule.getName() == null) {
            rule.setName("rule" + ServiceTypeManager.generateRandomName());
        }
        this.rules.put(rule.getName(), rule);
    }

    public Rule removeRule(String string) {
        return (Rule)this.rules.remove(string);
    }

    Subjects getSubjects() {
        return this.users;
    }

    public Set getSubjectNames() {
        return this.users.getSubjectNames();
    }

    public Subject getSubject(String string) throws NameNotFoundException {
        return this.users.getSubject(string);
    }

    public void addSubject(String string, Subject subject) throws NameAlreadyExistsException, InvalidNameException {
        this.users.addSubject(string, subject, false);
    }

    public void addRealmSubject(SSOToken sSOToken, String string, String string2, boolean bl) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        PolicyManager policyManager = new PolicyManager(sSOToken, string2);
        SubjectTypeManager subjectTypeManager = policyManager.getSubjectTypeManager();
        this.addRealmSubject(string, subjectTypeManager, bl);
    }

    public void addRealmSubject(String string, SubjectTypeManager subjectTypeManager, boolean bl) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        String string2 = subjectTypeManager.getPolicyManager().getOrganizationDN();
        string2 = new DN(string2).toRFCString().toLowerCase();
        if (this.subjectRealm != null && !this.subjectRealm.equals(string2)) {
            Object[] objectArray = new String[]{string2, this.subjectRealm};
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Policy.addRealmSubject():can not  realm subject " + string + " , from realm : " + string2 + " , policy already has subject from different realm:" + this.subjectRealm);
            }
            throw new InvalidNameException("amPolicy", "policy_realms_do_not_match", objectArray, null, string2, 1);
        }
        if (this.subjectRealm == null) {
            this.subjectRealm = string2;
        }
        Object var5_6 = null;
        subjectTypeManager.getSubjectByName(string);
        this.users.addSubject(string, subjectTypeManager.getSharedSubject(string), bl);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("Policy.addRealmSubject():added  realm subject " + string + " , from realm : " + string2);
        }
    }

    public void addSubject(String string, Subject subject, boolean bl) throws NameAlreadyExistsException, InvalidNameException {
        this.users.addSubject(string, subject, bl);
    }

    public void replaceSubject(String string, Subject subject) throws NameNotFoundException {
        this.users.replaceSubject(string, subject, false);
    }

    public void replaceSubject(String string, Subject subject, boolean bl) throws NameNotFoundException {
        this.users.replaceSubject(string, subject, bl);
    }

    public Subject removeSubject(String string) {
        return this.users.removeSubject(string);
    }

    public void removeSubject(Subject subject) {
        String string = this.users.getSubjectName(subject);
        if (string != null) {
            this.removeSubject(string);
        }
    }

    public boolean isSubjectExclusive(String string) throws NameNotFoundException {
        return this.users.isSubjectExclusive(string);
    }

    public boolean isRealmSubject(String string) throws NameNotFoundException {
        return this.users.isRealmSubject(string);
    }

    Referrals getReferrals() {
        return this.referrals;
    }

    public Set getReferralNames() {
        return this.referrals.getReferralNames();
    }

    public Referral getReferral(String string) throws NameNotFoundException {
        return this.referrals.getReferral(string);
    }

    public void addReferral(String string, Referral referral) throws NameAlreadyExistsException, InvalidNameException {
        this.referrals.addReferral(string, referral);
    }

    public void replaceReferral(String string, Referral referral) throws NameNotFoundException {
        this.referrals.replaceReferral(string, referral);
    }

    public Referral removeReferral(String string) {
        return this.referrals.removeReferral(string);
    }

    public void removeReferral(Referral referral) {
        String string = this.referrals.getReferralName(referral);
        if (string != null) {
            this.removeReferral(string);
        }
    }

    Conditions getConditions() {
        return this.conditions;
    }

    public Set getConditionNames() {
        return this.conditions.getConditionNames();
    }

    public Condition getCondition(String string) throws NameNotFoundException {
        return this.conditions.getCondition(string);
    }

    public void addCondition(String string, Condition condition) throws NameAlreadyExistsException, InvalidNameException {
        this.conditions.addCondition(string, condition);
    }

    public void replaceCondition(String string, Condition condition) throws NameNotFoundException {
        this.conditions.replaceCondition(string, condition);
    }

    public Condition removeCondition(String string) {
        return this.conditions.removeCondition(string);
    }

    public void removeCondition(Condition condition) {
        String string = this.conditions.getConditionName(condition);
        if (string != null) {
            this.removeCondition(string);
        }
    }

    ResponseProviders getResponseProviders() {
        return this.respProviders;
    }

    public Set getResponseProviderNames() {
        return this.respProviders.getResponseProviderNames();
    }

    public ResponseProvider getResponseProvider(String string) throws NameNotFoundException {
        return this.respProviders.getResponseProvider(string);
    }

    public void addResponseProvider(String string, ResponseProvider responseProvider) throws NameAlreadyExistsException {
        this.respProviders.addResponseProvider(string, responseProvider);
    }

    public void replaceResponseProvider(String string, ResponseProvider responseProvider) throws NameNotFoundException {
        this.respProviders.replaceResponseProvider(string, responseProvider);
    }

    public ResponseProvider removeResponseProvider(String string) {
        return this.respProviders.removeResponseProvider(string);
    }

    public void removeResponseProvider(ResponseProvider responseProvider) {
        String string = this.respProviders.getResponseProviderName(responseProvider);
        if (string != null) {
            this.removeResponseProvider(string);
        }
    }

    public void store(SSOToken sSOToken, String string) throws SSOException, NoPermissionException, NameAlreadyExistsException, NameNotFoundException, PolicyException {
        PolicyManager policyManager = new PolicyManager(sSOToken, string);
        policyManager.addPolicy(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Policy) {
            Policy policy = (Policy)object;
            if (this.rules.equals(policy.rules) && this.users.equals(policy.users) && this.referrals.equals(policy.referrals) && this.respProviders.equals(policy.respProviders) && this.conditions.equals(policy.conditions)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        Policy policy = null;
        try {
            policy = (Policy)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            policy = new Policy();
        }
        policy.origPolicyName = this.origPolicyName;
        policy.policyName = this.policyName;
        policy.description = this.description;
        policy.active = this.active;
        policy.rules = new HashMap();
        Iterator iterator = this.rules.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Rule rule = (Rule)this.rules.get(k);
            policy.rules.put(k, rule.clone());
        }
        policy.users = (Subjects)this.users.clone();
        policy.referrals = (Referrals)this.referrals.clone();
        policy.respProviders = (ResponseProviders)this.respProviders.clone();
        policy.conditions = (Conditions)this.conditions.clone();
        return policy;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<Policy name=\"");
        stringBuffer.append(XMLUtils.escapeSpecialCharacters(this.policyName));
        if (this.description != null && this.description.length() > 0) {
            stringBuffer.append("\" description=\"");
            stringBuffer.append(XMLUtils.escapeSpecialCharacters(this.description));
        }
        stringBuffer.append("\" referralPolicy=\"").append(this.referralPolicy);
        stringBuffer.append("\" active=\"").append(this.active);
        stringBuffer.append("\" >");
        Iterator iterator = this.getRuleNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Rule rule = this.getRule(string);
                stringBuffer.append(rule.toXML());
            }
            catch (Exception exception) {
                DEBUG.error("Error in policy.toXML():" + exception.getMessage());
            }
        }
        if (!this.referralPolicy) {
            if (!this.users.getSubjectNames().isEmpty()) {
                stringBuffer.append(this.users.toXML());
            }
            if (!this.conditions.getConditionNames().isEmpty()) {
                stringBuffer.append(this.conditions.toXML());
            }
            if (!this.respProviders.getResponseProviderNames().isEmpty()) {
                stringBuffer.append(this.respProviders.toXML());
            }
        } else if (!this.referrals.getReferralNames().isEmpty()) {
            stringBuffer.append(this.referrals.toXML());
        }
        stringBuffer.append("\n").append("</Policy>");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toXML();
    }

    static void checkForCharacter(String string, char c) throws InvalidNameException {
        if (string.indexOf(c) != -1) {
            Object[] objectArray = new Character[]{new Character(c)};
            throw new InvalidNameException("amPolicy", "invalid_char_in_name", objectArray, string, 1);
        }
    }

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, String string2, Set set, Map map) throws SSOException, NameNotFoundException, PolicyException {
        Collection collection;
        Object object;
        PolicyDecision policyDecision = new PolicyDecision();
        boolean bl = false;
        ServiceTypeManager serviceTypeManager = ServiceTypeManager.getServiceTypeManager();
        ServiceType serviceType = serviceTypeManager.getServiceType(string);
        this.evaluationOrder = sSOToken != null ? this.getEvaluationOrder(sSOToken) : 5;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("Policy " + this.getName() + " is Using Policy evaluation order :" + this.evaluationOrder);
        }
        if (this.isReferralPolicy() && !this.referrals.isEmpty()) {
            object = this.referrals.getPolicyDecision(sSOToken, string, string2, set, map);
            if (object != null) {
                PolicyEvaluator.mergePolicyDecisions(serviceType, (PolicyDecision)object, policyDecision);
            }
            if (DEBUG.messageEnabled()) {
                collection = sSOToken != null ? sSOToken.getPrincipal().getName() : "";
                DEBUG.message("at Policy.getPolicyDecision()" + " after processing referrals only:" + " principal, resource name, action names," + " policyName, referralResults = " + (String)((Object)collection) + ",  " + string2 + ",  " + set + ",  " + this.getName() + ",  " + object);
            }
        } else if (this.evaluationOrder == 1) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:SUBJECTS_CONDITIONS_RULES");
            }
            this.getPolicyDecisionSCR(sSOToken, serviceType, string2, set, map, policyDecision);
        } else if (this.evaluationOrder == 2) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:CONDITIONS_SUBJECTS_RULES");
            }
            this.getPolicyDecisionCSR(sSOToken, serviceType, string2, set, map, policyDecision);
        } else if (this.evaluationOrder == 3) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:RULES_SUBJECTS_CONDITIONS");
            }
            this.getPolicyDecisionRSC(sSOToken, serviceType, string2, set, map, policyDecision);
        } else if (this.evaluationOrder == 4) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:RULES_CONDITIONS_SUBJECTS");
            }
            this.getPolicyDecisionRCS(sSOToken, serviceType, string2, set, map, policyDecision);
        } else if (this.evaluationOrder == 5) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:SUBJECTS_RULES_CONDITIONS");
            }
            this.getPolicyDecisionSRC(sSOToken, serviceType, string2, set, map, policyDecision);
        } else if (this.evaluationOrder == 6) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:CONDITIONS_RULES_SUBJECTS");
            }
            this.getPolicyDecisionCRS(sSOToken, serviceType, string2, set, map, policyDecision);
        } else {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using default policy evaluation order:RULES_CONDITIONS_SUBJECTS");
            }
            this.getPolicyDecisionRCS(sSOToken, serviceType, string2, set, map, policyDecision);
        }
        if (DEBUG.messageEnabled()) {
            object = sSOToken != null ? sSOToken.getPrincipal().getName() : "";
            DEBUG.message("at Policy.getPolicyDecision()" + " principal, resource name, action names," + " policyName, policyDecision = " + (String)object + ",  " + string2 + ",  " + set + ",  " + this.getName() + ",  " + policyDecision);
        }
        if ((object = policyDecision.getActionDecisions()) != null && !object.isEmpty()) {
            collection = null;
            collection = object.values();
            if (collection != null && !collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Set set2 = ((ActionDecision)iterator.next()).getValues();
                    if (set2 == null || set2.isEmpty()) continue;
                    Map map2 = this.respProviders.getResponseProviderDecision(sSOToken, map);
                    policyDecision.setResponseAttributes(map2);
                    break;
                }
            }
        }
        return policyDecision;
    }

    private Map getMatchedRuleResults(ServiceType serviceType, String string, Set set) throws NameNotFoundException {
        String string2 = serviceType.getName();
        HashMap hashMap = null;
        StringBuffer stringBuffer = new StringBuffer(100);
        String string3 = stringBuffer.append(string2).append(string).append(set).toString();
        hashMap = (HashMap)this.matchRulesResultsCache.get(string3);
        if (hashMap == null) {
            Object object;
            Object object2;
            hashMap = new HashMap();
            Iterator iterator = this.rules.values().iterator();
            while (iterator.hasNext()) {
                object2 = (Rule)iterator.next();
                object = ((Rule)object2).getActionValues(string2, string, set);
                PolicyUtils.appendMapToMap((Map)object, hashMap);
            }
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                Set set2 = (Set)hashMap.get(object);
                if (set2.size() != 2) continue;
                ActionSchema actionSchema = null;
                AttributeSchema.Syntax syntax = null;
                try {
                    actionSchema = serviceType.getActionSchema((String)object);
                    syntax = actionSchema.getSyntax();
                }
                catch (InvalidNameException invalidNameException) {
                    PolicyManager.debug.error("can not find action schmea for action = " + (String)object, invalidNameException);
                }
                if (!AttributeSchema.Syntax.BOOLEAN.equals(syntax)) continue;
                String string4 = actionSchema.getTrueValue();
                set2.remove(string4);
            }
            this.matchRulesResultsCache.put(string3, hashMap);
        }
        return Policy.cloneRuleResults(hashMap);
    }

    Set getResourceNames(SSOToken sSOToken, String string, String string2, boolean bl) throws PolicyException, SSOException {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        ServiceType serviceType = ServiceTypeManager.getServiceTypeManager().getServiceType(string);
        Iterator iterator = this.rules.values().iterator();
        while (iterator.hasNext()) {
            object = (Rule)iterator.next();
            if (!((Rule)object).getServiceType().getName().equals(string)) continue;
            String string3 = ((Rule)object).getResourceName();
            ResourceMatch resourceMatch = serviceType.compare(string2, string3, true);
            if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH) || resourceMatch.equals(ResourceMatch.EXACT_MATCH) || resourceMatch.equals(ResourceMatch.WILDCARD_MATCH)) {
                hashSet.add(string3);
            }
            if (!DEBUG.messageEnabled()) continue;
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("at Policy.getResourceNames : ");
            stringBuffer.append(" for policyName, serviceType, resourceName, ");
            stringBuffer.append(" ruleResource, resourceMatch :");
            stringBuffer.append(this.getName()).append(",").append(string);
            stringBuffer.append(",").append(string2).append(",");
            stringBuffer.append(string3).append(",").append(resourceMatch);
            DEBUG.message(stringBuffer.toString());
        }
        if (!hashSet.isEmpty() && bl) {
            object = this.referrals.getResourceNames(sSOToken, string, string2);
            hashSet.addAll((Collection<String>)object);
        }
        if (DEBUG.messageEnabled()) {
            object = new StringBuffer(200);
            ((StringBuffer)object).append("at Policy.getResourceNames : ");
            ((StringBuffer)object).append(" for policyName, serviceType, resourceName, ");
            ((StringBuffer)object).append(" followReferral, resourceNames :");
            ((StringBuffer)object).append(this.getName()).append(",").append(string);
            ((StringBuffer)object).append(",").append(string2).append(",");
            ((StringBuffer)object).append(bl).append(",").append(hashSet);
            DEBUG.message(((StringBuffer)object).toString());
        }
        return hashSet;
    }

    Set getResourceNames(String string) throws SSOException, NameNotFoundException {
        HashSet<String> hashSet = new HashSet<String>();
        ServiceType serviceType = ServiceTypeManager.getServiceTypeManager().getServiceType(string);
        Iterator iterator = this.rules.values().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!rule.getServiceType().getName().equals(string)) continue;
            String string2 = rule.getResourceName();
            hashSet.add(string2);
        }
        return hashSet;
    }

    public String getServiceTypeName() {
        return null;
    }

    Set getReferredToOrganizations() throws PolicyException {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.referrals.getReferralNames().iterator();
        while (iterator.hasNext()) {
            Set set;
            String string = (String)iterator.next();
            Referral referral = this.referrals.getReferral(string);
            if (!(referral instanceof OrgReferral) || (set = referral.getValues()) == null || set.size() == 0) continue;
            String string2 = (String)set.iterator().next();
            hashSet.add(string2.toLowerCase());
        }
        return hashSet;
    }

    void setSubjectsResultTtl(long l) {
        this.users.setResultTtl(l);
    }

    private void validateName(String string) throws InvalidNameException {
        if (string == null || string.length() == 0) {
            DEBUG.message("Invalid policy name:" + string);
            throw new InvalidNameException("amPolicy", "null_name", null, "", 1);
        }
        if (string.indexOf(47) != -1) {
            DEBUG.message("Invalid policy name:" + string);
            DEBUG.message("Index Of /:" + string.indexOf(47));
            throw new InvalidNameException("amPolicy", "illegal_character_/_in_name", null, "", 1);
        }
    }

    private PolicyDecision getPolicyDecisionSCR(SSOToken sSOToken, ServiceType serviceType, String string, Set set, Map map, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean bl = false;
        ConditionDecision conditionDecision = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Map map2 = null;
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MIN_VALUE;
        Map map3 = null;
        if (sSOToken != null) {
            bl3 = this.users.isMember(sSOToken);
            l3 = this.users.getResultTtl(sSOToken);
        } else {
            bl3 = true;
            l3 = Long.MAX_VALUE;
        }
        if (bl3) {
            conditionDecision = this.conditions.getConditionDecision(sSOToken, map);
            bl2 = conditionDecision.isAllowed();
            map2 = conditionDecision.getAdvices();
            l = conditionDecision.getTimeToLive();
            if (l < l3) {
                l3 = l;
            }
            if (bl2) {
                map3 = this.getMatchedRuleResults(serviceType, string, set);
                boolean bl4 = bl = !map3.isEmpty();
                if (bl) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Set set2 = (Set)map3.get(string2);
                        ActionDecision actionDecision = new ActionDecision(string2, set2, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else {
                    policyDecision.setTimeToLive(Long.MAX_VALUE);
                }
            } else if (!map2.isEmpty()) {
                map3 = this.getMatchedRuleResults(serviceType, string, set);
                Iterator iterator = map3.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    ActionDecision actionDecision = new ActionDecision(string3, Collections.EMPTY_SET, map2, l3);
                    policyDecision.addActionDecision(actionDecision, serviceType);
                }
            } else {
                policyDecision.setTimeToLive(l3);
            }
        } else {
            policyDecision.setTimeToLive(l3);
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionSRC(SSOToken sSOToken, ServiceType serviceType, String string, Set set, Map map, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean bl = false;
        ConditionDecision conditionDecision = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Map map2 = null;
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MIN_VALUE;
        Map map3 = null;
        if (sSOToken != null) {
            bl3 = this.users.isMember(sSOToken);
            l3 = this.users.getResultTtl(sSOToken);
        } else {
            bl3 = true;
            l3 = Long.MAX_VALUE;
        }
        if (bl3) {
            map3 = this.getMatchedRuleResults(serviceType, string, set);
            boolean bl4 = bl = !map3.isEmpty();
            if (bl) {
                conditionDecision = this.conditions.getConditionDecision(sSOToken, map);
                bl2 = conditionDecision.isAllowed();
                map2 = conditionDecision.getAdvices();
                l = conditionDecision.getTimeToLive();
                if (l < l3) {
                    l3 = l;
                }
                if (bl2) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Set set2 = (Set)map3.get(string2);
                        ActionDecision actionDecision = new ActionDecision(string2, set2, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else if (!map2.isEmpty()) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        ActionDecision actionDecision = new ActionDecision(string3, Collections.EMPTY_SET, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else {
                    policyDecision.setTimeToLive(l3);
                }
            } else {
                policyDecision.setTimeToLive(Long.MAX_VALUE);
            }
        } else {
            policyDecision.setTimeToLive(l3);
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionCSR(SSOToken sSOToken, ServiceType serviceType, String string, Set set, Map map, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean bl = false;
        ConditionDecision conditionDecision = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Map map2 = null;
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MIN_VALUE;
        Map map3 = null;
        conditionDecision = this.conditions.getConditionDecision(sSOToken, map);
        bl2 = conditionDecision.isAllowed();
        map2 = conditionDecision.getAdvices();
        l3 = conditionDecision.getTimeToLive();
        if (bl2) {
            bl3 = this.users.isMember(sSOToken);
            l2 = this.users.getResultTtl(sSOToken);
            if (l2 < l3) {
                l3 = l2;
            }
            if (bl3) {
                map3 = this.getMatchedRuleResults(serviceType, string, set);
                boolean bl4 = bl = !map3.isEmpty();
                if (bl) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Set set2 = (Set)map3.get(string2);
                        ActionDecision actionDecision = new ActionDecision(string2, set2, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else {
                    policyDecision.setTimeToLive(Long.MAX_VALUE);
                }
            } else {
                policyDecision.setTimeToLive(l3);
            }
        } else {
            boolean bl5 = false;
            if (!map2.isEmpty()) {
                bl5 = this.users.isMember(sSOToken);
                l2 = this.users.getResultTtl(sSOToken);
                if (l2 < l3) {
                    l3 = l2;
                }
            }
            if (bl5) {
                map3 = this.getMatchedRuleResults(serviceType, string, set);
                Iterator iterator = map3.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    ActionDecision actionDecision = new ActionDecision(string3, Collections.EMPTY_SET, map2, l3);
                    policyDecision.addActionDecision(actionDecision, serviceType);
                }
            } else {
                policyDecision.setTimeToLive(l3);
            }
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionCRS(SSOToken sSOToken, ServiceType serviceType, String string, Set set, Map map, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean bl = false;
        ConditionDecision conditionDecision = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Map map2 = null;
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MIN_VALUE;
        Map map3 = null;
        conditionDecision = this.conditions.getConditionDecision(sSOToken, map);
        bl2 = conditionDecision.isAllowed();
        map2 = conditionDecision.getAdvices();
        l3 = conditionDecision.getTimeToLive();
        map3 = this.getMatchedRuleResults(serviceType, string, set);
        if (bl2) {
            boolean bl4 = bl = !map3.isEmpty();
            if (bl) {
                bl3 = this.users.isMember(sSOToken);
                l2 = this.users.getResultTtl(sSOToken);
                if (l2 < l3) {
                    l3 = l2;
                }
                if (bl3) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Set set2 = (Set)map3.get(string2);
                        ActionDecision actionDecision = new ActionDecision(string2, set2, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else {
                    policyDecision.setTimeToLive(l3);
                }
            } else {
                policyDecision.setTimeToLive(Long.MAX_VALUE);
            }
        } else {
            boolean bl5 = false;
            if (!map2.isEmpty()) {
                bl5 = this.users.isMember(sSOToken);
                l2 = this.users.getResultTtl(sSOToken);
                if (l2 < l3) {
                    l3 = l2;
                }
            }
            if (bl5) {
                map3 = this.getMatchedRuleResults(serviceType, string, set);
                Iterator iterator = map3.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    ActionDecision actionDecision = new ActionDecision(string3, Collections.EMPTY_SET, map2, l3);
                    policyDecision.addActionDecision(actionDecision, serviceType);
                }
            } else {
                policyDecision.setTimeToLive(l3);
            }
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionRSC(SSOToken sSOToken, ServiceType serviceType, String string, Set set, Map map, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean bl = false;
        ConditionDecision conditionDecision = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Map map2 = null;
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MIN_VALUE;
        Map map3 = this.getMatchedRuleResults(serviceType, string, set);
        boolean bl4 = bl = !map3.isEmpty();
        if (bl) {
            bl3 = this.users.isMember(sSOToken);
            l3 = this.users.getResultTtl(sSOToken);
            if (bl3) {
                conditionDecision = this.conditions.getConditionDecision(sSOToken, map);
                bl2 = conditionDecision.isAllowed();
                map2 = conditionDecision.getAdvices();
                l = conditionDecision.getTimeToLive();
                if (l < l3) {
                    l3 = l;
                }
                if (bl2) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Set set2 = (Set)map3.get(string2);
                        ActionDecision actionDecision = new ActionDecision(string2, set2, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else {
                    Iterator iterator = map3.keySet().iterator();
                    if (!map2.isEmpty()) {
                        while (iterator.hasNext()) {
                            String string3 = (String)iterator.next();
                            ActionDecision actionDecision = new ActionDecision(string3, Collections.EMPTY_SET, map2, l3);
                            policyDecision.addActionDecision(actionDecision, serviceType);
                        }
                    } else {
                        policyDecision.setTimeToLive(l3);
                    }
                }
            } else {
                policyDecision.setTimeToLive(l3);
            }
        } else {
            policyDecision.setTimeToLive(Long.MAX_VALUE);
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionRCS(SSOToken sSOToken, ServiceType serviceType, String string, Set set, Map map, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean bl = false;
        ConditionDecision conditionDecision = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Map map2 = null;
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        long l3 = Long.MIN_VALUE;
        Map map3 = this.getMatchedRuleResults(serviceType, string, set);
        boolean bl4 = bl = !map3.isEmpty();
        if (bl) {
            conditionDecision = this.conditions.getConditionDecision(sSOToken, map);
            bl2 = conditionDecision.isAllowed();
            map2 = conditionDecision.getAdvices();
            l3 = l = conditionDecision.getTimeToLive();
            if (bl2) {
                bl3 = this.users.isMember(sSOToken);
                l2 = this.users.getResultTtl(sSOToken);
                if (l2 < l3) {
                    l3 = l2;
                }
                if (bl3) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        Set set2 = (Set)map3.get(string2);
                        ActionDecision actionDecision = new ActionDecision(string2, set2, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else {
                    policyDecision.setTimeToLive(l3);
                }
            } else {
                boolean bl5 = false;
                if (!map2.isEmpty()) {
                    bl5 = this.users.isMember(sSOToken);
                    l2 = this.users.getResultTtl(sSOToken);
                    if (l2 < l3) {
                        l3 = l2;
                    }
                }
                if (bl5) {
                    Iterator iterator = map3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        ActionDecision actionDecision = new ActionDecision(string3, Collections.EMPTY_SET, map2, l3);
                        policyDecision.addActionDecision(actionDecision, serviceType);
                    }
                } else {
                    policyDecision.setTimeToLive(l3);
                }
            }
        } else {
            policyDecision.setTimeToLive(Long.MAX_VALUE);
        }
        return policyDecision;
    }

    private int getEvaluationOrder(SSOToken sSOToken) throws SSOException {
        int n;
        int n2 = 4;
        int n3 = n = this.users.isSubjectResultCached(sSOToken) ? 0 : this.psWeight;
        if (n <= this.pcWeight && this.pcWeight <= this.prWeight) {
            n2 = 1;
        } else if (this.pcWeight <= n && n <= this.prWeight) {
            n2 = 2;
        } else if (this.prWeight <= this.pcWeight && this.pcWeight <= n) {
            n2 = 4;
        } else if (this.prWeight <= n && n <= this.pcWeight) {
            n2 = 3;
        } else if (n <= this.prWeight && this.prWeight <= this.pcWeight) {
            n2 = 5;
        } else if (this.pcWeight <= this.prWeight && this.prWeight <= n) {
            n2 = 6;
        }
        return n2;
    }

    private static void initializeStaticEvaluationWeights() {
        EVALUATION_WEIGHTS = SystemProperties.get(EVALUATION_WEIGHTS_KEY, DEFAULT_EVALUATION_WEIGHTS);
        StringTokenizer stringTokenizer = new StringTokenizer(EVALUATION_WEIGHTS, ":");
        int n = stringTokenizer.countTokens();
        if (n != 3) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid evaulationWeights defined,  defaulting to " + DEFAULT_EVALUATION_WEIGHTS);
            }
            EVALUATION_WEIGHTS = DEFAULT_EVALUATION_WEIGHTS;
        } else {
            String string = stringTokenizer.nextToken();
            try {
                subjectWeight = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid subjectWeight defined, defaulting to 0");
                }
                subjectWeight = 0;
            }
            string = stringTokenizer.nextToken();
            try {
                ruleWeight = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid ruleWeight defined, defaulting to 0");
                }
                ruleWeight = 0;
            }
            string = stringTokenizer.nextToken();
            try {
                conditionWeight = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid conditionWeight defined, defaulting to 0");
                }
                conditionWeight = 0;
            }
        }
    }

    void initializeEvaluationWeights() {
        this.psWeight = this.users.size() * subjectWeight;
        this.prWeight = this.rules.size() * ruleWeight;
        this.pcWeight = this.conditions.size() * conditionWeight;
    }

    boolean isApplicableToUser(SSOToken sSOToken) throws PolicyException, SSOException {
        return this.users.isMember(sSOToken);
    }

    static Map cloneRuleResults(Map map) {
        HashMap hashMap = new HashMap();
        if (map != null && !map.isEmpty()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set = (Set)map.get(string);
                HashSet hashSet = new HashSet();
                hashSet.addAll(set);
                hashMap.put(string, hashSet);
            }
        }
        return hashMap;
    }

    String getSubjectRealm() {
        return this.subjectRealm;
    }

    static {
        Policy.initializeStaticEvaluationWeights();
    }
}

