/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.sm.PluginSchema;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ConditionTypeManager {
    private static String CONDITION = "Condition";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    static Debug debug = PolicyManager.debug;

    ConditionTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String string = this.token.getProperty("Locale");
        java.util.Locale locale = Locale.getLocale(string);
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    ConditionTypeManager(PolicyManager policyManager) {
        java.util.Locale locale;
        this.pm = policyManager;
        this.token = policyManager.token;
        try {
            String string = this.token.getProperty("Locale");
            locale = Locale.getLocale(string);
        }
        catch (SSOException sSOException) {
            debug.error("ConditionTypeManager:Unable to retreive locale from SSOToken", sSOException);
            locale = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("SubjectManager locale=" + locale + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", locale);
    }

    public Set getConditionTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(CONDITION);
    }

    public Set getSelectedConditionTypeNames() throws SSOException, PolicyException {
        Object v;
        String string = this.pm.getOrganizationDN();
        Map map = PolicyConfig.getPolicyConfig(string);
        if (map != null && (v = map.get("iplanet-am-policy-selected-conditions")) != null) {
            return (Set)v;
        }
        return Collections.EMPTY_SET;
    }

    public String getConditionTypeName(Condition condition) {
        return ConditionTypeManager.conditionTypeName(condition);
    }

    protected String getI18NPropertiesFileName(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(CONDITION, string);
        return null;
    }

    public String getI18NKey(String string) {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(CONDITION, string);
        if (pluginSchema != null) {
            return pluginSchema.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String string) {
        String string2 = null;
        String string3 = this.getI18NKey(string);
        string2 = string3 == null || string3.length() == 0 ? string : Locale.getString(this.rb, string3, debug);
        return string2;
    }

    public Condition getCondition(String string) throws NameNotFoundException, PolicyException {
        PluginSchema pluginSchema = PolicyManager.getPluginSchema(CONDITION, string);
        if (pluginSchema == null) {
            throw new NameNotFoundException("amPolicy", "invalid_condition", null, string, 5);
        }
        Condition condition = null;
        try {
            String string2 = pluginSchema.getClassName();
            condition = (Condition)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new PolicyException(exception);
        }
        return condition;
    }

    static String conditionTypeName(Condition condition) {
        if (condition == null) {
            return null;
        }
        String string = null;
        String string2 = condition.getClass().getName();
        Iterator iterator = PolicyManager.getPluginSchemaNames(CONDITION).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            PluginSchema pluginSchema = PolicyManager.getPluginSchema(CONDITION, string3);
            if (!string2.equals(pluginSchema.getClassName())) continue;
            string = string3;
            break;
        }
        return string;
    }

    public String getViewBeanURL(Condition condition) {
        return PolicyManager.getViewBeanURL(CONDITION, condition.getClass().getName());
    }
}

