/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;

public class RemoteHandler
extends Handler {
    private static LogManager manager = (LogManager)LogManagerUtil.getLogManager();
    private int recCount = 0;
    private String bufferSize;
    private int recCountLimit;
    private Map reqSetMap = new HashMap();
    private Timer bufferTimer;
    private boolean timeBufferingEnabled = false;
    private String logName;
    private URL logServURL;

    private void configure() {
        String string;
        this.bufferSize = manager.getProperty("iplanet-am-logging-buffer-size");
        if (this.bufferSize != null && this.bufferSize.length() > 0) {
            try {
                this.recCountLimit = Integer.parseInt(this.bufferSize);
            }
            catch (NumberFormatException numberFormatException) {
                this.recCountLimit = 1;
            }
        } else {
            this.recCountLimit = 1;
        }
        if ((string = manager.getProperty("iplanet-am-logging-time-buffering-status")) != null && string.equalsIgnoreCase("ON")) {
            this.timeBufferingEnabled = true;
        }
        this.setLevel(Level.INFO);
        this.setFilter(null);
        String string2 = manager.getProperty("iplanet-am-naming-logging-url");
        try {
            this.logServURL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            Debug.error("RemoteHandler.getLogHostURL(): '" + string2 + "' is malformed. " + malformedURLException.getMessage());
        }
    }

    public RemoteHandler(String string) {
        this.configure();
        if (this.timeBufferingEnabled) {
            this.startTimeBufferingThread();
        }
    }

    public synchronized void publish(java.util.logging.LogRecord logRecord) {
        this.logName = logRecord.getLoggerName();
        String string = this.getFormatter().format(logRecord);
        if (string == null || string.length() <= 0) {
            if (Debug.warningEnabled()) {
                Debug.warning(this.logName + ":RemoteHandler.publish : formatted xml is null");
            }
            return;
        }
        Request request = new Request(string);
        Map map = ((LogRecord)logRecord).getLogInfoMap();
        String string2 = (String)map.get("LoggedBySid");
        if (string2 != null) {
            RequestSet requestSet = (RequestSet)this.reqSetMap.get(string2);
            if (requestSet == null) {
                requestSet = new RequestSet("Logging");
            }
            requestSet.addRequest(request);
            this.reqSetMap.put(string2, requestSet);
        }
        ++this.recCount;
        if (this.recCount == this.recCountLimit) {
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":RemoteHandler.publish(): got " + this.recCount + " records, flushing all");
            }
            this.flush();
        }
    }

    public void close() {
        this.flush();
        this.stopBufferTimer();
    }

    public synchronized void flush() {
        if (this.recCount <= 0) {
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler.flush(): no records in buffer to send");
            }
            return;
        }
        Vector vector = new Vector();
        if (Debug.messageEnabled()) {
            Debug.message("RemoteHandler.flush(): sending buffered records");
        }
        try {
            Iterator iterator = this.reqSetMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                URL uRL = this.getLogHostURL(string);
                if (uRL == null) {
                    Debug.error("RemoteHandler.flush(): logHostURL is null");
                    this.recCount = 0;
                    this.reqSetMap = new HashMap();
                    return;
                }
                RequestSet requestSet = (RequestSet)this.reqSetMap.get(string);
                vector = PLLClient.send(uRL, requestSet);
                Iterator iterator2 = ((AbstractList)vector).iterator();
                while (iterator2.hasNext()) {
                    Response response = (Response)iterator2.next();
                    String string2 = response.getContent();
                    if (string2.equals("OK")) continue;
                    Debug.error("RemoteHandler.flush(): " + string2 + " on remote machine");
                }
            }
        }
        catch (Exception exception) {
            Debug.error("RemoteHandler.flush(): ", exception);
        }
        this.recCount = 0;
        this.reqSetMap = new HashMap();
    }

    private URL getLogHostURL(String string) {
        SessionID sessionID = new SessionID(string);
        String string2 = sessionID.getSessionServerProtocol();
        String string3 = sessionID.getSessionServer();
        String string4 = sessionID.getSessionServerPort();
        if (!(LogManager.isLocal || string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0)) {
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler.getLogHostURL(): remote serv = " + this.logServURL);
            }
            return this.logServURL;
        }
        if (Debug.messageEnabled()) {
            Debug.message("RemoteHandler.getLogHostURL():  sessionProtocol: " + string2 + " sessionHost: " + string3 + " sessionPort: " + string4);
        }
        URL uRL = null;
        try {
            uRL = WebtopNaming.getServiceURL("Logging", string2, string3, string4);
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler.getLogHostURL(): WebtopNaming loggingservice URL: " + uRL);
            }
        }
        catch (URLNotFoundException uRLNotFoundException) {
            Debug.error("RemoteHandler.getLogHostURL(): URLNotFoundException: ", uRLNotFoundException);
            return null;
        }
        return uRL;
    }

    private void startTimeBufferingThread() {
        String string = manager.getProperty("iplanet-am-logging-buffer-time-in-seconds");
        long l = string != null || string.length() != 0 ? Long.parseLong(string) : 3600L;
        l *= 1000L;
        if (this.bufferTimer == null) {
            this.bufferTimer = new Timer();
            this.bufferTimer.scheduleAtFixedRate((TimerTask)new TimeBufferingTask(), l, l);
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler: Time Buffering Thread Started");
            }
        }
    }

    private void stopBufferTimer() {
        if (this.bufferTimer != null) {
            this.bufferTimer.cancel();
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler: Buffer Timer Stopped");
            }
        }
    }

    private class TimeBufferingTask
    extends TimerTask {
        private TimeBufferingTask() {
        }

        public void run() {
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler:TimeBufferingTask.run() called");
            }
            RemoteHandler.this.flush();
        }
    }
}

