/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.log.Logger;
import com.sun.identity.sm.DNMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class AMIdentityRepository {
    private SSOToken token;
    private String org;
    public static Debug debug = Debug.getInstance("amIdm");
    protected static Logger logger = null;
    protected static boolean logStatus = false;
    private static Set supportedIdTypes = new HashSet(8);
    public static Map listeners = new CaseInsensitiveHashMap();

    public AMIdentityRepository(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        this.token = sSOToken;
        this.org = DNMapper.orgNameToDN(string);
    }

    public Set getSupportedIdTypes() throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Set set = aMDirectoryManager.getSupportedTypes(this.token, this.org);
        set.remove(IdType.REALM);
        return set;
    }

    public Set getAllowedIdOperations(IdType idType) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.getSupportedOperations(this.token, idType, this.org);
    }

    public IdSearchResults getSpecialIdentities(IdType idType) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.getSpecialIdentities(this.token, idType, this.org);
    }

    public IdSearchResults searchIdentities(IdType idType, String string, Map map, boolean bl, int n, int n2, Set set, boolean bl2) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.search(this.token, idType, string, map, bl, n, n2, set, this.org);
    }

    public IdSearchResults searchIdentities(IdType idType, String string, IdSearchControl idSearchControl) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.search(this.token, idType, string, idSearchControl, this.org);
    }

    public AMIdentity getRealmIdentity() throws IdRepoException, SSOException {
        String string = "id=ContainerDefaultTemplateRole,ou=realm," + this.org;
        return IdUtils.getIdentity(this.token, string);
    }

    public AMIdentity createIdentity(IdType idType, String string, Map map) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.create(this.token, idType, string, map, this.org);
    }

    public Set createIdentities(IdType idType, Map map) throws IdRepoException, SSOException {
        HashSet<AMIdentity> hashSet = new HashSet<AMIdentity>();
        if (map == null || map.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map2 = (Map)map.get(string);
            AMIdentity aMIdentity = aMDirectoryManager.create(this.token, idType, string, map2, this.org);
            hashSet.add(aMIdentity);
        }
        return hashSet;
    }

    public void deleteIdentities(IdType idType, Set set) throws IdRepoException, SSOException {
        if (set == null || set.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMIdentity aMIdentity = (AMIdentity)iterator.next();
            aMDirectoryManager.delete(this.token, aMIdentity.getType(), aMIdentity.getName(), this.org, aMIdentity.DN);
        }
    }

    public int addEventListener(IdEventListener idEventListener) {
        ArrayList<IdEventListener> arrayList = (ArrayList<IdEventListener>)listeners.get(this.org);
        if (arrayList == null) {
            arrayList = new ArrayList<IdEventListener>();
        }
        Map map = listeners;
        synchronized (map) {
            arrayList.add(idEventListener);
            listeners.put(this.org, arrayList);
        }
        return arrayList.size() - 1;
    }

    public void removeEventListener(int n) {
        ArrayList arrayList = (ArrayList)listeners.get(this.org);
        if (arrayList != null) {
            Map map = listeners;
            synchronized (map) {
                arrayList.remove(n);
            }
        }
    }
}

