/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCrypt;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public final class AMIdentity {
    private String univId;
    private SSOToken token;
    private String name;
    private IdType type;
    private String orgName;
    private AMHashMap modMap = new AMHashMap(false);
    private AMHashMap binaryModMap = new AMHashMap(true);
    protected String DN = null;

    protected AMIdentity(SSOToken sSOToken, String string) {
        this.univId = string;
        DN dN = new DN(this.univId);
        String[] stringArray = dN.explodeDN(true);
        this.name = stringArray[0];
        this.type = new IdType(stringArray[1]);
        this.orgName = dN.getParent().getParent().toRFCString();
        this.token = sSOToken;
    }

    public AMIdentity(SSOToken sSOToken, String string, IdType idType, String string2, String string3) {
        this.name = string;
        this.type = idType;
        this.orgName = string2;
        this.token = sSOToken;
        this.DN = string3;
        this.univId = string3 == null ? "id=" + string + ",ou=" + idType.getName() + "," + string2 : "id=" + string + ",ou=" + idType.getName() + "," + string2 + ",amsdkdn=" + string3;
    }

    public String getName() {
        return this.name;
    }

    public IdType getType() {
        return this.type;
    }

    public String getRealm() {
        return this.orgName;
    }

    public boolean isActive() throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.isActive(this.token, this.type, this.name, this.orgName, this.DN);
    }

    public Map getAttributes() throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.getAttributes(this.token, this.type, this.name, this.orgName, this.DN);
    }

    public Map getAttributes(Set set) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.getAttributes(this.token, this.type, this.name, set, this.orgName, this.DN, true);
    }

    public Map getBinaryAttributes(Set set) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.getAttributes(this.token, this.type, this.name, set, this.orgName, this.DN, false);
    }

    public Set getAttribute(String string) throws IdRepoException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Map map = aMDirectoryManager.getAttributes(this.token, this.type, this.name, hashSet, this.orgName, this.DN, true);
        return (Set)map.get(string);
    }

    public void setAttributes(Map map) throws IdRepoException, SSOException {
        this.modMap.copy(map);
    }

    public void setBinaryAttributes(Map map) throws IdRepoException, SSOException {
        this.binaryModMap.copy(map);
    }

    public void removeAttributes(Set set) throws IdRepoException, SSOException {
        if (set == null || set.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.modMap.put(string, Collections.EMPTY_SET);
        }
    }

    public void store() throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        if (this.modMap != null && !this.modMap.isEmpty()) {
            aMDirectoryManager.setAttributes(this.token, this.type, this.name, this.modMap, false, this.orgName, this.DN, true);
            this.modMap.clear();
        }
        if (this.binaryModMap != null && !this.binaryModMap.isEmpty()) {
            aMDirectoryManager.setAttributes(this.token, this.type, this.name, this.binaryModMap, false, this.orgName, this.DN, false);
            this.binaryModMap.clear();
        }
    }

    public Set getAssignedServices() throws IdRepoException, SSOException {
        Set set;
        block4: {
            ServiceManager serviceManager;
            try {
                serviceManager = new ServiceManager(this.token);
            }
            catch (SMSException sMSException) {
                throw new IdRepoException("amIdRepo", "106", null);
            }
            Map map = serviceManager.getServiceNamesAndOCs(this.type.getName());
            AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
            set = Collections.EMPTY_SET;
            try {
                set = aMDirectoryManager.getAssignedServices(this.token, this.type, this.name, map, this.orgName, this.DN);
            }
            catch (IdRepoException idRepoException) {
                if (idRepoException.getErrorCode().equals("402")) break block4;
                throw idRepoException;
            }
        }
        return set;
    }

    public Set getAssignableServices() throws IdRepoException, SSOException {
        ServiceManager serviceManager;
        try {
            serviceManager = new ServiceManager(this.token);
        }
        catch (SMSException sMSException) {
            throw new IdRepoException("amIdRepo", "106", null);
        }
        Map map = serviceManager.getServiceNamesAndOCs(this.type.getName());
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Set set = Collections.EMPTY_SET;
        try {
            set = aMDirectoryManager.getAssignedServices(this.token, this.type, this.name, map, this.orgName, this.DN);
        }
        catch (IdRepoException idRepoException) {
            if (!idRepoException.getErrorCode().equals("402")) {
                throw idRepoException;
            }
            return set;
        }
        Set set2 = map.keySet();
        set2.removeAll(set);
        return set2;
    }

    public void assignService(String string, Map map) throws IdRepoException, SSOException {
        SchemaType schemaType;
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Set set = this.getServiceOCs(this.token, string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        hashMap.put(string, set);
        Set set2 = aMDirectoryManager.getAssignedServices(this.token, this.type, this.name, hashMap, this.orgName, this.DN);
        if (set2.contains(string)) {
            Object[] objectArray = new Object[]{string, this.type.getName()};
            throw new IdRepoException("amIdRepo", "105", objectArray);
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(this.type.getName());
            if (serviceSchema != null) {
                map = serviceSchema.validateAndInheritDefaults(map, this.orgName, true);
                map = AMCommonUtils.removeEmptyValues(map);
                schemaType = serviceSchema.getServiceType();
            } else {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                if (serviceSchema == null) {
                    Object[] objectArray = new Object[]{string};
                    throw new IdRepoException("amIdRepo", "102", objectArray);
                }
                if (map == null) {
                    try {
                        map = AMServiceUtils.getServiceConfig(this.token, string, SchemaType.DYNAMIC);
                    }
                    catch (SMSException sMSException) {
                        Object[] objectArray = new Object[]{string, this.type.getName()};
                        throw new IdRepoException("amIdRepo", "451", objectArray);
                    }
                } else {
                    map = serviceSchema.validateAndInheritDefaults(map, this.orgName, true);
                }
                map = AMCommonUtils.removeEmptyValues(map);
                schemaType = SchemaType.DYNAMIC;
            }
            map = AMCrypt.encryptPasswords(map, serviceSchema);
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "101", objectArray);
        }
        map.put("objectclass", set);
        aMDirectoryManager.assignService(this.token, this.type, this.name, string, schemaType, map, this.orgName, this.DN);
    }

    public void unassignService(String string) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Set set = this.getServiceOCs(this.token, string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        hashMap.put(string, set);
        Set set2 = aMDirectoryManager.getAssignedServices(this.token, this.type, this.name, hashMap, this.orgName, this.DN);
        if (!set2.contains(string)) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "101", objectArray);
        }
        HashMap<String, Set> hashMap2 = new HashMap<String, Set>();
        Set set3 = this.getAttribute("objectclass");
        if (set3 != null && !set3.isEmpty()) {
            Set set4 = AMCommonUtils.updateAndGetRemovableOCs(set3, set);
            try {
                Set set5 = new HashSet();
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                ServiceSchema serviceSchema = serviceSchemaManager.getSchema(this.type.getName());
                if (serviceSchema != null) {
                    set5 = serviceSchema.getAttributeSchemaNames();
                }
                Iterator iterator = set5.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    hashMap2.put(string2, Collections.EMPTY_SET);
                }
            }
            catch (SMSException sMSException) {
                // empty catch block
            }
            hashMap2.put("objectclass", set4);
        }
        aMDirectoryManager.unassignService(this.token, this.type, this.name, string, hashMap2, this.orgName, this.DN);
    }

    public Map getServiceAttributes(String string) throws IdRepoException, SSOException {
        Object object;
        Set set = Collections.EMPTY_SET;
        try {
            set = new HashSet();
            object = new ServiceSchemaManager(string, this.token);
            ServiceSchema serviceSchema = ((ServiceSchemaManager)object).getSchema(this.type.getName());
            if (serviceSchema != null) {
                set = serviceSchema.getAttributeSchemaNames();
            }
            if ((serviceSchema = ((ServiceSchemaManager)object).getDynamicSchema()) != null) {
                set.addAll(serviceSchema.getAttributeSchemaNames());
            }
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
        object = AMDirectoryWrapper.getInstance();
        return ((AMDirectoryManager)object).getServiceAttributes(this.token, this.type, this.name, string, set, this.orgName, this.DN);
    }

    public void modifyService(String string, Map map) throws IdRepoException, SSOException {
        SchemaType schemaType;
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        Set set = this.getServiceOCs(this.token, string);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        hashMap.put(string, set);
        Set set2 = aMDirectoryManager.getAssignedServices(this.token, this.type, this.name, hashMap, this.orgName, this.DN);
        if (!set2.contains(string)) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "101", objectArray);
        }
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(this.type.getName());
            if (serviceSchema != null) {
                map = serviceSchema.validateAndInheritDefaults(map, false);
                schemaType = serviceSchema.getServiceType();
            } else {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                if (serviceSchema == null) {
                    Object[] objectArray = new Object[]{string};
                    throw new IdRepoException("amIdRepo", "102", objectArray);
                }
                map = serviceSchema.validateAndInheritDefaults(map, false);
                schemaType = SchemaType.DYNAMIC;
            }
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new Object[]{string};
            throw new IdRepoException("amIdRepo", "103", objectArray);
        }
        aMDirectoryManager.modifyService(this.token, this.type, this.name, string, schemaType, map, this.orgName, this.DN);
    }

    public boolean isMember(AMIdentity aMIdentity) throws IdRepoException, SSOException {
        IdRepoException idRepoException;
        boolean bl;
        block11: {
            String string;
            AMIdentity aMIdentity2;
            Iterator iterator;
            String string2;
            Set set;
            AMDirectoryManager aMDirectoryManager;
            block10: {
                bl = false;
                idRepoException = null;
                aMDirectoryManager = AMDirectoryWrapper.getInstance();
                try {
                    set = aMDirectoryManager.getMemberships(this.token, this.getType(), this.getName(), aMIdentity.getType(), this.orgName, this.getDN());
                    if (set != null && set.contains(aMIdentity)) {
                        bl = true;
                        break block10;
                    }
                    if (set == null || (string2 = aMIdentity.getDN()) == null) break block10;
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        aMIdentity2 = (AMIdentity)iterator.next();
                        string = aMIdentity2.getDN();
                        if (string == null || !string.equalsIgnoreCase(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (IdRepoException idRepoException2) {
                    idRepoException = idRepoException2;
                }
            }
            if (!bl && aMIdentity.getType().equals(IdType.GROUP)) {
                try {
                    set = aMDirectoryManager.getMembers(this.token, aMIdentity.getType(), aMIdentity.getName(), aMIdentity.orgName, this.getType(), aMIdentity.getDN());
                    if (set != null && set.contains(this)) {
                        bl = true;
                        break block11;
                    }
                    if (set == null || (string2 = this.getDN()) == null) break block11;
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        aMIdentity2 = (AMIdentity)iterator.next();
                        string = aMIdentity2.getDN();
                        if (string == null || !string.equalsIgnoreCase(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (idRepoException != null) {
            throw idRepoException;
        }
        return bl;
    }

    public void addMember(AMIdentity aMIdentity) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(aMIdentity.getName());
        aMDirectoryManager.modifyMemberShip(this.token, this.type, this.name, hashSet, aMIdentity.getType(), 1, this.orgName);
    }

    public void removeMember(AMIdentity aMIdentity) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(aMIdentity.getName());
        aMDirectoryManager.modifyMemberShip(this.token, this.type, this.name, hashSet, aMIdentity.getType(), 2, this.orgName);
    }

    public void removeMembers(Set set) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMIdentity aMIdentity = (AMIdentity)iterator.next();
            hashSet.add(aMIdentity.getName());
            aMDirectoryManager.modifyMemberShip(this.token, this.type, this.name, hashSet, aMIdentity.getType(), 2, this.orgName);
            hashSet = new HashSet();
        }
    }

    public Set getMembers(IdType idType) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.getMembers(this.token, this.type, this.name, this.orgName, idType, this.getDN());
    }

    public Set getMemberships(IdType idType) throws IdRepoException, SSOException {
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        return aMDirectoryManager.getMemberships(this.token, this.type, this.name, idType, this.orgName, this.getDN());
    }

    public boolean equals(Object object) {
        if (object instanceof AMIdentity) {
            String string;
            AMIdentity aMIdentity = (AMIdentity)object;
            if (this.univId.equalsIgnoreCase(aMIdentity.univId)) {
                return true;
            }
            if (this.DN != null && (string = aMIdentity.getDN()) != null && string.equalsIgnoreCase(this.DN)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.DN != null) {
            return this.DN.toLowerCase().hashCode();
        }
        return this.univId.toLowerCase().hashCode();
    }

    public void setDN(String string) {
        this.DN = string;
    }

    public String getDN() {
        return this.DN;
    }

    public String getUniversalId() {
        return this.univId;
    }

    private Set getServiceOCs(SSOToken sSOToken, String string) throws SSOException {
        HashSet hashSet = new HashSet();
        try {
            Map map;
            Set set;
            if (AMServiceUtils.serviceHasSubSchema(sSOToken, string, SchemaType.GLOBAL) && (set = (Set)(map = AMServiceUtils.getServiceConfig(sSOToken, string, SchemaType.GLOBAL)).get("serviceObjectClasses")) != null) {
                hashSet.addAll(set);
            }
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
        return hashSet;
    }
}

