/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.common;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.logging.Level;

public class LogUtil {
    public static final String WRITE_ACCOUNT_FED_INFO = "WRITE_ACCOUNT_FED_INFO";
    public static final String REMOVE_ACCOUNT_FED_INFO = "REMOVE_ACCOUNT_FED_INFO";
    public static final String CREATE_AUTH_DOMAIN = "CREATE_AUTH_DOMAIN";
    public static final String DELETE_AUTH_DOMAIN = "DELETE_AUTH_DOMAIN";
    public static final String MODIFY_AUTH_DOMAIN = "MODIFY_AUTH_DOMAIN";
    public static final String CREATE_REMOTE_PROVIDER = "CREATE_REMOTE_PROVIDER";
    public static final String CREATE_HOSTED_PROVIDER = "CREATE_HOSTED_PROVIDER";
    public static final String DELETE_AFFILIATION = "DELETE_AFFILIATION";
    public static final String DELETE_ENTITY = "DELETE_ENTITY";
    public static final String DELETE_PROVIDER = "DELETE_PROVIDER";
    public static final String MODIFY_ENTITY = "MODIFY_ENTITY";
    public static final String MODIFY_AFFILIATION = "MODIFY_AFFILIATION";
    public static final String MODIFY_PROVIDER = "MODIFY_PROVIDER";
    public static final String CREATE_ENTITY = "CREATE_ENTITY";
    public static final String CREATE_AFFILIATION = "CREATE_AFFILIATION";
    public static final String MISSING_RESPONSE = "MISSING_RESPONSE";
    public static final String CREATE_ASSERTION = "CREATE_ASSERTION";
    public static final String LIBERTY_NOT_ENABLED = "LIBERTY_NOT_ENABLED";
    public static final String LOGOUT_REQUEST_PROCESSING_FAILED = "LOGOUT_REQUEST_PROCESSING_FAILED";
    public static final String MISSING_SOAP_MSG_FACTORY = "MISSING_SOAP_MSG_FACTORY";
    public static final String FAILED_SOAP_URL_END_POINT_CREATION = "FAILED_SOAP_URL_END_POINT_CREATION";
    public static final String MISMATCH_AUTH_TYPE_AND_PROTOCOL = "MISMATCH_AUTH_TYPE_AND_PROTOCOL";
    public static final String WRONG_AUTH_TYPE = "WRONG_AUTH_TYPE";
    public static final String SOAP_RECEIVER_URL = "SOAP_RECEIVER_URL";
    public static final String INVALID_SOAP_RESPONSE = "INVALID_SOAP_RESPONSE";
    public static final String INVALID_RESPONSE = "INVALID_RESPONSE";
    public static final String INVALID_ASSERTION = "INVALID_ASSERTION";
    public static final String SINGLE_SIGNON_FAILED = "SINGLE_SIGNON_FAILED";
    public static final String ACCESS_GRANTED_REDIRECT_TO = "ACCESS_GRANTED_REDIRECT_TO";
    public static final String NULL_INPUT_PARAMETER = "NULL_INPUT_PARAMETER";
    public static final String MISSING_AUTHN_RESPONSE = "MISSING_AUTHN_RESPONSE";
    public static final String ACCOUNT_FEDERATION_FAILED = "ACCOUNT_FEDERATION_FAILED";
    public static final String FAILED_SSO_TOKEN_GENERATION = "FAILED_SSO_TOKEN_GENERATION";
    public static final String INVALID_AUTHN_RESPONSE = "INVALID_AUTHN_RESPONSE";
    public static final String AUTHN_REQUEST_PROCESSING_FAILED = "AUTHN_REQUEST_PROCESSING_FAILED";
    public static final String SIGNATURE_VERIFICATION_FAILED = "SIGNATURE VERIFICATION FAILED";
    public static final String CANNOT_BUILD_RESPONSE = "CANNOT_BUILD_RESPONSE";
    public static final String CREATE_SAML_RESPONSE = "CREATE_SAML_RESPONSE";
    public static final String REDIRECT_TO = "REDIRECT_TO";
    public static final String COMMON_DOMAIN_META_DATA_NOT_FOUND = "COMMON_DOMAIN_META_DATA_NOT_FOUND";
    public static final String INVALID_REQUEST_ID = "INVALID_REQUEST_ID";
    public static final String PROVIDER_NOT_TRUSTED = "PROVIDER_NOT_TRUSTED";
    public static final String INVALID_AUTHN_REQUEST = "INVALID_AUTHN_REQUEST";
    public static final String USER_ACCOUNT_FEDERATION_INFO_NOT_FOUND = "USER_ACCOUNT_FEDERATION_INFO_NOT_FOUND";
    public static final String INVALID_AUTHN_REQUEST_EXCEPTION = "INVALID_AUTHN_REQUEST_EXCEPTION";
    public static final String USER_NOT_FOUND = "USER_NOT_FOUND";
    public static final String LOGOUT_PROFILE_NOT_SUPPORTED = "LOGOUT_PROFILE_NOT_SUPPORTED";
    public static final String LOGOUT_SUCCESS = "LOGOUT_SUCCESS";
    public static final String LOGOUT_REDIRECT_FAILED = "LOGOUT_REDIRECT_FAILED";
    public static final String LOGOUT_FAILED_REQUEST_IMPROPER = "LOGOUT_FAILED_REQUEST_IMPROPER";
    public static final String LOGOUT_FAILED_INVALID_HANDLER = "LOGOUT_FAILED_INVALID_HANDLER";
    public static final String INVALID_PROVIDER = "INVALID_PROVIDER";
    public static final String LOGOUT_FAILED = "LOGOUT_FAILED";
    public static final String REGISTRATION_FAILED_SP_NAME_IDENTIFIER = "REGISTRATION_FAILED_SP_NAME_IDENTIFIER";
    public static final String INVALID_SIGNATURE = "INVALID_SIGNATURE";
    public static final String TERMINATION_FAILED = "TERMINATION_FAILED";
    public static final String TERMINATION_SUCCESS = "TERMINATION_SUCCESS";
    public static final String TERMINATION_REQUEST_PROCESSING_FAILED = "TERMINATION_REQUEST_PROCESSING_FAILED";
    private static final String FEDERATION_LOG = "Federation";
    private static final String ACCESS_LOG_NAME = "amFederation.access";
    private static final String ERROR_LOG_NAME = "amFederation.error";
    private static Logger accessLogger;
    private static Logger errorLogger;
    private static LogMessageProvider msgProvider;
    private static SSOToken authSSOToken;
    private static boolean logStatus;

    public static void access(Level level, String string, String string2, Object[] objectArray) {
        LogUtil.access(level, string, MessageFormat.format(FSUtils.bundle.getString(string2), objectArray));
    }

    public static void access(Level level, String string, String[] stringArray) {
        LogUtil.access(level, string, stringArray, authSSOToken);
    }

    public static void access(Level level, String string, String[] stringArray, SSOToken sSOToken) {
        LogRecord logRecord;
        if (authSSOToken == null) {
            return;
        }
        if (accessLogger.isLoggable(level) && (logRecord = msgProvider.createLogRecord(string, stringArray, (Object)sSOToken)) != null) {
            accessLogger.log(logRecord, authSSOToken);
        }
    }

    public static void access(Level level, String string, String string2) {
        if (authSSOToken == null) {
            return;
        }
        if (accessLogger.isLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string2, authSSOToken);
            accessLogger.log(logRecord, authSSOToken);
        }
    }

    public static void error(Level level, String string, String string2) {
        if (authSSOToken == null) {
            return;
        }
        if (errorLogger.isLoggable(level)) {
            LogRecord logRecord = new LogRecord(level, string2, authSSOToken);
            errorLogger.log(logRecord, authSSOToken);
        }
    }

    public static void error(Level level, String string, String[] stringArray) {
        LogUtil.error(level, string, stringArray, authSSOToken);
    }

    public static void error(Level level, String string, String[] stringArray, SSOToken sSOToken) {
        LogRecord logRecord;
        if (authSSOToken == null) {
            return;
        }
        if (errorLogger.isLoggable(level) && (logRecord = msgProvider.createLogRecord(string, stringArray, (Object)sSOToken)) != null) {
            errorLogger.log(logRecord, authSSOToken);
        }
    }

    public static boolean isLogEnabled() {
        return logStatus;
    }

    public static boolean isAccessLoggable(Level level) {
        if (authSSOToken == null) {
            return false;
        }
        return accessLogger.isLoggable(level);
    }

    public static boolean isErrorLoggable(Level level) {
        if (authSSOToken == null) {
            return false;
        }
        return errorLogger.isLoggable(level);
    }

    static {
        String string;
        accessLogger = null;
        errorLogger = null;
        msgProvider = null;
        authSSOToken = null;
        logStatus = false;
        try {
            authSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            string = SystemProperties.get("com.iplanet.am.defaultOrg");
            authSSOToken.setProperty("Organization", string);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("LogUtil.static: Unable to create SSOToken", sSOException);
        }
        accessLogger = (Logger)Logger.getLogger(ACCESS_LOG_NAME);
        errorLogger = (Logger)Logger.getLogger(ERROR_LOG_NAME);
        try {
            msgProvider = MessageProviderFactory.getProvider((String)FEDERATION_LOG);
        }
        catch (Exception exception) {
            FSUtils.debug.message("Error getting log message provider ");
        }
        string = SystemProperties.get("com.iplanet.am.logstatus");
        if (string == null) {
            string = "INACTIVE";
        }
        if (string.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
    }
}

