/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.ServerEntryNotFoundException;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.service.NamingService;
import com.iplanet.services.naming.share.NamingBundle;
import com.iplanet.services.naming.share.NamingRequest;
import com.iplanet.services.naming.share.NamingResponse;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebtopNaming {
    private static final String sccsID = "$Id: WebtopNaming.java,v 1.46 2005/06/24 16:55:36 vs125812 Exp $ $Date: 2005/06/24 16:55:36 $  Sun Microsystems, Inc.";
    public static final String NAMING_SERVICE = "com.iplanet.am.naming";
    public static final String NODE_SEPARATOR = "|";
    private static Hashtable namingTable = null;
    private static Hashtable serverIdTable = null;
    private static Hashtable siteIdTable = null;
    private static Vector platformServers = new Vector();
    private static String[] namingServiceURL = null;
    protected static Debug debug = Debug.getInstance("amNaming");
    private static boolean serverMode = false;
    private static String amServerProtocol = null;
    private static String amServer = null;
    private static String amServerPort = null;
    private static final String IGNORE_NAMING_SERVICE = "com.iplanet.am.naming.ignoreNamingService";
    private static boolean ignoreNaming = false;
    private Thread monitorThread = null;

    public static boolean isServerMode() {
        return serverMode;
    }

    public static boolean isSiteEnabled(String string, String string2, String string3) throws Exception {
        String string4 = WebtopNaming.getServerID(string, string2, string3);
        return WebtopNaming.isSiteEnabled(string4);
    }

    public static boolean isSiteEnabled(String string) throws Exception {
        String string2 = (String)siteIdTable.get(string);
        return !string.equals(string2);
    }

    public static String getAMServerID() throws ServerEntryNotFoundException {
        return WebtopNaming.getServerID(amServerProtocol, amServer, amServerPort);
    }

    private static void getAMServer() {
        amServer = SystemProperties.get("com.iplanet.am.server.host");
        amServerPort = SystemProperties.get("com.iplanet.am.server.port");
        amServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
    }

    private static void initializeNamingService() {
        ignoreNaming = Boolean.valueOf(SystemProperties.get(IGNORE_NAMING_SERVICE, "false")) & !WebtopNaming.isServerMode();
        try {
            WebtopNaming.getNamingServiceURL();
        }
        catch (Exception exception) {
            debug.error("Failed to initialize naming service", exception);
        }
    }

    public static URL getServiceURL(String string, String string2, String string3, String string4) throws URLNotFoundException {
        boolean bl = WebtopNaming.isServerMode();
        return WebtopNaming.getServiceURL(string, string2, string3, string4, bl);
    }

    public static URL getServiceURL(String string, String string2, String string3, String string4, boolean bl) throws URLNotFoundException {
        try {
            if (string2 == null || string3 == null || string4 == null || string2.length() == 0 || string3.length() == 0 || string4.length() == 0) {
                throw new Exception(NamingBundle.getString("noServiceURL") + string);
            }
            if (ignoreNaming) {
                string2 = amServerProtocol;
                string3 = amServer;
                string4 = amServerPort;
            }
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            String string5 = null;
            String string6 = "iplanet-am-naming-" + string.toLowerCase() + "-url";
            string5 = (String)namingTable.get(string6);
            if (string5 != null) {
                int n;
                if (bl && string5.indexOf("%") != -1) {
                    WebtopNaming.validate(string2, string3, string4);
                }
                if ((n = string5.indexOf("%protocol")) != -1) {
                    string5 = string5.substring(0, n) + string2 + string5.substring(n + "%protocol".length(), string5.length());
                }
                if ((n = string5.indexOf("%host")) != -1) {
                    string5 = string5.substring(0, n) + string3 + string5.substring(n + "%host".length(), string5.length());
                }
                if ((n = string5.indexOf("%port")) != -1) {
                    string5 = string5.substring(0, n) + string4 + string5.substring(n + "%port".length(), string5.length());
                }
                return new URL(string5);
            }
            throw new Exception(NamingBundle.getString("noServiceURL") + string);
        }
        catch (Exception exception) {
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    public static Vector getServiceAllURLs(String string) throws URLNotFoundException {
        Vector<URL> vector = null;
        try {
            String string2;
            String string3;
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            if ((string3 = (String)namingTable.get(string2 = "iplanet-am-naming-" + string.toLowerCase() + "-url")) != null) {
                vector = new Vector<URL>();
                if (string3.indexOf("%") != -1) {
                    Vector vector2 = SiteMonitor.getAvailableSites();
                    Iterator iterator = ((AbstractList)vector2).iterator();
                    while (iterator.hasNext()) {
                        String string4 = WebtopNaming.getServerFromID((String)iterator.next());
                        URL uRL = new URL(string4);
                        vector.add(WebtopNaming.getServiceURL(string, uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getPort())));
                    }
                } else {
                    vector.add(new URL(string3));
                }
            }
            return vector;
        }
        catch (Exception exception) {
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    public static Vector getPlatformServerList() throws Exception {
        WebtopNaming.getNamingProfile(true);
        return platformServers;
    }

    private static String getValueFromTable(Hashtable hashtable, String string) {
        if (hashtable.contains(string)) {
            return (String)hashtable.get(string);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (String)hashtable.get(string2);
        }
        return null;
    }

    public static String getServerID(String string, String string2, String string3) throws ServerEntryNotFoundException {
        try {
            if (string == null || string2 == null || string3 == null || string.length() == 0 || string2.length() == 0 || string3.length() == 0) {
                throw new Exception(NamingBundle.getString("noServerID"));
            }
            String string4 = string + ":" + "//" + string2 + ":" + string3;
            String string5 = null;
            if (serverIdTable != null) {
                string5 = WebtopNaming.getValueFromTable(serverIdTable, string4);
            }
            if (string5 == null) {
                WebtopNaming.getNamingProfile(true);
                string5 = WebtopNaming.getValueFromTable(serverIdTable, string4);
            }
            if (string5 == null) {
                throw new ServerEntryNotFoundException(NamingBundle.getString("noServerID"));
            }
            return string5;
        }
        catch (Exception exception) {
            throw new ServerEntryNotFoundException(exception);
        }
    }

    public static String getServerFromID(String string) throws ServerEntryNotFoundException {
        String string2 = null;
        try {
            if (namingTable != null) {
                string2 = WebtopNaming.getValueFromTable(namingTable, string);
            }
            if (string2 == null) {
                WebtopNaming.getNamingProfile(true);
                string2 = WebtopNaming.getValueFromTable(namingTable, string);
            }
            if (string2 == null) {
                throw new ServerEntryNotFoundException(NamingBundle.getString("noServer"));
            }
        }
        catch (Exception exception) {
            throw new ServerEntryNotFoundException(exception);
        }
        return string2;
    }

    public static String getSiteID(String string, String string2, String string3) throws ServerEntryNotFoundException {
        Object var3_3 = null;
        String string4 = WebtopNaming.getServerID(string, string2, string3);
        return WebtopNaming.getSiteID(string4);
    }

    public static String getSiteID(String string) {
        String string2 = null;
        String string3 = null;
        if (siteIdTable == null) {
            return null;
        }
        string3 = (String)siteIdTable.get(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, NODE_SEPARATOR);
        if (stringTokenizer != null) {
            string2 = stringTokenizer.nextToken();
        }
        if (debug.messageEnabled()) {
            debug.message("WebtopNaming : SiteID for " + string + " is " + string2);
        }
        return string2;
    }

    public static String getSecondarySites(String string) {
        String string2 = null;
        String string3 = null;
        if (siteIdTable == null) {
            return null;
        }
        string2 = (String)siteIdTable.get(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(NODE_SEPARATOR);
        if (n != -1) {
            string3 = string2.substring(n + 1, string2.length());
        }
        if (debug.messageEnabled()) {
            debug.message("WebtopNaming : SecondarySites for " + string + " is " + string3);
        }
        return string3;
    }

    public static Set getSiteNodes(String string) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        if (namingTable == null) {
            WebtopNaming.getNamingProfile(false);
        }
        String string2 = WebtopNaming.getSiteID(string);
        Enumeration enumeration = siteIdTable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase(string3) || !string2.equalsIgnoreCase(WebtopNaming.getSiteID(string3))) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    public static String getServiceClass(String string) throws ClassNotFoundException {
        try {
            if (namingTable == null) {
                WebtopNaming.getNamingProfile(false);
            }
            String string2 = null;
            String string3 = "iplanet-am-naming-" + string.toLowerCase() + "-class";
            string2 = (String)namingTable.get(string3);
            if (string2 == null) {
                throw new Exception(NamingBundle.getString("noServiceClass") + string);
            }
            return string2;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(exception.getMessage());
        }
    }

    public static synchronized URL getNotificationURL() throws URLNotFoundException {
        try {
            String string = System.getProperty("com.iplanet.am.notification.url", SystemProperties.get("com.iplanet.am.notification.url"));
            if (string == null) {
                throw new URLNotFoundException(NamingBundle.getString("noNotificationURL"));
            }
            return new URL(string);
        }
        catch (Exception exception) {
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    private static synchronized void getNamingProfile(boolean bl) throws Exception {
        if (bl || namingTable == null) {
            WebtopNaming.updateNamingTable();
        }
    }

    private static void updateServerProperties(URL uRL) {
        amServerProtocol = uRL.getProtocol();
        amServer = uRL.getHost();
        amServerPort = Integer.toString(uRL.getPort());
        SystemProperties.initializeProperties("com.iplanet.am.server.protocol", amServerProtocol);
        SystemProperties.initializeProperties("com.iplanet.am.server.host", amServer);
        SystemProperties.initializeProperties("com.iplanet.am.server.port", amServerPort);
    }

    private static Hashtable getNamingTable(URL uRL) throws Exception {
        Hashtable hashtable = null;
        NamingRequest namingRequest = new NamingRequest("2.0");
        Request request = new Request(namingRequest.toXMLString());
        RequestSet requestSet = new RequestSet(NAMING_SERVICE);
        requestSet.addRequest(request);
        Vector vector = null;
        try {
            vector = PLLClient.send(uRL, requestSet);
            if (vector.size() != 1) {
                throw new Exception(NamingBundle.getString("unexpectedResponse"));
            }
            Response response = (Response)vector.elementAt(0);
            NamingResponse namingResponse = NamingResponse.parseXML(response.getContent());
            if (namingResponse.getException() != null) {
                throw new Exception(namingResponse.getException());
            }
            hashtable = namingResponse.getNamingTable();
        }
        catch (SendRequestException sendRequestException) {
            debug.error("Naming service connection failed for " + uRL, sendRequestException);
        }
        catch (Exception exception) {
            debug.error("getNamingTable: ", exception);
        }
        return hashtable;
    }

    private static void updateNamingTable() throws Exception {
        Object object;
        if (!WebtopNaming.isServerMode()) {
            if (namingServiceURL == null) {
                WebtopNaming.initializeNamingService();
            }
            namingTable = null;
            object = null;
            int n = 0;
            while (namingTable == null && n < namingServiceURL.length) {
                object = new URL(namingServiceURL[n]);
                namingTable = WebtopNaming.getNamingTable((URL)object);
                ++n;
            }
            if (namingTable == null) {
                debug.error("updateNamingTable : " + NamingBundle.getString("noNamingServiceAvailable"));
                throw new Exception(NamingBundle.getString("noNamingServiceAvailable"));
            }
            WebtopNaming.updateServerProperties((URL)object);
        } else {
            namingTable = NamingService.getNamingTable();
        }
        object = (String)namingTable.get("iplanet-am-platform-server-list");
        if (object != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            platformServers.clear();
            while (stringTokenizer.hasMoreTokens()) {
                platformServers.add(stringTokenizer.nextToken().toLowerCase());
            }
        }
        WebtopNaming.updateServerIdMappings();
        WebtopNaming.updateSiteIdMappings();
        if (debug.messageEnabled()) {
            debug.message("Naming table -> " + namingTable.toString());
            debug.message("Platform Servers -> " + platformServers.toString());
        }
    }

    private static void updateServerIdMappings() {
        serverIdTable = new Hashtable();
        Enumeration enumeration = namingTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)namingTable.get(string);
            if (string == null || string2 == null || string.equals("iplanet-am-platform-server-list")) continue;
            serverIdTable.put(string2, string);
        }
    }

    private static void updateSiteIdMappings() {
        siteIdTable = new Hashtable();
        String string = (String)namingTable.get("iplanet-am-platform-site-id-list");
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(NODE_SEPARATOR);
            if (n != -1) {
                string3 = string2.substring(n + 1, string2.length());
                string2 = string2.substring(0, n);
            }
            siteIdTable.put(string2, string3);
        }
        if (debug.messageEnabled()) {
            debug.message("SiteID table -> " + siteIdTable.toString());
        }
    }

    private static void validate(String string, String string2, String string3) throws URLNotFoundException {
        String string4 = (string + "://" + string2 + ":" + string3).toLowerCase();
        try {
            if (string.equalsIgnoreCase(amServerProtocol) && string2.equalsIgnoreCase(amServer) && string3.equals(amServerPort)) {
                return;
            }
            if (debug.messageEnabled()) {
                debug.message("platformServers: " + platformServers);
            }
            if (!platformServers.contains(string4)) {
                WebtopNaming.getNamingProfile(true);
                if (!platformServers.contains(string4)) {
                    throw new URLNotFoundException(NamingBundle.getString("invalidServiceHost") + " " + string4);
                }
            }
        }
        catch (Exception exception) {
            debug.error("platformServers: " + platformServers, exception);
            throw new URLNotFoundException(exception.getMessage());
        }
    }

    public static synchronized String[] getNamingServiceURL() throws Exception {
        if (namingServiceURL == null) {
            Object object;
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = System.getProperty("com.iplanet.am.naming.url");
            if (string2 != null) {
                arrayList.add(string2);
            }
            if ((string = SystemProperties.get("com.iplanet.am.naming.url")) != null) {
                object = new StringTokenizer(string);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    if (arrayList.contains(string3)) {
                        if (!debug.warningEnabled()) continue;
                        debug.warning("Duplicate naming service URL specified " + string3 + ", will be ignored.");
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
            if (arrayList.size() == 0) {
                throw new Exception(NamingBundle.getString("noNamingServiceURL"));
            }
            if (debug.messageEnabled()) {
                debug.message("Naming service URL list: " + arrayList);
            }
            namingServiceURL = new String[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, namingServiceURL, 0, arrayList.size());
            if (!WebtopNaming.isServerMode() && arrayList.size() > 1) {
                object = new Thread(new SiteMonitor());
                ((Thread)object).setDaemon(true);
                ((Thread)object).setPriority(1);
                ((Thread)object).start();
            } else if (debug.messageEnabled()) {
                debug.message("Only one naming service URL specified. NamingServiceMonitor will be disabled.");
            }
        }
        return namingServiceURL;
    }

    static {
        serverMode = Boolean.valueOf(System.getProperty("com.iplanet.am.serverMode", SystemProperties.get("com.iplanet.am.serverMode", "false")));
        try {
            WebtopNaming.getAMServer();
        }
        catch (Exception exception) {
            debug.error("Failed to initialize server properties", exception);
        }
    }

    static class SiteMonitor
    implements Runnable {
        static final String MONITORING_INTERVAL = "com.sun.identity.sitemonitor.interval";
        static long sleepInterval;
        static Vector availableSiteList;
        static String currentSiteID;

        SiteMonitor() {
        }

        public void run() {
            String string = null;
            Vector<String> vector = new Vector<String>();
            if (debug.messageEnabled()) {
                debug.message("SiteMonitor started");
            }
            while (true) {
                vector.clear();
                int n = 0;
                while (n < namingServiceURL.length) {
                    block7: {
                        if (debug.messageEnabled()) {
                            debug.message("SiteMonitor: checking availability of " + namingServiceURL[n]);
                        }
                        try {
                            URL uRL = new URL(namingServiceURL[n]);
                            uRL.openConnection().connect();
                            string = WebtopNaming.getServerID(uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getPort()));
                            vector.add(string);
                            if (debug.messageEnabled()) {
                                debug.message("SiteMonitor: " + namingServiceURL[n] + " available...");
                            }
                        }
                        catch (Exception exception) {
                            if (!debug.messageEnabled()) break block7;
                            debug.message("SiteMonitor: Site URL " + namingServiceURL[n] + " is not available.", exception);
                        }
                    }
                    ++n;
                }
                this.updateSiteList(vector);
                this.updateCurrentSite(vector);
                SiteMonitor.Sleep();
            }
        }

        static void Sleep() {
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                debug.error("SiteMonitor: monitor interrupted", interruptedException);
            }
        }

        static Vector getAvailableSites() {
            Vector vector = null;
            Vector vector2 = availableSiteList;
            synchronized (vector2) {
                vector = availableSiteList;
            }
            return vector;
        }

        void updateSiteList(Vector vector) {
            Vector vector2 = availableSiteList;
            synchronized (vector2) {
                availableSiteList = vector;
            }
        }

        void updateCurrentSite(Vector vector) {
            String string = (String)vector.firstElement();
            if (!currentSiteID.equalsIgnoreCase(string)) {
                try {
                    currentSiteID = string;
                    String string2 = WebtopNaming.getServerFromID(currentSiteID);
                    WebtopNaming.updateServerProperties(new URL(string2));
                }
                catch (Exception exception) {
                    debug.error("SiteMonitor: ", exception);
                }
            }
        }

        static {
            availableSiteList = new Vector();
            currentSiteID = null;
            try {
                sleepInterval = Long.valueOf(SystemProperties.get(MONITORING_INTERVAL, "100000"));
                WebtopNaming.updateNamingTable();
                currentSiteID = WebtopNaming.getServerID(amServerProtocol, amServer, amServerPort);
            }
            catch (Exception exception) {
                debug.message("SiteMonitor initialization failed : ", exception);
            }
        }
    }
}

