/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.JSSSocketFactory;
import com.iplanet.services.util.XMLException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.UMSObject;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.SMSSchema;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.security.auth.login.LoginException;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServerConfigMgr {
    private static final String HELP = "--help";
    private static final String S_HELP = "-h";
    private static final String Q_HELP = "?";
    private static final String SQ_HELP = "-?";
    private static final String ADMIN = "--admin";
    private static final String S_ADMIN = "-a";
    private static final String PROXY = "--proxy";
    private static final String S_PROXY = "-p";
    private static final String OLD = "--old";
    private static final String S_OLD = "-o";
    private static final String NEW = "--new";
    private static final String S_NEW = "-n";
    private static final String ENCRYPT = "--encrypt";
    private static final String S_ENCRYPT = "-e";
    private static final int MIN_PASSWORD_LEN = 8;
    private static final String RUN_TIME_CONFIG_PATH = "com.iplanet.coreservices.configpath";
    private String configFile;
    private Document document;
    private Node root;
    private Node defaultServerGroup;
    private static ResourceBundle i18n = ResourceBundle.getBundle("amSDK");
    private static Debug debug = Debug.getInstance("amSDK");
    private static String loadLibrary = "amutils";
    private static boolean libraryLoaded = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerConfigMgr() throws Exception {
        Exception exception;
        block14: {
            File file;
            this.configFile = null;
            this.document = null;
            this.root = null;
            this.defaultServerGroup = null;
            String string = SystemProperties.get("com.iplanet.services.configpath");
            if (string == null) {
                string = System.getProperty(RUN_TIME_CONFIG_PATH);
            }
            this.configFile = string + System.getProperty("file.separator") + "serverconfig.xml";
            if (debug.messageEnabled()) {
                debug.message("Server config file: " + this.configFile);
            }
            if (!((file = new File(this.configFile)).exists() && file.canRead() && file.canWrite())) {
                if (debug.warningEnabled()) {
                    debug.warning("User does not have read/write privileges for file: " + this.configFile);
                }
                Object[] objectArray = new String[]{this.configFile};
                throw new Exception(MessageFormat.format(i18n.getString("dscfg-no-file-permission"), objectArray));
            }
            exception = null;
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    this.document = XMLUtils.getXMLDocument(fileInputStream);
                    if (this.document == null) {
                        debug.error("Unable to read server config file: " + this.configFile + " error in getting the document");
                        throw new XMLException(i18n.getString("dscfg-error-reading-config-file") + "\n" + i18n.getString("dscfg-corrupted-serverconfig"));
                    }
                    this.root = XMLUtils.getRootNode(this.document, "iPlanetDataAccessLayer");
                    if (this.root == null) {
                        debug.error("Unable to get root node: " + this.configFile + " error in parsing the document");
                        throw new XMLException(i18n.getString("dscfg-unable-to-find-root-node") + "\n" + i18n.getString("dscfg-corrupted-serverconfig"));
                    }
                    this.defaultServerGroup = XMLUtils.getNamedChildNode(this.root, "ServerGroup", "name", "default");
                    if (this.defaultServerGroup == null) {
                        debug.error("Misconfigured server config file: " + this.configFile + " unable to get default server group");
                        throw new XMLException(i18n.getString("dscfg-unable-to-find-default-servergroup") + "\n" + i18n.getString("dscfg-corrupted-serverconfig"));
                    }
                    Object var7_6 = null;
                    if (fileInputStream == null) break block14;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    Object var7_7 = null;
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw throwable;
            }
            fileInputStream.close();
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object[] objectArray;
        Object[] objectArray2;
        String string = SystemProperties.get("com.iplanet.am.admin.cli.certdb.dir");
        String string2 = SystemProperties.get("com.iplanet.am.admin.cli.certdb.prefix");
        File file = new File(string + File.separatorChar + string2 + "cert7.db");
        if (file.isFile()) {
            try {
                JSSSocketFactory.initialize(string, string2, string2, "", true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if (stringArray.length == 0 || stringArray[0].equals(HELP) || stringArray[0].equals(S_HELP) || stringArray[0].equals(Q_HELP) || stringArray[0].equals(SQ_HELP)) {
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        } else if (!(stringArray[0].equals(ADMIN) || stringArray[0].equals(S_ADMIN) || stringArray[0].equals(PROXY) || stringArray[0].equals(S_PROXY) || stringArray[0].equals(ENCRYPT) || stringArray[0].equals(S_ENCRYPT))) {
            objectArray2 = new String[]{stringArray[0]};
            System.err.println(MessageFormat.format(i18n.getString("dscfg-invalid-option"), objectArray2));
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        } else if (stringArray.length != 1 && stringArray.length != 2 && stringArray.length != 5) {
            System.err.println(i18n.getString("dscfg-illegal-args"));
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        }
        if (stringArray[0].equals(S_ENCRYPT) || stringArray[0].equals(ENCRYPT)) {
            objectArray2 = null;
            if (stringArray.length > 1) {
                objectArray2 = stringArray[1];
            } else {
                System.out.print(i18n.getString("dscfg-enter-encrypt-password"));
                objectArray2 = ServerConfigMgr.readPassword();
                if (objectArray2 == null || objectArray2.length() == 0) {
                    System.err.println(i18n.getString("dscfg-null-password"));
                    System.err.println(i18n.getString("dscfg-usage"));
                    System.exit(1);
                }
            }
            System.out.println((String)AccessController.doPrivileged(new EncodeAction((String)objectArray2)));
            System.exit(0);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray[0].equals(S_ADMIN) || stringArray[0].equals(ADMIN)) {
            bl = true;
        } else {
            bl2 = true;
        }
        String string3 = null;
        Object object3 = null;
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n].equals(OLD) || stringArray[n].equals(S_OLD)) {
                string3 = stringArray[++n];
            } else if (stringArray[n].equals(NEW) || stringArray[n].equals(S_NEW)) {
                object3 = stringArray[++n];
            } else {
                objectArray = new String[]{stringArray[n]};
                System.err.println(MessageFormat.format(i18n.getString("dscfg-invalid-option"), objectArray));
                System.err.println(i18n.getString("dscfg-usage"));
                System.exit(1);
            }
            ++n;
        }
        if (string3 == null || object3 == null) {
            System.out.print(i18n.getString("dscfg-enter-old-password"));
            string3 = ServerConfigMgr.readPassword();
            objectArray = new String[]{Integer.toString(8)};
            System.out.print(MessageFormat.format(i18n.getString("dscfg-enter-new-password"), objectArray));
            object2 = ServerConfigMgr.readPassword();
            System.out.print(i18n.getString("dscfg-enter-new-password-again"));
            object = ServerConfigMgr.readPassword();
            ServerConfigMgr.checkPassword(string3, (String)object2);
            ServerConfigMgr.checkPassword(string3, (String)object);
            if (((String)object2).equals(object)) {
                object3 = object2;
            } else {
                System.err.println(i18n.getString("dscfg-new-passwords-donot-match"));
                System.exit(1);
            }
        } else {
            ServerConfigMgr.checkPassword(string3, object3);
        }
        try {
            objectArray = new ServerConfigMgr();
            object2 = new DN(objectArray.getUserDN("admin"));
            object = new DN(super.getUserDN("proxy"));
            if (((DN)object2).equals((DN)object)) {
                bl = true;
                bl2 = true;
            }
            if (bl) {
                if (debug.messageEnabled()) {
                    debug.message("Setting the admin password");
                }
                objectArray.setAdminUserPassword(string3, (String)object3);
            }
            if (bl2) {
                if (debug.messageEnabled()) {
                    debug.message("Setting the proxy password");
                }
                objectArray.setProxyUserPassword(string3, (String)object3);
            }
            if (debug.messageEnabled()) {
                debug.message("Updating serverconfig.xml");
            }
            objectArray.save();
            System.out.println(i18n.getString("dscfg-passwd-success"));
        }
        catch (Exception exception) {
            debug.error("Exception while changing password", exception);
            System.err.println(exception.getMessage());
        }
    }

    public void setAdminUserPassword(String string, String string2) throws Exception {
        this.changePassword("admin", string, string2);
    }

    protected void setProxyUserPassword(String string, String string2) throws Exception {
        this.changePassword("proxy", string, string2);
    }

    public void save() throws Exception {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer(100);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.configFile));
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf("iPlanetDataAccessLayer");
            if (n == -1) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
                continue;
            }
            if (--n <= 0) break;
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append("\n");
            break;
        }
        bufferedReader.close();
        if (debug.messageEnabled()) {
            debug.message("Prefix read from old serverconfig.xml: " + stringBuffer);
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.configFile));
        if (debug.messageEnabled()) {
            debug.message("Prefix being added to serverconfig.xml: " + stringBuffer);
        }
        printWriter.print(stringBuffer.toString());
        if (debug.messageEnabled()) {
            debug.message("Config info being added to serverconfig.xml: " + SMSSchema.nodeToString(this.root));
        }
        printWriter.println(SMSSchema.nodeToString(this.root));
        printWriter.close();
    }

    protected void setAdminUser(String string) {
    }

    protected void setProxyDN(String string) {
    }

    protected void setServer(String string, String string2, int n, String string3) {
    }

    private Node getUserNode(String string) throws Exception {
        Node node = XMLUtils.getNamedChildNode(this.defaultServerGroup, "User", "type", string);
        if (node == null) {
            debug.error("Unable to get user type: " + string + " node from file: " + this.configFile);
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        return node;
    }

    private String getUserDN(String string) throws Exception {
        Node node = XMLUtils.getChildNode(this.getUserNode(string), "DirDN");
        if (node == null) {
            debug.error("Unable to get user DN for type: " + string + " from file: " + this.configFile);
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        return XMLUtils.getValueOfValueNode(node);
    }

    private void changePassword(String string, String string2, String string3) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Node node = null;
        node = XMLUtils.getChildNode(this.getUserNode(string), "DirPassword");
        if (node == null) {
            debug.error("Unable to get Password for type: " + string + " from file: " + this.configFile);
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        String string4 = XMLUtils.getValueOfValueNode(node);
        String string5 = this.getUserDN(string);
        if (string4 == null || string4.length() == 0 || string5 == null || string5.length() == 0) {
            debug.error("Null password or user DN for user type: " + string + " from file: " + this.configFile);
            throw new XMLException(i18n.getString("dscfg-corrupted-serverconfig"));
        }
        if (!string2.equals((String)AccessController.doPrivileged(new DecodeAction(string4)))) {
            throw new Exception(i18n.getString("dscfg-old-passwd-donot-match"));
        }
        try {
            object3 = new AuthContext((Principal)new AuthPrincipal(string5), string3.toCharArray());
            if (debug.messageEnabled()) {
                debug.message("DN: " + string5 + " new password is already " + "updated in the directory");
            }
        }
        catch (LoginException loginException) {
            try {
                object2 = new AuthContext((Principal)new AuthPrincipal(string5), string2.toCharArray());
                if (debug.messageEnabled()) {
                    debug.message("For DN: " + string5 + " old password matchs with directory");
                }
                object = UMSObject.getObject((SSOToken)object2.getSSOToken(), (Guid)new Guid(string5));
                if (debug.messageEnabled()) {
                    debug.message("For DN: " + string5 + " changing password in directory");
                }
                object.setAttribute(new Attr("userPassword", string3));
                object.save();
            }
            catch (LoginException loginException2) {
                if (debug.warningEnabled()) {
                    debug.warning("For DN: " + string5 + " new and old passwords donot match with directory");
                }
                throw new Exception(i18n.getString("dscfg-invalid-password") + "\n" + loginException2.getMessage());
            }
        }
        object3 = (String)AccessController.doPrivileged(new EncodeAction(string3));
        if (debug.messageEnabled()) {
            debug.message("Updating the XML document with new password");
        }
        object2 = node.getChildNodes();
        object = object2.item(0);
        object.setNodeValue((String)object3);
        int n = 1;
        while (n < object2.getLength()) {
            node.removeChild(object2.item(n));
            ++n;
        }
    }

    private static void checkPassword(String string, String string2) {
        if (string == null || string.length() == 0) {
            System.err.println(i18n.getString("dscfg-null-old-password"));
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        }
        if (string2 == null || string2.length() == 0) {
            System.err.println(i18n.getString("dscfg-null-new-password"));
            System.err.println(i18n.getString("dscfg-usage"));
            System.exit(1);
        }
        if (string2.length() < 8) {
            Object[] objectArray = new String[]{Integer.toString(8)};
            System.err.println(MessageFormat.format(i18n.getString("dscfg-password-lenght-not-met"), objectArray));
            System.exit(1);
        } else if (string2.equals(string)) {
            System.err.println(i18n.getString("dscfg-passwords-are-same"));
            System.exit(1);
        }
    }

    private static String readPassword() {
        Object object;
        if (!libraryLoaded) {
            object = loadLibrary;
            synchronized (object) {
                if (!libraryLoaded) {
                    try {
                        System.loadLibrary(loadLibrary);
                        libraryLoaded = true;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        debug.error("Error in loading library", unsatisfiedLinkError);
                    }
                }
            }
        }
        if (libraryLoaded) {
            try {
                object = ServerConfigMgr.jniReadPassword();
                if (object != null) {
                    return object;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                debug.error("Error in loading library", unsatisfiedLinkError);
            }
        }
        while (true) {
            try {
                object = new BufferedReader(new InputStreamReader(System.in));
                return ((BufferedReader)object).readLine();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                continue;
            }
            break;
        }
    }

    public static native String jniReadPassword();
}

